/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.pub.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysUtils;
import com.ustc.gen.util.DBPropertyUtil;
import com.ustc.pub.dao.PubContactOrgAccountDao;
import com.ustc.pub.dao.PubOrgConAccountRelationDao;
import com.ustc.pub.entity.PubContactOrgAccount;
import com.ustc.pub.entity.PubOrgConAccountRelation;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class PubContactOrgAccountService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private PubContactOrgAccountDao pubcontactorgaccountDao;
    @Autowired
    private PubOrgConAccountRelationDao pubOrgConAccountRelationDao;

    public PubContactOrgAccount findPubContactOrgAccount(Long id) {
        PubContactOrgAccount entity = (PubContactOrgAccount)this.pubcontactorgaccountDao.findById(id).get();
        return entity;
    }

    public void savePubContactOrgAccount(PubContactOrgAccount entity) {
        this.pubcontactorgaccountDao.save(entity);
        if (entity.getDataList() != null) {
            for (PubOrgConAccountRelation relation : entity.getDataList()) {
                relation.setOrgAccountId(entity.getOrgAccountId());
                relation.setContactOrgId(entity.getContactOrgId());
                if (StrKit.isBlank(relation.getIsUse())) {
                    relation.setIsUse("Y");
                }
                if (relation.getRelationId() == null) {
                    relation.setCreateAccount(entity.getModifyAccount());
                    relation.setCreateTime(new Date());
                }
                relation.setModifyAccount(entity.getModifyAccount());
                relation.setModifyTime(new Date());
                this.pubOrgConAccountRelationDao.save(relation);
            }
        }
    }

    public void delPubContactOrgAccount(Long id) {
        PubContactOrgAccount entity = (PubContactOrgAccount)this.pubcontactorgaccountDao.findById(id).get();
        entity.setIsUse("N");
        this.pubcontactorgaccountDao.save(entity);
        List<PubOrgConAccountRelation> relations = this.pubOrgConAccountRelationDao.findByOrgAccountIdAndIsUse(id, "Y");
        for (PubOrgConAccountRelation relation : relations) {
            relation.setIsUse("N");
            this.pubOrgConAccountRelationDao.save(relation);
        }
    }

    public PageObject PageAll(String contactOrgId, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)contactOrgId)) {
            return null;
        }
        params.put("contactOrgId", contactOrgId);
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("pub.PubContactOrgAccount.selectWin", params, PageRequest.of((int)page, (int)rows));
    }

    public PageObject selectAll(Long id, Long flowDone, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (id != null) {
            params.put("id", id);
        }
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (flowDone != null) {
            params.put("flowsql", " and " + SysUtils.genFlowDoneStatusSQL("t.workflow_status", flowDone) + " \n");
        }
        return this.bSqlHelper.serachPage("pub.PubContactOrgAccount.selectAll", params, PageRequest.of((int)page, (int)rows));
    }

    public PageObject PageSelect(String contactOrgId, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)contactOrgId)) {
            params.put("contactOrgId", contactOrgId);
        }
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("pub.PubContactOrgAccount.PageSelect", params, PageRequest.of((int)page, (int)rows));
    }

    public String findHiddenPanel(Long id, Boolean isdetail) {
        String excludepanels = "";
        if (id == null) {
            return excludepanels;
        }
        PubContactOrgAccount entity = this.findPubContactOrgAccount(id);
        if (entity.getWorkflowStatus() != null && entity.getWorkflowStatus().toString().indexOf(1) == -1 && isdetail.booleanValue()) {
            if ("N".equals(entity.getIsCancellationAccount()) && "N".equals(entity.getIsAllCon())) {
                return excludepanels;
            }
            excludepanels = "relationPanelId,";
        }
        return excludepanels;
    }

    public List<Map<String, Object>> findBanksByContactOrgId(Long contactOrgId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("contactOrgId", contactOrgId);
        return this.bSqlHelper.getMapList("pub.PubContactOrgAccount.select", params);
    }
}

