/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.pub.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.service.BasMessageService;
import com.ustc.doc.entity.FormFileBean;
import com.ustc.doc.service.DocFormFileService;
import com.ustc.gen.util.DBPropertyUtil;
import com.ustc.pub.dao.PubContactAltDao;
import com.ustc.pub.entity.PubContactAlt;
import com.ustc.pub.entity.PubContactOrg;
import com.ustc.pub.service.PubContactOrgService;
import com.ustc.workflow.service.FlowUtilService;
import java.lang.reflect.InvocationTargetException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class PubContactAltService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasMessageService msgService;
    @Autowired
    private PubContactAltDao pubcontactaltDao;
    @Autowired
    private DocFormFileService docFormFileService;
    @Autowired
    private FlowUtilService flowUtilService;
    @Autowired
    private PubContactOrgService pubContactOrgService;

    public PubContactAlt findPubContactAlt(Long id) {
        PubContactAlt entity = (PubContactAlt)this.pubcontactaltDao.findById(id).get();
        return entity;
    }

    public void savePubContactAlt(PubContactAlt entity) {
        this.pubcontactaltDao.save(entity);
    }

    public void savePubContactAlt(PubContactAlt entity, FormFileBean formfile) {
        this.pubcontactaltDao.save(entity);
        if (formfile != null) {
            formfile.setPrimaryKey(entity.getContactAltId());
            formfile.setAccountid(entity.getModifyAccount());
            this.docFormFileService.SaveFormFileBean(formfile);
        }
    }

    public void delPubContactAlt(Long id) {
        PubContactAlt entity = (PubContactAlt)this.pubcontactaltDao.findById(id).get();
        entity.setIsUse("N");
        entity.setModifyTime(new Date());
        this.pubcontactaltDao.save(entity);
        this.msgService.delMydealByProcessinstid(entity.getProcessinstid(), id.toString());
    }

    public PageObject PageAll(Long flowDone, String search, int page, int rows, String sort, String order, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((String)type)) {
            params.put("type", type);
        }
        if (flowDone != null) {
            params.put("flowsql", " and t.processinstid in (" + this.flowUtilService.queryDealedProcess(flowDone) + ") \n");
        } else {
            params.put("flowsql", " and t.workflow_status='3' \n");
        }
        return this.bSqlHelper.serachPage("pub.PubContactAlt.select", params, PageRequest.of((int)page, (int)rows));
    }

    public void writeContactAltBack(Long processinstid) throws IllegalAccessException, InvocationTargetException {
        List<PubContactAlt> list = this.pubcontactaltDao.findByProcessinstid(processinstid);
        if (list.isEmpty()) {
            return;
        }
        PubContactAlt altEntity = list.get(0);
        if (altEntity.getContactOrgId() == null) {
            return;
        }
        PubContactOrg entity = this.pubContactOrgService.findPubContactOrg(altEntity.getContactOrgId());
        if (entity != null) {
            entity.setContactOrgName(altEntity.getContactAltName());
            this.pubContactOrgService.savePubContactOrg(entity);
        }
    }
}

