/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.gen.service;

import cn.hutool.core.map.MapUtil;
import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.DateUtils;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.service.CommonService;
import com.ustc.gen.entity.DBColumn;
import com.ustc.gen.entity.DBTable;
import com.ustc.gen.entity.GenForm;
import com.ustc.gen.service.GenFormService;
import com.ustc.gen.util.DBPropertyUtil;
import com.ustc.gen.util.FreeMarkerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GeneratorService {
    @Value(value="${tableSchema}")
    private String tableSchema;
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private GenFormService genformService;

    public DBTable buildTable(String tablename) {
        ArrayList<DBColumn> list = new ArrayList<DBColumn>();
        String sql = " SELECT  \n  t.TABLE_NAME,\n t.COLUMN_NAME,\n t.DATA_TYPE,\n t.CHARACTER_MAXIMUM_LENGTH DATA_LENGTH,\n t.NUMERIC_PRECISION DATA_PRECISION,\n t.NUMERIC_SCALE DATA_SCALE,\n t.is_NULLABLE NULLABLE,\n t.COLUMN_COMMENT comments\n FROM INFORMATION_SCHEMA.`COLUMNS` t \n where  t.TABLE_SCHEMA=schema()\nand t.TABLE_NAME=?1 order by t.ORDINAL_POSITION";
        List collist = this.sqlHelper.queryByNativeSQL(sql, new Object[]{tablename.toUpperCase()}, new int[0]);
        for (Object object : collist) {
            Map row = (Map)object;
            DBColumn col = new DBColumn();
            col.setFieldDbName(row.get("COLUMN_NAME").toString());
            col.setDataLength(Objects.toString(row.get("DATA_LENGTH"), "2000"));
            col.setFieldName(DBPropertyUtil.columnToProperty2(row.get("COLUMN_NAME").toString().toLowerCase()));
            col.setFieldType(DBPropertyUtil.sqlType2JavaType(row.get("DATA_TYPE").toString()));
            col.setPrecision(row.get("DATA_PRECISION") == null ? "" : row.get("DATA_PRECISION").toString());
            col.setNullable("YES".equals(row.get("NULLABLE").toString()) ? "Y" : "N");
            col.setScale(row.get("DATA_SCALE") == null ? "" : row.get("DATA_SCALE").toString());
            if ("0".equals(col.getScale()) && "BigDecimal".equals(col.getFieldType())) {
                col.setFieldType("Long");
            }
            col.setFieldTitle(row.get("COMMENTS") == null ? col.getFieldName() : row.get("COMMENTS").toString());
            if (col.getFieldType().equalsIgnoreCase("Long") && Long.parseLong(col.getScale()) > 0L) {
                col.setFieldType("Double");
            }
            list.add(col);
        }
        DBTable table = new DBTable();
        table.setTablename(tablename.toUpperCase());
        table.setEntityName(DBPropertyUtil.tblToEntity(tablename.toLowerCase()));
        table.setColumns(list);
        table.setDescription("\u4ee3\u7801\u751f\u6210\u5de5\u5177\u81ea\u52a8\u751f\u6210");
        table.setDate(DateUtils.dateToStr(new Date()));
        table.setPk(this.getPK(tablename.toUpperCase()));
        table.setPkHump(DBPropertyUtil.columnToProperty2(table.getPk().toLowerCase()));
        return table;
    }

    public String getFormKey(String formCode) {
        GenForm form = this.genformService.findGenFormByCode(formCode);
        return DBPropertyUtil.columnToProperty2(this.getPK(form.getBusiTable()).toLowerCase());
    }

    public Map<String, Object> getProcessinstidByFormCode(HttpServletRequest request, String formCode) {
        GenForm form = this.genformService.findGenFormByCode(formCode);
        String pkfield = DBPropertyUtil.columnToProperty2(this.getPK(form.getBusiTable()).toLowerCase());
        String pk = request.getParameter(pkfield);
        String sql = "select processinstid from " + form.getBusiTable() + " where " + this.getPK(form.getBusiTable().toUpperCase()) + "=" + pk;
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("id", pk);
        map.put("processinstid", this.sqlHelper.getSingal(sql));
        return map;
    }

    public String getPK(String tablename) {
        return this.bSqlHelper.getStringValue("gen.db.getPk", MapUtil.of((Object)"tableName", (Object)tablename));
    }

    public List allTable() {
        String sql = " SELECT underlineToCamel(t.TABLE_NAME) hump_name, t.TABLE_NAME  ,t.TABLE_COMMENT COMMENTS FROM INFORMATION_SCHEMA.`TABLES` t \n where t.TABLE_SCHEMA<>'mysql'\nand   t.TABLE_SCHEMA='" + this.tableSchema + "'\norder by t.TABLE_NAME";
        List list = this.sqlHelper.queryByNativeSQL(sql, new int[0]);
        return list;
    }

    public List allTableAndView(String tableName) {
        String sql = " SELECT underlineToCamel(t.TABLE_NAME) hump_name, t.TABLE_NAME  ,t.TABLE_COMMENT COMMENTS,t.table_type FROM INFORMATION_SCHEMA.`TABLES` t where t.TABLE_SCHEMA = '" + this.tableSchema + "'\n";
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)tableName)) {
            params.put("search", "%" + tableName.toUpperCase() + "%");
            sql = sql + " and upper(t.TABLE_NAME) like :search or upper(t.TABLE_COMMENT) like :search";
        }
        sql = sql + " order by t.table_type,t.TABLE_NAME";
        List list = this.sqlHelper.queryByNativeSQL(sql, params, new int[0]);
        return list;
    }

    public DBTable bulidwithColumnInfo(DBTable table, List rows) {
        for (DBColumn column : table.columns) {
            for (Object o : rows) {
                Map row = (Map)o;
                if (!column.getFieldDbName().equals(row.get("fieldDbName").toString())) continue;
                if (StrKit.notNull(row.get("fieldTitle"))) {
                    column.setFieldTitle(row.get("fieldTitle").toString());
                }
                if (!StrKit.notNull(row.get("fieldDic")) || !StrKit.notBlank(row.get("fieldDic").toString())) continue;
                column.setFieldDic(row.get("fieldDic").toString());
            }
        }
        return table;
    }

    public void buildPage(DBTable table, String type, String gensrc, String genobjs) {
        String srcpath = gensrc + "\\src\\main\\";
        String javapath = srcpath + "java\\";
        String webpath = srcpath + "webapp\\";
        String sqlpath = srcpath + "resources\\beetlsql\\";
        List<String> objs = Arrays.asList(genobjs.split(","));
        HashMap<String, DBTable> propMap = new HashMap<String, DBTable>();
        propMap.put("table", table);
        if (objs.contains("entity")) {
            FreeMarkerUtil.instance().geneHtmlFile("/com/ustc/gen/ftl/entityTemplate.ftl", propMap, javapath + table.getBaspackEntity().replace(".", "\\"), table.getEntityName() + ".java");
        }
        if (objs.contains("beetsql")) {
            FreeMarkerUtil.instance().geneHtmlFile("/com/ustc/gen/ftl/" + table.getTemplatePath() + "/beetlSql.ftl", propMap, sqlpath + table.getBizpack().replace("com.ustc.", "").replace(".", "\\"), table.getEntityName() + ".md");
        }
        if (objs.contains("controller")) {
            if ("process".equals(type)) {
                FreeMarkerUtil.instance().geneHtmlFile("/com/ustc/gen/ftl/" + table.getTemplatePath() + "/controllerTemplateWithProcess.ftl", propMap, javapath + table.getBaspackController().replace(".", "\\"), table.getEntityName() + "Controller.java");
            } else if ("editFrom".equals(type)) {
                FreeMarkerUtil.instance().geneHtmlFile("/com/ustc/gen/ftl/" + table.getTemplatePath() + "/controllerTemplateEditFrom.ftl", propMap, javapath + table.getBaspackController().replace(".", "\\"), table.getEntityName() + "Controller.java");
            } else {
                FreeMarkerUtil.instance().geneHtmlFile("/com/ustc/gen/ftl/" + table.getTemplatePath() + "/controllerTemplate.ftl", propMap, javapath + table.getBaspackController().replace(".", "\\"), table.getEntityName() + "Controller.java");
            }
        }
        if (objs.contains("service")) {
            if ("process".equals(type)) {
                FreeMarkerUtil.instance().geneHtmlFile("/com/ustc/gen/ftl/" + table.getTemplatePath() + "/servicelTemplateWithProcess.ftl", propMap, javapath + table.getBaspackService().replace(".", "\\"), table.getEntityName() + "Service.java");
            } else if ("editFrom".equals(type)) {
                FreeMarkerUtil.instance().geneHtmlFile("/com/ustc/gen/ftl/" + table.getTemplatePath() + "/servicelTemplateEditFrom.ftl", propMap, javapath + table.getBaspackService().replace(".", "\\"), table.getEntityName() + "Service.java");
            } else {
                FreeMarkerUtil.instance().geneHtmlFile("/com/ustc/gen/ftl/" + table.getTemplatePath() + "/servicelTemplate.ftl", propMap, javapath + table.getBaspackService().replace(".", "\\"), table.getEntityName() + "Service.java");
            }
        }
        if (objs.contains("dao")) {
            FreeMarkerUtil.instance().geneHtmlFile("/com/ustc/gen/ftl/daoTemplate.ftl", propMap, javapath + table.getBaspackDao().replace(".", "\\"), table.getEntityName() + "Dao.java");
        }
        if (objs.contains("jsp")) {
            if ("process".equals(type)) {
                FreeMarkerUtil.instance().geneHtmlFile("/com/ustc/gen/ftl/" + table.getTemplatePath() + "/jspTemplateWithProcess.ftl", propMap, webpath + "\\WEB-INF\\view\\" + table.getViewpath().replace("/", "\\"), table.getEntityName() + ".jsp");
            } else if ("editFrom".equals(type)) {
                FreeMarkerUtil.instance().geneHtmlFile("/com/ustc/gen/ftl/" + table.getTemplatePath() + "/jspTemplateEditFrom.ftl", propMap, webpath + "\\WEB-INF\\view\\" + table.getViewpath().replace("/", "\\"), table.getEntityName() + ".jsp");
            } else {
                FreeMarkerUtil.instance().geneHtmlFile("/com/ustc/gen/ftl/" + table.getTemplatePath() + "/jspTemplate.ftl", propMap, webpath + "\\WEB-INF\\view\\" + table.getViewpath().replace("/", "\\"), table.getEntityName() + ".jsp");
            }
            if ("0".equals(table.getPagetype()) && "".equals(type)) {
                FreeMarkerUtil.instance().geneHtmlFile("/com/ustc/gen/ftl/" + table.getTemplatePath() + "/jspformTemplate.ftl", propMap, webpath + "\\WEB-INF\\view\\" + table.getViewpath().replace("/", "\\"), table.getEntityName() + "form.jsp");
            }
        }
        if (objs.contains("js")) {
            if ("".equals(type)) {
                FreeMarkerUtil.instance().geneHtmlFile("/com/ustc/gen/ftl/" + table.getTemplatePath() + "/jsTemplate.ftl", propMap, webpath + "\\WEB-INF\\js\\" + table.getViewpath().replace("/", "\\"), table.getEntityName() + ".js");
                FreeMarkerUtil.instance().geneHtmlFile("/com/ustc/gen/ftl/" + table.getTemplatePath() + "/extraJsTemplate.ftl", propMap, webpath + "\\WEB-INF\\js\\" + table.getViewpath().replace("/", "\\"), table.getEntityName() + "Extra.js");
            } else if ("process".equals(type)) {
                FreeMarkerUtil.instance().geneHtmlFile("/com/ustc/gen/ftl/" + table.getTemplatePath() + "/jsTemplateWithProcess.ftl", propMap, webpath + "\\WEB-INF\\js\\" + table.getViewpath().replace("/", "\\"), table.getEntityName() + ".js");
                FreeMarkerUtil.instance().geneHtmlFile("/com/ustc/gen/ftl/" + table.getTemplatePath() + "/extraJsTemplate.ftl", propMap, webpath + "\\WEB-INF\\js\\" + table.getViewpath().replace("/", "\\"), table.getEntityName() + "Extra.js");
            }
        }
    }

    public PageObject findHibernateSequences(Integer page, Integer rows) {
        StringBuilder sql = new StringBuilder();
        this.sqlHelper.exeNativeSQL("call get_all_max_ids() ");
        sql.append("select t.sequence_name,20*t.sequence_next_hi_value as sequence_next_hi_value,m.MAX_ID,(case when 20*t.sequence_next_hi_value<ifnull( CONVERT(m.MAX_ID,DECIMAL),0) then true else false end) FLAG from hibernate_sequences t,table_max_id m where (m.MAX_ID REGEXP '[^0-9.]') = 0  and m.tablename =lower(t.sequence_name) order by 20*t.sequence_next_hi_value-ifnull(CONVERT(m.MAX_ID,DECIMAL),0), t.sequence_name asc");
        int start = (page - 1) * rows;
        PageObject pageobject = new PageObject();
        String sqlCount = "select count(1)  from (" + sql + ") a";
        int count = Integer.parseInt(this.sqlHelper.getSingal(sqlCount).toString());
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), start, rows);
        int totalPage = count % rows == 0 ? count / rows : count / rows + 1;
        pageobject.setTotal(count);
        pageobject.setPageNumber(totalPage);
        pageobject.setCurrpage(page);
        pageobject.setRows(list);
        return pageobject;
    }

    public void appengMaxIdColumn(List list) {
        for (Object o : list) {
            Map row = (Map)o;
            String tableName = row.get("SEQUENCE_NAME").toString();
            Integer value = Integer.parseInt(row.get("SEQUENCE_NEXT_HI_VALUE").toString());
            String pk = this.commonService.getPK(tableName);
            if (!StringUtils.isEmpty((String)pk)) {
                StringBuilder sql = new StringBuilder();
                sql.append("select max(" + pk + ") from " + tableName + " t ");
                int maxId = 0;
                if (this.sqlHelper.getSingal(sql.toString()) != null) {
                    try {
                        maxId = Integer.parseInt(this.sqlHelper.getSingal(sql.toString()).toString());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                row.put("MAX_ID", maxId);
                if (maxId > value) {
                    row.put("FLAG", true);
                    continue;
                }
                row.put("FLAG", false);
                continue;
            }
            row.put("MAX_ID", 0);
            row.put("FLAG", false);
        }
    }

    public PageObject exesql(String sql, int page, int rows, String sort, String order) {
        if (StrKit.notBlank(sort)) {
            sql = "select t.* from (" + sql.toString() + ") t " + SysUtils.genOrderBy("t." + sort, order);
        }
        return this.sqlHelper.pagerNativeSQL(sql.toString(), page, rows);
    }

    public void updateHibernateSequences(String tableName, int maxId) {
        Integer value = maxId / 20 + 1;
        StringBuilder sql = new StringBuilder();
        sql.append("update hibernate_sequences t set t.sequence_next_hi_value =?1 where t.sequence_name=?2 ");
        this.sqlHelper.exeNativeSQL(sql.toString(), new Object[]{value, tableName});
    }
}

