/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.gen.service;

import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.service.CommonService;
import com.ustc.doc.dao.DocFileTypeDao;
import com.ustc.doc.entity.DocFileType;
import com.ustc.gen.dao.GenPanelFileDao;
import com.ustc.gen.entity.GenPanelFile;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GenPanelFileService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private GenPanelFileDao genpanelfileDao;
    @Autowired
    private DocFileTypeDao docFileTypeDao;

    public GenPanelFile findGenPanelFile(String id) {
        GenPanelFile entity = (GenPanelFile)this.genpanelfileDao.findById(id).get();
        return entity;
    }

    @CacheEvict(cacheNames={"FormCache"}, allEntries=true)
    public void saveGenPanelFile(GenPanelFile entity) {
        this.genpanelfileDao.save(entity);
    }

    @CacheEvict(cacheNames={"FormCache"}, allEntries=true)
    public void delGenPanelFile(String id) {
        this.genpanelfileDao.deleteById(id);
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        String sql = "select * from GEN_PANEL_FILE t  order by t.PANEL_FILE_ID";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select * from GEN_PANEL_FILE t where   upper(t.PANEL_FILE_ID) like ?1  or upper(t.PANEL_ID) like ?1  or upper(t.FILE_TYPE_ID) like ?1  or upper(t.REQUIRED) like ?1  or upper(t.IS_USE) like ?1  or upper(t.DISPLAY_NO) like ?1  order by t.PANEL_FILE_ID";
            pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{"%" + search.toUpperCase() + "%"}, page, rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql, page, rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject PageAllByPanelID(String panelid, int page, int rows) {
        PageObject pageobject = new PageObject();
        String sql = "select T.PANEL_FILE_ID,T.PANEL_ID,T.FILE_TYPE_ID,A.FILE_TYPE_NAME,A.FILE_NATURE,A.CATALOG_ID,B.CATALOG_NAME,T.REQUIRED,t.FILTER_FUNCTION from GEN_PANEL_FILE t left join DOC_FILE_TYPE A ON T.FILE_TYPE_ID=A.FILE_TYPE_ID left join DOC_CATALOG B ON A.CATALOG_ID=B.CATALOG_ID where t.PANEL_ID=?1 AND T.IS_USE='Y' order by t.DISPLAY_NO";
        pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{panelid}, page, rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("FILE_NATURE", "FILE_NATURE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    @CacheEvict(cacheNames={"FormCache"}, allEntries=true)
    public void saveGenPanelFiles(String panelid, String filetypeids) {
        if (StrKit.notBlank(filetypeids)) {
            String[] ids;
            for (String id : ids = filetypeids.split(",")) {
                GenPanelFile entity = this.genpanelfileDao.findByPanelIdAndFileTypeIdAndIsUse(panelid, id, "Y");
                if (entity != null) continue;
                DocFileType type = (DocFileType)this.docFileTypeDao.findById(id).get();
                GenPanelFile newentity = new GenPanelFile();
                newentity.setPanelId(panelid);
                newentity.setFileTypeId(id);
                newentity.setFileTypeName(type.getFileTypeName());
                newentity.setCatalogId(type.getCatalogId());
                newentity.setIsUse("Y");
                newentity.setEditableAct("Act_1");
                this.genpanelfileDao.save(newentity);
            }
        }
    }
}

