/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.gen.service;

import com.alibaba.fastjson.JSONArray;
import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.SysUtils;
import com.ustc.gen.dao.GenActFileDao;
import com.ustc.gen.entity.GenActFile;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GenActFileService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private GenActFileDao genactfileDao;

    public GenActFile findGenActFile(String id) {
        GenActFile entity = (GenActFile)this.genactfileDao.findById(id).get();
        return entity;
    }

    public void saveGenActFile(GenActFile entity) {
        this.genactfileDao.save(entity);
    }

    public void saveGenActFileList(String data, String settingId, String actId) {
        List list = JSONArray.parseArray((String)data, GenActFile.class);
        for (GenActFile file : list) {
            file.setSettingId(settingId);
            file.setActId(actId);
            file.setIsUse("Y");
            file.setModifyAccount(SysUtils.getLoginAccountId());
            file.setModifyTime(new Date());
            if (file.getId() != null) continue;
            file.setCreateAccount(file.getModifyAccount());
            file.setCreateTime(file.getModifyTime());
        }
        this.genactfileDao.saveAll(list);
    }

    public void delGenActFile(String id) {
        GenActFile entity = (GenActFile)this.genactfileDao.findById(id).get();
        entity.setIsUse("N");
        this.genactfileDao.save(entity);
    }

    public PageObject PageAll(Long accountId, String id, String actId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("actId", actId);
        return this.bSqlHelper.serachPage("gen.GenActFile.select", params);
    }
}

