/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.gen.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ustc.base.common.exception.GEPSBisException;
import com.ustc.base.common.spring.SystemControllerLog;
import com.ustc.base.common.util.DataSourceutil;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.controller.BaseController;
import com.ustc.base.service.BasMenuService;
import com.ustc.gen.entity.DBTable;
import com.ustc.gen.service.GenFormService;
import com.ustc.gen.service.GenPanelItemService;
import com.ustc.gen.service.GeneratorService;
import com.ustc.workflow.service.FlowUtilService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/gen"})
public class GeneratorController
extends BaseController {
    private static final Logger logger = Logger.getLogger(GeneratorController.class);
    @Autowired
    private GeneratorService generatorService;
    @Autowired
    private GenPanelItemService genpanelitemService;
    @Autowired
    private FlowUtilService flowutilService;
    @Autowired
    private BasMenuService baseMenuService;
    @Autowired
    private GenFormService genformService;
    @Autowired
    private DataSourceutil dataSourceutil;

    @RequestMapping(value={"/gensrc"})
    @ResponseBody
    public Object genSrc(HttpServletRequest request, String tablename, String bizpackage, String pagetype, String rowlist, String treeid, String treepid, String treetext, Long panelid, String type, String gensrc, String genobjs, String menuName, Long pmenuId) {
        JsonMsg msg = new JsonMsg();
        DBTable table = this.generatorService.buildTable(tablename);
        JSONArray rows = JSON.parseArray((String)rowlist);
        this.generatorService.bulidwithColumnInfo(table, (List)rows);
        table.setPagetype(pagetype);
        if ("0".equals(pagetype)) {
            table.setTemplatePath("gridform");
        } else if ("1".equals(pagetype)) {
            table.setTemplatePath("treeform");
            table.setTreeid(treeid);
            table.setTreepid(treepid);
            table.setTreetext(treetext);
        }
        table.setBizpack(bizpackage);
        table.setViewpath(bizpackage.replace(".", "/"));
        List<String> objs = Arrays.asList(genobjs.split(","));
        if (pmenuId != null && objs.contains("menu")) {
            this.baseMenuService.genMenu(menuName, pmenuId, "/view/" + table.getViewpath() + "/" + table.getEntityName(), type);
        }
        if (StringUtils.isNotBlank((String)menuName)) {
            table.setDescription(menuName);
        }
        if (objs.contains("form")) {
            this.genformService.genFormByTable(table, objs.contains("proccess"));
        }
        this.generatorService.buildPage(table, type, gensrc, genobjs);
        msg.setSuccess(true);
        msg.setMsg("\u751f\u6210\u6210\u529f");
        return msg;
    }

    @RequestMapping(value={"/alltable"})
    @ResponseBody
    public ModelAndView allTable() {
        List list = this.generatorService.allTable();
        ModelAndView view = new ModelAndView();
        view.setViewName("/gen/alltable");
        view.addObject("tables", (Object)list);
        return view;
    }

    @RequestMapping(value={"/alltableAndView"})
    @ResponseBody
    public Object alltableAndView(String tableName) {
        return this.generatorService.allTableAndView(tableName);
    }

    @RequestMapping(value={"/getsqlColumn"})
    @ResponseBody
    public Object getsqlColumn(String sql, HttpServletResponse response) {
        if (sql.contains("delete ") || sql.contains("update ") || sql.contains("truncate ") || sql.contains("drop ") || sql.contains("create ") || sql.contains("alter ") || sql.contains("insert ") || sql.contains("DELETE ") || sql.contains("UPDATE ") || sql.contains("TRUNCATE ") || sql.contains("DROP ") || sql.contains("CREATE ") || sql.contains("ALTER ") || sql.contains("INSERT ")) {
            response.setStatus(403);
            return null;
        }
        Map<String, Map<String, Object>> sqlcolumns = this.dataSourceutil.getColunms(sql);
        ArrayList<String> cols = new ArrayList<String>();
        for (String field : sqlcolumns.keySet()) {
            cols.add(field);
        }
        return new JsonMsg(true, "", cols);
    }

    @RequestMapping(value={"/exesql"})
    @ResponseBody
    @SystemControllerLog(description="exesql")
    public Object exesql(@RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, String sql, String sort, String order, HttpServletResponse response) throws GEPSBisException {
        if (sql.contains("delete ") || sql.contains("update ") || sql.contains("truncate ") || sql.contains("drop ") || sql.contains("create ") || sql.contains("alter ") || sql.contains("insert ") || sql.contains("DELETE ") || sql.contains("UPDATE ") || sql.contains("TRUNCATE ") || sql.contains("DROP ") || sql.contains("CREATE ") || sql.contains("ALTER ") || sql.contains("INSERT ")) {
            response.setStatus(403);
            return null;
        }
        return this.generatorService.exesql(sql, page, rows, sort, order);
    }

    @RequestMapping(value={"/loadtable"})
    @ResponseBody
    public Object loadtable(String tablename) {
        JsonMsg msg = new JsonMsg();
        DBTable table = this.generatorService.buildTable(tablename);
        msg.setSuccess(true);
        msg.setO(table.columns);
        return msg;
    }

    @RequestMapping(value={"/loadtablecolumns"})
    @ResponseBody
    public Object loadtablecolumns(String tablename) {
        DBTable table = this.generatorService.buildTable(tablename);
        return table.columns;
    }

    @RequestMapping(value={"/findHibernateSequences"}, method={RequestMethod.POST})
    @ResponseBody
    public Object findHibernateSequences(HttpServletRequest request, String page, String rows) {
        Integer start = Integer.parseInt(page);
        Integer limit = Integer.parseInt(rows);
        return this.generatorService.findHibernateSequences(start, limit);
    }

    @RequestMapping(value={"/updateHibernateSequences"}, method={RequestMethod.POST})
    @ResponseBody
    public Object updateHibernateSequences(@RequestParam(value="maxId", required=false, defaultValue="0") int maxId, String tableName) {
        JsonMsg msg = new JsonMsg();
        this.generatorService.updateHibernateSequences(tableName, maxId);
        msg.setSuccess(true);
        msg.setMsg("\u66f4\u65b0\u6210\u529f,\u8bf7\u91cd\u65b0\u542f\u52a8\u670d\u52a1\u5668");
        return msg;
    }

    @RequestMapping(value={"/createLiuChengShili"})
    @ResponseBody
    public Object createLiuChengShili(String liuchengId, String accountid, Long liuchengnum, HttpServletRequest request) {
        Long accountIdLong;
        if (StringUtils.isEmpty((String)accountid)) {
            LoginUser user = this.getLoginUser(request);
            accountIdLong = user.getAccountid();
        } else {
            accountIdLong = Long.parseLong(accountid);
        }
        StringBuffer liuchengids = new StringBuffer();
        int i = 0;
        while ((long)i < liuchengnum) {
            Long processinstid = this.flowutilService.createAndStartProcessliuChengId(liuchengId, accountIdLong);
            liuchengids.append(processinstid);
            liuchengids.append(",");
            ++i;
        }
        JsonMsg msg = new JsonMsg();
        msg.setSuccess(true);
        msg.setO(liuchengids.toString());
        return msg;
    }

    @RequestMapping(value={"/getFormKey"})
    @ResponseBody
    public Object getFormKey(HttpServletRequest request, String formCode) {
        JsonMsg msg = new JsonMsg();
        msg.setSuccess(true);
        msg.setO(this.generatorService.getProcessinstidByFormCode(request, formCode));
        return msg;
    }
}

