/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.doc.service;

import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.CommTreeUtils;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.service.CommonService;
import com.ustc.doc.dao.DocFileTypeDao;
import com.ustc.doc.entity.DocFileType;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class DocFileTypeService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private DocFileTypeDao docfiletypeDao;

    public DocFileType findDocFileType(String id) {
        Optional op = this.docfiletypeDao.findById(id);
        if (!op.isPresent()) {
            return new DocFileType();
        }
        DocFileType entity = (DocFileType)this.docfiletypeDao.findById(id).get();
        return entity;
    }

    public void saveDocFileType(DocFileType entity) {
        this.docfiletypeDao.save(entity);
    }

    public void delDocFileType(String id) {
        this.docfiletypeDao.deleteById(id);
    }

    public PageObject PageAll(String catalogid, String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        String sql = "select * from DOC_FILE_TYPE t where t.CATALOG_ID=?1 and t.IS_USE='Y'  order by t.DISPLAY_NO";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select * from DOC_FILE_TYPE t where t.CATALOG_ID=?1  and t.IS_USE='Y'  and (  upper(t.FILE_TYPE_NAME) like ?2  or upper(t.REMARK) like ?2 ) order by t.DISPLAY_NO";
            pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{catalogid, "%" + search.toUpperCase() + "%"}, page, rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{catalogid}, page, rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("NULLABLE", "IS_USE");
        dicmapper.put("FILE_NATURE", "FILE_NATURE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject PageAllSearch(String catalogid, String search, int page, int rows, String projectId) {
        PageObject pageobject = new PageObject();
        String sql = "select t.*,a.file_no,a.file_name,b.original_name,b.version_no,b.version_id,getaccountname(c.create_account) create_account,c.create_time from doc_file_type t\n left join doc_form_file a on a.file_type_id=t.file_type_id\nleft join doc_file_version b on b.version_id=a.file_version_id\nleft join doc_file c on b.file_id=c.file_id\nwhere t.CATALOG_ID=?1 and t.IS_USE='Y'\n ";
        if (StringUtils.isNotEmpty((String)projectId)) {
            sql = sql + " and a.project_id = " + projectId + "\n";
        }
        sql = sql + " order by t.DISPLAY_NO";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select t.*,a.file_no,a.file_name,b.original_name,b.version_no,b.version_id,getaccountname(c.create_account) create_account,c.create_time from doc_form_file a\n left join doc_file_type t on a.file_type_id=t.file_type_id\nleft join doc_file_version b on b.version_id=a.file_version_id\nleft join doc_file c on b.file_id=c.file_id\nwhere t.CATALOG_ID=?1 and t.IS_USE='Y' \n";
            if (StringUtils.isNotEmpty((String)projectId)) {
                sql = sql + " and a.project_id = " + projectId + "\n";
            }
            sql = sql + "and (  upper(t.FILE_TYPE_NAME) like ?2  or upper(a.FILE_NAME) like ?2 or upper(a.FILE_NO) like ?2 or upper(t.REMARK) like ?2 ) order by t.DISPLAY_NO";
            pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{catalogid, "%" + search.toUpperCase() + "%"}, page, rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{catalogid}, page, rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("NULLABLE", "IS_USE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public List<ComBoxTreeNode> chooseFileTypeTree(String sysType) {
        StringBuilder sql = new StringBuilder();
        if (!StringUtils.isEmpty((String)sysType)) {
            sql.append("with recursive t as (select concat('C' , A.CATALOG_ID) ID,\n               concat('C' , A.PCATALOG_ID) PID,\n               A.CATALOG_NAME AS TEXT,\n               A.CATALOG_ID AS NODEID,\n               0 AS FILETYPE,\n               A.DISPLAY_NO\n          from DOC_CATALOG A where a.is_use='Y' and a.catalog_type=1 and (A.SYSTEM_CATEGORY ='" + sysType + "' or A.SYSTEM_CATEGORY ='PUBLIC') \n        UNION\n        SELECT concat('T' , B.FILE_TYPE_ID) ID,\n               concat('C' , B.CATALOG_ID) AS PID,\n               B.FILE_TYPE_NAME AS TEXT,\n               B.FILE_TYPE_ID AS NODEID,\n               1 AS FILETYPE,\n               B.DISPLAY_NO\n          FROM DOC_FILE_TYPE B where b.is_use='Y'),\n\t\t\t\t\ttemp as(\n\t\t\t\t\tselect t.* from t where t.PID = 'C0'\n\t\t\t\t\tunion all \n\t\t\t\t\tselect t.* from t,temp  where t.PID = temp.id\n\t\t\t\t\t)\nselect * from temp order by DISPLAY_NO");
        } else {
            sql.append("with recursive t as (select concat('C' , A.CATALOG_ID) ID,\n               concat('C' , A.PCATALOG_ID) PID,\n               A.CATALOG_NAME AS TEXT,\n               A.CATALOG_ID AS NODEID,\n               0 AS FILETYPE,\n               A.DISPLAY_NO\n          from DOC_CATALOG A where a.is_use='Y' and a.catalog_type=1  \n        UNION\n        SELECT concat('T' , B.FILE_TYPE_ID) ID,\n               concat('C' , B.CATALOG_ID) AS PID,\n               B.FILE_TYPE_NAME AS TEXT,\n               B.FILE_TYPE_ID AS NODEID,\n               1 AS FILETYPE,\n               B.DISPLAY_NO\n          FROM DOC_FILE_TYPE B where b.is_use='Y'),\n\t\t\t\t\ttemp as(\n\t\t\t\t\tselect t.* from t where t.PID = 'C0'\n\t\t\t\t\tunion all \n\t\t\t\t\tselect t.* from t,temp  where t.PID = temp.id\n\t\t\t\t\t)\nselect * from temp order by DISPLAY_NO");
        }
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        return CommTreeUtils.buildTreeNode(list);
    }
}

