/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.doc.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.SysUtils;
import com.ustc.doc.dao.DocFileLogDao;
import com.ustc.doc.entity.DocFileLog;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class DocFileLogService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private DocFileLogDao docfilelogDao;

    public DocFileLog findDocFileLog(Long id) {
        DocFileLog entity = (DocFileLog)this.docfilelogDao.findById(id).get();
        return entity;
    }

    public void saveDocFileLog(DocFileLog entity) {
        this.docfilelogDao.save(entity);
    }

    public void delDocFileLog(Long id) {
        DocFileLog entity = (DocFileLog)this.docfilelogDao.findById(id).get();
        this.docfilelogDao.save(entity);
    }

    public PageObject PageAll(String versionId, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", sort);
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((String)versionId)) {
            params.put("versionId", versionId);
        }
        return this.bSqlHelper.serachPage("doc.DocFileLog.select", params, PageRequest.of((int)page, (int)rows));
    }

    public void saveFileLog(LoginUser loginUser, Long versionid, HttpServletRequest request, String operationType) {
        DocFileLog log = new DocFileLog();
        if (loginUser != null) {
            log.setCreateAccount(loginUser.getAccountid());
        }
        log.setCreateTime(new Date());
        log.setIp(SysUtils.getIpAddr(request));
        log.setOperationType(operationType);
        log.setVersionId(versionid);
        this.docfilelogDao.save(log);
    }
}

