/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.doc.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.zxing.WriterException;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.BasMessage;
import com.ustc.base.service.BasMessageService;
import com.ustc.doc.common.FileService;
import com.ustc.doc.common.persist.FileInfo;
import com.ustc.doc.entity.DocFileVersion;
import com.ustc.doc.service.DocFileVersionService;
import java.io.IOException;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/qrcode"})
public class QRCodeController
extends BaseController {
    @Autowired
    private FileService fileService;
    @Autowired
    private DocFileVersionService docfileversionService;
    @Autowired
    private BasMessageService basMessageService;

    @RequestMapping(value={"/genqrcode"})
    public ModelAndView genqrcode(HttpServletRequest request, FileInfo fileinfo) {
        ModelAndView view = new ModelAndView();
        DocFileVersion version = fileinfo.isUsebase() ? this.docfileversionService.findBaseVersionByVersionid(fileinfo.getVersionid()) : this.docfileversionService.findDocFileVersion(fileinfo.getVersionid());
        view.setViewName("/common/printQrcode");
        view.addObject("fileversion", (Object)version);
        return view;
    }

    @RequestMapping(value={"/genFileCode"})
    @ResponseBody
    public void genFileCode(HttpServletRequest request, HttpServletResponse response, Long versionid) throws IOException, WriterException {
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        JSONObject object = new JSONObject();
        object.put("QRCODE", (Object)"0");
        object.put("versionid", (Object)versionid);
        SysUtils.genQRCode(response, object.toJSONString());
    }

    @RequestMapping(value={"/genBizCode"})
    @ResponseBody
    public void genBizCode(HttpServletRequest request, HttpServletResponse response, String formcode, Long id, Long processinstid, String url) throws IOException, WriterException {
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        JSONObject object = new JSONObject();
        object.put("QRCODE", (Object)"1");
        object.put("formcode", (Object)formcode);
        object.put("id", (Object)id);
        object.put("processinstid", (Object)processinstid);
        SysUtils.genQRCode(response, object.toJSONString());
    }

    @RequestMapping(value={"/scanQRCode"})
    @ResponseBody
    public JsonMsg scanQRCode(HttpServletRequest request, HttpServletResponse response, String params) throws IOException, WriterException {
        JsonMsg msg = new JsonMsg();
        if (StrKit.isBlank(params)) {
            msg.setSuccess(false);
            msg.setMsg("\u4e8c\u7ef4\u7801\u4fe1\u606f\u4e3a\u7a7a");
            return msg;
        }
        Long accountid = this.getLoginUser(request).getAccountid();
        JSONObject object = new JSONObject();
        try {
            System.out.println("\u4e8c\u7ef4\u7801\u626b\u63cf\u4fe1\u606f:" + params);
            String decodeparams = new String(Base64.decodeBase64((String)params));
            System.out.println("\u4e8c\u7ef4\u7801\u626b\u63cf\u4fe1\u606f\u89e3\u7801\u7ed3\u679c:" + decodeparams);
            object = JSON.parseObject((String)decodeparams);
            System.out.println("\u4e8c\u7ef4\u7801\u626b\u63cf\u7ed3\u679c:" + object);
        }
        catch (Exception e) {
            msg.setSuccess(false);
            msg.setMsg("\u4e8c\u7ef4\u7801\u4fe1\u606f\u4e0d\u53ef\u8bc6\u522b");
            return msg;
        }
        String qrcode = object.getString("QRCODE");
        Long processinstid = object.getLong("processinstid");
        HashMap<String, Object> returnparams = new HashMap<String, Object>();
        if ("1".equals(qrcode)) {
            BasMessage message = this.basMessageService.findMsgByProcessinstid(accountid, processinstid);
            if (message != null) {
                String url = "/BasMessage/todoDetail";
                if (StrKit.notBlank(message.getMsgUrl())) {
                    url = message.getMsgUrl();
                }
                String urlparams = "msgid=" + message.getMsgId() + "&formcode=" + object.getString("formcode") + "&id=" + object.getLong("id") + "&processinstid=" + object.getLong("processinstid");
                url = url.indexOf("?") > 0 ? url + "&" + urlparams : url + "?" + urlparams;
                returnparams.put("qrcodetype", "4");
                returnparams.put("url", url);
                returnparams.put("message", message);
                msg.setO(returnparams);
            } else {
                String nomessageurl = "/BasMessage/viewDetail";
                String noessageparams = "formcode=" + object.getString("formcode") + "&id=" + object.getLong("id") + "&processinstid=" + object.getLong("processinstid");
                nomessageurl = nomessageurl.indexOf("?") > 0 ? nomessageurl + "&" + noessageparams : nomessageurl + "?" + noessageparams;
                returnparams.put("qrcodetype", "3");
                returnparams.put("url", nomessageurl);
                returnparams.put("busiMainId", object.getLong("id"));
                msg.setO(returnparams);
            }
        } else if ("0".equals(qrcode)) {
            String url = "/file/viewfileByVersionId?versionid=" + object.getLong("versionid");
            returnparams.put("qrcodetype", "0");
            returnparams.put("url", url);
            msg.setO(returnparams);
        }
        return msg;
    }
}

