/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.doc.common.ocr;

import com.alibaba.fastjson.JSON;
import com.baidu.aip.contentcensor.EImgType;
import com.ustc.base.common.spring.ThirdPartyInterfaceLog;
import com.ustc.base.common.util.DateUtils;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.doc.common.ocr.AipOcr;
import com.ustc.doc.common.ocr.InvoiceInfo;
import com.ustc.doc.entity.DocFormFile;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AipOcrCilentUtils {
    public static String SWITCH = "off";
    public static String VERIFICATION_SWITCH = "off";
    public static String APP_ID = "25430881";
    public static String API_KEY = "IMyIWOP4Pm7DVaqv18p0M5Nd";
    public static String SECRET_KEY = "zBrVGyAgTBqumSCUhx9TZZpcxtA7Hs7I";
    private static AipOcr client = null;
    private static Logger loger = LoggerFactory.getLogger(AipOcrCilentUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AipOcr getClient() {
        if (client != null) return client;
        Class<AipOcrCilentUtils> clazz = AipOcrCilentUtils.class;
        synchronized (AipOcrCilentUtils.class) {
            client = new AipOcr(APP_ID, API_KEY, SECRET_KEY);
            client.setConnectionTimeoutInMillis(10000);
            client.setSocketTimeoutInMillis(60000);
            // ** MonitorExit[var0] (shouldn't be in output)
            return client;
        }
    }

    @ThirdPartyInterfaceLog(description="ocr\u667a\u80fd")
    public InvoiceInfo getMultipleInvoiceInfo(String path) {
        InvoiceInfo info = new InvoiceInfo();
        if (!"on".equals(SWITCH)) {
            return info;
        }
        String fileext = FilenameUtils.getExtension((String)path);
        List<String> types = Arrays.asList("pdf", "png", "jpg", "jpeg", "bmp");
        if (!types.contains(fileext)) {
            return info;
        }
        AipOcrCilentUtils.getClient();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("recognize_granularity", "big");
        options.put("probability", "true");
        options.put("accuracy", "normal");
        options.put("detect_direction", "true");
        long t1 = System.currentTimeMillis();
        JSONObject res = "pdf".equals(fileext) ? client.multipleInvoice(path, EImgType.PDF, options) : client.multipleInvoice(path, options);
        loger.info("ocr\u63a5\u53e3\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - t1) + "\u6beb\u79d2,\u8bc6\u522b\u7ed3\u679c\uff1a" + res.toString());
        try {
            res = res.getJSONArray("words_result").getJSONObject(0);
        }
        catch (Exception e2) {
            loger.error("ocr\u7ed3\u679c\u89e3\u6790\u5931\u8d25", (Throwable)e2);
        }
        JSONObject result = new JSONObject();
        try {
            result = res.getJSONObject("result");
        }
        catch (Exception e3) {
            loger.error("ocr\u7ed3\u679c\u89e3\u6790\u5931\u8d25", (Throwable)e3);
        }
        try {
            if ("vat_invoice".equals(res.getString("type"))) {
                if (result.getJSONArray("InvoiceType").getJSONObject(0).getString("word").contains("\u4e13\u7528")) {
                    info.setBillType("1");
                } else {
                    info.setBillType("2");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            info.setBillCode(result.getJSONArray("InvoiceCode").getJSONObject(0).getString("word"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            info.setBillNo(result.getJSONArray("InvoiceNum").getJSONObject(0).getString("word"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            info.setBillDate(DateUtils.strToDate(result.getJSONArray("InvoiceDate").getJSONObject(0).getString("word").replaceAll("\u5e74|\u6708|\u65e5", "-")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            info.setBillMoney(new BigDecimal(result.getJSONArray("AmountInFiguers").getJSONObject(0).getString("word")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            info.setBillMoneyNoTax(new BigDecimal(result.getJSONArray("TotalAmount").getJSONObject(0).getString("word")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (result.getJSONArray("TotalTax").getJSONObject(0).getString("word").contains("*")) {
                info.setBillTaxMoney(new BigDecimal(0));
            } else {
                info.setBillTaxMoney(new BigDecimal(result.getJSONArray("TotalTax").getJSONObject(0).getString("word")));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            info.setCheckCode(result.getJSONArray("CheckCode").getJSONObject(0).getString("word"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return info;
    }

    @ThirdPartyInterfaceLog(description="ocr\u53d1\u7968")
    public InvoiceInfo getInvoiceInfo(String path) {
        InvoiceInfo info = new InvoiceInfo();
        if (!"on".equals(SWITCH)) {
            return info;
        }
        String fileext = FilenameUtils.getExtension((String)path);
        List<String> types = Arrays.asList("pdf", "png", "jpg", "jpeg", "bmp");
        if (!types.contains(fileext)) {
            return info;
        }
        AipOcrCilentUtils.getClient();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("recognize_granularity", "big");
        options.put("probability", "true");
        options.put("accuracy", "normal");
        options.put("detect_direction", "true");
        long t1 = System.currentTimeMillis();
        JSONObject res = "pdf".equals(fileext) ? client.vatInvoice(path, EImgType.PDF, options) : client.vatInvoice(path, options);
        loger.info("\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - t1) + "\u6beb\u79d2,ocr\u7ed3\u679c\uff1a" + res);
        try {
            res = res.getJSONObject("words_result");
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        try {
            info.setBillCode(res.get("InvoiceCode").toString());
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            info.setBillNo(res.getString("InvoiceNum"));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            info.setBillDate(DateUtils.parseDate(res.getString("InvoiceDate")));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            info.setBillMoney(new BigDecimal(res.getString("AmountInFiguers")));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            info.setBillMoneyNoTax(new BigDecimal(res.getString("TotalAmount")));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            if (res.getString("TotalTax").contains("*")) {
                info.setBillTaxMoney(new BigDecimal(0));
            } else {
                info.setBillTaxMoney(new BigDecimal(res.getString("TotalTax")));
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            if (res.getString("InvoiceType").contains("\u4e13\u7528")) {
                info.setBillType("1");
            } else {
                info.setBillType("2");
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            info.setCheckCode(res.getString("CheckCode"));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            info.setSaleName(res.getString("SellerName"));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            info.setServiceType(res.getJSONArray("CommodityName").getJSONObject(0).getString("word"));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            info.setPurchaserName(res.getString("PurchaserName"));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            info.setPurchaserRegisterNum(res.getString("PurchaserRegisterNum"));
        }
        catch (Exception e2) {
            // empty catch block
        }
        try {
            String invoiceType = res.getString("InvoiceType");
            String buildinvoiceType = "normal_invoice";
            if (invoiceType.contains("\u7535\u5b50\u666e\u901a\u53d1\u7968")) {
                buildinvoiceType = "elec_normal_invoice";
            } else if (invoiceType.contains("\u7535\u5b50\u4e13\u7528\u53d1\u7968")) {
                buildinvoiceType = "elec_special_vat_invoice";
            } else if (invoiceType.contains("\u666e\u901a\u53d1\u7968")) {
                buildinvoiceType = "normal_invoice";
            } else if (invoiceType.contains("\u4e13\u7528\u53d1\u7968")) {
                buildinvoiceType = "special_vat_invoice";
            } else if (invoiceType.contains("\u4e13\u7528\u53d1\u7968")) {
                buildinvoiceType = "special_vat_invoice";
            } else if (invoiceType.contains("\u901a\u884c\u8d39\u7535\u5b50\u666e\u7968")) {
                buildinvoiceType = "toll_elec_normal_invoice";
            } else if (invoiceType.contains("\u533a\u5757\u94fe\u53d1\u7968")) {
                buildinvoiceType = "blockchain_invoice";
            } else if (invoiceType.contains("\u901a\u7528\u673a\u6253\u7535\u5b50\u53d1\u7968")) {
                buildinvoiceType = "special_vat_invoice";
            } else if (invoiceType.contains("\u4e8c\u624b\u8f66")) {
                buildinvoiceType = "used_vehicle_invoice";
            }
            info.setInvoiceType(buildinvoiceType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return info;
    }

    @ThirdPartyInterfaceLog(description="\u53d1\u7968\u9a8c\u771f")
    public JsonMsg verification(DocFormFile file) throws JSONException {
        JsonMsg msg = new JsonMsg();
        if (file != null && file.getBillTaxMoney() == null) {
            file.setBillTaxMoney(new BigDecimal(0));
        }
        if (!"on".equals(VERIFICATION_SWITCH)) {
            msg.setMsg("\u53d1\u7968\u9a8c\u771f\u5f00\u5173\u672a\u5f00\u542f");
            return msg;
        }
        AipOcrCilentUtils.getClient();
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("invoice_code", file.getBillCode());
        options.put("invoice_num", file.getBillNo());
        options.put("invoice_date", DateUtils.dateToStr(file.getBillDate(), "yyyyMMdd"));
        if (StringUtils.isNotBlank((CharSequence)file.getInvoiceType())) {
            options.put("invoice_type", file.getInvoiceType());
        } else if ("1".equals(file.getBillType())) {
            options.put("invoice_type", "special_vat_invoice");
        } else {
            options.put("invoice_type", "normal_invoice");
        }
        options.put("check_code", file.getCheckCode());
        if (file.getInvoiceType().startsWith("elec_invoice") || "used_vehicle_invoice".equals(file.getInvoiceType())) {
            options.put("total_amount", file.getBillMoney().toString());
        } else {
            options.put("total_amount", file.getBillMoney().subtract(file.getBillTaxMoney()).toString());
        }
        long t1 = System.currentTimeMillis();
        JSONObject res = client.invoiceVerification(null, options);
        loger.info("\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - t1) + "\u6beb\u79d2,\u53d1\u7968\u9a8c\u771f\u7ed3\u679c\uff1a" + res + ",\u53d1\u7968\u4fe1\u606f\uff1a" + options.toString());
        if ("0001".equals(res.getString("VerifyResult"))) {
            msg.setSuccess(true);
        } else {
            msg.setSuccess(false);
        }
        msg.setO("\u5171\u8017\u65f6\uff1a" + (System.currentTimeMillis() - t1) + "\u6beb\u79d2,\u53d1\u7968\u9a8c\u771f\u7ed3\u679c\uff1a" + res.getString("VerifyResult") + ",\u53d1\u7968\u4fe1\u606f\uff1a" + options.toString());
        msg.setMsg(res.getString("VerifyMessage"));
        try {
            msg.setCode(res.getString("VerifyResult"));
            if ("1005".equals(res.getString("VerifyResult")) || "1009".equals(res.getString("VerifyResult")) || "1006".equals(res.getString("VerifyResult")) || "0009".equals(res.getString("VerifyResult")) || "0006".equals(res.getString("VerifyResult")) || "0005".equals(res.getString("VerifyResult"))) {
                msg.setMsg(msg.getMsg() + ",\u8bf7\u68c0\u67e5\u53d1\u7968\u53f7\u3001\u53d1\u7968\u4ee3\u7801\u3001\u5f00\u7968\u65e5\u671f\u3001\u5f00\u7968\u91d1\u989d\u3001\u7a0e\u989d\u3001\u6821\u9a8c\u7801\u7b49\u662f\u5426\u6b63\u786e");
            }
        }
        catch (Exception e) {
            loger.error("\u83b7\u53d6\u9519\u8bef\u7801\u5931\u8d25", (Throwable)e);
        }
        return msg;
    }

    public String getAPP_ID() {
        return APP_ID;
    }

    @Value(value="${ocr.appId}")
    public void setAPP_ID(String aPP_ID) {
        APP_ID = aPP_ID;
    }

    public String getVERIFICATION_SWITCH() {
        return VERIFICATION_SWITCH;
    }

    @Value(value="${ocr.verswitch:'off'}")
    public void setVERIFICATION_SWITCH(String vERIFICATION_SWITCH) {
        VERIFICATION_SWITCH = vERIFICATION_SWITCH;
    }

    public String getAPI_KEY() {
        return API_KEY;
    }

    @Value(value="${ocr.appKey}")
    public void setAPI_KEY(String aPI_KEY) {
        API_KEY = aPI_KEY;
    }

    public String getSECRET_KEY() {
        return SECRET_KEY;
    }

    @Value(value="${ocr.secretKey}")
    public void setSECRET_KEY(String sECRET_KEY) {
        SECRET_KEY = sECRET_KEY;
    }

    public String getSWITCH() {
        return SWITCH;
    }

    @Value(value="${ocr.switch}")
    public void setSWITCH(String sWITCH) {
        SWITCH = sWITCH;
    }

    public static void main(String[] args) throws Exception {
        InvoiceInfo info = new AipOcrCilentUtils().getMultipleInvoiceInfo("C:\\Users\\40670\\Desktop\\1636430901(1).jpg");
        System.out.println(JSON.toJSONString((Object)info));
    }
}

