/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.doc.common.convert;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.arnx.wmf2svg.gdi.Gdi;
import net.arnx.wmf2svg.gdi.svg.SvgGdi;
import net.arnx.wmf2svg.gdi.wmf.WmfParser;
import org.w3c.dom.Document;

public class WmfToSvg {
    private static WmfToSvg instance;

    public static WmfToSvg getInstance() {
        if (instance == null) {
            instance = new WmfToSvg();
        }
        return instance;
    }

    public void converter(byte[] wmfBytes, String dest) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(wmfBytes);
        WmfParser parser = new WmfParser();
        SvgGdi gdi = new SvgGdi(false);
        parser.parse((InputStream)in, (Gdi)gdi);
        Document doc = gdi.getDocument();
        OutputStream out = new FileOutputStream(dest);
        if (dest.endsWith(".svgz")) {
            out = new GZIPOutputStream(out);
        }
        WmfToSvg.output(doc, out);
    }

    public void convert(String file, String dest) throws Exception {
        FileInputStream in = new FileInputStream(file);
        WmfParser parser = new WmfParser();
        SvgGdi gdi = new SvgGdi(false);
        parser.parse((InputStream)in, (Gdi)gdi);
        Document doc = gdi.getDocument();
        OutputStream out = new FileOutputStream(dest);
        if (dest.endsWith(".svgz")) {
            out = new GZIPOutputStream(out);
        }
        WmfToSvg.output(doc, out);
    }

    public byte[] encodeConvert() {
        return null;
    }

    private static void output(Document doc, OutputStream out) throws Exception {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("doctype-public", "-//W3C//DTD SVG 1.0//EN");
        transformer.setOutputProperty("doctype-system", "http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd");
        transformer.transform(new DOMSource(doc), new StreamResult(out));
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(doc), new StreamResult(bos));
        out.flush();
        out.close();
    }

    public static void main(String[] agrs) throws Exception {
    }
}

