/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.HtmlSignatureDao;
import com.ustc.base.entity.HtmlSignature;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class HtmlSignatureService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private HtmlSignatureDao htmlsignatureDao;

    public HtmlSignature findHtmlSignature(Long id) {
        HtmlSignature entity = (HtmlSignature)this.htmlsignatureDao.findById(id).get();
        return entity;
    }

    public List<HtmlSignature> findByDocumentidAndSignatureid(String documentid, String signatureid) {
        return this.htmlsignatureDao.findByDocumentidAndSignatureidAndIsUse(documentid, signatureid, "Y");
    }

    public List<HtmlSignature> findByDocumentid(String documentid) {
        return this.htmlsignatureDao.findByDocumentidAndIsUse(documentid, "Y");
    }

    public void saveHtmlSignature(HtmlSignature entity) {
        this.htmlsignatureDao.save(entity);
    }

    public void delHtmlSignature(HtmlSignature signature) {
        signature.setIsUse("N");
        this.htmlsignatureDao.save(signature);
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        String sql = "select * from HTML_SIGNATURE t  order by t.ID";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select * from HTML_SIGNATURE t where   upper(t.ID) like ?1  or upper(t.DOCUMENTID) like ?1  or upper(t.SIGNATUREID) like ?1  or upper(t.SIGNATURESIZE) like ?1  or upper(t.SIGNATURE) like ?1  order by t.ID";
            pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{"%" + search.toUpperCase() + "%"}, page, rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql, page, rows);
        }
        return pageobject;
    }
}

