/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.DateUtils;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.dao.GmSpaceDefineDao;
import com.ustc.base.entity.GmSpaceDefine;
import com.ustc.gen.util.DBPropertyUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GmSpaceDefineService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private GmSpaceDefineDao gmspacedefineDao;

    public GmSpaceDefine findGmSpaceDefine(Long id) {
        GmSpaceDefine entity = (GmSpaceDefine)this.gmspacedefineDao.findById(id).get();
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (id != null) {
            params.put("spaceId", id);
        }
        Map<String, Object> mapUseUser = this.bSqlHelper.getMap("base.GmSpaceDefine.getUseUserIdTextBySpaceId", params);
        entity.setUseUserId((String)mapUseUser.get("userId"));
        entity.setUseUserId_TEXT_((String)mapUseUser.get("userName"));
        Map<String, Object> mapManageUser = this.bSqlHelper.getMap("base.GmSpaceDefine.getManageUserIdTextBySpaceId", params);
        entity.setManageUserId((String)mapManageUser.get("userId"));
        entity.setManageUserId_TEXT_((String)mapManageUser.get("userName"));
        return entity;
    }

    public GmSpaceDefine findGmSpaceDefineById(Long id) {
        GmSpaceDefine entity = (GmSpaceDefine)this.gmspacedefineDao.findById(id).get();
        return entity;
    }

    public void saveGmSpaceDefine(GmSpaceDefine entity) {
        this.gmspacedefineDao.save(entity);
    }

    public void delGmSpaceDefine(Long id) {
        GmSpaceDefine entity = (GmSpaceDefine)this.gmspacedefineDao.findById(id).get();
        entity.setIsUse("N");
        this.gmspacedefineDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order, String spaceTypeText) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        if (!StringUtils.isEmpty((String)spaceTypeText)) {
            params.put("spaceTypeText", "%" + spaceTypeText.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.serachPage("base.GmSpaceDefine.select", params, PageRequest.of((int)page, (int)rows));
    }

    public List<GmSpaceDefine> getMySpaceList() {
        LoginUser user = SysUtils.getLoginUser();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("orgId", user.getOrgid());
        params.put("deptId", user.getDeptid());
        params.put("userId", user.getAccountid());
        return this.bSqlHelper.getList("base.GmSpaceDefine.getMySpaceList", params, GmSpaceDefine.class);
    }

    public List<Map<String, Object>> getMyApply(String search, int maxsize) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        params.put("userId", SysUtils.getLoginAccountId());
        params.put("maxsize", maxsize);
        return this.bSqlHelper.getMapList("base.GmSpaceDefine.getMyApply", params);
    }

    public List<Map<String, Object>> getMyWork(String search) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        LoginUser user = SysUtils.getLoginUser();
        params.put("accountid", user.getAccountid());
        params.put("org", user.getOrgid());
        params.put("dept", user.getDeptid());
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        params.put("userId", SysUtils.getLoginAccountId());
        return this.bSqlHelper.getMapList("base.GmSpaceDefine.getMyWork", params);
    }

    public List<Map<String, Object>> getMyEdocApply(String search, String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        if (!StringUtils.isEmpty((String)type)) {
            params.put("type", type);
        }
        params.put("userId", SysUtils.getLoginAccountId());
        return this.bSqlHelper.getMapList("base.GmSpaceDefine.getEdocApply", params);
    }

    public List<Map<String, Object>> getMyKnowledgeDocument(String search) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        LoginUser user = SysUtils.getLoginUser();
        params.put("userId", user.getAccountid());
        params.put("orgId", user.getOrgid());
        params.put("deptId", user.getDeptid());
        return this.bSqlHelper.getMapList("base.GmSpaceDefine.getMyKnowledgeDocument", params);
    }

    public PageObject getMyApplyNew(String page, String rows, String search, String startDate, String endDate, Long flowDone, String subject, String flowType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", SysUtils.getLoginAccountId());
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            params.put("startDate", startDate);
        }
        if (!StringUtils.isEmpty((String)endDate)) {
            params.put("endDate", endDate);
        }
        if (!StringUtils.isEmpty((String)subject)) {
            params.put("subject", subject);
        }
        if (!StringUtils.isEmpty((String)flowType)) {
            params.put("flowType", flowType);
        }
        if (flowDone != null) {
            params.put("status", flowDone);
        }
        return this.bSqlHelper.serachPage("base.GmSpaceDefine.getMyApplyNew", params, PageRequest.of((int)Integer.parseInt(page), (int)Integer.parseInt(rows)));
    }

    public Object getMyApplyNew1(String page, String rows, String search, String flowCode, String accountType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", SysUtils.getLoginAccountId());
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        if (!StringUtils.isEmpty((String)flowCode)) {
            params.put("flowCode", flowCode);
        }
        if (!StringUtils.isEmpty((String)accountType)) {
            params.put("accountType", accountType);
        }
        return this.bSqlHelper.serachPage("base.GmSpaceDefine.getMyApplyNew1", params, PageRequest.of((int)Integer.parseInt(page), (int)Integer.parseInt(rows)));
    }

    public Object getMyApplyListByFormCode(String page, String rows, String search, String formCode, String accountType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("userId", SysUtils.getLoginAccountId());
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        if (!StringUtils.isEmpty((String)formCode)) {
            params.put("formCode", formCode);
        }
        if (!StringUtils.isEmpty((String)accountType)) {
            params.put("accountType", accountType);
        }
        return this.bSqlHelper.serachPage("base.GmSpaceDefine.getMyApplyListByFormCode", params, PageRequest.of((int)Integer.parseInt(page), (int)Integer.parseInt(rows)));
    }

    public List<Map<String, Object>> findFirstMenuSpace(Long menuId, String station, Long orgId, Long deptId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("menuId", menuId);
        params.put("station", station);
        params.put("orgId", orgId);
        params.put("deptId", deptId);
        return this.bSqlHelper.getMapList("base.GmSpaceDefine.findFirstMenuSpace", params);
    }

    public Boolean checkGmSpaceDefine(GmSpaceDefine entity) {
        String orgIds = entity.getOrgId();
        String deptIds = entity.getDeptId();
        if (!StringUtils.isEmpty((String)orgIds)) {
            String[] org;
            for (String o : org = orgIds.split(",")) {
                if (!StringUtils.isEmpty((String)deptIds)) {
                    String[] dept;
                    for (String d : dept = deptIds.split(",")) {
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        if (entity.getSpaceId() != null) {
                            params.put("spaceId", entity.getSpaceId());
                        }
                        params.put("spaceType", entity.getSpaceType());
                        params.put("empLv", entity.getEmpLv());
                        params.put("org", o);
                        params.put("dept", d);
                        params.put("menuId", entity.getMenuId());
                        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.GmSpaceDefine.checkGmSpaceDefine", params);
                        if (list == null || list.size() <= 0) continue;
                        return false;
                    }
                    continue;
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                if (entity.getSpaceId() != null) {
                    params.put("spaceId", entity.getSpaceId());
                }
                params.put("spaceType", entity.getSpaceType());
                params.put("empLv", entity.getEmpLv());
                params.put("org", o);
                params.put("menuId", entity.getMenuId());
                List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.GmSpaceDefine.checkGmSpaceDefine", params);
                if (list == null || list.size() <= 0) continue;
                return false;
            }
        }
        return true;
    }

    public List<Map<String, Object>> getMyCommonProcesses(String search) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        return this.bSqlHelper.getMapList("base.BasMessage.getMyFlowCY", params);
    }

    public List<Map<String, Object>> getIncomeList(String type) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)type)) {
            params.put("type", type);
        }
        return this.bSqlHelper.getMapList("base.GmSpaceDefine.getIncomeList", params);
    }

    public List<Map<String, Object>> getIncomeListByYear() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.bSqlHelper.getMapList("base.GmSpaceDefine.getIncomeListByYear", params);
    }

    public List<Map<String, Object>> getGmAssetsInventory() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.bSqlHelper.getMapList("base.GmSpaceDefine.getGmAssetsInventory", params);
    }

    public Map<String, Object> getGmAssetsInventoryWG() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.bSqlHelper.getMap("base.GmSpaceDefine.getGmAssetsInventoryWG", params);
    }

    public Map<String, Object> getConIncomeInfo() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.bSqlHelper.getMap("base.GmSpaceDefine.getConIncomeInfo", params);
    }

    public Map<String, Object> getHouseInfo() {
        Map<Object, Object> map = new HashMap();
        HashMap<String, Object> params = new HashMap<String, Object>();
        map = this.bSqlHelper.getMap("base.GmSpaceDefine.getHouseInfo", params);
        List<Map<String, Object>> houseTypeCount = this.bSqlHelper.getMapList("base.GmSpaceDefine.getHouseTypeCount", params);
        map.put("houseTypeCount", houseTypeCount);
        return map;
    }

    public Map<String, Object> getFundMoney() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("money", this.bSqlHelper.getMap("base.GmSpaceDefine.getFundMoney", new HashMap<String, Object>()));
        map.put("index", this.bSqlHelper.getMapList("base.GmSpaceDefine.getMainBusiIndex", new HashMap<String, Object>()));
        return map;
    }

    public Map<String, Object> getMoneyInfo() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<Map<String, Object>> moneyYearList = this.bSqlHelper.getMapList("base.GmSpaceDefine.getMoneyByYear", params);
        params.put("month", DateUtils.dateToMonthStr(new Date()));
        Map<String, Object> moneyNow = this.bSqlHelper.getMap("base.GmSpaceDefine.getMoneyByYear", params);
        map.put("moneyYearList", moneyYearList);
        map.put("moneyNow", moneyNow);
        return map;
    }

    public Map<String, Object> getConInfo() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Map<String, Object> map = this.bSqlHelper.getMap("base.GmSpaceDefine.getConInfo", params);
        BigDecimal carryOnCount = new BigDecimal(map.get("carryOnCount").toString());
        BigDecimal thisCount = new BigDecimal(map.get("thisCount").toString());
        BigDecimal thisEndCount = new BigDecimal(map.get("thisEndCount").toString());
        BigDecimal renewalCount = new BigDecimal(map.get("renewalCount").toString());
        BigDecimal total = carryOnCount.add(thisCount).add(thisEndCount).add(renewalCount);
        BigDecimal carryOnCountRate = carryOnCount.divide(total, 2, 4).multiply(new BigDecimal("100")).setScale(2, 4);
        BigDecimal thisCountRate = thisCount.divide(total, 2, 4).multiply(new BigDecimal("100")).setScale(2, 4);
        BigDecimal thisEndCountRate = thisEndCount.divide(total, 2, 4).multiply(new BigDecimal("100")).setScale(2, 4);
        BigDecimal renewalCountRate = renewalCount.divide(total, 2, 4).multiply(new BigDecimal("100")).setScale(2, 4);
        map.put("carryOnCountRate", carryOnCountRate);
        map.put("thisCountRate", thisCountRate);
        map.put("thisEndCountRate", thisEndCountRate);
        map.put("renewalCountRate", renewalCountRate);
        return map;
    }

    public Map<String, Object> getFinanceMoneyInfo() {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyyMM");
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<Map<String, Object>> financeMoneyList = this.bSqlHelper.getMapList("base.GmSpaceDefine.getFinanceMoneyByYear", params);
        params.put("month", formatter.format(new Date()));
        Map<String, Object> financeMoneyNow = this.bSqlHelper.getMap("base.GmSpaceDefine.getFinanceMoneyByYear", params);
        map.put("financeMoneyList", financeMoneyList);
        map.put("financeMoneyNow", financeMoneyNow);
        return map;
    }

    public List<Map<String, Object>> findMyReimburseData(String search) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase().replace("%", "/%") + "%");
        }
        params.put("userId", SysUtils.getLoginAccountId());
        return this.bSqlHelper.getMapList("base.GmSpaceDefine.myReimburseData", params);
    }

    public Map<String, Object> getConCockpit() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        return this.bSqlHelper.getMap("base.GmSpaceDefine.getConCockpit", params);
    }
}

