/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.GmSpaceComponentCustomDao;
import com.ustc.base.dao.GmSpaceComponentDefinitionDao;
import com.ustc.base.entity.GmInfoType;
import com.ustc.base.entity.GmSpaceComponentCustom;
import com.ustc.base.entity.GmSpaceComponentDefinition;
import com.ustc.base.service.GmInfoTypeService;
import com.ustc.gen.util.DBPropertyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GmSpaceComponentCustomService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private GmSpaceComponentCustomDao gmSpaceComponentCustomDao;
    @Autowired
    private GmInfoTypeService gminfotypeService;
    @Autowired
    private GmSpaceComponentDefinitionDao gmSpaceComponentDefinitionDao;

    public GmSpaceComponentCustom findGmSpaceComponentCustom(Long id) {
        GmSpaceComponentCustom entity = (GmSpaceComponentCustom)this.gmSpaceComponentCustomDao.findById(id).get();
        return entity;
    }

    public void saveGmSpaceComponentCustom(GmSpaceComponentCustom entity) {
        this.gmSpaceComponentCustomDao.save(entity);
    }

    public void delGmSpaceComponentCustom(Long id) {
        GmSpaceComponentCustom entity = (GmSpaceComponentCustom)this.gmSpaceComponentCustomDao.findById(id).get();
        entity.setIsUse("N");
        this.gmSpaceComponentCustomDao.save(entity);
    }

    public PageObject PageAll(String search, String startDate, String endDate, String applyPerson, String applyDept, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((String)startDate)) {
            params.put("startDate", startDate);
        }
        if (!StringUtils.isEmpty((String)endDate)) {
            params.put("endDate", endDate);
        }
        if (!StringUtils.isEmpty((String)applyPerson)) {
            params.put("applyPerson", "%" + applyPerson.toUpperCase().replace("%", "/%") + "%");
        }
        if (applyDept != null) {
            params.put("applyDept", applyDept);
        }
        return this.bSqlHelper.serachPage("base.GmSpaceComponentCustom.select", params, PageRequest.of((int)page, (int)rows));
    }

    public void deleteByUserAndSpace(Long userId, Long spaceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (userId != null) {
            params.put("userId", userId);
            params.put("spaceId", spaceId);
        }
        this.bSqlHelper.updateOrDelete("base.GmSpaceComponentCustom.deleteByUserAndSpace", params);
    }

    public int findCountByUserAndSpace(Long userId, Long spaceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (userId != null) {
            params.put("userId", userId);
            params.put("spaceId", spaceId);
        }
        return this.bSqlHelper.getIntValue("base.GmSpaceComponentCustom.findCountByUserAndSpace", params);
    }

    public List<Map<String, Object>> findByUserAndSpace(Long userId, Long spaceId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (spaceId != null) {
            params.put("userId", userId);
            params.put("spaceId", spaceId);
        }
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.GmSpaceComponentCustom.findByUserAndSpace", params);
        for (Map<String, Object> map : list) {
            String[] ids;
            String componentId = (String)map.get("componentId");
            String columnNames = "";
            if ("1".equals(map.get("componentType").toString())) {
                if (componentId.indexOf(",") == -1) {
                    GmInfoType gmInfoType = this.gminfotypeService.findGmInfoType(Long.parseLong(componentId));
                    columnNames = columnNames + gmInfoType.getTypeName();
                } else {
                    for (String id : ids = componentId.split(",")) {
                        GmInfoType gmInfoType = this.gminfotypeService.findGmInfoType(Long.parseLong(id));
                        columnNames = columnNames + gmInfoType.getTypeName() + " ";
                    }
                }
                map.put("componentName", columnNames);
                continue;
            }
            if (componentId.indexOf(",") == -1) {
                GmSpaceComponentDefinition gmSpaceComponentDefinition = (GmSpaceComponentDefinition)this.gmSpaceComponentDefinitionDao.findById(Long.parseLong(componentId)).get();
                columnNames = columnNames + gmSpaceComponentDefinition.getComponentName();
                map.put("linkAddress", gmSpaceComponentDefinition.getLinkAddress());
            } else {
                for (String id : ids = componentId.split(",")) {
                    GmSpaceComponentDefinition gmSpaceComponentDefinition = (GmSpaceComponentDefinition)this.gmSpaceComponentDefinitionDao.findById(Long.parseLong(id)).get();
                    columnNames = columnNames + gmSpaceComponentDefinition.getComponentName() + " ";
                }
            }
            map.put("componentName", columnNames);
        }
        return list;
    }
}

