/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.dao.GcMealsCostDao;
import com.ustc.base.entity.GcMealsCost;
import com.ustc.base.service.CommonService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class GcMealsCostService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private GcMealsCostDao gcmealscostDao;

    public GcMealsCost findGcMealsCost(Long id) {
        GcMealsCost entity = (GcMealsCost)this.gcmealscostDao.findById(id).get();
        return entity;
    }

    public void saveGcMealsCost(GcMealsCost entity) {
        this.gcmealscostDao.save(entity);
    }

    public void delGcMealsCost(Long id) {
        GcMealsCost entity = (GcMealsCost)this.gcmealscostDao.findById(id).get();
        entity.setIsUse("N");
        this.gcmealscostDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*  ");
        sql.append(" from GC_MEALS_COST t  ");
        sql.append(" where t.is_use=:isUse ");
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and  (");
            sql.append("  upper(t.MONEY) like :search ");
            sql.append(" or upper(t.PARTICIPANTS) like :search ");
            sql.append(" or upper(t.DIRECTION) like :search ");
            sql.append(" or DATE_FORMAT(t.BIZ_DATE,'%Y-%m-%d') like :search ");
            sql.append(" or upper(t.REMARK) like :search ");
            sql.append(") ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.ID,t.DIRECTION");
        if (StrKit.notBlank(sort)) {
            String exesql = "select * from (" + sql.toString() + ") " + SysUtils.genOrderBy(sort, order);
            pageobject = this.sqlHelper.pagerNativeSQL(exesql, params, (Integer)page, (Integer)rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("DIRECTION", "direction");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public List<GcMealsCost> findByBizDate(Date bizDate) {
        return this.gcmealscostDao.findByBizDateAndIsUse(bizDate, "Y");
    }

    public List getMoneyRest() {
        String sql = "with x as\n (select regexp_substr(t.participants, '[^,]+', 1, level) name,\n         t.direction,\n         t.money\n    from GC_MEALS_COST t\n   where t.is_use = 'Y'\n  connect by level <= regexp_count(t.participants, ',') + 1  and t.id = prior t.id  and prior dbms_random.value is not null)\nselect x.name, sum(x.money * x.direction) money,sum(x.money * decode(x.direction,-1,1,0)) cost\n  from x\n where x.direction = 1or x.direction = -1\n group by x.name\nunion all\nselect '\u996d\u5361' name,ifnull(sum(x.money * decode(x.direction,-2,-1,x.direction)),0) money,sum(x.money * decode(x.direction,-1,1,0)) cost\n  from x\n";
        return this.sqlHelper.queryByNativeSQL(sql, new int[0]);
    }
}

