/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.ComboxUtils;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.BasUserGroupDao;
import com.ustc.base.entity.BasUserGroup;
import com.ustc.gen.util.DBPropertyUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasUserGroupService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasUserGroupDao basusergroupDao;
    @Autowired
    private NativeSqlHelper sqlHelper;

    public BasUserGroup findBasUserGroup(Long id) {
        BasUserGroup entity = (BasUserGroup)this.basusergroupDao.getOne(id);
        return entity;
    }

    public List<Map<String, Object>> findByForeignId(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>(2);
        params.put("id", id);
        return this.bSqlHelper.getMapList("base.BasUserGroup.select", params);
    }

    public void saveBasUserGroup(List<BasUserGroup> list, LoginUser loginUser) {
        for (BasUserGroup entity : list) {
            entity.setIsUse("Y");
            if (entity.getUserGroupId() == null) {
                entity.setCreateAccount(loginUser.getAccountid());
                entity.setCreateTime(new Date());
                this.basusergroupDao.save(entity);
                continue;
            }
            entity.setModifyAccount(loginUser.getAccountid());
            entity.setModifyTime(new Date());
            this.basusergroupDao.save(entity);
        }
    }

    public void delBasUserGroup(Long ids) {
        String sql = "update BAS_USER_GROUP set IS_USE = 'N' where USER_GROUP_ID in (" + ids + ")";
        String sql1 = "update BAS_USER_GROUP_MEMBER set IS_USE = 'N' where USER_GROUP_ID in (" + ids + ")";
        this.sqlHelper.exeNativeSQL(sql);
        this.sqlHelper.exeNativeSQL(sql1);
    }

    public PageObject PageAll(Long flowDone, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        return this.bSqlHelper.searchPage("base.BasUserGroup.select", params, PageRequest.of((int)page, (int)rows));
    }

    public Object getUserGroup() {
        StringBuilder sql = new StringBuilder();
        sql.append("WITH aa AS (\n\tSELECT DISTINCT\n\t\tT.USER_GROUP_ID ID,\n\t\tT.USER_GROUP_NAME TEXT,\n\t\tT.USER_GROUP_ID VALUE\n\tFROM\n\t\tBAS_USER_GROUP t \n\tWHERE\n\t\tt.is_use = 'Y'\n\t) SELECT aa.* FROM aa ORDER BY aa.VALUE");
        List list = this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
        return ComboxUtils.buildComboxNodes(list);
    }
}

