/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.dao.BasSysCodeSeqDao;
import com.ustc.base.entity.BasSysCodeSeq;
import com.ustc.base.service.CommonService;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasSysCodeSeqService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasSysCodeSeqDao bassyscodeseqDao;

    public BasSysCodeSeq findBasSysCodeSeq(Long id) {
        BasSysCodeSeq entity = (BasSysCodeSeq)this.bassyscodeseqDao.findById(id).get();
        return entity;
    }

    public void saveBasSysCodeSeq(BasSysCodeSeq entity) {
        this.bassyscodeseqDao.save(entity);
    }

    public void delBasSysCodeSeq(Long id) {
        this.bassyscodeseqDao.deleteById(id);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*  ");
        sql.append(" from BAS_SYS_CODE_SEQ t  ");
        sql.append(" where t.is_use=:isUse ");
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and  (");
            sql.append("  upper(t.ID) like :search ");
            sql.append(" or upper(t.SYS_CODE_ID) like :search ");
            sql.append(" or upper(t.GENCODE_DATE) like :search ");
            sql.append(" or upper(t.GENCODE_NO) like :search ");
            sql.append(") ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.ID");
        if (StrKit.notBlank(sort)) {
            String exesql = "select * from (" + sql.toString() + ") " + SysUtils.genOrderBy(sort, order);
            pageobject = this.sqlHelper.pagerNativeSQL(exesql, params, (Integer)page, (Integer)rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }
}

