/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.dao.BasMenuDao;
import com.ustc.base.dao.BasRolesMenuTopDao;
import com.ustc.base.entity.BasMenu;
import com.ustc.base.entity.BasRolesMenuTop;
import com.ustc.base.service.CommonService;
import com.ustc.sys.util.ListUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasRolesMenuTopService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasRolesMenuTopDao basrolesmenutopDao;
    @Autowired
    private BasMenuDao basmenuDao;

    public BasRolesMenuTop findBasRolesMenuTop(Long id) {
        BasRolesMenuTop entity = (BasRolesMenuTop)this.basrolesmenutopDao.findById(id).get();
        return entity;
    }

    public void saveBasRolesMenuTop(BasRolesMenuTop entity) {
        this.basrolesmenutopDao.save(entity);
    }

    public void delBasRolesMenuTop(Long id) {
        BasRolesMenuTop entity = (BasRolesMenuTop)this.basrolesmenutopDao.findById(id).get();
        this.basrolesmenutopDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*  ");
        sql.append(" from BAS_ROLES_MENU_TOP t  ");
        sql.append(" where t.is_use=:isUse ");
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and  (");
            sql.append("  upper(t.MENU_TOP_ID) like :search ");
            sql.append(" or upper(t.MODEL_ID) like :search ");
            sql.append(" or upper(t.ACCOUNT_ID) like :search ");
            sql.append(" or upper(t.MENU_ID) like :search ");
            sql.append(" or upper(t.MEMO) like :search ");
            sql.append(" or upper(t.IS_USE) like :search ");
            sql.append(") ");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.MENU_TOP_ID");
        if (StrKit.notBlank(sort)) {
            String exesql = "select * from (" + sql.toString() + ") " + SysUtils.genOrderBy(sort, order);
            pageobject = this.sqlHelper.pagerNativeSQL(exesql, params, (Integer)page, (Integer)rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public JsonMsg saveBasRolesMenuTop(Long modelId, Long accountId, String menuids) {
        JsonMsg msg = new JsonMsg();
        ArrayList<BasRolesMenuTop> entities = new ArrayList<BasRolesMenuTop>();
        this.basrolesmenutopDao.deleteByAccountId(accountId);
        if (StrKit.notBlank(menuids)) {
            List menus = ListUtils.stringToList(menuids);
            for (String menuid : menus) {
                BasMenu entity = (BasMenu)this.basmenuDao.findById(Long.parseLong(menuid)).get();
                if (entity == null || !"2".equals(entity.getMenuType())) continue;
                BasRolesMenuTop newentity = new BasRolesMenuTop();
                newentity.setModelId(modelId);
                newentity.setMenuId(entity.getMenuId());
                newentity.setAccountId(accountId);
                entities.add(newentity);
            }
        }
        this.basrolesmenutopDao.saveAll(entities);
        return msg;
    }

    public List<BasMenu> findMenuTop(Long modelId, Long accountId) {
        ArrayList<BasMenu> menulist = new ArrayList<BasMenu>();
        List<BasRolesMenuTop> menuTopList = this.basrolesmenutopDao.findByModelIdAndAccountId(modelId, accountId);
        for (BasRolesMenuTop menutop : menuTopList) {
            BasMenu menu;
            if (menutop.getMenuId() == null || !"2".equals((menu = (BasMenu)this.basmenuDao.findById(menutop.getMenuId()).get()).getMenuType())) continue;
            menulist.add(menu);
        }
        return menulist;
    }
}

