/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.dao.BasMessageReceiveDao;
import com.ustc.base.entity.BasMessageReceive;
import com.ustc.base.service.CommonService;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasMessageReceiveService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasMessageReceiveDao basmessagereceiveDao;

    public BasMessageReceive findBasMessageReceive(Long id) {
        BasMessageReceive entity = (BasMessageReceive)this.basmessagereceiveDao.findById(id).get();
        return entity;
    }

    public void saveBasMessageReceive(BasMessageReceive entity) {
        this.basmessagereceiveDao.save(entity);
    }

    public void delBasMessageReceive(Long id) {
        this.basmessagereceiveDao.deleteById(id);
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        String sql = "select * from BAS_MESSAGE_RECEIVE t  order by t.RECIVE_ID";
        if (!StringUtils.isEmpty((String)search)) {
            sql = "select * from BAS_MESSAGE_RECEIVE t where   upper(t.RECIVE_ID) like ?1  or upper(t.MSG_ID) like ?1  or upper(t.ACCOUNT_ID) like ?1  or upper(t.IS_DEAL) like ?1  or upper(t.IS_READ) like ?1  or upper(t.READ_TIME) like ?1  order by t.RECIVE_ID";
            pageobject = this.sqlHelper.pagerNativeSQL(sql, new Object[]{"%" + search.toUpperCase() + "%"}, page, rows);
        } else {
            pageobject = this.sqlHelper.pagerNativeSQL(sql, page, rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public PageObject getFlowReceiveList(Long processinstid, List<Long> workitemid, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*, r.is_deal, r.is_read, r.read_time, a.account_name\n  from bas_message t\n  left join bas_message_receive r\n    on t.msg_id = r.msg_id\n  left join bas_emp_account a\n    on a.account_id = r.account_id\n where t.is_use = :isUse \n ");
        sql.append(" and r.account_id <> " + SysContent.ADMIN_ACCOUNT_ID + " \n");
        if (processinstid != null) {
            sql.append(" and t.processinstid = :processinstid \n");
            params.put("processinstid", processinstid);
        }
        if (!workitemid.isEmpty()) {
            sql.append(" and t.workitemid in :workitemid \n");
            params.put("workitemid", workitemid);
        }
        params.put("isUse", "Y");
        sql.append(" order by r.RECIVE_ID ");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("IS_DEAL", "IS_USE");
        dicmapper.put("IS_READ", "IS_USE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public List<BasMessageReceive> findAllnotReadReceive() {
        return this.basmessagereceiveDao.findByIsDealAndIsRead("N", "N");
    }

    public List<BasMessageReceive> findByMsgIdAndReceiver(Long msgid, Long accountid) {
        return this.basmessagereceiveDao.findByAccountIdAndMsgId(accountid, msgid);
    }

    public List<BasMessageReceive> findByAllNotDealReceive(Long proinstId) {
        String sql = "SELECT\n   t2.* \nFROM\n   bas_message t1,\n   bas_message_receive t2 \nWHERE\n   t1.MSG_ID = t2.MSG_ID \n   AND t1.IS_USE = 'Y' \n   AND t1.IS_PUBLIC = 'Y' \n   AND t1.PROCESSINSTID = " + proinstId + " \n   AND t2.IS_DEAL = 'N'";
        return this.sqlHelper.queryByNativeSQL(sql, BasMessageReceive.class, new int[0]);
    }
}

