/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ustc.base.common.util.DateUtils;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.dao.BasEmpAccountDao;
import com.ustc.base.dao.BasEmpDao;
import com.ustc.base.entity.BasEmp;
import com.ustc.base.entity.BasEmpAccount;
import com.ustc.base.entity.ImUser;
import com.ustc.base.service.BasEmpAccountService;
import com.ustc.base.service.CommonService;
import com.ustc.doc.entity.FormFileBean;
import com.ustc.doc.service.DocFormFileService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.SQLReady;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="BasEmpService")
@Transactional
public class BasEmpService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    SQLManager sqlManager;
    @Autowired
    private BasEmpDao basEmpDao;
    @Autowired
    private BasEmpAccountDao empAccountDao;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasEmpAccountService basEmpAccountService;
    @Autowired
    private DocFormFileService docFormFileService;

    public Object pageall(Long orgid, Long deptid, String search, Integer page, Integer rows) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("select DISTINCT t.*,d.DIC_TEXT IS_APP_TEXT_,\n(SELECT group_concat(p.post_name)\n FROM   hr_post p\n  WHERE Instr(concat(',' ,h.present_job , ','), concat(',' , p.post_id , ','))!= 0 )     AS present_job_text_,\n DATE_FORMAT(t.lock_time,'%Y-%m-%d %H:%i:%s') as locktime ,a.abbr dept_name,c.abbr org_name,h.sex,h.PHOTO_VERSION_ID from bas_emp t\n left join bas_dept a on a.dept_id=t.dept_id\n left join bas_org c on c.org_id=t.org_id\n left join bas_dic d on d.dic_value=t.is_app and d.dic_code= 'IS_USE'\n left join hr_emp h on h.emp_id=t.hr_emp_id\n        where t.is_use='Y'");
        params.put("orgid", orgid);
        sql.append(" and t.org_id in (with recursive org as (select m.* from BAS_ORG m where m.ORG_ID =:orgid  and m.is_use='Y'  union all select m.* from BAS_ORG m,org  where  m.PORG_ID=org.ORG_ID and m.is_use='Y') select  t.ORG_ID   from org t ) ");
        if (deptid != null) {
            sql.append(" and t.dept_id in (with recursive dept as (select m.* from BAS_DEPT m where m.dept_id =:deptid  and m.is_use='Y'  union all select m.* from BAS_DEPT m,dept  where  m.pdept_id=dept.dept_id and m.is_use='Y') select  t.dept_id   from dept t)   ");
            params.put("deptid", deptid);
        }
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and (upper(t.emp_name) like :search or upper(t.login_name) like :search)  \n");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.display_no,t.org_id,t.dept_id");
        PageObject pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, page, rows);
        return pageobject;
    }

    public PageObject pageAllEmp(String topEducation, Long borndaya, Long borndayb, String politicalStatus, String empPropStatus, String nationStatus, String status, Long orgid, Long deptid, String professionalTitle, String search, int page, int rows, String sort, String order) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select DISTINCT t.*,\n");
        sql.append(" DATE_FORMAT(t.birthday,'%Y-%m') birthday_f,\n");
        sql.append(" DATE_FORMAT(t.work_Time,'%Y-%m') work_Time_f,\n");
        sql.append(" DATE_FORMAT(t.entry_Time,'%Y-%m') entry_Time_f,\n");
        sql.append("floor(months_between(SYSDATE,birthday) / 12) bornday,\n");
        sql.append(" c.sort shi,a.display_no xian,t.display_no chu,a.dept_name dept_name,c.abbr org_name,b.DIC_TEXT, \n");
        sql.append(" ep.post_name as PRESENT_JOB_TEXT_, \n");
        sql.append(" (select count(*) from HR_LABOR_CONTRACT lc where lc.is_use='Y' and lc.emp_id=t.emp_id ) labor_num \n");
        sql.append(" from hr_emp t \n");
        sql.append(" left join bas_dept a on a.dept_id=t.dept_id\n");
        sql.append(" left join bas_org c on c.org_id=t.org_id\n");
        sql.append(" left join (select emp.emp_id, group_concat(p.post_name) post_name \n");
        sql.append("   from (SELECT cp.emp_id, \n");
        sql.append("    substring_index(substring_index(cp.present_job,',',L),',',-1) AS ES_GROUP, L \n");
        sql.append("    FROM HR_emp CP, \n");
        sql.append("   (SELECT LEVEL L FROM DUAL CONNECT BY LEVEL <= 10)\n");
        sql.append("   WHERE L(+) <= LENGTH(cp.present_job) - LENGTH(REPLACE(cp.present_job, ',')) + 1 \n");
        sql.append("   order by emp_id) emp\n");
        sql.append("   left join hr_post p on p.post_id = emp.ES_GROUP \n");
        sql.append("    group by emp.emp_id) ep on ep.emp_id = t.emp_id\n ");
        sql.append("LEFT JOIN bas_dic b ON b.DIC_CODE= 'SEX' AND t.sex=b.DIC_VALUE \n");
        sql.append("where t.is_use='Y' and t.is_visual='N' \n");
        if (orgid != null) {
            sql.append(" and t.org_id in (with RECURSIVE cte as (    select * from BAS_ORG where org_id = :orgid    union all    select o.* from BAS_ORG o    inner join cte on o.PORG_ID = cte.ORG_ID    )select ORG_ID from cte) ");
            params.put("orgid", orgid);
        }
        if (deptid != null) {
            sql.append(" and t.dept_id in (with RECURSIVE cte as (    select * from BAS_DEPT where dept_id = :deptid    union all    select o.* from BAS_DEPT o    inner join cte on o.pdept_id = cte.dept_id    )select dept_id from cte) ");
            params.put("deptid", deptid);
        }
        if (StringUtils.isNotBlank((String)politicalStatus)) {
            sql.append(" and t.POLITICAL_STAT = :politicalStatus\n");
            params.put("politicalStatus", politicalStatus);
        }
        if (StrKit.notBlank(empPropStatus)) {
            sql.append(" and t.EMP_PROPERTY = :empPropStatus");
            params.put("empPropStatus", empPropStatus);
        }
        if (StrKit.notBlank(nationStatus)) {
            sql.append(" and t.NATION = :nationStatus");
            params.put("nationStatus", nationStatus);
        }
        if (StringUtils.isNotBlank((String)topEducation)) {
            sql.append(" and t.top_Education = :topEducation\n");
            params.put("topEducation", topEducation);
        }
        if (borndaya != null) {
            sql.append("and floor(months_between(SYSDATE,birthday) / 12) >=:borndaya\n");
            params.put("borndaya", borndaya);
        }
        if (borndayb != null) {
            sql.append(" and floor(months_between(SYSDATE,birthday) / 12) <=:borndayb\n");
            params.put("borndayb", borndayb);
        }
        if (StrKit.notBlank(professionalTitle)) {
            if ("1".equals(professionalTitle)) {
                sql.append(" and (t.rank is null or t.rank like '%\u65e0%' ) \n");
            } else if ("2".equals(professionalTitle)) {
                sql.append(" and (t.rank like '%\u521d\u7ea7%' or t.rank like '%\u52a9\u7406%' ) \n");
            } else if ("3".equals(professionalTitle)) {
                sql.append(" and (t.rank like '%\u4e2d\u7ea7%' ) \n");
            } else if ("4".equals(professionalTitle)) {
                sql.append(" and (t.rank like '%\u9ad8\u7ea7%' ) \n");
            }
        }
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and ( ");
            sql.append("  upper(t.emp_name) like :search or upper(t.login_name) like :search  \n");
            sql.append(" or upper(a.abbr) like :search   \n");
            sql.append(" or upper(c.abbr) like :search   \n");
            sql.append(" or upper(b.DIC_TEXT) like :search   \n");
            sql.append(" or upper(t.EMP_CODE) like :search   \n");
            sql.append(" or upper(t.rank) like :search   \n");
            sql.append(" or upper(t.NATIVE_PLACE) like :search   \n");
            sql.append(" or upper(t.PROFESSION) like :search   \n");
            sql.append(" or upper(t.MOBILEPHONE) like :search   \n");
            sql.append(" or upper(t.IDENTIFICATION) like :search   \n");
            sql.append(" or upper(t.GRADUATE_COLL) like :search   \n");
            sql.append(" )   \n");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (StringUtils.isNotBlank((String)status)) {
            sql.append(" and t.STATUS = :status\n");
            params.put("status", status);
        }
        if (StrKit.notBlank(sort)) {
            String exesql = "select * from (" + sql.toString() + ") " + SysUtils.genOrderBy(sort, order);
            pageobject = this.sqlHelper.pagerNativeSQL(exesql, params, (Integer)page, (Integer)rows);
        } else {
            sql.append("  order by c.sort, a.display_no,t.display_no ");
            pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        }
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("SEX", "SEX");
        dicmapper.put("POLITICAL_STAT", "POLITICAL_STAT");
        dicmapper.put("TOP_EDUCATION", "ACADEMIC_DEGREE");
        dicmapper.put("STATION", "STATION");
        dicmapper.put("TECHNICAL", "TECHNICAL");
        dicmapper.put("STATUS", "STAFF_STATUS");
        dicmapper.put("STATION_LEVEL", "STATIONLEVEL");
        dicmapper.put("NATION", "NATION");
        dicmapper.put("EMP_TYPE", "EMP_TYPE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public Object findDBOne(Long id) {
        String sql = "select t.*,DATE_FORMAT(t.lock_time,'%Y-%m-%d %H:%i:%s') as locktime ,a.abbr dept_name,c.abbr org_name from bas_emp t  left join bas_dept a on a.dept_id=t.dept_id  left join bas_org c on c.org_id=t.org_id where t.is_use='Y' and t.emp_id=?1";
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("SEX", "SEX");
        dicmapper.put("STATUS", "USER_STATUS");
        dicmapper.put("WORKSTATION", "POSITION_NAME");
        Object o = this.sqlHelper.getSingalMap(sql, new Object[]{id});
        return this.commonService.fmtListWithDic(o, dicmapper);
    }

    public BasEmp findEmpByempId(Long empId) {
        BasEmp emp = (BasEmp)this.basEmpDao.findById(empId).get();
        if (emp != null) {
            return emp;
        }
        return new BasEmp();
    }

    public BasEmp findByEmpCode(String empCode) {
        return this.basEmpDao.findByEmpCodeAndIsUse(empCode, "Y");
    }

    public BasEmp findByEmpName(String empName) {
        return this.basEmpDao.findByEmpNameAndIsUse(empName, "Y");
    }

    public BasEmp saveEmp(BasEmp baseEmp) {
        return (BasEmp)this.basEmpDao.save(baseEmp);
    }

    public boolean delEmp(String empId) {
        Long searchEmpId = Long.parseLong(empId);
        BasEmp basEmp = this.findEmpByempId(searchEmpId);
        if (basEmp != null) {
            basEmp.setIsUse("N");
            this.saveEmp(basEmp);
            List<BasEmpAccount> empAccountList = this.empAccountDao.findByEmpIdAndIsUse(searchEmpId, "Y");
            if (!empAccountList.isEmpty()) {
                for (BasEmpAccount empAccount : empAccountList) {
                    empAccount.setIsUse("N");
                    this.empAccountDao.save(empAccount);
                }
            }
        }
        return true;
    }

    public boolean cancelEmp(String empId) {
        Long searchEmpId = Long.parseLong(empId);
        BasEmp basEmp = this.findEmpByempId(searchEmpId);
        if (basEmp != null) {
            basEmp.setStatus("2");
            this.saveEmp(basEmp);
        }
        return true;
    }

    public BasEmp findByloginName(String loginName) {
        return this.basEmpDao.findByloginNameAndIsUse(loginName, "Y");
    }

    public BasEmp findByCaId(String caId) {
        List<BasEmp> list = this.basEmpDao.findByCaIdAndIsUse(caId, "Y");
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public List queryAllEmplist() {
        StringBuilder sql = new StringBuilder();
        sql.append("  SELECT t.emp_id,t.emp_name from BAS_EMP  t  where t.IS_USE='Y' ");
        return this.sqlHelper.queryByNativeSQL(sql.toString(), new int[0]);
    }

    public List<ImUser> queryAllWebChatUser() {
        List list = this.sqlManager.execute(new SQLReady("SELECT t.emp_id as userCode,t.emp_name as userName,a.ABBR as userDept,b.ABBR as userORG from BAS_EMP  t \nleft join BAS_DEPT a on t.DEPT_ID=a.DEPT_ID\nleft join BAS_ORG b on t.ORG_ID=B.ORG_ID\nwhere t.IS_USE='Y'"), ImUser.class);
        return list;
    }

    public boolean hasloginName(String loginname, Long empid) {
        Object o;
        StringBuilder sql = new StringBuilder();
        sql.append("select count(1) from bas_emp t where t.login_name =?1 and t.is_use='Y' ");
        if (empid != null) {
            sql.append(" and t.emp_id <> " + empid);
        }
        return Long.parseLong((o = this.sqlHelper.getSingal(sql.toString(), new Object[]{loginname})).toString()) <= 0L;
    }

    public JsonMsg saveBasEmpHr(HttpServletRequest request, BasEmp basEmp, FormFileBean formfile, String formcode) throws ParseException {
        boolean isAdd;
        JsonMsg msg = new JsonMsg();
        boolean bl = isAdd = basEmp.getEmpId() == null;
        if (isAdd) {
            basEmp.setLoginPassword(SysUtils.md5two("123"));
            basEmp.setLoginName(basEmp.getEmpName().trim());
        } else {
            BasEmp oldemp = this.findEmpByempId(basEmp.getEmpId());
            basEmp.setLoginPassword(oldemp.getLoginPassword());
            basEmp.setLoginName(oldemp.getLoginName());
            basEmp.setDisplayNo(oldemp.getDisplayNo());
            basEmp.setIsUse("Y");
        }
        basEmp.setIsUse("Y");
        basEmp.setIsVisual("N");
        this.saveEmp(basEmp);
        msg.setO(basEmp);
        if (isAdd) {
            BasEmpAccount basEmpAccount = new BasEmpAccount();
            basEmpAccount.setAccountName(basEmp.getLoginName());
            basEmpAccount.setEmpId(basEmp.getEmpId());
            basEmpAccount.setIsUse("Y");
            basEmpAccount.setOrgId(basEmp.getOrgId());
            basEmpAccount.setDeptId(basEmp.getDeptId());
            basEmpAccount = this.basEmpAccountService.saveBasEmpAccount(basEmpAccount);
        } else {
            List<BasEmpAccount> accountList = this.basEmpAccountService.findByEmpId(basEmp.getEmpId());
            for (BasEmpAccount account : accountList) {
                account.setOrgId(basEmp.getOrgId());
                account.setDeptId(basEmp.getDeptId());
                this.basEmpAccountService.saveBasEmpAccount(account);
            }
        }
        formfile.setPrimaryKey(basEmp.getEmpId());
        formfile.setAccountid(basEmp.getModifyAccount());
        this.docFormFileService.SaveFormFileBean(formfile);
        return msg;
    }

    public JsonMsg genEmpXml(Long empId) {
        JsonMsg msg = new JsonMsg();
        return msg;
    }

    public Object pageSMSEmp(Long orgid, Long deptid, String search, Integer page, Integer rows) {
        StringBuilder sql = new StringBuilder();
        HashMap<String, Object> params = new HashMap<String, Object>();
        sql.append("select t.EMP_NAME,h.MOBILEPHONE,\n");
        sql.append("a.abbr dept_name,c.abbr org_name from bas_emp t  left join hr_emp h on h.emp_id=t.emp_id  left join bas_dept a on a.dept_id=t.dept_id  left join bas_org c on c.org_id=t.org_id where t.is_use='Y' ");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append(" and (upper(t.emp_name) like :search or upper(t.login_name) like :search or upper(t.mobilephone) like :search)  \n");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (orgid != null) {
            params.put("orgid", orgid);
            sql.append(" and t.org_id in (with recursive org as (select m.* from BAS_ORG m where m.ORG_ID =:orgid  and m.is_use='Y'  union all select m.* from BAS_ORG m,org  where  m.PORG_ID=org.ORG_ID and m.is_use='Y') select  t.ORG_ID   from org t ) ");
        }
        if (deptid != null) {
            sql.append(" and t.dept_id in (with recursive dept as (select m.* from BAS_DEPT m where m.dept_id =:deptid  and m.is_use='Y'  union all select m.* from BAS_DEPT m,dept  where  m.pdept_id=dept.dept_id and m.is_use='Y') select  t.dept_id   from dept t)   ");
            params.put("deptid", deptid);
        }
        sql.append(" order by a.display_no,t.emp_name");
        PageObject pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, page, rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("SEX", "SEX");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public BasEmp findByMobilephone(String mobilephone) {
        List<BasEmp> list = this.basEmpDao.findByMobilephoneAndIsUse(mobilephone, "Y");
        if (list != null && list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public boolean checkWorkDate(String workgridrowlist) {
        ArrayList<String> workdateList = new ArrayList<String>();
        if (StrKit.notBlank(workgridrowlist)) {
            JSONArray rows = JSON.parseArray((String)workgridrowlist);
            for (Object o : rows) {
                Map row = (Map)o;
                if (row.get("START_TIME") != null && StrKit.notBlank(row.get("START_TIME").toString())) {
                    workdateList.add(row.get("START_TIME").toString());
                }
                if (row.get("END_TIME") == null || !StrKit.notBlank(row.get("END_TIME").toString())) continue;
                workdateList.add(row.get("END_TIME").toString());
            }
        }
        System.out.println("\u6392\u5e8f\u524d" + workdateList);
        final SimpleDateFormat f = new SimpleDateFormat("yyyy-MM");
        Collections.sort(workdateList, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                try {
                    Date d1 = (Date)f.parseObject(o1);
                    Date d2 = (Date)f.parseObject(o2);
                    return d1.compareTo(d2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return 0;
                }
            }
        });
        System.out.println("\u6392\u5e8f\u540e" + workdateList);
        for (int i = 0; i < workdateList.size(); ++i) {
            if ((i + 1) % 2 != 0) continue;
            try {
                String stratTime = workdateList.get(i).toString();
                String endTime = workdateList.get(i + 1).toString();
                if (DateUtils.getDatePoorDays(DateUtils.strToMonthDate(endTime), DateUtils.strToMonthDate(stratTime)) <= 31L) continue;
                return false;
            }
            catch (Exception e) {
                System.out.println("\u5de5\u4f5c\u5c65\u5386\u51fa\u9519:" + e.getMessage());
                return false;
            }
        }
        return true;
    }

    public void initERP() {
        StringBuilder sql = new StringBuilder();
        sql.append("{call GCERP.update_erp_org_user()}");
        this.sqlHelper.exeNativeSQL(sql.toString());
    }
}

