/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.BasContactOrgAttrDao;
import com.ustc.base.entity.BasContactOrgAttr;
import com.ustc.base.service.CommonService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasContactOrgAttrService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasContactOrgAttrDao bascontactorgattrDao;

    public BasContactOrgAttr findBasContactOrgAttr(Long id) {
        BasContactOrgAttr entity = (BasContactOrgAttr)this.bascontactorgattrDao.findById(id).get();
        return entity;
    }

    public void saveBasContactOrgAttr(BasContactOrgAttr entity) {
        this.bascontactorgattrDao.save(entity);
    }

    public void delBasContactOrgAttr(Long id) {
        BasContactOrgAttr entity = (BasContactOrgAttr)this.bascontactorgattrDao.findById(id).get();
        this.bascontactorgattrDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        Object[] params = null;
        String sql = "select * from BAS_CONTACT_ORG_ATTR t where t.is_use='Y' ";
        if (!StringUtils.isEmpty((String)search)) {
            sql = sql + "and  (  upper(t.CONTACT_ORG_ATTR_ID) like ?1  or upper(t.CONTACT_ORG_ID) like ?1  or upper(t.CONTACT_ORG_ATTR) like ?1 )";
            params = new Object[]{"%" + search.toUpperCase() + "%"};
        }
        sql = sql + " order by t.CONTACT_ORG_ATTR_ID";
        pageobject = this.sqlHelper.pagerNativeSQL(sql, params, page, rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public BasContactOrgAttr findByContactOrgTypeAndContactOrgId(Long contactOrgId, String contactOrgAttr) {
        List<BasContactOrgAttr> list = this.bascontactorgattrDao.findByContactOrgIdAndContactOrgAttr(contactOrgId, contactOrgAttr);
        BasContactOrgAttr basContactOrgAttr = list.size() > 0 ? list.get(0) : new BasContactOrgAttr();
        return basContactOrgAttr;
    }

    public List findBasContactOrgAttrList(Long contactOrgId) {
        ArrayList<String> attrs = new ArrayList<String>();
        List<BasContactOrgAttr> bascontactorgattrList = this.bascontactorgattrDao.findByContactOrgId(contactOrgId);
        for (BasContactOrgAttr attr : bascontactorgattrList) {
            attrs.add(attr.getContactOrgAttr());
        }
        return attrs;
    }
}

