/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.CommTreeUtils;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.BasBusinessProcessDao;
import com.ustc.base.entity.BasBusinessProcess;
import com.ustc.doc.dao.DocFileVersionDao;
import com.ustc.doc.entity.DocFileVersion;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasBusinessProcessService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private DocFileVersionDao docFileVersionDao;
    @Autowired
    private BasBusinessProcessDao basbusinessprocessDao;

    public BasBusinessProcess findBasBusinessProcess(Long id) {
        DocFileVersion version;
        BasBusinessProcess entity = (BasBusinessProcess)this.basbusinessprocessDao.findById(id).get();
        if (entity != null && entity.getFileId() != null && (version = (DocFileVersion)this.docFileVersionDao.findById(entity.getFileId()).get()) != null) {
            entity.setImageUrl(version.getOriginalName());
        }
        return entity;
    }

    public void saveBasBusinessProcess(BasBusinessProcess entity) {
        this.basbusinessprocessDao.save(entity);
    }

    public void delBasBusinessProcess(Long id) {
        this.basbusinessprocessDao.deleteById(id);
    }

    public PageObject PageAll(String search, int page, int rows, Long businessId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", search);
        }
        if (businessId != null) {
            params.put("businessId", businessId);
        }
        return this.bSqlHelper.serachPage("base.BasBusinessProcess.PageAll", params);
    }

    public void delBasBusinessProcessAndChild(Long id) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        this.bSqlHelper.updateOrDelete("base.BasBusinessProcess.delBasBusinessProcessAndChild", params);
    }

    public List<ComBoxTreeNode> treeBasBusinessProcess(Long pid) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pid", pid);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasBusinessProcess.select", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public List<BasBusinessProcess> findByBusinessCodeAndIsUse(String code) {
        return this.basbusinessprocessDao.findByBusinessCodeAndIsUse(code, "Y");
    }

    public List<BasBusinessProcess> childDetail(String businessCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("businessCode", businessCode);
        List<BasBusinessProcess> list = this.bSqlHelper.getList("base.BasBusinessProcess.selectDetail", params, BasBusinessProcess.class);
        return list;
    }

    public List<Map<String, Object>> queryBusinessFlow(String businessCode) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("businessCode", businessCode);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasBusinessProcess.selectDetailByCode", params);
        for (Map<String, Object> map : list) {
            HashMap<String, Object> detailParams = new HashMap<String, Object>();
            detailParams.put("businessId", map.get("businessId"));
            List<Map<String, Object>> detailList = this.bSqlHelper.getMapList("base.BasBusinessProcess.selectBusinessList", detailParams);
            for (Map<String, Object> mapFlow : detailList) {
                HashMap<String, Object> flowParams = new HashMap<String, Object>();
                flowParams.put("businessId", mapFlow.get("businessId"));
                List<Map<String, Object>> flowList = this.bSqlHelper.getMapList("base.BasBusinessProcess.selectBusinessFlow", flowParams);
                mapFlow.put("flowList", flowList);
                mapFlow.put("size", flowList.size());
            }
            map.put("detailList", detailList);
        }
        return list;
    }
}

