/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.CommTreeUtils;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.NativeSqlHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.dao.BasBankAccountDao;
import com.ustc.base.dao.BasBankDao;
import com.ustc.base.dao.BasOrgDao;
import com.ustc.base.entity.BasBank;
import com.ustc.base.entity.BasBankAccount;
import com.ustc.base.service.CommonService;
import com.ustc.gen.util.DBPropertyUtil;
import com.ustc.sys.util.ListUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasBankAccountService {
    @Autowired
    private NativeSqlHelper sqlHelper;
    @Autowired
    private CommonService commonService;
    @Autowired
    private BasBankAccountDao basbankaccountDao;
    @Autowired
    private BasBankDao basbankDao;
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasOrgDao basorgDao;

    public BasBankAccount findBasBankAccount(Long id) {
        BasBankAccount entity = (BasBankAccount)this.basbankaccountDao.findById(id).get();
        if (entity != null && entity.getBankId() != null) {
            BasBank bank = (BasBank)this.basbankDao.findById(entity.getBankId()).get();
            entity.setBankName(bank == null ? "" : bank.getBankName());
        }
        return entity;
    }

    public BasBank findBasBank(Long id) {
        BasBankAccount entity = (BasBankAccount)this.basbankaccountDao.findById(id).get();
        if (entity == null) {
            return null;
        }
        return (BasBank)this.basbankDao.findById(entity.getBankId()).get();
    }

    public BasBank findBasBank(String accountNo) {
        BasBankAccount bankAccount = this.findBasBankAccount(accountNo);
        if (bankAccount != null && bankAccount.getBankId() != null) {
            return (BasBank)this.basbankDao.findById(bankAccount.getBankId()).get();
        }
        return new BasBank();
    }

    public BasBankAccount findBasBankAccount(String accountNo) {
        List<BasBankAccount> accountList = this.basbankaccountDao.findByAccountNoAndIsUse(accountNo, "Y");
        if (accountList.size() > 0) {
            return accountList.get(0);
        }
        return new BasBankAccount();
    }

    public JsonMsg checkRepeat(BasBankAccount entity) {
        JsonMsg msg = new JsonMsg();
        List<BasBankAccount> list = this.basbankaccountDao.findByAccountNoAndIsUse(entity.getAccountNo(), "Y");
        if (list.size() > 1) {
            msg.setSuccess(false);
            msg.setMsg("\u94f6\u884c\u8d26\u53f7\u91cd\u590d,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
        } else if (list.size() == 1 && !list.get(0).getBankId().equals(entity.getBankId())) {
            msg.setSuccess(false);
            msg.setMsg("\u94f6\u884c\u8d26\u53f7\u91cd\u590d,\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u4fdd\u5b58");
        }
        return msg;
    }

    public JsonMsg saveBasBankAccount(BasBankAccount entity, String updated) {
        JsonMsg msg = new JsonMsg();
        this.basbankaccountDao.save(entity);
        return msg;
    }

    public void delBasBankAccount(Long id, Long userId) {
        BasBankAccount entity = (BasBankAccount)this.basbankaccountDao.findById(id).get();
        entity.setIsUse("N");
        entity.setModifyAccount(userId);
        entity.setModifyTime(new Date());
        this.basbankaccountDao.save(entity);
    }

    public PageObject PageAll(String isEnAnble, String bankid, Long orgid, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("bankid", bankid);
        if (orgid != 0L) {
            params.put("orgid", orgid);
        }
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (!StringUtils.isEmpty((String)isEnAnble)) {
            params.put("isEnAnble", isEnAnble);
        }
        return this.bSqlHelper.serachPage("base.BasBankAccount.select", params, PageRequest.of((int)page, (int)rows));
    }

    public PageObject PageBasBankDeposit(Long orgid, String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        if (orgid != null) {
            params.put("orgid", orgid);
        } else {
            orgid = SysUtils.getLoginUser().getOrgid();
            params.put("orgid", orgid);
        }
        return this.bSqlHelper.serachPage("base.BasBankAccount.PageBasBankDeposit", params, PageRequest.of((int)page, (int)rows));
    }

    public PageObject getBankList(Long orgId, String types, String search, int page, int rows) {
        PageObject pageobject = new PageObject();
        HashMap<String, Object> params = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder();
        sql.append("select t.*,nvl(a.abbr,a.org_name) as abbr,b.ACCOUNT_NAME as MODIFY_ACCOUNT_NAME,c.BANK_NAME from BAS_BANK_ACCOUNT t  left join bas_org a on t.org_id=a.org_id  left join bas_emp_account b on t.MODIFY_ACCOUNT=b.account_id  left join BAS_BANK c on t.bank_id=c.bank_id  where t.BANK_ID in (SELECT  distinct t.BANK_ID id  FROM  BAS_BANK T   START WITH T.BANK_PID = 0   CONNECT BY PRIOR T.BANK_ID = T.BANK_PID) and t.is_use=:isUse ");
        if (orgId != null) {
            sql.append(" and t.org_id=:orgId ");
            params.put("orgId", orgId);
        }
        if (StrKit.notBlank(types)) {
            sql.append(" and t.account_type in :types ");
            params.put("types", ListUtils.stringToList(types));
        }
        params.put("isUse", "Y");
        if (!StringUtils.isEmpty((String)search)) {
            sql.append("and  (");
            sql.append("  upper(b.ACCOUNT_NAME) like :search ");
            sql.append(" or upper(c.BANK_NAME) like :search ");
            sql.append(" or upper(t.ACCOUNT_DATE) like :search ");
            sql.append(" or upper(t.ACCOUNT_NAME) like :search ");
            sql.append(" or upper(t.ACCOUNT_NO) like :search ");
            sql.append(")");
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        sql.append(" order by t.org_id,t.ACCOUNT_DATE desc");
        pageobject = this.sqlHelper.pagerNativeSQL(sql.toString(), params, (Integer)page, (Integer)rows);
        HashMap<String, String> dicmapper = new HashMap<String, String>();
        dicmapper.put("ACCOUNT_USE", "ACCOUNT_USE");
        this.commonService.fmtListWithDic(pageobject.getRows(), dicmapper);
        return pageobject;
    }

    public BasBank getTopBank(Long bankId) {
        String sql = "select t.*\n  from bas_bank t\n  where t.pbank_id=0\n start with t.bank_id = ?1\nconnect by t.bank_id = prior t.pbank_id";
        List list = this.sqlHelper.queryByNativeSQL(sql, new Object[]{bankId}, BasBank.class, new int[0]);
        if (list.isEmpty()) {
            return new BasBank();
        }
        return (BasBank)list.get(0);
    }

    public JsonMsg genbankAccountXml(Long bankAccountId) {
        JsonMsg msg = new JsonMsg();
        return msg;
    }

    public List<ComBoxTreeNode> treeBankAndBankAccount(Long pid, String searchData) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("pid", pid);
        List<Map<String, Object>> list = this.bSqlHelper.getMapList("base.BasBankAccount.selectBankAccountTree", params);
        return CommTreeUtils.buildTreeNode(list);
    }

    public BasBankAccount findDataByAccountData(Long orgId, String bankName, String bankAccount) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)bankName)) {
            return new BasBankAccount();
        }
        params.put("bankName", bankName);
        if (StringUtils.isEmpty((String)bankAccount)) {
            return new BasBankAccount();
        }
        params.put("bankAccount", bankAccount);
        if (orgId == null) {
            return new BasBankAccount();
        }
        params.put("orgId", orgId);
        return this.bSqlHelper.getEntity("base.BasBankAccount.findDataByAccountData", params, BasBankAccount.class);
    }
}

