/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.service;

import cn.hutool.core.util.StrUtil;
import com.ustc.base.common.util.BeetlSQLHelper;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.dao.BasAppVersionDao;
import com.ustc.base.entity.BasAppVersion;
import com.ustc.doc.entity.DocFileVersion;
import com.ustc.doc.service.DocFileVersionService;
import com.ustc.gen.util.DBPropertyUtil;
import com.ustc.util.StringUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Transactional
public class BasAppVersionService {
    @Autowired
    private BeetlSQLHelper bSqlHelper;
    @Autowired
    private BasAppVersionDao basappversionDao;
    @Autowired
    private DocFileVersionService docFileVersionService;

    public BasAppVersion findBasAppVersion(Long id) {
        BasAppVersion entity = (BasAppVersion)this.basappversionDao.getOne(id);
        return entity;
    }

    public void saveBasAppVersion(BasAppVersion entity) {
        this.basappversionDao.save(entity);
    }

    public void delBasAppVersion(Long id) {
        BasAppVersion entity = (BasAppVersion)this.basappversionDao.getOne(id);
        entity.setIsUse("N");
        this.basappversionDao.save(entity);
    }

    public PageObject PageAll(String search, int page, int rows, String sort, String order) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!StringUtils.isEmpty((String)search)) {
            params.put("search", "%" + search.toUpperCase() + "%");
        }
        if (!StringUtils.isEmpty((String)sort)) {
            params.put("sort", DBPropertyUtil.underscoreName(sort));
        }
        if (!StringUtils.isEmpty((String)order)) {
            params.put("order", order);
        }
        PageObject<Map<String, Object>> pageObject = this.bSqlHelper.searchPage("base.BasAppVersion.select", params, PageRequest.of((int)page, (int)rows));
        Iterator<Map<String, Object>> iterator = pageObject.getRows().iterator();
        while (iterator.hasNext()) {
            DocFileVersion fileVersion;
            Map<String, Object> rowObject;
            Map<String, Object> row = rowObject = iterator.next();
            Long apkVersionId = StringUtil.strToLong(row.get("apkVersionId"));
            Long wgtVersionId = StringUtil.strToLong(row.get("wgtVersionId"));
            if (apkVersionId != null) {
                fileVersion = this.docFileVersionService.findBaseVersionByVersionid(apkVersionId);
                row.put("apkVersionId_TEXT_", fileVersion.getOriginalName());
            }
            if (wgtVersionId == null) continue;
            fileVersion = this.docFileVersionService.findBaseVersionByVersionid(wgtVersionId);
            row.put("wgtVersionId_TEXT_", fileVersion.getOriginalName());
        }
        return pageObject;
    }

    public BasAppVersion findLatestAppVersion(String appId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StrUtil.isEmpty((CharSequence)appId)) {
            return null;
        }
        params.put("appId", appId);
        return this.bSqlHelper.getEntity("base.BasAppVersion.findLatestAppVersion", params, BasAppVersion.class);
    }
}

