/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.controller;

import cn.hutool.core.io.FileUtil;
import com.gexin.fastjson.JSON;
import com.ustc.base.common.spring.SpringContextHolder;
import com.ustc.base.common.util.GenerateRandomKeyUtil;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.StrKit;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.BasLoginPageConfig;
import com.ustc.base.entity.BasMenu;
import com.ustc.base.service.BasLoginPageConfigService;
import com.ustc.base.service.BasMenuLinkService;
import com.ustc.base.service.BasMenuService;
import com.ustc.base.service.BasRolesAccountService;
import com.ustc.config.LoginConfigProperties;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class IndexController
extends BaseController {
    public static Logger loger = Logger.getLogger(IndexController.class);
    @Autowired
    private BasMenuService basMenuService;
    @Autowired
    private BasMenuLinkService basMenuLinkService;
    @Autowired
    private BasRolesAccountService basrolesaccountService;
    @Autowired
    private BasLoginPageConfigService configService;

    @RequestMapping(value={"/"})
    public ModelAndView index(HttpServletRequest request) {
        LoginUser loginuser = this.getLoginUser(request);
        String isAdmin = "N";
        if (this.basrolesaccountService.findByRoleIdAndAccountId(SysContent.ROLE_ID_SUPER_ADMIN, SysUtils.getLoginAccountId()) != null) {
            isAdmin = "Y";
        }
        ModelAndView view = new ModelAndView();
        if (loginuser != null) {
            Subject currentUser = SecurityUtils.getSubject();
            view.addObject("homeProjectQuery", (Object)currentUser.isPermitted("homeProjectQuery"));
            view.addObject("homeEdocQuery", (Object)currentUser.isPermitted("homeEdocQuery"));
            view.addObject("homePmconQuery", (Object)currentUser.isPermitted("homePmconQuery"));
            view.addObject("homeInfoQuery", (Object)currentUser.isPermitted("homeInfoQuery"));
            view.addObject("docInfoQuery", (Object)currentUser.isPermitted("docInfoQuery"));
            view.setViewName("mainframelayui");
            view.addObject("fontSize", (Object)loginuser.getFontSize());
            view.addObject("themes", (Object)loginuser.getThemes());
            view.addObject("loginuser", (Object)loginuser);
            view.addObject("isAdmin", (Object)isAdmin);
            view.addObject("defaultpassword", (Object)"123");
            view.addObject("menulist", this.basMenuService.getAccountBasMenu(loginuser.getAccountid()));
            view.addObject("menuLinklist", (Object)this.basMenuLinkService.getMenuLink());
            view.addObject("queryAddrlist", (Object)this.basMenuLinkService.getqueryAddr());
            view.addObject("navCount", (Object)this.getNavCount(request));
            view.addObject("profiles", (Object)SpringContextHolder.getProperty("spring.profiles.active"));
            BasLoginPageConfig config = this.configService.getConfig();
            if (config != null && config.getThemeNo() != null) {
                view.addObject("loginConfig", (Object)config);
                if (StringUtils.isNotBlank((CharSequence)config.getTitle())) {
                    view.addObject("systemName", (Object)config.getTitle());
                }
                String indexLogoImgName = (String)FileUtil.listFileNames((String)(LoginConfigProperties.baseDir + LoginConfigProperties.INDEX_LOGO)).get(0);
                view.addObject("indexLogoUrl", (Object)(request.getContextPath() + "/loginImg/" + LoginConfigProperties.INDEX_LOGO + "/" + indexLogoImgName));
                List sloganImgNames = FileUtil.listFileNames((String)(LoginConfigProperties.baseDir + LoginConfigProperties.LOGIN_SLOGAN));
                if (sloganImgNames != null && !sloganImgNames.isEmpty()) {
                    view.addObject("sloganImgUrl", (Object)(request.getContextPath() + "/loginImg/" + LoginConfigProperties.LOGIN_SLOGAN + "/" + (String)sloganImgNames.get(0)));
                }
            }
        } else {
            BasLoginPageConfig config;
            if (request.getSession().getAttribute("sessionSalt") == null) {
                request.getSession().setAttribute("sessionSalt", (Object)GenerateRandomKeyUtil.getRandomKey(16));
            }
            if ((config = this.configService.getConfig()) != null && config.getThemeNo() != null) {
                view.addObject("loginConfig", (Object)config);
                List fileNames = FileUtil.listFileNames((String)(LoginConfigProperties.baseDir + LoginConfigProperties.LOGIN_BG));
                List loginBgImgs = fileNames.stream().map(s -> request.getContextPath() + "/loginImg/" + LoginConfigProperties.LOGIN_BG + "/" + s).collect(Collectors.toList());
                view.addObject("loginBgImgs", (Object)JSON.toJSONString(loginBgImgs));
                String logoImgName = (String)FileUtil.listFileNames((String)(LoginConfigProperties.baseDir + LoginConfigProperties.LOGO)).get(0);
                view.addObject("logoImgUrl", (Object)(request.getContextPath() + "/loginImg/" + LoginConfigProperties.LOGO + "/" + logoImgName));
                List sloganImgNames = FileUtil.listFileNames((String)(LoginConfigProperties.baseDir + LoginConfigProperties.LOGIN_SLOGAN));
                if (sloganImgNames != null && !sloganImgNames.isEmpty()) {
                    view.addObject("sloganImgUrl", (Object)(request.getContextPath() + "/loginImg/" + LoginConfigProperties.LOGIN_SLOGAN + "/" + (String)sloganImgNames.get(0)));
                }
                view.setViewName("/loginTemplate/login" + config.getThemeNo());
            } else {
                view.setViewName("/index");
            }
        }
        return view;
    }

    @RequestMapping(value={"/help/index"})
    public ModelAndView helpindex(HttpServletRequest request) {
        ModelAndView view = new ModelAndView();
        view.setViewName("help");
        return view;
    }

    @RequestMapping(value={"/errorpage/{errorcode}"})
    public String errorpage(@PathVariable(value="errorcode") String errorcode) {
        return "/errorpage/" + errorcode;
    }

    @RequestMapping(value={"/view/{page}"}, method={RequestMethod.GET})
    public String viewpage(Model model, HttpServletRequest request, @PathVariable(value="page") String page) {
        this.fillModel(model, request);
        return page;
    }

    @RequestMapping(value={"/view/{page1}/{page2}"}, method={RequestMethod.GET})
    public String viewpage2(Model model, HttpServletRequest request, @PathVariable(value="page1") String page1, @PathVariable(value="page2") String page2) {
        this.fillModel(model, request);
        return page1 + "/" + page2;
    }

    @RequestMapping(value={"/view/{page1}/{page2}/{page3}"}, method={RequestMethod.GET})
    public String viewpage3(Model model, HttpServletRequest request, @PathVariable(value="page1") String page1, @PathVariable(value="page2") String page2, @PathVariable(value="page3") String page3) {
        this.fillModel(model, request);
        return page1 + "/" + page2 + "/" + page3;
    }

    private void fillModel(Model model, HttpServletRequest request) {
        BasLoginPageConfig config;
        BasMenu menu;
        String menuId = request.getParameter("menuId");
        model.addAttribute("menuIco", (Object)"icon-default");
        model.addAttribute("menuName", (Object)"");
        model.addAttribute("menuColor", (Object)"#409eff");
        if (menuId != null && !menuId.equals("0") && (menu = this.basMenuService.findBasMenu(Long.valueOf(menuId))) != null) {
            model.addAttribute("menuIco", (Object)menu.getMenuIco());
            model.addAttribute("menuName", (Object)menu.getMenuName());
            model.addAttribute("menuColor", (Object)(StringUtils.isBlank((CharSequence)menu.getBackgroundColor()) ? "#409EFF" : menu.getBackgroundColor()));
        }
        Map map = request.getParameterMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            model.addAttribute(key, (Object)(map.get(key = (String)iterator.next()) == null ? "" : StrKit.join((String[])map.get(key), ",")));
        }
        LoginUser loginuser = this.getLoginUser(request);
        if (loginuser != null) {
            model.addAttribute("loginuser", (Object)loginuser);
            model.addAttribute("accountName", (Object)loginuser.getAccountName());
            model.addAttribute("accountId", (Object)loginuser.getAccountid());
            model.addAttribute("fontSize", (Object)loginuser.getFontSize());
            model.addAttribute("WebIMServer", (Object)loginuser.getWebIMServer());
        }
        if ((config = this.configService.getConfig()) != null && StringUtils.isNotBlank((CharSequence)config.getTitle())) {
            model.addAttribute("systemName", (Object)config.getTitle());
        }
    }
}

