/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ustc.base.common.exception.GEPSBisException;
import com.ustc.base.common.util.ComboxNode;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.GmInfoType;
import com.ustc.base.entity.GmSpaceComponentAssociated;
import com.ustc.base.entity.GmSpaceComponentCustom;
import com.ustc.base.entity.GmSpaceComponentDefinition;
import com.ustc.base.service.CommonService;
import com.ustc.base.service.GmInfoTypeManagersService;
import com.ustc.base.service.GmInfoTypeService;
import com.ustc.base.service.GmSpaceComponentAssociatedService;
import com.ustc.base.service.GmSpaceComponentCustomService;
import com.ustc.base.service.GmSpaceComponentDefinitionService;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/GmSpaceComponentAssociated"})
public class GmSpaceComponentAssociatedController
extends BaseController {
    @Autowired
    private GmSpaceComponentAssociatedService gmspacecomponentassociatedService;
    @Autowired
    private CommonService comService;
    @Autowired
    private GmSpaceComponentDefinitionService gmSpaceComponentDefinitionService;
    @Autowired
    private GmInfoTypeService gmInfoTypeService;
    @Autowired
    private GmInfoTypeManagersService gmInfoTypeManagersService;
    @Autowired
    private GmSpaceComponentCustomService gmSpaceComponentCustomService;

    @RequestMapping(value={"/findGmSpaceComponentAssociated"})
    @ResponseBody
    public Object findGmSpaceComponentAssociated(Long id) {
        JsonMsg msg = new JsonMsg();
        GmSpaceComponentAssociated entity = this.gmspacecomponentassociatedService.findGmSpaceComponentAssociated(id);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delGmSpaceComponentAssociated"})
    @ResponseBody
    public Object delGmSpaceComponentAssociated(Long id) {
        this.gmspacecomponentassociatedService.delGmSpaceComponentAssociated(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/saveGmSpaceComponentAssociated"})
    @ResponseBody
    public Object saveGmSpaceComponentAssociated(HttpServletRequest request, String dataStr, Long spaceId) throws GEPSBisException {
        JsonMsg msg = new JsonMsg();
        GmSpaceComponentAssociated entity = new GmSpaceComponentAssociated();
        JSONObject jsonObject = JSONObject.parseObject((String)dataStr);
        entity.setAssociated(Long.parseLong((String)jsonObject.get((Object)"associated")));
        entity.setSpaceId(spaceId);
        entity.setComponentType((String)jsonObject.get((Object)"componentType"));
        entity.setComponentId((String)jsonObject.get((Object)"componentId"));
        entity.setSquence(Long.parseLong((String)jsonObject.get((Object)"squence")));
        entity.setDisplayName((String)jsonObject.get((Object)"displayName"));
        entity.setComponentWidth((String)jsonObject.get((Object)"componentWidth"));
        entity.setComponentHeight(Long.parseLong((String)jsonObject.get((Object)"componentHeight")));
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        if (entity.getAssociated() == null) {
            entity.setCreateAccount(this.getLoginUser(request).getAccountid());
            entity.setCreateTime(new Date());
        }
        this.gmspacecomponentassociatedService.saveGmSpaceComponentAssociated(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/toGmSpaceComponentAssociatedPage"})
    public String toGmSpaceComponentAssociatedPage(Long id, Model model) {
        if (id != null) {
            List<Map<String, Object>> gmSpaceComponentList = this.gmspacecomponentassociatedService.findBySpaceId(id);
            model.addAttribute("dataList", gmSpaceComponentList);
        } else {
            model.addAttribute("dataList", new ArrayList());
        }
        return "business/gm/GmSpaceComponentAssociated";
    }

    @RequestMapping(value={"/saveSpaceComponentSquence"})
    @ResponseBody
    public Object saveSpaceComponentSquence(String dataStr) {
        JsonMsg msg = new JsonMsg();
        JSONArray jsonArray = JSONArray.parseArray((String)dataStr);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            Long associated = Long.parseLong(Objects.toString(jsonObject.get((Object)"associated")));
            GmSpaceComponentAssociated gmSpaceComponentAssociated = this.gmspacecomponentassociatedService.findGmSpaceComponentAssociated(associated);
            Integer squence = (Integer)jsonObject.get((Object)"squence");
            gmSpaceComponentAssociated.setSquence(squence.longValue());
            this.gmspacecomponentassociatedService.saveGmSpaceComponentAssociated(gmSpaceComponentAssociated);
        }
        return msg;
    }

    @RequestMapping(value={"/allocateGmSpaceComponent"})
    public String allocateGmSpaceComponent(Long spaceId, String componentType, Model model) {
        List<ComboxNode> componentTypes = this.comService.getDicComboWithDefault("COMPONENT_TYPE");
        model.addAttribute("spaceId", (Object)spaceId);
        model.addAttribute("componentType", (Object)componentType);
        model.addAttribute("componentTypes", componentTypes);
        return "business/gm/GmSpaceComponentWin";
    }

    @RequestMapping(value={"/showInfoTypeSelectWin"})
    public String showInfoTypeSelectWin(Long spaceId, String componentType, Long associated, Model model) {
        String componentType2;
        model.addAttribute("spaceId", (Object)spaceId);
        model.addAttribute("componentType", (Object)componentType);
        GmSpaceComponentAssociated gmSpaceComponentAssociated = null;
        ArrayList<GmInfoType> list = new ArrayList<GmInfoType>();
        if (associated != null && (componentType2 = (gmSpaceComponentAssociated = this.gmspacecomponentassociatedService.findGmSpaceComponentAssociated(associated)).getComponentType()) == "1") {
            String componentId = gmSpaceComponentAssociated.getComponentId();
            for (String id : componentId.split(",")) {
                GmInfoType gmInfoType = this.gmInfoTypeService.findGmInfoType(Long.parseLong(id));
                list.add(gmInfoType);
            }
        }
        model.addAttribute("gmInfoTypeList", list);
        return "business/gm/infoTypeSelectWin";
    }

    @RequestMapping(value={"/showComponentSelectWin"})
    public String showComponentSelectWin(Long spaceId, String componentType, Model model) {
        model.addAttribute("spaceId", (Object)spaceId);
        model.addAttribute("componentType", (Object)componentType);
        return "business/gm/componentSelectWin";
    }

    @RequestMapping(value={"/addComponentAssociated"})
    @ResponseBody
    public Object addComponentAssociated(HttpServletRequest request, Long spaceId, String dataStr, Long maxSquence) throws UnsupportedEncodingException {
        JsonMsg msg = new JsonMsg();
        JSONArray jsonArray = JSONArray.parseArray((String)dataStr);
        ArrayList<GmSpaceComponentAssociated> list = new ArrayList<GmSpaceComponentAssociated>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            String linkAddress;
            GmSpaceComponentAssociated entity = new GmSpaceComponentAssociated();
            Long l = maxSquence;
            Long l2 = maxSquence = Long.valueOf(maxSquence + 1L);
            JSONObject jsonObject = (JSONObject)jsonArray.get(i);
            entity.setSpaceId(spaceId);
            String componentType = (String)jsonObject.get((Object)"componentType");
            String componentId = (String)jsonObject.get((Object)"componentId");
            entity.setComponentType(componentType);
            entity.setComponentId(componentId);
            if ("1".equals(componentType)) {
                linkAddress = "/GmInfoContent/viewContentListByIds?typeIds=" + componentId;
                String infoContent = SysUtils.GetHttpContent(request, linkAddress);
                entity.setComponentContent(infoContent);
            } else {
                GmSpaceComponentDefinition spaceComponentDefinition = this.gmSpaceComponentDefinitionService.findGmSpaceComponentDefinition(Long.parseLong(componentId));
                linkAddress = "/GmSpaceComponentDefinition/viewContentListByIds?componentIds=" + spaceComponentDefinition.getComponentId();
                String componentContent = SysUtils.GetHttpContent(request, linkAddress);
                entity.setComponentContent(componentContent);
            }
            entity.setSquence(maxSquence);
            entity.setComponentWidth("33.3%");
            entity.setComponentHeight(300L);
            entity.setModifyAccount(this.getLoginUser(request).getAccountid());
            entity.setModifyTime(new Date());
            entity.setIsUse("Y");
            if (entity.getAssociated() == null) {
                entity.setCreateAccount(this.getLoginUser(request).getAccountid());
                entity.setCreateTime(new Date());
            }
            this.gmspacecomponentassociatedService.saveGmSpaceComponentAssociated(entity);
            list.add(entity);
        }
        msg.setO(list);
        return msg;
    }

    @RequestMapping(value={"/addComponentAssociatedInCard"})
    @ResponseBody
    public Object addComponentAssociatedInCard(HttpServletRequest request, String dataStr, Long associated) throws UnsupportedEncodingException {
        JsonMsg msg = new JsonMsg();
        GmSpaceComponentAssociated gmSpaceComponentAssociated = this.gmspacecomponentassociatedService.findGmSpaceComponentAssociated(associated);
        String componentId = gmSpaceComponentAssociated.getComponentId();
        JSONArray jsonArray = JSONArray.parseArray((String)dataStr);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject jsonObject = (JSONObject)jsonArray.get(i);
            String singlecComponentId = (String)jsonObject.get((Object)"componentId");
            componentId = componentId + "," + singlecComponentId;
        }
        gmSpaceComponentAssociated.setComponentId(componentId);
        gmSpaceComponentAssociated.setModifyAccount(this.getLoginUser(request).getAccountid());
        gmSpaceComponentAssociated.setModifyTime(new Date());
        this.gmspacecomponentassociatedService.saveGmSpaceComponentAssociated(gmSpaceComponentAssociated);
        String componentType = gmSpaceComponentAssociated.getComponentType();
        String linkAddress = "1".equals(componentType) ? "/GmInfoContent/viewContentListByIds?typeIds=" + gmSpaceComponentAssociated.getComponentId() : "/GmSpaceComponentDefinition/viewContentListByIds?componentIds=" + gmSpaceComponentAssociated.getComponentId();
        String content = SysUtils.GetHttpContent(request, linkAddress);
        gmSpaceComponentAssociated.setComponentContent(content);
        msg.setO(gmSpaceComponentAssociated);
        return msg;
    }

    @RequestMapping(value={"/countInfoTypeIsOrNotUse"})
    @ResponseBody
    public Object countInfoTypeIsOrNotUse(Long id) {
        JsonMsg msg = new JsonMsg();
        Integer countInfoTypeIsOrNotUse = this.gmspacecomponentassociatedService.countInfoTypeIsOrNotUse(id);
        if (countInfoTypeIsOrNotUse == 1) {
            msg.setMsg("\u8be5\u680f\u76ee\u88ab\u7a7a\u95f4\u6240\u5f15\u7528,\u4e0d\u80fd\u5220\u9664");
        } else {
            this.gmInfoTypeManagersService.deleteByTypeId(id);
        }
        return msg;
    }

    @RequestMapping(value={"/findPublishScopeByTypeId"})
    @ResponseBody
    public Object findPublishScopeByTypeId(Long typeId) {
        JsonMsg msg = new JsonMsg();
        Map<String, Object> data = this.gmspacecomponentassociatedService.findPublishScopeByTypeId(typeId);
        msg.setO(data);
        return msg;
    }

    @RequestMapping(value={"/showInfoTypeSelectWinFilter"})
    public String showInfoTypeSelectWinFilter(Long spaceId, String componentType, Long associated, Model model) {
        model.addAttribute("spaceId", (Object)spaceId);
        model.addAttribute("componentType", (Object)componentType);
        return "business/gm/infoTypeSelectWinFilter";
    }

    @RequestMapping(value={"/showComponentSelectWinFilter"})
    public String showComponentSelectWinFilter(Long spaceId, String componentType, Model model) {
        model.addAttribute("spaceId", (Object)spaceId);
        model.addAttribute("componentType", (Object)componentType);
        return "business/gm/componentSelectWinFilter";
    }

    @RequestMapping(value={"/saveSpaceComponentSquenceCustom"})
    @ResponseBody
    public Object saveSpaceComponentSquenceCustom(HttpServletRequest request, String dataStr, Long spaceId) {
        JsonMsg msg = new JsonMsg();
        JSONArray jsonArray = JSONArray.parseArray((String)dataStr);
        this.gmSpaceComponentCustomService.deleteByUserAndSpace(this.getLoginUser(request).getAccountid(), spaceId);
        for (int i = 0; i < jsonArray.size(); ++i) {
            GmSpaceComponentCustom entity = new GmSpaceComponentCustom();
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            entity.setComponentType(jsonObject.get((Object)"componentType").toString());
            entity.setComponentId(jsonObject.get((Object)"componentId").toString());
            entity.setSquence(Long.parseLong(jsonObject.get((Object)"squence").toString()));
            Integer squence = (Integer)jsonObject.get((Object)"squence");
            entity.setSquence(squence.longValue());
            entity.setSpaceId(spaceId);
            entity.setDisplayName(null);
            entity.setCreateAccount(this.getLoginUser(request).getAccountid());
            entity.setCreateTime(new Date());
            entity.setModifyAccount(this.getLoginUser(request).getAccountid());
            entity.setModifyTime(new Date());
            entity.setIsUse("Y");
            entity.setComponentHeight(jsonObject.get((Object)"componentHeight") != null ? jsonObject.getLong("componentHeight") : 338L);
            entity.setComponentWidth(jsonObject.get((Object)"componentWidth") != null ? jsonObject.getString("componentWidth") : "33.30%");
            this.gmSpaceComponentCustomService.saveGmSpaceComponentCustom(entity);
        }
        return msg;
    }

    @RequestMapping(value={"/resetSpaceComponentSquenceCustom"})
    @ResponseBody
    public Object resetSpaceComponentSquenceCustom(HttpServletRequest request, Long spaceId) {
        JsonMsg msg = new JsonMsg();
        this.gmSpaceComponentCustomService.deleteByUserAndSpace(this.getLoginUser(request).getAccountid(), spaceId);
        return msg;
    }
}

