/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.controller;

import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.ComboxNode;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.common.util.LoginUser;
import com.ustc.base.common.util.SysContent;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.BasDept;
import com.ustc.base.entity.BasEmpAccount;
import com.ustc.base.service.BasDeptService;
import com.ustc.base.service.BasEmpAccountService;
import com.ustc.base.service.BasRolesAccountService;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/basdept"})
public class BaseDeptController
extends BaseController {
    @Autowired
    private BasDeptService basDeptService;
    @Autowired
    private BasRolesAccountService basRolesAccountService;
    @Autowired
    private BasEmpAccountService basEmpAccountService;

    @RequestMapping(value={"/queryDeptmenu"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryDeptmenu(HttpServletRequest request, String pid, String orgId, @RequestParam(value="isTree", required=false, defaultValue="false") String isTree) {
        long searchPid = 0L;
        long searchOrgId = 0L;
        if (!StringUtils.isEmpty((Object)pid)) {
            searchPid = Long.parseLong(pid);
        }
        if (!StringUtils.isEmpty((Object)orgId)) {
            searchOrgId = Long.parseLong(orgId);
        } else {
            LoginUser user = this.getLoginUser(request);
            searchOrgId = user.getOrgid();
        }
        List<ComBoxTreeNode> deptlist = this.basDeptService.getDeptMenu(searchPid, searchOrgId);
        if ("true".equals(isTree)) {
            ComBoxTreeNode root = new ComBoxTreeNode();
            root.setId("0");
            root.setText("\u90e8\u95e8\u4f53\u7cfb");
            root.setChecked(false);
            root.setChildren(deptlist);
            ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
            list.add(root);
            return list;
        }
        return deptlist;
    }

    @RequestMapping(value={"/queryDeptdefault"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryDeptmenu() {
        long searchPid = 0L;
        long searchOrgId = 10001L;
        List<ComBoxTreeNode> deptlist = this.basDeptService.getDeptMenu(searchPid, searchOrgId);
        return deptlist;
    }

    @RequestMapping(value={"/queryDeptCombox"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryDeptCombox(HttpServletRequest request, String deptLevel, @RequestParam(value="showBusinessUnit", defaultValue="false") boolean showBusinessUnit, @RequestParam(value="isdetail", defaultValue="false") boolean isdetail) {
        LoginUser user = this.getLoginUser(request);
        Long searchOrgId = null;
        String orgId = request.getParameter("orgId");
        if (isdetail && !StringUtils.isEmpty((Object)orgId)) {
            searchOrgId = Long.parseLong(orgId);
        } else if (!isdetail) {
            searchOrgId = user.getOrgid();
        }
        List<ComboxNode> deptlist = this.basDeptService.getDeptCombo(searchOrgId, deptLevel, showBusinessUnit);
        return deptlist;
    }

    @RequestMapping(value={"/queryAllDept"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryAllDept(Long orgId) {
        List<ComboxNode> deptlist = this.basDeptService.getDeptCombo(orgId, null);
        return deptlist;
    }

    @RequestMapping(value={"/queryDeptCombo"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryDeptCombo(Long orgId, String deptLevel) {
        Long searchOrgId = SysContent.ORG_ID_TFJT;
        if (orgId != null) {
            searchOrgId = orgId;
        }
        List<ComboxNode> deptlist = this.basDeptService.getDeptCombo(searchOrgId, deptLevel);
        return deptlist;
    }

    @RequestMapping(value={"/queryDeptInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryDeptInfo(String deptId) {
        BasDept entity = this.basDeptService.findByDeptId(Long.parseLong(deptId));
        if (entity == null) {
            return new BasDept();
        }
        if (!StringUtils.isEmpty((Object)entity.getDeptHead())) {
            String[] acc = entity.getDeptHead().split(",");
            StringBuilder str = new StringBuilder();
            for (String acc1 : acc) {
                BasEmpAccount account = this.basEmpAccountService.findById(Long.parseLong(acc1));
                if (account == null) continue;
                str.append(account.getAccountName()).append(",");
            }
            String string = str.substring(0, str.lastIndexOf(","));
            entity.setDeptHead_TEXT_(string);
        }
        if (!StringUtils.isEmpty((Object)entity.getDeptLeader())) {
            String[] acc2 = entity.getDeptLeader().split(",");
            StringBuilder str2 = new StringBuilder();
            for (String acc3 : acc2) {
                BasEmpAccount account2 = this.basEmpAccountService.findById(Long.parseLong(acc3));
                if (account2 == null) continue;
                str2.append(account2.getAccountName()).append(",");
            }
            String string = str2.substring(0, str2.lastIndexOf(","));
            entity.setDeptLeader_TEXT_(string);
        }
        return entity;
    }

    @RequestMapping(value={"/saveDept"})
    @ResponseBody
    public Object saveDept(BasDept basDept) {
        return this.basDeptService.saveDept(basDept);
    }

    @RequestMapping(value={"/deleDept"}, method={RequestMethod.POST})
    @ResponseBody
    public Object deleDept(String deptId) {
        BasDept basDept = this.basDeptService.findByDeptId(Long.parseLong(deptId));
        basDept.setIsUse("N");
        JsonMsg msg = this.basDeptService.saveDept(basDept);
        return msg;
    }

    @RequestMapping(value={"/findArchivesDept"}, method={RequestMethod.POST})
    @ResponseBody
    public Object findArchivesDept() {
        return this.basDeptService.findArchivesDept();
    }

    @RequestMapping(value={"/deleDepts"}, method={RequestMethod.POST})
    @ResponseBody
    public Object deleOrgs(String deptId) {
        Long searchId = Long.parseLong(deptId);
        BasDept basDept = this.basDeptService.findByDeptId(searchId);
        basDept.setIsUse("N");
        if (this.basDeptService.delDepts(searchId)) {
            return this.basDeptService.saveDept(basDept);
        }
        return new JsonMsg(false, "\u64cd\u4f5c\u5931\u8d25");
    }

    @RequestMapping(value={"/pageBasDept"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageBasDept(@RequestParam(value="orgId", defaultValue="0") Long orgId, @RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.basDeptService.PageAll(orgId, search, page, rows);
    }

    @RequestMapping(value={"/queryDeptComboxByOrgId"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryDeptComboxByOrgId(HttpServletRequest request, String deptLevel, @RequestParam(value="showBusinessUnit", defaultValue="false") boolean showBusinessUnit, @RequestParam(value="isdetail", defaultValue="false") boolean isdetail, Long orgId) {
        LoginUser user = this.getLoginUser(request);
        if (orgId == null) {
            ArrayList deptlist = new ArrayList();
            return deptlist;
        }
        if (isdetail) {
            orgId = null;
        }
        List<ComboxNode> deptlist = this.basDeptService.getDeptCombo(orgId, null, showBusinessUnit);
        return deptlist;
    }

    @RequestMapping(value={"/queryDeptAndOrgCombo"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryDeptAndOrgCombo(Long deptId) {
        List<ComboxNode> deptlist = this.basDeptService.getComboxListForDeptAndOrg(deptId);
        return deptlist;
    }

    @RequestMapping(value={"/queryDeptAndOrgNameById"}, method={RequestMethod.POST})
    @ResponseBody
    public String queryDeptAndOrgNameById(Long id) {
        return this.basDeptService.queryDeptAndOrgNameById(id);
    }

    @RequestMapping(value={"/queryOrgDeptCombox"}, method={RequestMethod.POST})
    @ResponseBody
    public Object queryOrgDeptCombox(HttpServletRequest request, String deptLevel, @RequestParam(value="showBusinessUnit", defaultValue="false") boolean showBusinessUnit, @RequestParam(value="isdetail", defaultValue="false") boolean isdetail) {
        String isAll = request.getParameter("isAll");
        LoginUser user = this.getLoginUser(request);
        Long searchOrgId = null;
        String orgId = request.getParameter("orgId");
        if (isdetail && !StringUtils.isEmpty((Object)orgId)) {
            searchOrgId = Long.parseLong(orgId);
        } else if (!isdetail) {
            searchOrgId = user.getOrgid();
        }
        List<ComboxNode> deptlist = this.basDeptService.queryOrgDeptCombox(searchOrgId, deptLevel, showBusinessUnit, isAll);
        return deptlist;
    }
}

