/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.controller;

import com.ustc.base.common.util.ComboxNode;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.BasSysCode;
import com.ustc.base.service.BasSysCodeService;
import com.ustc.base.service.CommonService;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/BasSysCode"})
public class BasSysCodeController
extends BaseController {
    @Autowired
    private BasSysCodeService basSysCodeService;
    @Autowired
    private CommonService commonService;

    @RequestMapping(value={"/pageBasSysCode"}, method={RequestMethod.POST})
    @ResponseBody
    public Object pageBasSysCode(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows) {
        return this.basSysCodeService.PageAll(search, page, rows);
    }

    @RequestMapping(value={"/findBasSysCode"})
    @ResponseBody
    public Object findBasSysCode(String id) {
        return this.basSysCodeService.findBasSysCode(id);
    }

    @RequestMapping(value={"/saveBasSysCode"})
    @ResponseBody
    public Object saveBasSysCode(HttpServletRequest request, BasSysCode entity) {
        JsonMsg msg = new JsonMsg();
        if (StringUtils.isBlank((CharSequence)entity.getSysCodeId())) {
            entity.setGencodeDate(new Date());
            entity.setGencodeNo(0L);
        } else {
            BasSysCode oldentity = this.basSysCodeService.findBasSysCode(entity.getSysCodeId());
            entity.setGencodeDate(oldentity.getGencodeDate());
            entity.setGencodeNo(oldentity.getGencodeNo());
        }
        this.basSysCodeService.saveBasSysCode(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delBasSysCode"})
    @ResponseBody
    public Object delBasSysCode(String id) {
        this.basSysCodeService.delBasSysCode(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/allcode"})
    @ResponseBody
    public Object allcode() {
        return this.basSysCodeService.allcode();
    }

    @RequestMapping(value={"/gencode"})
    @ResponseBody
    public Object gencode(HttpServletRequest request, String code) {
        String queryString = request.getQueryString();
        return this.basSysCodeService.genCode(code, queryString);
    }

    @RequestMapping(value={"/allrule"})
    @ResponseBody
    public List<ComboxNode> allrule() {
        return this.commonService.getDicCombo("SYS_CODE");
    }
}

