/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.controller;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.map.MapUtil;
import com.gexin.fastjson.JSON;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.BasLoginPageConfig;
import com.ustc.base.service.BasLoginPageConfigService;
import com.ustc.config.LoginConfigProperties;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/loginPage"})
public class BasLoginPageConfigController
extends BaseController {
    private static final Logger logger = LoggerFactory.getLogger(BasLoginPageConfigController.class);
    @Autowired
    private BasLoginPageConfigService configService;

    @RequestMapping(value={"/config"})
    public ModelAndView config(HttpServletRequest request) {
        ModelAndView mv = new ModelAndView();
        BasLoginPageConfig config = this.configService.getConfig();
        mv.setViewName("/base/loginPageConfig");
        mv.addObject("loginForm", (Object)JSON.toJSONString((Object)config));
        List fileNames = FileUtil.listFileNames((String)(LoginConfigProperties.baseDir + LoginConfigProperties.LOGIN_BG));
        List fileList = fileNames.stream().map(s -> MapUtil.builder().put((Object)"name", s).put((Object)"url", (Object)(request.getContextPath() + "/loginImg/" + LoginConfigProperties.LOGIN_BG + "/" + s)).build()).collect(Collectors.toList());
        mv.addObject("fileList", (Object)JSON.toJSONString(fileList));
        List loginLogoNames = FileUtil.listFileNames((String)(LoginConfigProperties.baseDir + LoginConfigProperties.LOGO));
        List logoImgs = loginLogoNames.stream().map(s -> MapUtil.builder().put((Object)"name", s).put((Object)"url", (Object)(request.getContextPath() + "/loginImg/" + LoginConfigProperties.LOGO + "/" + s)).build()).collect(Collectors.toList());
        mv.addObject("logoImgs", (Object)JSON.toJSONString(logoImgs));
        List indexLogoNames = FileUtil.listFileNames((String)(LoginConfigProperties.baseDir + LoginConfigProperties.INDEX_LOGO));
        List indexLogos = indexLogoNames.stream().map(s -> MapUtil.builder().put((Object)"name", s).put((Object)"url", (Object)(request.getContextPath() + "/loginImg/" + LoginConfigProperties.INDEX_LOGO + "/" + s)).build()).collect(Collectors.toList());
        mv.addObject("indexLogos", (Object)JSON.toJSONString(indexLogos));
        List faviconNames = FileUtil.listFileNames((String)(LoginConfigProperties.baseDir + LoginConfigProperties.FAVICON));
        List faviconImg = faviconNames.stream().map(s -> MapUtil.builder().put((Object)"name", s).put((Object)"url", (Object)(request.getContextPath() + "/loginImg/" + LoginConfigProperties.FAVICON + "/" + s)).build()).collect(Collectors.toList());
        mv.addObject("faviconImg", (Object)JSON.toJSONString(faviconImg));
        List sloganNames = FileUtil.listFileNames((String)(LoginConfigProperties.baseDir + LoginConfigProperties.LOGIN_SLOGAN));
        List sloganImg = sloganNames.stream().map(s -> MapUtil.builder().put((Object)"name", s).put((Object)"url", (Object)(request.getContextPath() + "/loginImg/" + LoginConfigProperties.LOGIN_SLOGAN + "/" + s)).build()).collect(Collectors.toList());
        mv.addObject("sloganImg", (Object)JSON.toJSONString(sloganImg));
        return mv;
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public JsonMsg saveConfig(BasLoginPageConfig config) {
        this.configService.saveConfig(config);
        return new JsonMsg(true, "\u4fdd\u5b58\u6210\u529f");
    }

    @RequestMapping(value={"/refreshSession"})
    @ResponseBody
    public JsonMsg refreshSession(HttpServletRequest request, BasLoginPageConfig config) {
        request.getSession().setAttribute("loginPageConfig", (Object)config);
        return new JsonMsg(true, "\u5237\u65b0\u6210\u529f");
    }

    @RequestMapping(value={"/getTemplate"})
    public ModelAndView getTemplate(HttpServletRequest request, Integer themeNo) {
        ModelAndView mv = new ModelAndView();
        BasLoginPageConfig config = (BasLoginPageConfig)request.getSession().getAttribute("loginPageConfig");
        if (config == null) {
            config = this.configService.getConfig();
        }
        mv.setViewName("/base/loginTemplate/login" + themeNo);
        mv.addObject("loginConfig", (Object)config);
        List fileNames = FileUtil.listFileNames((String)(LoginConfigProperties.baseDir + LoginConfigProperties.LOGIN_BG));
        List loginBgImgs = fileNames.stream().map(s -> request.getContextPath() + "/loginImg/" + LoginConfigProperties.LOGIN_BG + "/" + s).collect(Collectors.toList());
        mv.addObject("loginBgImgs", (Object)JSON.toJSONString(loginBgImgs));
        String logoImgName = (String)FileUtil.listFileNames((String)(LoginConfigProperties.baseDir + LoginConfigProperties.LOGO)).get(0);
        mv.addObject("logoImgUrl", (Object)(request.getContextPath() + "/loginImg/" + LoginConfigProperties.LOGO + "/" + logoImgName));
        List sloganImgNames = FileUtil.listFileNames((String)(LoginConfigProperties.baseDir + LoginConfigProperties.LOGIN_SLOGAN));
        if (sloganImgNames != null && !sloganImgNames.isEmpty()) {
            mv.addObject("sloganImgUrl", (Object)(request.getContextPath() + "/loginImg/" + LoginConfigProperties.LOGIN_SLOGAN + "/" + (String)sloganImgNames.get(0)));
        }
        return mv;
    }

    @RequestMapping(value={"/uploadBgPic"})
    @ResponseBody
    public JsonMsg uploadBgPic(MultipartFile bgPic, String catalog) {
        String filename = UUID.randomUUID() + "." + bgPic.getContentType().substring(bgPic.getContentType().lastIndexOf("/") + 1);
        try {
            String SAVE_PATH = LoginConfigProperties.baseDir + catalog;
            if (StringUtils.hasText((String)catalog) && (catalog.equals("logo") || catalog.equals("indexLogo"))) {
                FileUtil.clean((String)SAVE_PATH);
            }
            Path path = Paths.get(SAVE_PATH, filename);
            bgPic.transferTo(path.toFile());
        }
        catch (IOException e) {
            logger.error("uploadBgPic error", (Throwable)e);
        }
        return new JsonMsg(true, "\u4e0a\u4f20\u6210\u529f", filename);
    }

    @RequestMapping(value={"/deleteBgPic"})
    @ResponseBody
    public JsonMsg deleteBgPic(String filename) {
        FileUtil.del((File)new File(LoginConfigProperties.baseDir + LoginConfigProperties.LOGIN_BG + "/" + filename));
        return new JsonMsg(true, "\u5220\u9664\u6210\u529f", filename);
    }

    @RequestMapping(value={"/getLoginBg"})
    @ResponseBody
    public List<Map> getLoginBg() {
        List fileNames = FileUtil.listFileNames((String)(LoginConfigProperties.baseDir + LoginConfigProperties.LOGIN_BG));
        return fileNames.stream().map(s -> MapUtil.builder().put((Object)"name", s).put((Object)"url", (Object)(LoginConfigProperties.baseDir + LoginConfigProperties.LOGIN_BG + "/" + s)).build()).collect(Collectors.toList());
    }

    @RequestMapping(value={"/uploadFavicon"})
    @ResponseBody
    public JsonMsg uploadFavicon(MultipartFile favicon) {
        String filename = "favicon.ico";
        try {
            String SAVE_PATH = LoginConfigProperties.baseDir + LoginConfigProperties.FAVICON;
            FileUtil.clean((String)SAVE_PATH);
            Path path = Paths.get(SAVE_PATH, filename);
            favicon.transferTo(path.toFile());
        }
        catch (IOException e) {
            logger.error("uploadFavicon error", (Throwable)e);
        }
        return new JsonMsg(true, "\u4e0a\u4f20\u6210\u529f", filename);
    }
}

