/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.controller;

import com.ustc.base.common.util.ComBoxTreeNode;
import com.ustc.base.common.util.JsonMsg;
import com.ustc.base.controller.BaseController;
import com.ustc.base.entity.BasBusinessProcess;
import com.ustc.base.service.BasBusinessProcessService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/BasBusinessProcess"})
public class BasBusinessProcessController
extends BaseController {
    @Autowired
    private BasBusinessProcessService basbusinessprocessService;

    @RequestMapping(value={"/pageBasBusinessProcess"})
    @ResponseBody
    public Object pageBasBusinessProcess(@RequestParam(value="search", defaultValue="") String search, @RequestParam(value="page", defaultValue="1") int page, @RequestParam(value="rows", defaultValue="50") int rows, Long businessId) {
        return this.basbusinessprocessService.PageAll(search, page, rows, businessId);
    }

    @RequestMapping(value={"/findBasBusinessProcess"})
    @ResponseBody
    public Object findBasBusinessProcess(Long id) {
        return this.basbusinessprocessService.findBasBusinessProcess(id);
    }

    @RequestMapping(value={"/findBusinessById"})
    @ResponseBody
    public Object findBusinessById(Long id) {
        BasBusinessProcess entity = this.basbusinessprocessService.findBasBusinessProcess(id);
        if (entity != null) {
            return new JsonMsg(true, "", entity);
        }
        return new JsonMsg(false, "\u672a\u67e5\u627e\u5230\u6570\u636e");
    }

    @RequestMapping(value={"/saveBasBusinessProcess"})
    @ResponseBody
    public Object saveBasBusinessProcess(BasBusinessProcess entity, HttpServletRequest request) {
        JsonMsg msg = new JsonMsg();
        String pidCode = "";
        BasBusinessProcess pidEntity = this.basbusinessprocessService.findBasBusinessProcess(entity.getBusinessPid());
        if (pidEntity != null && pidEntity.getBusinessCode() != null) {
            pidCode = pidEntity.getBusinessCode();
        }
        if ("1".equals(entity.getBusinessType())) {
            entity.setBusinessPidCode("");
        } else if ("2".equals(entity.getBusinessType())) {
            entity.setBusinessPidCode(pidCode);
        } else if ("3".equals(entity.getBusinessType())) {
            entity.setBusinessPidCode(pidCode);
        } else if ("4".equals(entity.getBusinessType())) {
            if (!"3".equals(pidEntity.getBusinessType())) {
                pidCode = pidCode + "00";
            }
            entity.setBusinessPidCode(pidCode);
        }
        entity.setModifyAccount(this.getLoginUser(request).getAccountid());
        entity.setModifyTime(new Date());
        entity.setIsUse("Y");
        this.basbusinessprocessService.saveBasBusinessProcess(entity);
        msg.setO(entity);
        return msg;
    }

    @RequestMapping(value={"/delBasBusinessProcess"})
    @ResponseBody
    public Object delBasBusinessProcess(Long id) {
        BasBusinessProcess entity = this.basbusinessprocessService.findBasBusinessProcess(id);
        this.basbusinessprocessService.delBasBusinessProcess(id);
        this.basbusinessprocessService.saveBasBusinessProcess(entity);
        return new JsonMsg();
    }

    @RequestMapping(value={"/treeBasBusinessProcessWithRoot"})
    @ResponseBody
    public Object treeBasBusinessProcessWithRoot(@RequestParam(value="pid", defaultValue="0") Long pid) {
        List<ComBoxTreeNode> treelist = this.basbusinessprocessService.treeBasBusinessProcess(pid);
        ComBoxTreeNode root = new ComBoxTreeNode();
        root.setId("0");
        root.setText("\u6839\u8282\u70b9");
        root.setChecked(false);
        root.setChildren(treelist);
        ArrayList<ComBoxTreeNode> list = new ArrayList<ComBoxTreeNode>();
        list.add(root);
        return list;
    }

    @RequestMapping(value={"/treeBasBusinessProcess"})
    @ResponseBody
    public Object treeBasBusinessProcess(@RequestParam(value="pid", defaultValue="0") Long pid) {
        return this.basbusinessprocessService.treeBasBusinessProcess(pid);
    }

    @RequestMapping(value={"/delBasBusinessProcessAndChild"})
    @ResponseBody
    public Object delBasBusinessProcessAndChild(Long id) {
        this.basbusinessprocessService.delBasBusinessProcessAndChild(id);
        return new JsonMsg();
    }

    @RequestMapping(value={"/IsBusinessType"})
    @ResponseBody
    public Object IsBusinessType(String code) {
        JsonMsg msg = new JsonMsg();
        List<BasBusinessProcess> list = this.basbusinessprocessService.findByBusinessCodeAndIsUse(code);
        if (list == null || list.size() != 1) {
            msg.setSuccess(false);
            msg.setMsg("\u4e1a\u52a1\u6d41\u7a0b\u8bbe\u8ba1\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u64cd\u4f5c");
            return msg;
        }
        msg.setSuccess(true);
        msg.setO(list.get(0));
        if ("3".equals(list.get(0).getBusinessType())) {
            msg.setMsg("Y");
        } else if ("4".equals(list.get(0).getBusinessType())) {
            msg.setMsg("N");
        } else {
            msg.setMsg("C");
        }
        return msg;
    }

    @RequestMapping(value={"/childDetail"})
    @ResponseBody
    public Object childDetail(String businessCode) {
        JsonMsg msg = new JsonMsg();
        List<BasBusinessProcess> mapList = this.basbusinessprocessService.childDetail(businessCode);
        if (mapList != null && mapList.size() > 0) {
            msg.setO(mapList);
            msg.setSuccess(true);
        } else {
            msg.setSuccess(false);
        }
        return msg;
    }

    @RequestMapping(value={"/businessFlow"})
    public Object projectBoard(Model model, String businessCode) {
        List<Map<String, Object>> data = this.basbusinessprocessService.queryBusinessFlow(businessCode);
        model.addAttribute("dataList", data);
        return "/pub/businessFlowTest";
    }
}

