/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.common.util;

import com.ustc.base.common.util.LayuiPageObject;
import com.ustc.base.common.util.PageObject;
import com.ustc.base.common.util.SysUtils;
import com.ustc.gen.util.DBPropertyUtil;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.beetl.sql.core.SQLManager;
import org.beetl.sql.core.engine.PageQuery;
import org.hibernate.engine.spi.SessionImplementor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Repository;

@Repository(value="BeetlSQLHelper")
public class BeetlSQLHelper {
    @Autowired
    SQLManager sqlManager;
    private static final String userkey = "loginuser";
    @PersistenceContext
    @Resource
    private EntityManager entityManager;
    private static Logger logger = LoggerFactory.getLogger(BeetlSQLHelper.class);

    private void appendUserToParams(Map<String, Object> paras) {
        if (paras != null && !paras.containsKey(userkey)) {
            paras.put(userkey, SysUtils.getLoginUser());
        }
        if (paras != null && paras.get("search") != null) {
            paras.put("search", paras.get("search").toString().replace("_", "/_"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> getMetaInfoList(String sql, Object[] params) {
        Statement pst = null;
        ResultSet rs = null;
        try {
            ResultSetMetaData data;
            SessionImplementor session = (SessionImplementor)this.entityManager.unwrap(SessionImplementor.class);
            Connection con = session.connection();
            pst = con.prepareStatement(sql);
            if (params != null) {
                for (int i = 0; i < params.length; ++i) {
                    pst.setObject(i + 1, params[i]);
                }
            }
            if ((data = (rs = pst.executeQuery()).getMetaData()) != null) {
                ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
                for (int i = 1; i <= data.getColumnCount(); ++i) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("colNum", data.getColumnName(i));
                    map.put("colType", data.getColumnTypeName(i));
                    map.put("colField", DBPropertyUtil.columnToProperty2(data.getColumnName(i).toLowerCase()));
                    result.add(map);
                }
                ArrayList<Map<String, Object>> arrayList = result;
                return arrayList;
            }
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u6570\u636e\u5e93\u76f8\u5e94\u5217\u540d\u4fe1\u606f\u5931\u8d25\uff01", (Throwable)e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error("ResultSet failed\uff01", (Throwable)e);
                }
            }
            if (pst != null) {
                try {
                    pst.close();
                }
                catch (SQLException e) {
                    logger.error("PreparedStatement failed\uff01", (Throwable)e);
                }
            }
        }
        return null;
    }

    public PageObject<Map<String, Object>> serachPage(String sqlId, Map<String, Object> paras, PageRequest pageRequest) {
        this.appendUserToParams(paras);
        PageQuery query = new PageQuery((long)pageRequest.getPageNumber(), paras, -1L, (long)pageRequest.getPageSize());
        Class<Map> clazz = Map.class;
        this.sqlManager.pageQuery(sqlId, clazz, query);
        return new PageObject<Map<String, Object>>(query);
    }

    public LayuiPageObject<Map<String, Object>> serachLayuiPage(String sqlId, Map<String, Object> paras, PageRequest pageRequest) {
        this.appendUserToParams(paras);
        PageQuery query = new PageQuery((long)pageRequest.getPageNumber(), paras, -1L, (long)pageRequest.getPageSize());
        Class<Map> clazz = Map.class;
        this.sqlManager.pageQuery(sqlId, clazz, query);
        return new LayuiPageObject<Map<String, Object>>(query);
    }

    public PageObject<Map<String, Object>> serachPage(String sqlId, Map<String, Object> paras) {
        this.appendUserToParams(paras);
        Class<Map> clazz = Map.class;
        List<Map> list = this.getList(sqlId, paras, clazz);
        PageObject<Map<String, Object>> pageObject = new PageObject<Map<String, Object>>();
        pageObject.setRows(list);
        pageObject.setTotal(Long.parseLong(String.valueOf(list.size())));
        return pageObject;
    }

    public <T> PageObject<T> serachPage(String sqlId, Map<String, Object> paras, Class<T> cls, PageRequest pageRequest) {
        this.appendUserToParams(paras);
        PageQuery query = new PageQuery((long)pageRequest.getPageNumber(), paras, -1L, (long)pageRequest.getPageSize());
        this.sqlManager.pageQuery(sqlId, cls, query);
        return new PageObject(query);
    }

    public <T> PageObject<T> serachPage(String sqlId, Map<String, Object> paras, Class<T> cls) {
        this.appendUserToParams(paras);
        List<T> list = this.getList(sqlId, paras, cls);
        PageObject<T> pageObject = new PageObject<T>();
        pageObject.setRows(list);
        pageObject.setTotal(Long.parseLong(String.valueOf(list.size())));
        return pageObject;
    }

    public <T> List<T> getList(String sqlId, Map<String, Object> paras, Class<T> cls) {
        this.appendUserToParams(paras);
        List list = this.sqlManager.select(sqlId, cls, paras);
        return list;
    }

    public List<Map<String, Object>> getMapList(String sqlId, Map<String, Object> paras) {
        this.appendUserToParams(paras);
        Class<Map> clazz = Map.class;
        List list = this.sqlManager.select(sqlId, clazz, paras);
        return list;
    }

    public <T> T getEntity(String sqlId, Map<String, Object> paras, Class<T> cls) {
        this.appendUserToParams(paras);
        Object t = this.sqlManager.selectSingle(sqlId, paras, cls);
        return (T)t;
    }

    public Map<String, Object> getMap(String sqlId, Map<String, Object> paras) {
        this.appendUserToParams(paras);
        Class<Map> clazz = Map.class;
        Map retrunMap = (Map)this.sqlManager.selectSingle(sqlId, paras, clazz);
        return retrunMap;
    }

    public Long getLongValue(String sqlId, Map<String, Object> paras) {
        this.appendUserToParams(paras);
        return this.sqlManager.longValue(sqlId, paras);
    }

    public Integer getIntValue(String sqlId, Map<String, Object> paras) {
        this.appendUserToParams(paras);
        return this.sqlManager.intValue(sqlId, paras);
    }

    public BigDecimal getBigDecimalValue(String sqlId, Map<String, Object> paras) {
        this.appendUserToParams(paras);
        return this.sqlManager.bigDecimalValue(sqlId, paras);
    }

    public String getStringValue(String sqlId, Map<String, Object> paras) {
        this.appendUserToParams(paras);
        return (String)this.sqlManager.selectSingle(sqlId, paras, String.class);
    }

    public int updateOrDelete(String sqlId, Map<String, Object> paras) {
        this.appendUserToParams(paras);
        return this.sqlManager.update(sqlId, paras);
    }

    public int updateBysql(String sql, Map<String, Object> paras) {
        this.appendUserToParams(paras);
        return this.sqlManager.executeUpdate(sql, paras);
    }

    public PageObject<Map<String, Object>> serachPageBySql(String sql, Map<String, Object> paras, PageRequest pageRequest) {
        this.appendUserToParams(paras);
        Class<Map> clazz = Map.class;
        List list = this.sqlManager.execute(sql, clazz, paras, (long)pageRequest.getPageNumber(), (long)pageRequest.getPageSize());
        PageObject<Map<String, Object>> pageObject = new PageObject<Map<String, Object>>();
        pageObject.setRows(list);
        pageObject.setTotal(Long.parseLong(String.valueOf(list.size())));
        return pageObject;
    }

    public List<Map<String, Object>> serachBySql(String sql, Map<String, Object> paras) {
        this.appendUserToParams(paras);
        Class<Map> clazz = Map.class;
        List list = this.sqlManager.execute(sql, clazz, paras);
        return list;
    }

    public <T> List<T> serachBySql(String sql, Map<String, Object> paras, Class<T> cls) {
        this.appendUserToParams(paras);
        List list = this.sqlManager.execute(sql, cls, paras);
        return list;
    }

    public PageObject<Map<String, Object>> searchPage(String sqlId, Map<String, Object> params) {
        this.appendUserToParams(params);
        Class<Map> clazz = Map.class;
        List<Map> list = this.getList(sqlId, params, clazz);
        PageObject<Map<String, Object>> pageObject = new PageObject<Map<String, Object>>();
        pageObject.setRows(list);
        pageObject.setTotal(Long.parseLong(String.valueOf(list.size())));
        return pageObject;
    }

    public <T> PageObject<T> searchPage(String sqlId, Map<String, Object> paras, Class<T> cls, PageRequest pageRequest) {
        this.appendUserToParams(paras);
        PageQuery query = new PageQuery((long)pageRequest.getPageNumber(), paras, -1L, (long)pageRequest.getPageSize());
        this.sqlManager.pageQuery(sqlId, cls, query);
        return new PageObject(query);
    }

    public PageObject<Map<String, Object>> searchPage(String sqlId, Map<String, Object> paras, PageRequest pageRequest) {
        this.appendUserToParams(paras);
        PageQuery query = new PageQuery((long)pageRequest.getPageNumber(), paras, -1L, (long)pageRequest.getPageSize());
        Class<Map> clazz = Map.class;
        this.sqlManager.pageQuery(sqlId, clazz, query);
        return new PageObject<Map<String, Object>>(query);
    }
}

