/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.common.spring;

import com.ustc.base.common.spring.SpringContextHolder;
import com.ustc.base.common.util.Reflections;
import com.ustc.base.common.util.SysUtils;
import com.ustc.base.entity.BasMessage;
import com.ustc.base.service.CreateCodeService;
import com.ustc.gen.util.DBPropertyUtil;
import com.ustc.workflow.entity.WfWorkitemAdd;
import com.ustc.workflow.service.FlowUtilService;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.Column;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import javax.persistence.Version;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;
import org.springframework.util.StringUtils;

public class MyJpaRepository<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID> {
    private static final Logger logger = LoggerFactory.getLogger(MyJpaRepository.class);
    private static Map<String, Method> cachedMethod = new ConcurrentHashMap<String, Method>();
    private CreateCodeService createCodeService;

    @Autowired
    public MyJpaRepository(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
    }

    public <S extends T> S save(S entity) {
        this.prepareSave(entity);
        return (S)super.save(entity);
    }

    public <S extends T> void prepareSave(S entity) {
        block11: {
            Class<?> cls = entity.getClass();
            Method method = MyJpaRepository.findGetIdMethod(cls);
            if (method == null) {
                logger.error("\u5728Class {} \u4e2d\u672a\u627e\u5230id\u5b57\u6bb5\u7684get\u65b9\u6cd5\uff0c\u65e0\u6cd5\u8fdb\u884c\u9884\u5904\u7406\uff01\u8bf7\u68c0\u67e5Entity\u8bbe\u8ba1\u662f\u5426\u6b63\u786e\uff01", cls);
                return;
            }
            try {
                Object id = method.invoke(entity, new Object[0]);
                if (Reflections.getAccessibleField(entity, "modifyAccount") != null) {
                    BeanUtils.setProperty(entity, (String)"modifyAccount", (Object)SysUtils.getLoginAccountId());
                    try {
                        Method modifyMethod = cls.getMethod("getModifyTime", new Class[0]);
                        if (!modifyMethod.isAnnotationPresent(Version.class)) {
                            BeanUtils.setProperty(entity, (String)"modifyTime", (Object)new Date());
                        }
                    }
                    catch (Exception e) {
                        logger.error("\u6267\u884c\u53cd\u5c04\u65b9\u6cd5\u5931\u8d25\uff01", (Throwable)e);
                    }
                }
                if (StringUtils.isEmpty((Object)id)) {
                    this.prepareInsert(entity);
                    break block11;
                }
                try {
                    ApplicationContext ac = SpringContextHolder.getApplicationContext();
                    if (!BasMessage.class.isInstance(entity) && !WfWorkitemAdd.class.isInstance(entity) && "N".equals(BeanUtils.getProperty(entity, (String)"isUse")) && BeanUtils.getProperty(entity, (String)"processinstid") != null) {
                        ((FlowUtilService)ac.getBean(FlowUtilService.class)).getProcInstService().terminateProcess(Long.parseLong(BeanUtils.getProperty(entity, (String)"processinstid")));
                    }
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                logger.error("\u6267\u884c\u53cd\u5c04\u65b9\u6cd5\u5931\u8d25\uff01", (Throwable)e);
                throw new RuntimeException("\u4fdd\u5b58\u5904\u7406\u65f6\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
            }
        }
    }

    public <S extends T> void prepareInsert(S entity) {
        try {
            if (Reflections.getAccessibleField(entity, "createAccount") != null) {
                BeanUtils.setProperty(entity, (String)"createAccount", (Object)SysUtils.getLoginAccountId());
                BeanUtils.setProperty(entity, (String)"createTime", (Object)new Date());
            }
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u4eba\u521b\u5efa\u65f6\u95f4\u6ce8\u5165\u5931\u8d25\uff01");
        }
        if (this.createCodeService == null) {
            this.createCodeService = SpringContextHolder.getBean(CreateCodeService.class);
        }
        this.createCodeService.createCode(entity);
    }

    public static String getColumnName(Class<?> classtype, Class<? extends Annotation> annotationType) {
        Method[] methods = classtype.getMethods();
        String columnName = "";
        for (Method method : methods) {
            Column columnAnno;
            if (!method.isAnnotationPresent(annotationType) || (columnAnno = method.getAnnotation(Column.class)) == null) continue;
            columnName = columnAnno.name();
            return columnName;
        }
        logger.error("\u5728{}\u4e2d\u627e\u4e0d\u5230\u540c\u65f6\u5e26\u6709{}\u6ce8\u89e3\u548cColumn\u6ce8\u89e3\u7684\u5b57\u6bb5\uff01", (Object)classtype.getName(), (Object)annotationType.getName());
        return columnName;
    }

    private static Method findGetIdMethod(Class<?> cls) {
        String className = cls.getName();
        Method method = cachedMethod.get(className);
        if (method != null) {
            logger.debug("\u627e\u5230\u65b9\u6cd5\u7f13\u5b58\uff1a{}", (Object)method.getName());
            return method;
        }
        String primeryKeyName = DBPropertyUtil.columnToProperty2(MyJpaRepository.getColumnName(cls, Id.class)).toLowerCase();
        Method[] methods = cls.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            method = methods[i];
            if (!("get" + primeryKeyName).equals(method.getName().toLowerCase())) continue;
            cachedMethod.put(className, method);
            return method;
        }
        return null;
    }
}

