/*
 * Decompiled with CFR 0.152.
 */
package com.ustc.base.common.CronTask;

import com.ustc.base.common.CronTask.ScheduledTask;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.config.CronTask;
import org.springframework.stereotype.Component;

@Component
public class CronTaskRegistrar
implements DisposableBean {
    private final Map<String, ScheduledTask> scheduledTasks = new ConcurrentHashMap<String, ScheduledTask>(16);
    @Autowired
    private TaskScheduler taskScheduler;

    public TaskScheduler getScheduler() {
        return this.taskScheduler;
    }

    public void addCronTask(String taskId, Runnable task, String cronExpression) {
        this.addCronTask(taskId, new CronTask(task, cronExpression));
    }

    public void addCronTask(String taskId, CronTask cronTask) {
        if (cronTask != null) {
            if (this.scheduledTasks.containsKey(taskId)) {
                this.removeCronTask(taskId);
            }
            this.scheduledTasks.put(taskId, this.scheduleCronTask(cronTask));
        }
    }

    public void addCronTask(String taskId, Runnable task, Date date) {
        if (task != null) {
            if (this.scheduledTasks.containsKey(taskId)) {
                this.removeCronTask(taskId);
            }
            this.scheduledTasks.put(taskId, this.scheduleCronTask(task, date));
        }
    }

    public void removeCronTask(String taskId) {
        ScheduledTask scheduledTask = this.scheduledTasks.remove(taskId);
        if (scheduledTask != null) {
            scheduledTask.cancel();
        }
    }

    public ScheduledTask scheduleCronTask(CronTask cronTask) {
        ScheduledTask scheduledTask = new ScheduledTask();
        scheduledTask.future = this.taskScheduler.schedule(cronTask.getRunnable(), cronTask.getTrigger());
        return scheduledTask;
    }

    public ScheduledTask scheduleCronTask(Runnable task, Date date) {
        ScheduledTask scheduledTask = new ScheduledTask();
        scheduledTask.future = this.taskScheduler.schedule(task, date);
        return scheduledTask;
    }

    public void destroy() {
        for (ScheduledTask task : this.scheduledTasks.values()) {
            task.cancel();
        }
        this.scheduledTasks.clear();
    }
}

