/*!
 * jQuery Print Previw Plugin v1.0.1
 *
 * Copyright 2011, Tim Connell
 * Licensed under the GPL Version 2 license
 * http://www.gnu.org/licenses/gpl-2.0.html
 *
 * Date: Wed Jan 25 00:00:00 2012 -000
 */
 
(function($) { 
	var isChrome =  navigator.userAgent.indexOf('Chrome') > -1 ;
	// Initialization
	$.fn.printPreview = function() {
		this.each(function() {
			$(this).bind('click', function(e) {
			    e.preventDefault();
			    if (!$('#print-modal').length) {
			        $.printPreview.loadPrintPreview();
			    }
			});
		});
		return this;
	};
    
    // Private functions
    var mask, size, print_modal, print_controls;
    $.printPreview = {
        loadPrintPreview: function(printele) {
        	$("canvas").each(function(index,item){//fixes 打印时canvas复制不了导致二维码丢失的bug
        		var image = $("<image width="+$(item).width()+" height="+$(item).height()+" />");
            	image.attr ('src',$(item)[0].toDataURL("image/png"));
            	$(item).parent().append($(image));
            	$(item).remove();
        	});
        	
            // Declare DOM objects
            print_modal = $('<div id="print-modal"></div>');
            print_controls = $('<div id="print-modal-controls">' + 
                                    '<a href="#" class="print" title="打印">Print page</a>' +
                                    '<a href="#" class="close" title="关闭">Close</a>').hide();
            var print_frame ;
            if(isChrome){
               print_frame = $('<iframe id="print-modal-content" style="display:none;" scrolling="no" border="0" frameborder="0" name="print-frame" />');
            
            }else{
               print_frame = $('<iframe id="print-modal-content" scrolling="no" border="0" frameborder="0" name="print-frame"/>');
            
            }

            // Raise print preview window from the dead, zooooooombies
            print_modal
                .hide()
                .append(print_controls)
                .append(print_frame)
                .appendTo('body');

            // The frame lives
            for (var i=0; i < window.frames.length; i++) {
                if (window.frames[i].name == "print-frame") {    
                    var print_frame_ref = window.frames[i].document;
                    break;
                }
            }
            print_frame_ref.open();
            print_frame_ref.write('<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">' +
                '<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">' + 
                '<head><title>' + document.title + '</title></head>' +
                '<body></body>' +
                '</html>');
            print_frame_ref.close();
            
            // Grab contents and apply stylesheet
            var $iframe_head;
            if(isChrome){
            	$iframe_head = $('link[media*=print],link[media=all],style[media=all],style[media=print]').clone();
            }else{
            	$iframe_head = $('head link[media*=print], head link[media=all],style[media=all]').clone();
            }
            if(!printele){
            	printele = 'body > *:not(#print-modal):not(script)';
            }
            $('body', print_frame_ref).append($("body").children("svg").clone());
            $iframe_body = $(printele).clone();
            $iframe_head.each(function() {
            	if($(this).prop("tagName").toLowerCase()=="link"){
            		$(this).attr('media', 'all');
            	}
            });
            if (!$.browser.msie && !($.browser.version < 7) ) {
                $('head', print_frame_ref).append($iframe_head);
                $('head', print_frame_ref).append($("style[easyui=true]").clone());
                $('body', print_frame_ref).append($iframe_body);
                
            }
            else {
                $('style[easyui=true]').clone().each(function() {
                    $('head', print_frame_ref).append(this.outerHTML);
                });
                $('body > *:not(#print-modal):not(script)').clone().each(function() {
                    $('body', print_frame_ref).append(this.outerHTML);
                });
                $('head link[media*=print], head link[media=all], head script').each(function() {
                    $('head', print_frame_ref).append($(this).clone().attr('media', 'all')[0].outerHTML);
                });
            }
            
            // Disable all links
            $('a', print_frame_ref).bind('click.printPreview', function(e) {
                e.preventDefault();
            });
            
            // Introduce print styles
            $('head').append('<style type="text/css">' +
                '@media print {' +
                    '/* -- Print Preview --*/' +
                    '#print-modal-mask,' +
                    '#print-modal {' +
                        'display: none !important;' +
                    '}' +
                '}' +
                '</style>'
            );
			if(!isChrome){
			   // Load mask
            	$.printPreview.loadMask();
            
            // Disable scrolling
            	$('body').css({overflowY: 'hidden', height: '100%'});
			}
			
         
            $('img', print_frame_ref).load(function() {
                print_frame.height($('body', print_frame.contents())[0].scrollHeight);
            });
            
            // Position modal            
            starting_position = $(window).height() + $(window).scrollTop();
            var css = {
                    top:         starting_position,
                    position:           'absolute', 
                    height:      '100%',
                    overflowY:   'auto',
                    zIndex:      10000,
                    display:     'block'
                }
            if(!isChrome){
                 print_modal
                .css(css)
                .animate({ top: $(window).scrollTop()}, 400, 'linear', function() {
                    print_controls.fadeIn('slow').focus();
                });
            }
       
            print_frame.height($('body', print_frame.contents())[0].scrollHeight+40);
            if(isChrome){
            	$.printPreview.printFrame(print_frame[0]);
                setTimeout(function(){
                	print_modal.remove()
                }, 1000);
            }
            // Bind closure
            $('a', print_controls).bind('click', function(e) {
                e.preventDefault();
                if (!!window.ActiveXObject || "ActiveXObject" in window) {
        	        remove_ie_header_and_footer();
        	    }
                if ($(this).hasClass('print')) { $.printPreview.printFrame(print_frame[0]);}
                else { $.printPreview.distroyPrintPreview(); }
            });
    	},
    	distroyPrintPreview: function() {
    	    print_controls.fadeOut(100);
    	    print_modal.animate({ top: $(window).scrollTop() - $(window).height(), opacity: 1}, 400, 'linear', function(){
    	        print_modal.remove();
    	        //$('body').css({overflowY: 'auto', height: 'auto'});
    	    });
    	    mask.fadeOut('slow', function()  {
    			mask.remove();
    		});				

    		$(document).unbind("keydown.printPreview.mask");
    		mask.unbind("click.printPreview.mask");
    		$(window).unbind("resize.printPreview.mask");
	    },
	    printFrame:function(frameWindow) {
	        // Print the selected window/iframe
	        var def = $.Deferred();
	        try {
	            frameWindow = frameWindow.contentWindow || frameWindow.contentDocument || frameWindow;
	            var printed = false,
	                callPrint = function () {
	                    if(printed) {
	                        return;
	                    }
	                    // Fix for IE : Allow it to render the iframe
	                    frameWindow.focus();
	                    try {
	                        // Fix for IE11 - printng the whole page instead of the iframe content
	                        if (!frameWindow.document.execCommand('print', false, null)) {
	                            // document.execCommand returns false if it failed -http://stackoverflow.com/a/21336448/937891
	                            frameWindow.print();
	                        }
	                        // focus body as it is losing focus in iPad and content not getting printed
	                        $('body').focus();
	                    } catch (e) {
	                        frameWindow.print();
	                    }
	                    def.resolve();
	                };
	            // Print once the frame window loads - seems to work for the new-window option but unreliable for the iframe
	            $(frameWindow).on("load", callPrint);
	            // Fallback to printing directly if the frame doesn't fire the load event for whatever reason
	            setTimeout(callPrint, 750);
	        } catch (err) {
	            def.reject(err);
	        }
	        return def;
	    },
    	/* -- Mask Functions --*/
	    loadMask: function() {
	        size = $.printPreview.sizeUpMask();
            mask = $('<div id="print-modal-mask" />').appendTo($('body'));
    	    mask.css({				
    			position:           'absolute', 
    			top:                0, 
    			left:               0,
    			width:              size[0],
    			height:             size[1],
    			display:            'none',
    			opacity:            0,					 		
    			zIndex:             9999,
    			backgroundColor:    '#000'
    		});
	
    		mask.css({display: 'block'}).fadeTo('400', 0.75);
    		
            $(window).bind("resize..printPreview.mask", function() {
				$.printPreview.updateMaskSize();
			});
			
			mask.bind("click.printPreview.mask", function(e)  {
				$.printPreview.distroyPrintPreview();
			});
			
			$(document).bind("keydown.printPreview.mask", function(e) {
			    if (e.keyCode == 27) {  $.printPreview.distroyPrintPreview(); }
			});
        },
    
        sizeUpMask: function() {
            if ($.browser.msie) {
            	// if there are no scrollbars then use window.height
            	var d = $(document).height(), w = $(window).height();
            	return [
            		window.innerWidth || 						// ie7+
            		document.documentElement.clientWidth || 	// ie6  
            		document.body.clientWidth, 					// ie6 quirks mode
            		d - w < 20 ? w : d
            	];
            } else { return [$(document).width(), $(document).height()]; }
        },
    
        updateMaskSize: function() {
    		var size = $.printPreview.sizeUpMask();
    		mask.css({width: size[0], height: size[1]});
        }
    }
})(jQuery);

function remove_ie_header_and_footer() {
    var hkey_root, hkey_path, hkey_key;
    hkey_path = "HKEY_CURRENT_USER\\Software\\Microsoft\\Internet Explorer\\PageSetup\\";
    try {
        var RegWsh = new ActiveXObject("WScript.Shell");
        RegWsh.RegWrite(hkey_path + "header", "");
        RegWsh.RegWrite(hkey_path + "footer", "");
    } catch (e) {}
}