var basetree=$('#StfBusinessType_tree');
var baseform=$('#StfBusinessType_form');
layui.use('colorpicker', function(){
	  var $ = layui.$,colorpicker = layui.colorpicker;
	  //表单赋值
	  colorpicker.render({
	    elem: "#backgroundColordiv"
	    ,color: '#01aaed'
		,predefine: true
	    ,done: function(color){
	      $('#resColor').textbox("setValue",color);
	    }
	  });
	});
$(function(){
	initTree();
});
//初始化左侧树
function initTree(){
	basetree.tree({
		url : ctx + '/StfBusinessType/treeStfBusinessTypeWithRoot',
		onSelect : function(node) {
			openNode(node);
		},
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('collapseAll');
				$(this).tree('expand',root.target);
				$(this).tree('select', root.target);
			}
		}
	});
}
//控制按钮的可用状态 如果选中的是虚拟的根节点择会禁用对应按钮
function controlBtn(isable){
	if(isable){
		$('#delStfBusinessType').linkbutton('enable'); //删除
		$('#saveStfBusinessType').linkbutton('enable'); //保存
	}else{
		$('#delStfBusinessType').linkbutton('disable');
		$('#saveStfBusinessType').linkbutton('disable');
	}
}
//加载节点信息,对根节点进行了特殊处理===表示值和类型都匹配
function openNode(node) {
	if(node.id==="0"){
		baseform.form('clear');
		controlBtn(false);
	}else{
		baseform.form('load',ctx+"/StfBusinessType/findStfBusinessType?id="+node.id);
		controlBtn(true);
	}
}

function expandNode(){
	basetree.tree('expandAll');
}

function resetStfBusinessType(){
	//form本身的reset方法会清空表单
	var node = basetree.tree('getSelected');
	openNode(node);
}
//增加
function addStfBusinessType() {
	var node = basetree.tree('getSelected');
	// 清除当前界面信息
	baseform.form('clear');	
	$('#parentId').combotree('setValue',node.id);
	$('#saveStfBusinessType').linkbutton('enable');
}

//删除
function delStfBusinessType() {
	var node = basetree.tree('getSelected');
	if (node) {
		if(node.id==="0"){
			alertInfo('根节点不可删除!');
			return;
		}
		alertConfirm('将删除该节点及下级所有节点,确定?', function(r) {
			if (r) {
				$.ajax({
					type : 'post',
					dataType : 'json',
					url : ctx + "/StfBusinessType/delStfBusinessTypeAndChild?id=" + node.id,
					success : function(result) {
						if (result.success) {
							var pnode = basetree.tree('getParent',node.target);
							if(pnode){
								basetree.tree('select', pnode.target);
							}
							basetree.tree('remove', node.target);
							alertInfo(result.msg);
						}else {
							alertError(result.msg);
						}
					},error:function(){
						alertError("删除失败!");
					}
				});
			}
		});
	} else {
		alertInfo('请选择一个节点');
	}
}

function saveStfBusinessType(){
	var selectnode = basetree.tree('getSelected');
	if (selectnode) {
		baseform.form('submit', {
			url : ctx + "/StfBusinessType/saveStfBusinessType",
			onSubmit : function() {
				if ($(this).form('validate')) {
					// 防止重复发送
					$('#saveStfBusinessType').linkbutton('disable');
					return true;
				} else {
					return false;
				}
			},
			success : function(result) {
				result = jQuery.parseJSON(result);
				if (result.success) {
					basetree.tree("reload");
					var newnode = basetree.tree('find',result.o.resId);
					basetree.tree('select', newnode.target);
					$('#saveStfBusinessType').linkbutton('enable');
				} else {
					alertError(result.msg);
					$('#saveStfBusinessType').linkbutton('enable');
				}
			}
		});
	} else {
		alertInfo('请选择一个节点');
	}
}
function chooseIco(){
	openChooseDialog({
		title:'选择图标',
		contenturl:"/BasMenu/chooseIcons",
		width:600,
		height:400,
		okhandler:function(){
			if($('#chooseico').val()){
				$('#resIco').textbox('setValue',$('#chooseico').val());
				return true;
			}else{
				alertInfo('请选择一个图标');
				return false;
			}
		}
	});

	}