var basegrid=$('#BasCourt_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#BasCourt_datagrid_tb",
	    url:ctx+'/BasCourt/pageBasCourt',
	    columns:[[
	    {field:'COURT_ID',title:'法院ID',hidden:true,halign:'center'},
	    {field:'COURT_NAME',title:'法院名称',width:160,halign:'center'},
	    {field:'REGION_ID',title:'地区ID',hidden:true,halign:'center'},
	    {field:'REGION_NAME',title:'地区',width:100,halign:'center'},
	    {field:'COURT_ADDR',title:'法院地址',width:200,halign:'center'},
	    {field:'CONTACT_MAN',title:'联系人',width:100,halign:'center'},
	    {field:'CONTACT_NUMBER',title:'联系电话',width:100,halign:'center'},
	    {field:'DISPLAY_NO',title:'显示顺序',width:100,hidden:true,halign:'center'},
	    {field:'STATUS',hidden:true,halign:'center'},
	    {field:'STATUS_TEXT_',title:'状态',width:60,align:'center'},
	    {field:'MODIFY_ACCOUNT',title:'修改人',hidden:true,halign:'center'},
	    {field:'MODIFY_ACCOUNT_NAME',title:'修改人',width:100,halign:'center'},
	    {field:'MODIFY_TIME_F',title:'修改时间',width:130,align:'center'},
	    {field:'IS_USE',hidden:true},
	    {field:'IS_USE_TEXT_',title:'是否使用',hidden:true}
	    ]],
	    onDblClickRow : editBasCourt
	});
	basegrid.datagrid('doCellTip');
	var pager = basegrid.datagrid('getPager');    // 得到datagrid的pager对象  
	pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasCourt_datagrid',"法院信息");   
	        }    
	    }]   
	}); 
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchBasCourt(){
	basegrid.datagrid('load',{
		search:$("#searchBasCourt").val()
	});
}

//增加记录
function addBasCourt() {
	openSaveDialog({
		title:"添加记录",
		contenturl:"/view/sys/BasCourtform",
		submiturl:"/BasCourt/saveBasCourt",
		callback:reloadGrid
	});
	
}

//修改记录
function editBasCourt() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.COURT_ID;
		openSaveDialog({
			title : "修改记录",
			contenturl : "/view/sys/BasCourtform",
			submiturl : "/BasCourt/saveBasCourt",
			onload : "/BasCourt/findBasCourt?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delBasCourt() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.COURT_ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/BasCourt/delBasCourt",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据');
	}
}

/**********************************************************弹出窗口操作****************************************************/
//行政区域弹出框
function showRegionWinFun(){
	openChooseDialog({
		title : "选择行政区域",
		contenturl:'/view/sys/regionSelectWin',
		width : 600,
		height : 400,
		okhandler : function(){
			var r = $('#regionSelect_datagrid').datagrid('getSelected');
			if(r){
				$('#regionId').val(r.REGION_ID);
				$('#regionName').textbox('setValue',r.REGION_NAME);
				return true;
			}else{
				alertInfo("请选择人员");
				return false;
			}
		},
		onload:function(){
			loadRegionSelectGrid();
		}
	})
	
}

//行政区域加载表格
function loadRegionSelectGrid() {
	$('#regionSelect_datagrid').datagrid({
		fit : true,
		border : false,
		singleSelect : true,
		rownumbers : true,
		fitColumns : true,
		pagination : true,
		toolbar : "#engionSelectTb",
		url : ctx + '/BasRegion/pageBasRegion',
		columns : [ [ {
			field : 'REGION_ID',
			title : '地区ID',
			hidden : true
		}, {
			field : 'REGION_CODE',
			title : '地区代码'
		}, {
			field : 'REGION_NAME',
			title : '地区名称'
		}, {
			field : 'REMARK',
			title : '描述'
		}, {
			field : 'DISPLAY_NO',
			title : '显示顺序',
			hidden : true
		}, {
			field : 'FINANCE_ID',
			title : '财务ID',
			hidden : true
		}, {
			field : 'EAS_ID',
			title : 'EASID'
		}, {
			field : 'MODIFY_ACCOUNT',
			title : '修改人',
			hidden : true
		}, {
			field : 'MODIFY_ACCOUNT_NAME',
			title : '修改人'
		}, {
			field : 'MODIFY_TIME',
			title : '修改时间'
		}, {
			field : 'IS_USE',
			hidden : true
		}, {
			field : 'IS_USE_TEXT_',
			title : '是否使用',
			hidden : true
		} ] ]
	});

	$('#engionSelectTb').show();
	$('#searchRegionSelect').searchbox({
		searcher : function(value, name) {
			$('#regionSelect_datagrid').datagrid('load', {
				search : value
			});
		},
		width : 200
	});
}