var basegrid=$('#ReportBaseDs_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#ReportBaseDs_datagrid_tb",
	    url:ctx+'/ReportBaseDs/pageReportBaseDs',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+row.ID+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'SQL_SCRIPT',title:'sql脚本',width:100,align:'center',halign:'center'},
	    {field:'IS_USE',title:'是否启用',width:100,align:'center',halign:'center'},
	    {field:'CREATE_BY',title:'创建人',width:100,align:'center',halign:'center'},
	    {field:'CREATE_TIME',title:'创建时间',width:100,align:'center',halign:'center'},
	    {field:'MODIFY_ACCOUNT',title:'修改人',width:100,align:'center',halign:'center'},
	    {field:'MODIFY_TIME',title:'修改时间',width:100,align:'center',halign:'center'},
	    {field:'ID',title:'id',width:100,align:'center',halign:'center'},
	    {field:'REPORT_ID',title:'reportId',width:100,align:'center',halign:'center'},
	    {field:'DS_NAME',title:'名称',width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.ID);
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('ReportBaseDs_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=ReportBaseDs_Form&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchReportBaseDs(){
	basegrid.datagrid('load',{
		search:$("#searchReportBaseDs").val()
	});
}

//增加记录
function addReportBaseDs() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=ReportBaseDs_Form",
		submiturl:"/ReportBaseDs/saveReportBaseDs?formcode=ReportBaseDs_Form",
//		contenturl:"/view/report/ReportBaseDs_Form",
//		submiturl:"/ReportBaseDs/saveReportBaseDs",
		callback:reloadGrid
	});
	
}

//修改记录
function editReportBaseDs() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.ID;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=ReportBaseDs_Form&id=" + id,
			submiturl:"/ReportBaseDs/saveReportBaseDs?formcode=ReportBaseDs_Form",
//			contenturl : "/view/report/ReportBaseDs_Form",
//			submiturl : "/ReportBaseDs/saveReportBaseDs",
//			onload : "/ReportBaseDs/findReportBaseDs?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delReportBaseDs() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.ID;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/ReportBaseDs/delReportBaseDs",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
