$(function(){
	initSelectGrid();
});

function initSelectGrid(){
	$('#PubOrgConAccountSel_datagrid').datagrid({
		fit:true,
		border:false,
		singleSelect:false,
		rownumbers:true,
		pagination:true,
		fitColumns:false,
		checkbox:true,
		toolbar:"#PubOrgConAccountSel_datagrid_tb",
	    url:ctx+'/PubOrgConAccountRelation/pageConSelect',
		queryParams:{
			filterInfoId:filterInfoId,
			id:contactOrgId
		},
		 columns:[[
			    {
					field:'opt',title:'明细',width:40,align:'center',
					formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
						return '<div onclick="openDetail('+row.conId+',\''+row.formcode+'\')" class="icon-detail iconfont blue">&nbsp;</div>';
				}},
	    {field:'conId',title:'合同ID',hidden:true},
	    {field:'pmconTypeName',title:'合同类别',width:100,align:'left',halign:'center'},
	    {field:'conName',title:'合同名称',width:300,align:'left',halign:'center'},
	    {field:'conCode',title:'合同编码',width:150,align:'left',halign:'center'}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
	    	openDetail(row.conId,row.formcode);
	    }
	});
    $('#PubOrgConAccountSel_datagrid').datagrid('doCellTip');
    var pager = $('#PubOrgConAccountSel_datagrid').datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('PubOrgConAccountSel_datagrid',"title");   
	        }    
	    }]   
	});
}

//查看表单明细
function openDetail(id,formcode){
    openFormDetailCon(id,formcode);
}
//重新加载表格
function reloadSelectGrid(){
	$('#PubOrgConAccountSel_datagrid').datagrid('reload');
}
//查询表格
function searchPubOrgConAccountSel(){
	$('#PubOrgConAccountSel_datagrid').datagrid('load',{
		filterInfoId:filterInfoId,
		id:contactOrgId,
		search:$("#searchPubOrgConAccountSel").val()
	});
}

