var PubContactAltDataGrid=$('#PubContactAlt_datagrid');
$(function(){
     //流程状态下拉框
	$('#flow_combo').combobox({
		editable : false,
		onChange:function(newV,oldV){
			if(oldV){
				searchPubContactAlt();
			}
		}
	});
	initPubContactAltGrid();
});

function initPubContactAltGrid(){
	PubContactAltDataGrid.datagrid({
		// fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		cls:'md',
		height:$("body").height()-140,
		queryParams:{
			flowDone:haseasyui('#flow_combo')?$('#flow_combo').combobox('getValue'):"",
			type:type
		},
		toolbar:"#PubContactAlt_datagrid_tb",
	    url:ctx+'/PubContactAlt/pagePubContactAlt',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="PubContactAltFormDetail('+row.contactAltId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
		{field:'versionNo',title:'版本号',width:80,halign:'center',align:'center',sortable:true,formatter:function(value){
	    	return "第"+value+"版";
	    }},
	    {field:'contactOrgName',title:'原名称',width:100,align:'center',halign:'center',sortable:true},
	    {field:'contactAltName',title:'变更后名称',width:100,align:'center',halign:'center',sortable:true},
	    {field:'empIdText',title:'经办人',width:100,align:'center',halign:'center',sortable:true},
	    {field:'altDate',title:'变更时间',width:100,align:'center',halign:'center',sortable:true},
	    {field:'remark',title:'备注',width:100,align:'center',halign:'center',sortable:true},
	    {field:'workflowStatusText',title:'审批状态',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			PubContactAltFormDetail(row.contactAltId);
	    }
	});
    PubContactAltDataGrid.datagrid('doCellTip');
    var pager = PubContactAltDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('PubContactAlt_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function PubContactAltFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=PubContactAlt&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadPubContactAlt(){
	PubContactAltDataGrid.datagrid('reload');
}
//查询表格
function searchPubContactAlt(){
	PubContactAltDataGrid.datagrid('load',{
	    flowDone:haseasyui('#flow_combo')?$('#flow_combo').combobox('getValue'):"",
	    type:type,
		search:$("#searchPubContactAlt").val()
	});
}

//增加记录
function addPubContactAlt() {
	var str='';
	str = "initContactOrgName();"
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		submitType : 'single',
		contenturl:"/GenForm/form?formcode=PubContactAlt&type="+type,
		submiturl:"/PubContactAlt/savePubContactAlt?formcode=PubContactAlt",
		loadScript:str,
		callback:reloadPubContactAlt
	});

}

//修改记录
function editPubContactAlt() {
	var row = PubContactAltDataGrid.datagrid('getSelected');
	if (row) {
	    if(row.workflowStatus.toString().indexOf('1')==-1){
			alertInfo('数据已经上报过,不能修改');
			return;
		}
		var id = row.contactAltId;
		var type = row.orgType;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=PubContactAlt&id=" + id,
			submiturl:"/PubContactAlt/savePubContactAlt?formcode=PubContactAlt",
			onload:function(){
				if (type == 1) {
					$('#contactOrgName').textbox({
						buttonText : '选择',
						onClickButton : showContactOrgFun1Win('','',1),
						editable : false
					});
				} else {
					$('#contactOrgName').textbox({
						buttonText : '选择',
						onClickButton : showContactOrgFun1Win('','',2),
						editable : false
					});
				}
				$('#orgType').val(type);
			},
			callback : reloadPubContactAlt
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delPubContactAlt() {
	var row = PubContactAltDataGrid.datagrid('getSelected');
	if (row) {
    if(row.workflowStatus.toString().indexOf('1')==-1){
		alertInfo('数据已经上报过,不能删除');
		return;
	}
		
	var id =row.contactAltId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/PubContactAlt/delPubContactAlt",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							PubContactAltDataGrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
function doFlow(){
	var row = PubContactAltDataGrid.datagrid('getSelected');
	if (row) {
		if(row.workflowStatus=='3'){
			alertInfo('数据已通过');
			return;
		}
		
		openFlowDialog({
    		processInstId:row.processinstid,
			businessMainId:row.contactAltId,
			formCode:"PubContactAlt",
			callback:reloadPubContactAlt
        });
	} else {
		alertInfo('请先选择一条数据信息');
	}
}

function viewFlow(){
	var row = PubContactAltDataGrid.datagrid('getSelected');
	if (row) {
		viewFlowDialog(row.processinstid)
	} else {
		alertInfo('请先选择一条数据信息');
	}
}