var groupItemGrid=$('#groupItem_datagrid');
$(function(){
	initGourpItemGrid();
});

function initGourpItemGrid(){
	groupItemGrid.datagrid({
//		fit:true,
		title:"面板内容",
		idField:"itemId",
		border:false,
		height:365,
		singleSelect:false,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#groupItem_datagrid_tb",
	    url:ctx+'/GenPanelGroup/pageGourpItem',
	    queryParams:{
	    	groupId: groupId,
	    	panelId: panelId
        },
	    columns:[[
    	{field:'opt',title:'',checkbox:true},
		{field:'itemId',title:'分组ID',hidden:true},
	    {field:'groupId',title:'分组ID',hidden:true},
	    {field:'itemHtmlid',title:'标签ID',width:100,align:'center',halign:'center',sortable:true},
		{field:'itemHtmlname',title:'标签NAME',width:100,align:'center',halign:'center',sortable:true},
	    {field:'itemLabel',title:'标签文字',width:100,align:'center',halign:'center',sortable:true},
	    {field:'displayNo',title:'排序',width:50,align:'center',halign:'center',sortable:true}
	    ]]
	});
    groupItemGrid.datagrid('doCellTip');
    var pager = groupItemGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('groupItem_datagrid',"title");   
	        }    
	    }]   
	});
}

//增加记录
function addGourpItem() {
	 openChooseDialog({
	        title: "选择面板内容",
	        contenturl: '/view/gen/GroupItemChoose',
	        width: 800,
	        height: 450,
	        okhandler: function () {
	            var rows = $('#itemChoose_datagrid').datagrid('getSelections');
	            if (rows) {
	            	for(var i=0;i<rows.length;i++){
	            		groupItemGrid.datagrid('appendRow',{
	            			itemId: rows[i].itemId,
	            			groupId: groupId,
	            			itemHtmlid:rows[i].itemHtmlid,
	            			itemHtmlname:rows[i].itemHtmlname,
	            			itemLabel: rows[i].itemLabel,
	            			displayNo: rows[i].displayNo
	            		});
					}
	                return true;
	            } else {
	                alertInfo("请选择数据");
	                return false;
	            }
	        },
	        onload: function () {}
	    })
}

//删除记录
function delGourpItem() {
	 var rows = groupItemGrid.datagrid('getSelections');
	 console.info(rows);
     if (rows&&rows.length>0) {
    	 alertConfirmYes('您是否要移除当前选中的关联？', function(r) {
 			if (r) {
 				var itemIds = [];
 		     	for(var i=0;i<rows.length;i++){
 		     		itemIds.push(rows[i].itemId);
 				}
 				$.ajax({
 					url : ctx+"/GenPanelGroup/removeItemId",
 					data : {
 						itemIds : itemIds.join(",")
 					},
 					dataType : 'json',
 					success : function(result) {
 						if (result.success) {
 							reloadGourpItem();
 							alertInfo(result.msg);
 						}else{
 							alertError(result.msg);
 						}
 					}
 				});
 			}
 		});
     } else{
    	 alertError("请选择要删除数据");
     }
}

function searchGourpItem(){
	groupItemGrid.datagrid('load',{
		groupId: groupId,
    	panelId: panelId
	});
}

function reloadGourpItem(){
	groupItemGrid.datagrid('reload');
}
