window.console = window.console || (function () {
    var c = {};
    c.log = c.warn = c.debug = c.info = c.error = c.time = c.dir = c.profile
        = c.clear = c.exception = c.trace = c.assert = function () {
    };
    return c;
})();
Date.prototype.Format = function (fmt) { // author: meizz
    var o = {
        "M+": this.getMonth() + 1, // 月份
        "d+": this.getDate(), // 日
        "h+": this.getHours(), // 小时
        "m+": this.getMinutes(), // 分
        "s+": this.getSeconds(), // 秒
        "q+": Math.floor((this.getMonth() + 3) / 3), // 季度
        "S": this.getMilliseconds() // 毫秒
    };
    if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    for (var k in o)
        if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
    return fmt;
};
//去掉该选择器下所有的必填验证
function removerequired(selector){
	$(selector).find(".textbox-f").each(function(index,item){
	    var type = $(item).attr('class').split(" ")[0].replace('easyui-','');
		$(item)[type]({required:false})
	})	
}
// grid金钱格式化函数
function formatterMoney(value) {
    if (value === null || value === "") {
        return value;
    }
    return $.FormatMoney(value, 2);
}
//grid金钱格式化函数
function formatterMoneyMillion(value) {
    if (value === null || value === "") {
        return value;
    }
    return $.FormatMoney(value, 1);
}
//grid数量格式化
function formatterNum(value) {
    if (value === null || value === "") {
        return value;
    }
    return $.FormatMoney(value, 0);
}
//grid金钱格式转化函数+元格式化成万元
function formatterMoneyThousands(value) {
    if (value === null || value === "") {
        return value;
    }
    return $.FormatMoney(parseFloat(value/10000), 2);
}
// 金额千分位格式化
function formatCurrency(num) {
	if (!num) {
        return num;
    }
    num = num.toString().replace(/\$|\,/g, '');
    if (isNaN(num))
        num = "0";
    sign = (num == (num = Math.abs(num)));
    num = Math.floor(num * 100 + 0.50000000001);
    cents = num % 100;
    num = Math.floor(num / 100).toString();
    if (cents < 10)
        cents = "0" + cents;
    for (var i = 0; i < Math.floor((num.length - (1 + i)) / 3); i++)
        num = num.substring(0, num.length - (4 * i + 3)) + ',' +
            num.substring(num.length - (4 * i + 3));
    return (((sign) ? '' : '-') + num + '.' + cents);
}
/**
 * 取得地址栏参数
 */
function getUrlParam(name) {
    var reg = new RegExp("(^|&)" + name + "=([^&]*)(&|$)"); // 构造一个含有目标参数的正则表达式对象
    var r = decodeURIComponent(window.location.search).substr(1).match(reg);  // 匹配目标参数
    // 返回参数值
    if (r != null) {
        return unescape(r[2]);
    }
    return null;
}
/**
 * 取得地址栏参数
 */
function getStrUrlParam(url,name) {
    var reg = new RegExp("(^|&|\\?)" + name + "=([^&]*)(&|$)"); // 构造一个含有目标参数的正则表达式对象
    var r = url.match(reg);  // 匹配目标参数
    // 返回参数值
    if (r != null) {
        return unescape(r[2]);
    }
    return null;
}
/**
* 取得地址栏参数字符串
* @return {}
*/
function getStrParam(url) {
	var reg = new RegExp(/\?(\S*)/);
   var r = url.match(reg);  // 匹配目标参数
   // 返回参数值
   if (r != null) {
       return unescape(r[1]);
   }
   return null;
}
/**
 * 动态添加url连接符
 * @param url
 * @returns
 */
function getUrlConnector(url){
	var connector = '?';
	if(url&&url.indexOf("?")>-1){
		connector = "&";
	}
	return connector;
}
/**
 * 封装message alert方法
 */
var vuemessage = new Vue();
var alertInfo = function (msg) {
    	vuemessage.$message({
            message: (typeof(msg) == "object"?msg.title:msg )+"!",
            type: 'success',
            showClose: true,
            customClass: 'message-override'
          });
};
var alertWarn = function (msg) {
    vuemessage.$message({
        message: (typeof(msg) == "object"?msg.title:msg )+"!",
        type: 'warning',
        showClose: true,
        customClass: 'message-override'
      });
};
var alertError = function (msg) {
    vuemessage.$message({
        message: (typeof(msg) == "object"?msg.title :msg )+"!",
        type: 'error',
        showClose: true,
        customClass: 'message-override'
      });
};
var alertConfirm = function (msg, func) {
	vuemessage.$confirm(msg, '提示', {
        confirmButtonText: '确定',
        cancelButtonText: '取消',
        type: 'warning'
      }).then(function(){
    	  if (typeof(func) == "function") func(true);
      }).catch(function(){
    	  if (typeof(func) == "function") func(false);     
      });
}
var alertConfirmYes = function (msg, func, title) {
	alertConfirm(msg, func);
}
/**
 * 判断指定ID的控件是否是easyui 组件
 * @return {Boolean}
 */
function haseasyui(element) {
    if ($(element).length > 0 && ($(element).attr("data-options") || $(element).hasClass("panel-body"))) {
        return true;
    } else {
        return false;
    }
}
/**
 * 流程发起样式新增方法
 * @param formCode
 * @param title
 * @param edocType
 * @param tempId
 * @returns
 */
function addFormFlow(formCode,title,edocType,tempId,urlParams,options){
	var url = '/GenForm/addFormFlow?isLayer=Y&formCode='+formCode;
	if(urlParams&&urlParams!="undefined"){
		url+='&'+urlParams;
	}
	if(formCode=="edocApply"){
		url="/EdocApply/toOfficePage?isLayer=Y&edocType="+edocType+"&tempId="+tempId;
		if(edocType==2){
			url+="&type=FWNG"
		}else if(edocType==1){
			url+="&type=SWDJ"
		}
	}
	if(options.url){
		url=options.url;
	}
	if (parent && parent.openInMainTab) {
		if(options){
			var fncOnSubmit = options.onsubmit;
			var callback = options.callback;
			var fncOnClose = options.onclose;
			var error = options.error;
			if(options.loadScript&&options.loadScript!="undefined"){
				url+="&loadScript="+escape(options.loadScript);
			}
		}
		var l_index = parent.layer.open({
			type: 2,
			title: title,
			closeBtn: 1, //不显示关闭按钮
			maxmin: true,
	        zIndex:$.fn.window?Math.ceil($.fn.window.defaults.zIndex++):1001,
			skin: 'layui-layer-qllan',
            area: [$(top.window).width() + 'px', $(top.window).height() + 'px'],
			content: [ctx+url, 'no'], //iframe的url，no代表不显示滚动条 
			success: function (layero, index) {
			},
//			yes:function(index, layero){
//				layer.close(index); //如果设定了yes回调，需进行手工关闭
//			},
			end: function () {
				(callback && typeof(callback) === "function") && callback();
			},
			cancel:function(index, layero){ 
//				(fncOnClose && typeof(fncOnClose) === "function") && fncOnClose();
			}
		});
		//parent.layer.full(l_index);
	} else {
		window.open(ctx + url, '_blank');
	}
}
/**
 * 封装打开窗口的方法 options.title 标题 options.contenturl 内容的地址 options.submiturl 表单提交的地址
 * options.width 宽度 options.height 高度 options.callback 提交成功后的回调 options.onload
 * 内容加载成功后需要做的操作 nstring类型为地址 会根据地址请求的数据加载表单 function 为加载成功后需要执行的函数
 * options.onsubmit 提交前要进行的操作
 */
function openSaveDialog(_options) {
    var options = {
            title: '窗口',
            contenturl: '',
            submiturl: '',
            width: 500,
            height: 300,
            maximized: false,
            iconCls: 'icon-select iconfont blue',
            saveIconCls: 'icon-save iconfont blue',
            submitType:'default',//default:默认方式,可保存可提交.single:提交时弹出审批框，走默认线。submit：只有提交按钮，没有保存按钮.
            iframe:true,//form提交方式 是否以iframe方式提交  默认不通过  附件上传时需要设置成true
            flowform:true,
            autoClose:true
    }
    $.extend(options, _options);
    var fncOnSubmit = options.onsubmit;
    var callback = options.callback;
    var fncOnLoad = options.onload;
    var fncOnClose = options.onclose;
    var error = options.error;
    	
    var id = getStrUrlParam(options.contenturl,'id');
	var formcode = getStrUrlParam(options.contenturl,'formcode');
    //20201028 新增页面时,调用流程发起样式表单
	if(options.flowform&&formcode&&checkFormFlow(formcode)){
		var urlParams = getStrParam(options.contenturl);
//		var loadScript = escape(options.loadScript);//新样式3,传的onload的js,需要转换成字符串方式传入,并且字符串需要转译,否则会无法当字符串传递
		addFormFlow(formcode,options.title,null,null,urlParams,options)
		return;
	}
		//原有弹出框功能
        if (options.maximized) {
            options.sureText = options.sureText ? options.sureText : '保存';
            options.closeText = options.closeText ? options.closeText : '返回';
            options.draggable = false;
        } else {
            options.sureText = options.sureText ? options.sureText : '确定';
            options.closeText = options.closeText ? options.closeText : '取消';
            options.draggable = true;
        }
        var uuid = generateUUID();
        // 循环添加自定义按钮
        var resToolBar = [];
        function submitForm(doflow){
            var okbutton = $("#" + uuid+'save');
            var d = $("#open_dialog" + uuid).find('.window-body');
            var submitform = $("form.easyui-form", "#open_dialog" + uuid);
            if(submitform.length==0){
            	submitform = $("form", "#open_dialog" + uuid)
            }
            if (options.submitbtn) {
                submitform = $("#" + options.submitbtn);
            }
            submitform.form('enableValidation');
            submitform.form('submit', {
                dataType: 'json',
                method: "POST",
                iframe:options.iframe,
                ajax:true,
                url: ctx + options.submiturl,
                onSubmit: function (param) {
                	var validate=true;
                	if($('.required').length>0){
                		$('.required').each(function(index,item){
                			if(typeof $("input[name="+$(this).attr('itemname')+"]:checked").val()=='undefined'){
                				validate=false;
                    			alertInfo('请选择'+$(this).attr('itemlabel'));
                				return;
                			}
                		});
                		if(!validate){
                			return false;
                		}
                	}
                	//判断附件必填
                	if($('.filerequired').length>0 ){
                		$('.filerequired').each(function(index,item){
                			if($(this).parent().find("tr[filetypeid="+$(this).attr('filetypeid')+"]").find(".panelfile_isuse[value='Y']").length<1){
                				validate=false;
                    			alertInfo('请上传'+$(this).attr('fileTypeName'));
                				return;
                			}
                		});
                		if(!validate){
                			return false;
                		}
                	}
                    if ($(this).form('validate')) {
                        if (fncOnSubmit && typeof(fncOnSubmit) === "function") {
                            if (fncOnSubmit(param)) {
                                if ($(this).form('validate')) {
                                    layer.msg('发送中', {icon: 16, shade: 0.3, time: 0});
                                } else {
                                    return false;
                                }
                                okbutton.linkbutton('disable');// 防止重复发送
                                return true;
                            } else {
                                return false;
                            }
                        } else {
                            layer.msg('发送中', {icon: 16, shade: 0.3, time: 0});
                            okbutton.linkbutton('disable');// 防止重复发送
                            return true;
                        }
                    } else {
                    	alertInfo('请完善表单信息');
                    	$(".validatebox-invalid").parents(".easyui-tabs").tabs("select",$(".validatebox-invalid").parents(".tabs-panels").children().index($(".validatebox-invalid").parents(".tabs-panels>.panel")))
                    	$(".validatebox-invalid").eq(0).focus();
                        return false;
                    }
                },
                success: function (result) {
                    result = jQuery.parseJSON(result);
                    if (result.success) {
                        layer.closeAll();
                        if(typeof doflow=='function'){
                        	doflow(result.o);
                        }else{
                        	options.autoClose&&$("#open_dialog" + uuid).dialog('destroy');
                        	(callback && typeof(callback) === "function") && callback(result);
                        	alertInfo(result.msg);
                        }
                        if(!options.autoClose){
                        	okbutton.linkbutton('enable');// 防止重复发送
                        	//$("#open_dialog" + uuid).dialog('refresh',ctx + options.contenturl+"&id="+result.o.projectSetupId)
                        }
                    } else {
                        layer.closeAll();
                        alertError(result.msg);
                        (error && typeof(error) === "function") && error(result);
                        okbutton.linkbutton('enable');// 信息错误 则启用按钮
                    }
                }
            });
        }
        // 如果有请求路径,则提供保存按钮
        if (options.submiturl) {
        	//配置保存按钮
        	if(options.submitType!='submit'){
        		resToolBar.push({
        			text: options.sureText,
        			id : uuid+'save',
        			iconCls: options.saveIconCls,
        			handler: submitForm
        		});
        		if (options.maximized) {
        			resToolBar.push('-');
        		}
        	}
        }
        if(formcode&&!options.hideSubBtn&&checkFormFlow(formcode)){
        	resToolBar.push({
                text: options.submitText?options.submitText:"发送",
                iconCls: 'icon-location iconfont blue2',
                handler: function () {
                	var submitform = $("form", "#open_dialog" + uuid);
                	if(submitform.form('validate')){
                		var savebtn = $("#" + uuid+'save');
                		if(id==null&&options.submitType=='default'){
                			alertConfirmYes("确认发送流程？", function (yes) {
                				if (yes) {
                					submitform.append("<input type='hidden' name='app' value='1' >");
                					savebtn.click();
                				}
                			});
                		}else{
                			submitForm(function(result){
                				result.formCode=formcode;
                				var processInstId;
                				if(!id||!$("#"+formcode+" #processinstid").val()){
                					$.ajax({
                						url : ctx+"/gen/getFormKey",
                						type:'POST',
                						data:result,
                						async:false,
                						dataType:'JSON',
                						success:function(data){
                        					id=data.o.id;
                        					processInstId = data.o.processinstid;
                						}
                					})
                				}
                				if(!processInstId&&!result.processinstid&&!$("#"+formcode+" #processinstid").val()){
                					options.autoClose&&$("#open_dialog" + uuid).dialog('destroy');
                            		(callback && typeof(callback) === "function") && callback(result);
                				}else{
                					layer.closeAll();
                					var reportAdvice = "" ;
                					if($(".flowopinion").length>0){
                				        var advices=[];
                				        $(".flowopinion").each(function(){
                				        	advices.push($(this).textbox("getValue"));
                				        });
                				        reportAdvice = advices.join(" ");
                					}
                    				openFlowDialog({
                						processInstId :processInstId?processInstId:$("#"+formcode+" #processinstid").val(),
                						businessMainId : id,
                						formCode : formcode,
                						advice : reportAdvice,
                						callback : function(){
            	                            layer.closeAll();
            	                            options.autoClose&&$("#open_dialog" + uuid).dialog('destroy');
            	                            if(!options.autoClose){
            	                            	$("#" + uuid+'save').linkbutton('enable');// 防止重复发送
            	                            }
            	                            (callback && typeof(callback) === "function") && callback(result);
//            	                            alertInfo(result.msg);
                						}
                					})
                				}
                			})
                		}
                	}else{
                		alertInfo("请完善表单信息");
                	}
                }
            });
        	if (options.maximized) {
                resToolBar.push('-');
            }
        }
        // 拼装自定义按钮
        if (options.bottons) {
            for (var i = 0; i < options.bottons.length; i++) {
                resToolBar.push(options.bottons[i]);
                if (options.maximized) {
                    resToolBar.push('-');
                }
            }
        }
        // 拼装返回按钮
        resToolBar.push({
            text: options.closeText,
            iconCls: 'icon-back iconfont red2',
            handler: function () {
            	//点击返回按钮时,增加提示是否保存-2019-12-25
            	var submitform = $("form", "#open_dialog" + uuid);
            	var affirmClose = true;
            	
            	var d = $(this).closest('.window').find('.window-body');
            	if(!affirmClose){
            		alertConfirmYes('数据还未保存,请确认是否关闭？', function(r) {
            			if (r) {
                    		if (fncOnClose && typeof(fncOnClose) === "function") {
                    			fncOnClose()
                    		}
                    		d.dialog('destroy');
            			}
            		});
            	}else{
            		if (fncOnClose && typeof(fncOnClose) === "function") {
            			fncOnClose()
            		}
            		
            		d.dialog('destroy');
            	}
            }
        });
        $('<div/>').dialog({
            id: "open_dialog" + uuid,
            href: ctx + options.contenturl,
            style: {overflowX: 'hidden'},
            width: options.width,
            height: options.height,
            iconCls:options.iconCls,
            modal: true,
            title: options.title,
            maximized: options.maximized,
            draggable: options.draggable,
            toolbar: options.maximized ? resToolBar : '',
            buttons: options.maximized ? '' : resToolBar,
            inline: false,
            onClose: function () {
                if (fncOnClose && typeof(fncOnClose) === "function") {
                    fncOnClose()
                }
                //重置表单
                $("form", "#open_dialog" + uuid).form('reset');
                $(this).dialog('destroy');
            },
            onLoad: function () {
                if (fncOnLoad && typeof(fncOnLoad) === "string") {
                    $.ajax({
                        type: 'post',
                        dataType: 'json',
                        url: ctx + fncOnLoad,
                        success: function (data) {
                            var submitform = $("form", "#open_dialog" + uuid);
                            if (options.submitbtn) {
                                submitform = $("#" + options.submitbtn);
                            }
                            submitform.form('load', data);
                        }
                    });
                } else if (fncOnLoad && typeof(fncOnLoad) === "function") {
                    fncOnLoad()
                }
            }
        });
}

function openDetailDialog(_options) {
    var options = {
        title: '窗口',
        contenturl: '',
        submiturl: '',
        width: $("body").width()*0.8,
        height: $("body").height()*0.8,
        iconCls: 'icon-save iconfont blue',
        isdetail:true,
        flowform:true,
        maximized: false
    }

    $.extend(options, _options);
    var fncOnLoad = options.onload;
    var fncOnClose = options.onclose;
    //流程审批样式
    var id = getStrUrlParam(options.contenturl,'id');
	var formcode = getStrUrlParam(options.contenturl,'formcode');
    //20201028 新增页面时,调用流程发起样式表单
	if(options.flowform&&formcode&&checkFormFlow(formcode)){
		var urlParams = getStrParam(options.contenturl);
		var loadScript = escape(options.loadScript);//新样式3,传的onload的js,需要转换成字符串方式传入,并且字符串需要转译,否则会无法当字符串传递
		
		addFormFlow(formcode,options.title,null,null,urlParams,options)
		return;
	}
    var uuid = generateUUID();
    // 循环添加自定义按钮
    var resToolBar = [];
    // 拼装自定义按钮
    if (options.bottons) {
        for (var i = 0; i < options.bottons.length; i++) {
            resToolBar.push(options.bottons[i]);
            if (options.maximized) {
                resToolBar.push('-');
            }
        }
    }
    //拼接审批记录按钮,如果有流程实例ID才显示
    if(options.isdetail&&options.maximized&&!options.hideViewBtn){
    	resToolBar.push({
    		text:'审批记录',
    		iconCls:'icon-view-flow iconfont blue2',
    		plain:true,
    		handler:function(){
    			if($("#open_dialog" + uuid+" #processinstid")&&$("#open_dialog" + uuid+" #processinstid").val()){
    				viewFlowDialog($("#open_dialog" + uuid+" #processinstid").val());
    			}else{
    				alertInfo("该条数据没有流程审批记录");
    			}
    		}
    	});
    }
    // 拼装返回按钮
    resToolBar.push({
        text: '关闭',
        iconCls: 'icon-back iconfont red2',
        plain : true,
        handler: function () {
        	if (fncOnClose && typeof(fncOnClose) === "function") {
                fncOnClose()
            }

            var d = $(this).closest('.window').find('.window-body');
            d.dialog('destroy');
        }
    });
    var dialogoptions = {
            id: "open_dialog" + uuid,
            style: {overflowX: 'hidden'},
            width: options.width,
            height: options.height,
            modal: true,
            iconCls:options.iconCls,
            title: options.title,
            maximized: options.maximized,
            inline: false,
            toolbar: options.maximized ? resToolBar : '',
            buttons: options.maximized ? '' : resToolBar,
            onClose: function () {
            	if (fncOnClose && typeof(fncOnClose) === "function") {
                    fncOnClose()
                }
                $(this).dialog('destroy');
            },
            onLoad: function () {
                if (fncOnLoad && typeof(fncOnLoad) === "string") {
                    $.ajax({
                        type: 'post',
                        dataType: 'json',
                        url: ctx + fncOnLoad,
                        success: function (data) {
                            var submitform = $("form",
                                "#open_dialog");
                            if (options.submitbtn) {
                                submitform = $("#" + options.submitbtn);
                            }
                            submitform.form('load', data);
                        }
                    });
                } else if (fncOnLoad && typeof(fncOnLoad) === "function") {
                    fncOnLoad()
                }
            }
        };
    if(options.isframe){
    	dialogoptions.content="<iframe frameborder='0'  style='display:block;border:0;width:100%;height:100%;' src='"+ctx + options.contenturl+"'></iframe>";
    }else{
    	dialogoptions.href=ctx + options.contenturl;
    }
    $('<div/>').dialog(dialogoptions);
}

function openChooseDialog(_options) {
    var options = {
        title: '窗口',
        contenturl: '',
        submiturl: '',
        iconCls: 'icon-view-flow green iconfont',
        width: 500,
        height: 300,
        maximized: false,
        isframe:false,
        zIndex:$.fn.window?Math.ceil($.fn.window.defaults.zIndex++):1001
    }
    $.extend(options, _options);
    var okhandler = options.okhandler;
    var onload = options.onload;
    var callback = options.callback;
    var onclose = options.onclose;
    var layoptions={
			  type: 1,
			  title: "<div style='display: inline-block;text-align: center; vertical-align: middle;'><i class='"+options.iconCls+" ' style='font-size:16px;'>&nbsp;&nbsp;</i></div><span >"+options.title+"</span>",
			  maxmin: true,
			  closeBtn: 1, //不显示关闭按钮
			  btn: [options.sureText ? options.sureText : '确定'],
			  //skin: 'layui-layer-qllan',
			  area: [options.width+'px',options.height+"px"],
			  zIndex:options.zIndex,
			  yes:function(index, layero){
				  	if (okhandler && typeof(okhandler) === "function") {
		                if (okhandler()) {
				          	layer.close(index);
		                    (callback && typeof(callback) === "function") && callback();
				            return true;
		                }
		            } else {
			          	layer.close(index);
			            return true;
		            }
			  },
			  success: function (layero, index) {
				  if($.fn.window.defaults.zIndex+2<layero.css("zIndex")){
					  layero.css("zIndex",$.fn.window.defaults.zIndex+1)
					  layero.prev().css("zIndex",$.fn.window.defaults.zIndex)
					  
				  }
				  $.parser.parse(layero.find(".layui-layer-content"))
				  $(layero).find(".datagrid-f").datagrid("resize")
				  if(onload && typeof(onload) === "function"){
					  onload();
				  }
			  },
		      end: function () {   
		    	  if (onclose && typeof(onclose) === "function") {
		    		  onclose()
		    	  }
		      },full : function(){
				  $(".datagrid-f").datagrid("resize")
		      },min : function(){
				  $(".datagrid-f").datagrid("resize")
		      },restore  : function(){
				  $(".datagrid-f").datagrid("resize")
		      }
	  
    }
    // 循环添加自定义按钮
    var resToolBar = [];
    // 拼装自定义按钮
    if (options.bottons) {
        for (var i = 0; i < options.bottons.length; i++) {
        	layoptions.btn.push(options.bottons[i].text);
            layoptions['btn'+(i+2)]=options.bottons[i].handler
        }
    }
	layoptions.btn.push("关闭");
	if(options.isframe){
		layoptions.type = 2;
		layoptions.content = ctx +options.contenturl;
		options.maximized?layer.full(layer.open(layoptions)):layer.open(layoptions)
	}else{
		 $.get(ctx + options.contenturl,  function(str){
	    		layoptions.content =str
	    		options.maximized?layer.full(layer.open(layoptions)):layer.open(layoptions)
			});
	}
   
}
function downloadFile(options) {
    var options = {
        versionid: options.versionid ? options.versionid : '',
        usebase: (options.usebase == false) ? false : true// usebase使用基础版本
        // 传入false择使用version对应的版本,否则
        // 使用version对应的基础版本
    }
    window.open(ctx + "/file/download?versionid=" + options.versionid + "&usebase=" + options.usebase);
}

function downloadhelpFile(filename) {
    window.open(ctx + "/file/downloadhelpfile?filename=" + filename);
}
function previewFileByFileId(fileId) {
	 $.ajax({
         type: 'post',
         dataType: 'json',
         url: ctx + "/DocFile/findDocFileID?fileid="+fileId,
         success: function (data) {
        	 previewFile({versionid:data.versionId});
         }
     });
}

function previewFile(options) {
    var options = {
        versionid: options.versionid ? options.versionid : '',
        usebase: (options.usebase == false) ? false : true// usebase使用基础版本
        // 传入false择使用version对应的版本,否则
        // 使用version对应的基础版本
    }
    window.open(ctx + "/file/preview?versionid=" + options.versionid + "&&usebase=" + options.usebase, null, "");
}

function choosedownloadfiles(options) {
	$.post(ctx+"/file/getdownloadcount",{
		formcode: options.formcode,
		Panelid:options.panelid ,
		PK:options.pk,
		fileTypeId:(options.fileTypeId?options.fileTypeId:'')
	},function(result){
		if(result.o.length==1){
			 window.open(ctx + "/file/downloadfiles?versionids=" + result.o[0].fileVersionId);
		}else{
			openChooseDialog({
		        title: "选择要打包下载的文件",
		        contenturl: '/file/choosedownloadfiles?formcode=' + options.formcode + "&Panelid=" + options.panelid + "&PK=" + options.pk+ "&fileTypeId=" + (options.fileTypeId?options.fileTypeId:'')+"&isStage="+options.isStage+"&projectId="+(options.projectId?options.projectId:''),
		        width: 600,
		        height: 400,
		        okhandler: function () {
		            var rows = $('#choosedownloadfilesgrid').datagrid('getSelections');
		            if (rows.length > 0) {
		                var versionids = [];
		                for (var i = 0; i < rows.length; i++) {
		                    versionids.push(rows[i].versionid);
		                }
		                window.open(ctx + "/file/downloadfiles?versionids=" + versionids.join(','));
		                return true;
		            } else {
		                alertInfo("请选择要打包下载的文件");
		                return false;
		            }
		        }
		    })
		}
	},'json');
}
function printQrcode(options) {
    var options = {
        versionid: options.versionid ? options.versionid : '',
        usebase: (options.usebase == false) ? false : true// usebase使用基础版本
        // 传入false择使用version对应的版本,否则
        // 使用version对应的基础版本
    }
    openDetailDialog({
        title: "二维码查看",
        width: 300,
        height: 400,
        contenturl: "/qrcode/genqrcode?versionid=" + options.versionid + "&&usebase=" + options.usebase
    });
}
// 生成uuid
function generateUUID() {
    var d = new Date().getTime();
    var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
        var r = (d + Math.random() * 16) % 16 | 0;
        d = Math.floor(d / 16);
        return (c == 'x' ? r : (r & 0x3 | 0x8)).toString(16);
    });
    return uuid;
}
// 查看流程
function viewFlowDialog(processInstId) {
    if (processInstId) {
        openChooseDialog({
            title:  "流程审批记录",
            sureText:"查看流程",
            iconCls: 'icon-view-flow iconfont blue2',
            width: $("body").width()-50,
            height: $("body").height()-50,
            isframe : true,
            okhandler:function(){
            	viewFlowChart(processInstId)
            },
            contenturl: '/viewwf/viewProcessApp?processInstId=' + processInstId
        });
    } else {
        alertInfo('该数据信息没有流程实例');
    }
}
function viewFlowChart(processinstid) {
    window.open(ctx + '/viewwf/viewFlow?processInstId=' + processinstid, '');
}
/**
 * 验证流程权限和业务信息校验后在弹出流程提交弹窗
 */
function openFlowDialog(_options){
    var options = {
            title: "流程操作",
            processInstId: null,
            businessMainId: null,
            formCode: null,
            callback: null,
            msgtitle: null,
            params: {},
            dialogoptions: {},
            msgid: '',
            showtodo: false,
            msglevel: 0,
            onsubmit: null,
            advice: null,
            gotoDetail:false
        }
        $.extend(options, _options);
        if (!options.processInstId) {
            alertInfo("该数据信息没有流程实例");
            return;
        }
        if (!options.businessMainId || !options.formCode) {
            alertInfo("业务主键和表单编码不能为空");
            return;
        }
        if ($("#flow_dialog").length > 0) {
            return;
        }
        if(options.gotoDetail){
        	gotoDetailFlow(options.processInstId,options.callback);
        	return ;
        }
        if (!options.params) {
            options.params = {};
        }
        var conditon = "";
        options.params.processInstId = options.processInstId;
        options.params.businessMainId = options.businessMainId;
        options.params.formCode = options.formCode;
        options.params.showtodo = options.showtodo;
        options.params.backoptions = options.backoptions;
        options.params.nextPerson = JSON.stringify(options.nextPerson);
        checkFlow(options.params,function(wfActivityParams){
        	options.wfActivityParams=wfActivityParams;
        	// 没有操作权限直接返回 - 20200909流程权限判断前置
        	if(!options.wfActivityParams.lines||options.wfActivityParams.lines.length==0){
        		alertWarn("您当前没有流程操作权限！");
        		return;
        	}
        	/** *议题相关校验 */
        	// 判断该节点是否有议题
//        	 var judge = meetingAgendaJudge(options);
//        	// 如果不需要填写议题,则直接走openFlowDialog_action方法,如果需要填写议题,则弹出议题录入弹出框,录入完成,再执行openFlowDialog_action方法
//             if(judge){
//            	 meetingAgendaAddData(options);
//             }else{
            	 openFlowDialog_action(options);	 
//             }
        	
        });
}
/**
 * 检查流程提交合法性 有无非法提示信息和确认信息
 */
function checkFlow(params,callback){
	var msgIndex = parent.layer.msg('流程数据校验中', {icon: 16, shade: 0.3, time: 0});
	$.ajax({
        url: ctx + "/wf/getWfActivityParams",
        data: {
            processInstId : params.processInstId,
            formCode : params.formCode,
            conditon : JSON.stringify(params)
        },
        dataType: 'json',
        success: function (result) {
			parent.layer.close(msgIndex);
            if (result.success) {
            	//wfActivityParams.lines下一步可分支的线
            	if(result.o.validate){
            		if(result.o.needConfirm){// 有确认消息
            			alertConfirmYes(result.o.cofirmMsg, function (yes) {
                   						 if (yes) {
                   						 	callback(result.o);
                   						 }
               						 });
            		}else{// 无非法和确认消息
            			callback(result.o);
            		}
            	}else{// 有非法消息不能提交
            		alertWarn(result.o.unvalidateMsg);
            	}
               
            } else {
                alertError(result.msg);
            }
        }
    });
}
/**
 * @param {}
 *            _options processInstId 流程实例ID /n businessMainId 业务表主键ID: formCode
 *            表单编码 callback 回调函数 msgtitle 消息参数 params 执行流程时传入的参数 options 其他选项
 *            msgid 待办ID showtodo 流程操作页面是否显示待办的超链接
 */
function openFlowDialog_action(options) {
	var lines = options.wfActivityParams.lines;
//	//没有操作权限直接返回
//	if(!options.wfActivityParams.lines||options.wfActivityParams.lines.length==0){
//		alertWarn("您当前没有流程操作权限！");
//		return;
//	}
	//只有一条线 且下一步节点不能指定参与人员  表单里面有流程意见框（options.advice不为空） 则直接发送流程 不弹出流程弹窗
//	if(options.backActId||((lines.length==1||!options.wfActivityParams.allWorkDone)&&(lines[0][5]+"")!="true"&&options.advice)){
	if(options.backActId){
	    if(options.backActId){
			options.params.backActId = options.backActId;
			options.params.toActId = options.backActId;
			options.params.TH = "TH";
		}else{
			options.params.condition = lines[0][1];
			options.params.toActId = lines[0][2];
			options.params.TH = lines[0][3];
			options.params.jumpacts = lines[0][10];
			options.params.conds = lines[0][11];
		}
        options.params.title = options.msgtitle;
        options.params.advice = options.advice;
		if(options.wfActivityParams.needConfirm){
			flowSubmit(options.callback, options.params, this, options.onsubmit);
		}else{
			var opname = "发送流程";
	       	 if(options.backActId){
	       		 opname="退回流程到【"+options.backActName+"】节点";
	       		 
	       	 }
			top.alertConfirmYes("确认"+opname+"？", function (yes) {
					 if (yes) {
						 flowSubmit(options.callback, options.params, this, options.onsubmit);
					 }
				 });
		}
		return;
	}
	if(options.wfActivityParams.actClass=='0'){//无需意见
		options.advice = options.advice||' ';
	}
    var conditon = "";
    conditon = "&conditon=" + encodeURI(JSON.stringify(options.params));
    // 默认配置
    var opendialogoptions = {
        title: '流程操作',
        url: ctx + '/wf/getLineCondition.action?formCode='+options.params.formCode+'&processInstId=' + options.processInstId + "&msglevel=" + options.msglevel + "&showtodo=" + options.showtodo + "&msgid=" + options.msgid + conditon,
        width: 800,
        height: 390
    }
    if (options.dialogoptions) {
        $.extend(opendialogoptions, options.dialogoptions);
    }
    if(options.advice){
    	opendialogoptions.height -= 100;
    }
    opendialogoptions.height+=options.wfActivityParams.lines.length*30;
    if(options.wfActivityParams.params.taskUrl){
    	opendialogoptions.height+= 260;
    }

    if ($("#flow_dialog").length > 0) {
        return;
    }
    $('<div/>').dialog({
        id: "flow_dialog",
        cls : "c6",
        border : 'thin',
        href: opendialogoptions.url,
        width: opendialogoptions.width,
        height: opendialogoptions.height,
        modal: true,
        title: opendialogoptions.title,
        buttons: [{
            text: '确定',
            iconCls: 'icon-disk',
            handler: function () {
                if ($("#hasper").val() == "0") {
                    var d = $(this).closest('.window').find('.window-body');
                    d.dialog('destroy');
                    return;
                }
                if ($('#flowForm').form('validate')) {
                    options.params.processInstId = $("#flow_processInstId").val();
                    options.params.businessMainId = $("#flow_businessMainId").val();
                    options.params.formCode = $("#flow_formCode").val();
                    options.params.fromActId = $("#flow_actId").val();
                    options.params.workItemId = $("#flow_workItemId").val();
                    // 对应上面的不再把title传到后台去往复一遍,这里执行流程的时候直接传给后台
                    options.params.title = options.msgtitle;
                    options.params.msglevel = $("#msglevel").combobox('getValue');
                    // params.title=$("#flow_title").val();
                    if ($("#hasper").val() == 0) {// 没有操作权限
				        var d = $(this).closest('.window').find('.window-body');
				        d.dialog('destroy');
				        return;
				    }
				    var toActId=[];// 下一步的节点ID
				    var condition=[];// 线的复杂表达式
				    var jumpacts=[];//默认执行节点
				    var conds=[];//默认执行节点
				    var nextPerson=[];//接收人
				    var nextPersonName=[];//接收人
				    var TH;// 改线是否是退回操作
				    var isChecked = false;
				    $('input[name^=line]:checked').each(function () {
				        isChecked = true;
				        TH = $(this).attr("TH");
				        toActId.push($(this).attr("toActId"));
				        jumpacts.push($(this).attr("jumpacts"));
				        conds.push($(this).attr("conds"));
				        condition.push($(this).attr("condition"));
				        var np=$("#nextPerson_"+$(this).attr("toActId")).val();
				        nextPerson.push(np?np:" ");
				        var npName=$("#nextPersonName_"+$(this).attr("toActId")).val();
				        nextPersonName.push(npName?npName:" ");
				    });
				    if (!isChecked) {
				        alertInfo("请选择处理意见");
				        return;
				    }
//				    if (nextPersonName[0]==" "&&toActId[0]!="act_finish") {
//				        alertInfo("当前节点未维护下一步审批人，请联系相关人员设置");
//				        return;
//				    }
				    var splitstr = "@#@";
                    options.params.nextPerson = nextPerson.join(splitstr);//主送人员
                    options.params.copyPersons = $('#copyPersons').val();//抄送人员
				    options.params.condition = condition.join(splitstr);
				    options.params.toActId = toActId.join(splitstr);
				    options.params.jumpacts = jumpacts.join(splitstr);
					options.params.conds = conds.join(splitstr);
			    	options.params.advice = $("#advice").val();
				    options.params.TH = TH;
                    flowSubmit(options.callback, options.params, this, options.onsubmit);
                }else{
                	alertInfo("请完善发送信息")
                }
            }
        }, {
            text: '取消',
            iconCls: 'icon-back iconfont red2',
            handler: function () {
                var d = $(this).closest('.window').find('.window-body');
                d.dialog('destroy');
            }
        }],
        onClose: function () {
            $(this).dialog('destroy');
        },
        onLoad: function () {
        	if(options.advice){
            	$("#advice").closest("tr").hide();
            	$(".workitemfile").closest("tr").hide();
            	$("#advice").textbox("setValue",options.advice);
            }
        }
    });
}

/**
 * 根据流程参数执行流程
 * @param {}callback 成功回掉函数
 * @param {}params 执行参数 包含 必需 processInstId condition fromActId toActId TH
 *            businessMainId formCode msgid 非必需 msglevel title advice
 * @param {} win
 * @param {}submit
 */
function flowSubmit(callback, params, win, submit) {
    $.messager.progress({
        title: "请稍等",
        msg: "数据发送中...",
        text: "",
        interval: 500
    });
    var isChecked=true;
    // 同意前校验方法
    if (params.TH != 'TH' && submit && typeof(submit) === "function") {
        isChecked = submit();
    }
    var fileIds=[];
    $(".workitemfileVersionId").each(function(){
    	fileIds.push($(this).val());
    })
    params.fileIds = fileIds.join(",");
    if (isChecked) {
        $.ajax({
            type: "POST",
            url: ctx + '/wf/excuteFlow.action',
            data: params,
            dataType: "json",
            success: function (result) {
                $.messager.progress('close');
        		if(win){
    	            var d = $(win).closest('.window').find('.window-body');
    	            d.dialog('destroy');
                }	
                if (result.success) {
                    top.alertInfo("流程流转发送成功");
              		 (callback && typeof(callback) === "function") && callback(params);
                } else {
                    top.alertWarn(result.msg);
                }
            },
            error: function (request, textStatus, error) {
                $.messager.progress('close');
            }
        });
    } else {
        $.messager.progress('close');
    }
}
function doFlowWithBatch(_options) {
    var options = {
        title: '批量审批',
        contenturl: ctx + '/view/workflow/flowSubmitBatch',
        submiturl: '',
        width: 700,
        height: 300,
        maximized: false
    }
    $.extend(options, _options);
    $('<div/>').dialog({
        id: "flow_dialog",
        href: options.contenturl,
        width: options.width,
        height: options.height,
        modal: true,
        title: options.title,
        buttons: [{
            text: '确定',
            iconCls: 'icon-disk',
            handler: function () {
                var d = $(this).closest('.window').find('.window-body');
                var flowlinetext = $("input[name='flowline']:checked").next("label").text();
                alertConfirmYes("批量审批将按照您选择的'" + flowlinetext + "',对流程进行统一操作,确定?", function (yes) {
                    if (yes) {
                        $.messager.progress({
                            title: "请稍等",
                            msg: "数据发送中...",
                            text: "",
                            interval: 500
                        });
                        $.ajax({
                            type: "POST",
                            url: ctx + '/wf/excuteFlowWithMsgIds',
                            data: {
                                msgIds: _options.msgIds,
                                flowline: $("input[name='flowline']:checked").val(),
                                advice: $("#advice").val()
                            },
                            dataType: "json",
                            success: function (result) {
                                $.messager.progress('close');
                                if (result.success) {
                                    alertInfo("流程流转发送成功");
                                } else {
                                    alertWarn(result.msg);
                                }

                                d.dialog('destroy');
                                (options.callback && typeof(options.callback) === "function")
                                && options.callback();
                            },
                            error: function (request, textStatus, error) {
                                $.messager.progress('close');
                            }
                        });
                    }
                })
            }
        }, {
            text: '取消',
            iconCls: 'icon-back iconfont red2',
            handler: function () {
                var d = $(this).closest('.window').find('.window-body');
                d.dialog('destroy');
            }
        }],
        onClose: function () {
            $(this).dialog('destroy');
        },
        onLoad: function () {
        }
    });
}
//页面发送按钮进入代办样式
function gotoDetailFlow(processinstid,callback){
	var msgId ;
	if (processinstid) {
        $.ajax({
            type: "POST",
            url: ctx + "/BasMessage/findMsgByProcessinstid",
            data: "processinstid=" + processinstid,
            async : true,
            dataType: "json",
            success: function (result) {
            	if(result&&result.msgId){
            		msgId = result.msgId;
            		updataMsgisRead(msgId);
            		var url = '/BasMessage/todoDetail?msgid=' + msgId+"&isLayer=Y";
            		var l_index = parent.layer.open({
            			  type: 2,
            			  title: "审批记录",
            			  closeBtn: 1, //不显示关闭按钮,
            		      zIndex:$.fn.window?Math.ceil($.fn.window.defaults.zIndex++):1001,
            			  maxmin: true,
            			  skin: 'layui-layer-qllan',
            			  area: ['800px', '600px'],
            			  content: [ctx+url, 'no'], //iframe的url，no代表不显示滚动条
            			  success: function (layero, index) {
            	          },
            	          end: function () { 
            	        	  (callback && typeof(callback) === "function") && callback();
            	          }
            	    });
            		parent.layer.full(l_index);
            	}else{
            		alertWarn("您当前没有流程操作权限！");
            	}
            }
        });
    }
}
/** *************************************************弹出窗口操作********************************************* */
/**
 * 格式化弹出框操作对象
 * @param o操作的input对象
 * @return inputobj
 */
function formatterInputobj(o) {
    // 弹出框操作对象
    var inputobj = {
        inputId: '',
        inputText: ''
    }
    // indexOf() 方法可返回某个指定的字符串值在字符串中首次出现的位置
    if (o && o.id && o.id.toString().indexOf("_TEXT_") > -1) {
        inputobj.inputId = o.id.split("_TEXT_")[0];
        inputobj.inputText = o.id;
    } else {
        inputobj.inputId = o.id;
    }
    return inputobj;
}
//列表中  格式化弹出框操作对象
function gridFormatterInputobj(o) {
    // 弹出框操作对象
    var inputobj = {
        inputId: '',
        inputText: ''
    }
    // indexOf() 方法可返回某个指定的字符串值在字符串中首次出现的位置
    if (o && o.id && o.id.toString().indexOf("_TEXT_") > -1) {
    	var reg = new RegExp("_TEXT_","g");
        inputobj.inputId = o.id.replace(reg,"");
        inputobj.inputText = o.id;
    } else {
        inputobj.inputId = o.id;
    }
    return inputobj;
}
// 鼠标移动提示框
function formatterTip(value) {
    if (value === null || value === "") {
        return value;
    }
    return '<li title="' + value + '" class="tip">' + value + '</li>';
}
// 格式化日期 返回年月 可编辑表格
function dateformatter(value, row) {
    if (value != undefined && value != null && value != '') {
        value = value.replace(/-/g, "/");
        var date = new Date(value);
        return date.Format("yyyy-MM");
    }
    return value;
}
// grid金钱元->万元
function formatterMoney2(value) {
    return $.FormatMoney(parseFloat(value / 10000), 6);
}
// 智能判断赋值
function autoSetValue(id, value) {
    var obj = $("#" + id);
    if(obj.length>0){
    	var objCls = obj.attr("class");
        if (id && objCls && objCls.indexOf("easyui") != -1) {
            if (objCls.indexOf("numberbox") != -1) {
                obj.numberbox('setValue', value);
            } else if (objCls.indexOf("datebox") != -1) {
                obj.datebox('setValue', value);
            } else if (objCls.indexOf("combobox") != -1) {
                obj.combobox('setValue', value);
            }else if (objCls.indexOf("combotree") != -1) {
                obj.combotree('setValue', value);
            } else {
                obj.textbox('setValue', value);
            }
        } else if (id) {
            obj.val(value);
        }
    }
}
function monthDayFormatter(date) {
    var y = date.getFullYear();
    var m = date.getMonth() + 1;
    var d = date.getDate();
    if (m < 10) {
        m = "0" + m;
    }
    if (d < 10) {
        d = "0" + d;
    }
    return m + '-' + d;
}
function monthDayParser(s){
	s=s.split(" ")[0];
	if(s.length<7){
		s=new Date().getFullYear()+"-"+s;
	}
	var t = Date.parse(s);
	if (!isNaN(t)){
		return new Date(t);
	} else {
		return new Date();
	}
}
// 多选下拉框清空","
function formatterMultCombobox(newValue, oldValue) {
    if (newValue.length == 1 && !newValue[0]) {
        $('#' + this.id).combobox('clear');
    }
}
function updataMsgisRead(msgid) {
    if (msgid) {
        $.ajax({
            type: "POST",
            url: ctx + "/BasMessage/setMsgIsRead",
            data: "msgIds=" + msgid,
            dataType: "json",
            success: function (result) {
            }
        });
    }
}
// 计算日期相差天数
function dateDiff(start,sDate2) {
    oDate1 = new Date(start);  // 转换为yyyy-MM-dd格式
    oDate2 = new Date(sDate2);
    iDays = parseInt((oDate2 - oDate1) / 1000 / 60 / 60 / 24); // 把相差的毫秒数转换为天数
    return iDays;  // 返回相差天数
}
// 格式化日期
function myformatter(date) {
    var y = date.getFullYear();
    var m = date.getMonth() + 1;
    var d = date.getDate();
    return y + '-' + (m < 10 ? ('0' + m) : m) + '-' + (d < 10 ? ('0' + d) : d);
}
function getNextDate(date,day) {  
	  var dd = new Date(date);
	  dd.setDate(dd.getDate() + day);
	  var y = dd.getFullYear();
	  var m = dd.getMonth() + 1 < 10 ? "0" + (dd.getMonth() + 1) : dd.getMonth() + 1;
	  var d = dd.getDate() < 10 ? "0" + dd.getDate() : dd.getDate();
	  return y + "-" + m + "-" + d;
};
// 格式化日期 返回年月
function formatterMonth(date) {
    return (new Date()).Format("yyyy-MM")
}
function queryByOrg(newValue, oldValue) {
    $('#dept_select').combobox({
        url: ctx + "/basdept/queryDeptCombo?orgId=" + newValue

    });
}
// 改变form表样式 changeCSS($('#id'),"add","combobox");
function changeCSS($id, type, datatype) {//
    if ("add" == type) {
        if (datatype == "textbox") {
            $id.textbox('readonly');
        } else if (datatype == "numberbox") {
            $id.numberbox('readonly');
        } else if (datatype == "datebox") {
            $id.datebox('readonly');
        } else if(datatype == "combotree"){
        	$id.combotree('readonly');
        }else{
            $id.combobox('readonly');
        }
        $id.closest('td').addClass('disableinput');
    } else if (type == "remove") {
        if (datatype == "combobox") {
            $id.combobox('readonly', false);
        } else if (datatype == "datebox") {
            $id.textbox('readonly', false);
        } else if (datatype == "numberbox") {
            $id.numberbox('readonly', false);
        } else if(datatype == "combotree"){
        	$id.combotree('readonly', false);
        } else {
            $id.textbox('readonly', false);
        }
        $id.closest('td').removeClass('disableinput');
    }
}
// 动态设置控件属性 setCss($("#id"),"textbox",true,false,true,false,true);   
function setCss($id, datatype, editable, readonly, required, disableinput, clear) {
    if (datatype == "textbox") {
        $id.textbox({
            editable: editable,
            readonly: readonly,
            required: required,
            text:$id.textbox('getText'),
            value:$id.textbox('getValue'),
        });
        if (clear != null) {
            if (clear) {
                $id.textbox('clear');
                $id.textbox('setText','');
            }
        }
    } else if (datatype == "numberbox") {
        $id.numberbox({
            editable: editable,
            readonly: readonly,
            required: required
        });
        if (clear != null) {
            if (clear) {
                $id.numberbox('clear');
            }
        }
    } else if (datatype == "datebox") {
        $id.datebox({
            editable: editable,
            readonly: readonly,
            required: required
        });
        if (clear != null) {
            if (clear) {
                $id.datebox('clear');
            }
        }
    } else if (datatype == "combobox") {
        $id.combobox({
            editable: editable,
            readonly: readonly,
            required: required,
            text:$id.textbox('getText'),
            value:$id.textbox('getValue')
        });      
        if (clear != null) {
            if (clear) {
                $id.combobox('clear');
            }
        }
    }else if (datatype == "combotree") {
        $id.combotree({
            editable: editable,
            readonly: readonly,
            required: required
        });      
        if (clear != null) {
            if (clear) {
                $id.combotree('clear');
            }
        }
    }
    if (disableinput != null) {
        if (disableinput) {
            $id.parent().addClass('disableinput');
        } else {
            $id.parent().removeClass('disableinput');
        }
    }
}
// 计算可编辑表格某列金额之和
function getTotalMoney(index, $id) {
    var totalMoney = 0;
    for (var i = 0; i < index; i++) {
        if ($("#isUse" + i).val() != 'N') {
            if ($("#" + $id + i).val() != null && $("#" + $id + i).val() != '') {
                totalMoney = parseFloat(totalMoney) + parseFloat($("#" + $id + i).val());
            }
        }
    }
    return totalMoney;
}
/**
 * 计算可编辑表格某列金额之和。
 * 多个tab页时可使用
 * @param index
 * @param $grid
 * @param $id
 * @returns {number}
 */
function getTotalMoney2(index,$grid ,$id) {
    var totalMoney = 0;
    for (var i = 0; i < index; i++) {
        if ($("#" + $grid+" #isUse" + i).val() != 'N') {
            if ($("#" + $grid+" #" + $id + i).val() != null && $("#" + $grid+" #" + $id + i).val() != '') {
                totalMoney = parseFloat(totalMoney) + parseFloat($("#" + $grid+" #" + $id + i).val());
            }
        }
    }
    return totalMoney;
}

/**
 * 通过id获取结尾数字 var index = getEndNumberForStr(this.id);
 * 
 * @param str
 * @returns
 */
function getEndNumberForStr(str) {
    var regend = new RegExp("\\d+$");
    str = str.match(regend);
    return str;
}
function hideShowHeader(grid, method, headers) {
    for (var i=0;i<headers.length;i++) {
        grid.datagrid(method, headers[i]);
    }
}
/**
 * @param checkMonth数据月份 格式: yyyy-MM
 * @returns {Boolean} true 允许上报 false 不允许上报
 */
function checkNowMonth(checkMonth) {
    if (checkMonth == (new Date()).Format("yyyy-MM")) {
        return true;
    } else {
        return false;
    }
}
/**
 * html行合并 tableId table id cols []数组 要合并的列
 */
function mergeTableRow(tableId, cols) {
    var tab = document.getElementById(tableId);
    var val, count, start;
    for (var k=0;k<cols.length;k++) {
        var col = cols[k];
        count = 1;
        val = "";
        for (var i = 0; i < tab.rows.length; i++) {
            if (val == tab.rows[i].cells[col].innerHTML) {
                count++;
            } else {
                if (count > 1) { // 合并
                    start = i - count;
                    // console.log("i:" + i + " count:" + count + "start :" +
					// start)
                    tab.rows[start].cells[col].rowSpan = count;
                    for (var j = start + 1; j < i; j++) {
                        tab.rows[j].cells[col].style.display = "none";
                    }
                    count = 1;
                }
                val = tab.rows[i].cells[col].innerHTML;
            }
        }
        if (count > 1) { // 合并，最后几行相同的情况下
            start = i - count;
            tab.rows[start].cells[col].rowSpan = count;
            for (var j = start + 1; j < i; j++) {
                tab.rows[j].cells[col].style.display = "none";
            }
        }
    }
}
function deleteRecord(grid_id, url, idName, calback) {
    var row = $(grid_id).datagrid('getSelections');
    if (row.length == 0) {
        msgWarn('请先选择要删除的数据!');
        return false;
    }
    var idArray = new Array();
    for (var i = 0; i < row.length; i++) {
        idArray.push(row[i][idName]);
    }
    alertConfirm("确定删除数据吗？", function (btn) {
        if (btn) {
            $.messager.progress({
                title: '提示',
                text: '数据处理中，请稍候....'
            }); // 显示进度条
            $.ajax({
                url: ctx + "/" + url,
                data: {
                    id: idArray.join(",")
                },
                dataType: 'json',
                success: function (result) {
                    $.messager.progress('close'); // 如果提交成功则隐藏进度条
                    if (result.success) {
                        $(grid_id).datagrid('reload');
                        alertInfo('删除成功');
                        if (calback) {
                            alertInfo(result.msg);
                        }
                    } else {
                        alertInfo(result.msg ? result.msg : "删除失败");
                    }
                }
            });
        }
    });
    return true;
}
function deleteRow(grid_id, index) {
    $(grid_id).datagrid('deleteRow', index);
}
function onClickDel(index, field, grid_id, url, idName, calback) {
    if (field == "_operate" || field == "" || field == null) {
        $(grid_id).datagrid('selectRow', index);
        var row = $(grid_id).datagrid('getSelected');
        if (row[idName]) {
            deleteRecord(grid_id, url, idName, calback);
        } else {
            deleteRow(grid_id, index);
        }
    }
}

/**
 * easyui 可编辑表格增加一行
 * @param gridId列表id
 * @param row增加的行内容
 *            如：var row = { id:"", name:"", code:"", …… }
 */
function addEditRow(gridId, row) {
    if (row) {
        $(gridId).datagrid('appendRow', row);
    } else {
        $(gridId).datagrid('appendRow', {});
    }
    var rows = $(gridId).datagrid('getRows');
    $(gridId).datagrid('scrollTo', rows.length - 1);
    $(gridId).datagrid('selectRow', rows.length - 1);// 必须选择该行
    $(gridId).datagrid('beginEdit', rows.length - 1);
}

/**
 * 数据字典数据查询 dicType: 数据字典中类型编码 func:回调方法名
 */
getDictionaryOfType = function (dicType, func) {
    $.ajax({
        type: "POST",
        async: false,
        dataType: "json",
        data: {dicType: dicType},
        cache: false,
        url: ctx + "/dic/dics.action",
        success: function (result) {
            if (typeof(func) == "function") {
                func(result);
            }
        }
    });
};
function formDetail(formCode, id, title, maximized) {
    var options = {
        title: '查看明细',
        width: 500,
        height: 300,
        maximized: true
    }
    $.extend(options, {
        title: title,
        maximized: maximized,
        contenturl: "/GenForm/form?formcode=" + formCode + "&isdetail=true&id=" + id
    });
    openDetailDialog(options);
}

function closewin() {
    if (navigator.userAgent.indexOf("Firefox") != -1) {
        window.location.href = "about:blank";
        window.close();
    } else if (navigator.userAgent.indexOf("Chrome") != -1) {
        var opened = window.open('about:blank', '_self');
        opened.opener = null;
        opened.close();
    } else {
        window.opener = null;
        window.open("", "_self");
        window.close();
    }
}
function getCodeMirrorEditor(type, title) {
    return function () {
        editjs(type, title, this)
    }
}
function editjs(type, title, that) {
    var mode = "text/javascript";
    if (type == "sql") {
        mode = "text/x-plsql";
    }
    var editor;
    var content = "<textarea style='width:100%;height:100%;' class='form-control' id='CodeMirrorEditor' name='CodeMirrorEditor'></textarea>";
    layer.open({
        title: title ? title : '代码编辑',
        content: content,
        btn: ['确定', '取消'],
        btn1: function (index) {
            $(that).textbox('setValue', editor.getValue());
            layer.close(index);
        }, btn2: function (index) {
            layer.close(index);
        },
        zIndex:$.fn.window?Math.ceil($.fn.window.defaults.zIndex++):1001,
        area: [($("body").width()-100)+'px', ($("body").height()-100)+'px'],
        success: function (layerE) {
            if ($("#CodeMirrorEditor")) {
                editor = CodeMirror.fromTextArea(document.getElementById("CodeMirrorEditor"), {
                    mode: mode,    // 实现js代码高亮
                    lineNumbers: true,	// 显示行号
                    theme: "dracula",	// 设置主题
                    lineWrapping: true,	// 代码折叠
                    extraKeys: {
                        "Alt-/": "autocomplete",
                        "F11": function (cm) {
                            cm.setOption("fullScreen", !cm.getOption("fullScreen"));
                        },
                        "Esc": function (cm) {
                            if (cm.getOption("fullScreen")) cm.setOption("fullScreen", false);
                        },
                        "'a'": this.completeAfter,
                        "'b'": this.completeAfter,
                        "'c'": this.completeAfter,
                        "'d'": this.completeAfter,
                        "'e'": this.completeAfter,
                        "'f'": this.completeAfter,
                        "'g'": this.completeAfter,
                        "'h'": this.completeAfter,
                        "'i'": this.completeAfter,
                        "'j'": this.completeAfter,
                        "'k'": this.completeAfter,
                        "'l'": this.completeAfter,
                        "'m'": this.completeAfter,
                        "'n'": this.completeAfter,
                        "'o'": this.completeAfter,
                        "'p'": this.completeAfter,
                        "'q'": this.completeAfter,
                        "'r'": this.completeAfter,
                        "'s'": this.completeAfter,
                        "'t'": this.completeAfter,
                        "'u'": this.completeAfter,
                        "'v'": this.completeAfter,
                        "'w'": this.completeAfter,
                        "'x'": this.completeAfter,
                        "'y'": this.completeAfter,
                        "'z'": this.completeAfter,
                        "'.'": this.completeAfter,
                        // "'='": this.completeIfInTag,
                        "Ctrl-Enter": "autocomplete"
                    },
                    indentUnit: 2,// 缩进单位，值为空格数，默认为2 。
                    smartIndent: true,// 自动缩进，设置是否根据上下文自动缩进（和上一行相同的缩进量）。默认为true。
                    foldGutter: true,
                    lint: true,
                    autoRefresh: true,
                    gutters: ["CodeMirror-linenumbers", "CodeMirror-foldgutter", "CodeMirror-lint-markers"],
                    matchBrackets: true	// 括号匹配
                    // readOnly: true, //只读
                });
                editor.setSize(($("body").width()-140)+'px', ($("body").height()-240)+'px');
                editor.setValue($(that).textbox('getValue'));
            }
        }
    });
}
/**
 * datagrid评分格式化 数字转☆
 */
function gradeFormatter(value, row, index) {
    if (value == +value) {
        var id = generateUUID();
        return "<div id='grade" + id + "' class='gridgrade' ><div><script>layui.use(['rate'], function(){var rate = layui.rate;rate.render({elem: '#grade" + id + "',value: " + value + ",readonly: true,half:true}); })</script>";
    }
    return value;
}
/**
 * 明细查看页面 如果当前登录人有对应待办则打开带待办处理的页面
 * @param {} title
 * @param {} formCode
 */
function openFormMsg(title, formCode, id) {
    openDetailDialog({
        title: title,
        maximized: true,
        contenturl: "/GenForm/form?formcode=" + formCode + "&isdetail=true&checkMsg=true&id=" + id
    });
}
function openWebOfficeDialog(){
	// 自身浏览器打开
    var mhtmlHeight = window.screen.availHeight; // 获得窗口的垂直位置;
    var mhtmlWidth = window.screen.availWidth; // 获得窗口的水平位置;
    var iTop = 0; // 获得窗口的垂直位置;
    var iLeft = 0; // 获得窗口的水平位置;
    var recordId=$("#content").val();
    if(recordId==""||recordId==null){
    	recordId = generateUUID();
    	autoSetValue("content",recordId);
    	autoSetValue("documentBody",recordId);
    	// $("#content").val(recordId);
    }
    var templateName="";
    if($("#templateName").length>0){
    	templateName=$("#templateName").textbox("getValue");
    }
    if($("#subject").length>0){
    	templateName=$("#subject").textbox("getValue");
    }
    if(templateName==""){
    	templateName="空文件";
    }
    var url=ctx+"/view/doc/iweboffice/addOrEditOffice?recordId="+recordId+"&templateName="+templateName;
    window.open(url, templateName, 'height=' + mhtmlHeight + ',width=' + mhtmlWidth + ',top=' + iTop + ',left=' + iLeft + ',toolbar=no,menubar=yes,scrollbars=no,resizable=yes, location=no,status=no');
}

function getActionIcon(actName){
	if(actName=="退回"){
		return "icon-page-undo";
	}else if(actName=="上报"){
		return "icon-move-up";
	}else if(actName=="通过"){
		return "icon-apply";
	} else {
		return "icon-approve";
	} 
}
// 转驼峰
function transformStr3(str){
    var re=/_(\w)/g;
    return str.replace(re,function ($0,$1){
        return $1.toUpperCase();
    });
}
var incons=['about','add','del','del1','add1','password','xls','file','yonghutouxiang','gerenxinxi','7z','flv',
	'ppt','txt','jpg','set','gif','doc','bmp','avi','mov','mp4','pdf','pr','psd','rar','mp3','tif','cdr','svg','zip','Addprofile'];
// 清除对象中没有值的引用，解决表单赋值的时候掩盖掉默认值的问题
function removeElement(obj){
    var param = {};
    if ( obj === null || obj === undefined || obj === "" ) return param;
    for ( var key in obj ){
        if ( obj[key] !== null && obj[key] !== undefined && obj[key] !== "" ){
            param[key] = obj[key];
        }
    }
    return param;
}
//数组删除元素的方法
Array.prototype.indexOf = function(val) { 
	for (var i = 0; i < this.length; i++) { 
	if (this[i] == val) return i; 
	} 
	return -1; 
};
Array.prototype.remove = function(val) { 
	var index = this.indexOf(val); 
	if (index > -1) { 
	this.splice(index, 1); 
	} 
};
/**
 * 检查表单有没有流程
 * @param formCode
 * @returns
 */
function checkFormFlow(formCode){
	var flag=false;
	$.ajax({
		url:ctx+"/GenForm/checkFormFlow",
		async:false,
		dataType:'JSON',
		data:{
			formCode:formCode
		},
		success:function(data){
			flag = data.success;
		}
	});
	return flag;
}
//null值转空字符串
function nullToEmpty(data){
	if(data==null){
		return "";
	}else{
		return data;
	}
}
//更具弹框的id关闭弹框
function closeWinById(id){
	var d = $("#"+id).closest('.window').find('.window-body');
	d.dialog('destroy');
}
/**
 * 计算easyui 可编辑单元格合计
 * @param grid_ 表格对象
 * @param editCell_ 可编辑列名
 * @param index_ 当前编辑索引
 * @returns 合计值
 */
function sumEditCell(grid_,editCell_,index_){
	var rows_ = grid_.datagrid("getRows");
	var sumNumber_ = 0.0;
	for(var i = 0;i<rows_.length;i++){
		if(index_==i){
			var ed = grid_.datagrid('getEditor', {index:editIndex,field:editCell_});
			if(ed){
				sumNumber_ += parseFloat($(ed.target).numberbox('getValue'));
			}
		}else if(rows_[i][editCell_]){
			sumNumber_ += parseFloat(rows_[i][editCell_]);
		}
	}
	
	return sumNumber_;
}
function mergeCellsByField(tableID, colList, mainColIndex) {
	var ColArray = colList.split(",");
	var tTable = $('#' + tableID);
	var TableRowCnts = tTable.datagrid("getRows").length;
	var tmpA = 0;
	var tmpB = 0;
	var PerTxt = "";
	var CurTxt = "";
	for ( var i = 0; i <= TableRowCnts; i++) {
		if (i == TableRowCnts) {
			CurTxt = "";
		} else {
			CurTxt = tTable.datagrid("getRows")[i][ColArray[mainColIndex]];
		}
		if (PerTxt == CurTxt) {
			tmpA += 1;
		} else {
			tmpB += tmpA;
			for ( var j = 0; j < ColArray.length; j++) {
				tTable.datagrid('mergeCells', {
					index : i - tmpA,
					field : ColArray[j],
					rowspan : tmpA,
					colspan : null
				});
			}
			tmpA = 1;
		}
		PerTxt = CurTxt;
	}
}
//处理textarea自动适应高度
function makeExpandingArea(el) {
    var timer = null;
    //由于ie8有溢出堆栈问题，故调整了这里
    var setStyle = function(el, auto) {
        if (auto) el.style.height = 'auto';
        el.style.height = el.scrollHeight + 'px';
    }
    var delayedResize = function(el) {
        if (timer) {
            clearTimeout(timer);
            timer = null;
        }
        timer = setTimeout(function() {
            setStyle(el)
        }, 200);
    }
    if (el && el.addEventListener) {
        el.addEventListener('input', function() {
            setStyle(el, 1);
        }, false);
        setStyle(el)
    } else if (el && el.attachEvent) {
        el.attachEvent('onpropertychange', function() {
            setStyle(el)
        })
        setStyle(el)
    }
}
/**
 * 获取easyui-tab 当前所选索引
 * @param tabId 
 * @returns
 */
function getEasyuiTabIndex(tabId){
	var tab = $(tabId).tabs('getSelected');
	var index = tab.tabs('getTabIndex',tab);
	return index;
}
function viewFormDetail(data) {
    if (data.formCode) {
    	var url;
    	if(data.formCode=="EdocApply"){
    		url = '/EdocApply/openPrintPage?id=' + data.id;
    	}else{
    		url = '/GenForm/form?hideCloseBtn=1&newpage=true&formcode='+data.formCode+'&isdetail=true&id=' + data.id;
    	}
        url = url + "&isLayer=Y" ;
		 var l_index = layer.open({
			  type: 2,
			  title: data.title?data.title:'数据详情',
			  closeBtn: 1, //不显示关闭按钮
			  maxmin: true,
		      zIndex:$.fn.window?Math.ceil($.fn.window.defaults.zIndex++):1001,
			  skin: 'layui-layer-qllan',
			  area: ['800px', '600px'],
			  content: [ctx+url, 'no'], //iframe的url，no代表不显示滚动条
			  success: function (layero, index) {
	         },
	         end: function () {  
					reloadGrid();
	         }
	     });
		 layer.full(l_index);
    } else {
        alertInfo('该数据信息');
    }
}
//处理 右侧框子展开后，还原panel内容不显示问题
function autoChangePanelWidth(formcode,colSize,tabPanelName) {
	var formdivwidth=$("#"+formcode).width()-3;
	var itemlebalwidth=Math.round(formdivwidth/colSize);//一个控件宽度 包含lebal
	var singleLength=formdivwidth-itemlebalwidth+Math.round(0.7*(0.85*itemlebalwidth-12));
	$("#"+tabPanelName).width(singleLength);
	$(".easyui-panel").panel('resize');
}
$(function(){
	$(window).resize(resizeDataGrid)
})
function resizeDataGrid(){
	 $(".datagrid-f").datagrid('resize',{
		    height:$("body").height()-($("#ff").height()+$(".el-card__header").height()+$(".space").height()+80)
		    })
}
function editInputPop(title,that){
	layer.open({
        type: 1
        ,title: title //不显示标题栏
        ,btn: ['确定', '取消']
        ,shadeClose :false
        ,area: ['460px',"330px"]
        ,shade: 0.2
        ,id: 'editInputPop' //设定一个id，防止重复弹出
        ,moveType: 1 //拖拽模式，0或者1
        ,content: '<div style="margin:auto;text-align:center;padding-top:8px;"><span  class="textbox sm fit"><textarea  class="textbox-text validatebox-text " autocomplete="off" style="margin: 0px; height: 200px; width: 430px;">'+$(that).val()+'</textarea></span></div>'
        ,success: function(layero){
        	
        }, yes: function (index, layero) {
        	$(that).parent().parent().find(".textbox-f").textbox("setValue",$(layero).find("textarea").val())
        	layer.close(index)
        }
      });
}

var _fileIndexMap={};
function initUploadFileCommon(fieldCode,isEditable,formId,fieldId){
	if($("#_local_filearray"+fieldId).length!=0){
		return
	}
	$("#"+fieldCode).parent().append(
			"<div style=\"float:left;padding:5px;\">    <table id=\"_local_filearray"+fieldId+"\" class=\"\" style=\"border:none;\">\n" + 
			"  <TBODY class=\"\">\n" + 
			"  </TBODY>\n" + 
			"</table></div>" + 
			"<div style=\"margin:5px 5px;float:left;\">\n" +
			"      <div id=\"container"+fieldId+"\">\n" + 
			"      <a href=\"#\" style=\"color:black;\" id=\"pickfiles"+fieldId+"\" >选择文件</a>\n" + 
			"      </div>\n" + 
			"    </div>\n");
	$("#pickfiles"+fieldId).linkbutton({
		iconCls:'blue iconfont icon-check',
		iconAlign:'left',
		plain:true,
		disabled:isEditable!="Y"
	});
	if(isEditable!="Y"){
		return false;
	}
	var _localfile_uploader = new plupload.Uploader({
		runtimes : 'html5,flash,silverlight,html4',
	    browse_button : 'pickfiles'+fieldId, //触发文件选择对话框的按钮，为那个元素id
	    container: document.getElementById('container'+fieldId), // ... or DOM Element itself
	    multi_selection:true,//文件多选
	    url : ctx+ '/file/multiupload', //服务器端的上传页面地址
	    flash_swf_url : ctx+'/static/plugins/plupload-2.3.1/js/Moxie.swf', //swf文件，当需要使用swf方式进行上传时需要配置该参数
	    silverlight_xap_url : ctx+'/static/plugins/plupload-2.3.1/js/Moxie.xap', //silverlight文件，当需要使用silverlight方式进行上传时需要配置该参数
	    filters: { //过滤器
	        max_file_size: '200mb',//文件最大尺寸
	        extensions: "jpg,gif,png,svg,doc,docx,xls,xlsx,ppt,pptx,pdf" 
	    },
	    multipart_params:{
	    	versionid:'',
			projectid:'',
			catalogid:'-999999',
			standerfileid:''
	   },
	    init:{
	    	FilesAdded: function(up, files) {
				plupload.each(files, function(file) {
					var fileId=file.id;
					var filename=file.name.split(".");
					var len=filename.length-1;
					var filetype =filename[len];
					if($("#subject").hasClass("easyui-textbox")){
					}
					if($("#subject").hasClass("easyui-textbox")&&fileIndex==0&&$("#subject").textbox("getValue")==""&&fieldCode=="content"){
						$("#subject").textbox("setValue",file.name.substring(0,file.name.length-filetype.length-1));
					}
					if(filetype .substr(filetype.length-1)=='x'){
						filetype =filetype.substr(0,filetype .length-1);
					}
					
					_fileIndexMap[fieldCode]=(_fileIndexMap[fieldCode]++)||0
					fileIndex=_fileIndexMap[fieldCode];
					var tr='<tr id="_localfile_tr_'+fileId+'" class="">'
							+'<input type="hidden" id="fileVersionId'+fileId+'"  class="'+formId+'fileVersionId" value=""/>'
							+'<td style="WORD-WRAP: break-word;border:none;"><a id="td_filename_'+fileId+'"><svg class="icon" aria-hidden="true"> <use xlink:href="#icon-'+(incons.indexOf(filetype)>0?filetype:'file')+'"></use> </svg>'+file.name+'</a></td>'
							+'<td  style="width:100px;border:none;" >'+(file.size?plupload.formatSize(file.size).toUpperCase():"0KB")+'</td>'
							+'<td  style="width:60px;border:none;"  align="center" ><div  id="td_status_'+fileId+'" style="color:blue">0%</div></td>'
							+'<td style="width:35px;border:none;" id="td_remove'+fileId+'"><div class="icon-remove-file" onclick="_localfile_del_fileCommon(\''+fileId+'\')">&nbsp;</div></td>'
							+'</tr>';
					$("#_local_filearray"+fieldId).append(tr);
					fileIndex++;
				});
				_localfile_uploader.start();
			},
			UploadProgress: function(up, file) {
				document.getElementById("td_status_"+file.id).innerHTML = file.percent+"%";
				if(file.percent>99){//上传到服务器并不算上传完成,要等待服务器有返回结果后才算上传完成
					document.getElementById("td_status_"+file.id).innerHTML ="99%";
				}
			},
			FileUploaded:function(uploader,file,responseObject){
				if(responseObject.status==200){//成功
					document.getElementById("td_status_"+file.id).innerHTML ="<div style=\"width:20px\" class=\"end_edit\">&nbsp;</div>";
					$("#fileVersionId"+file.id).val(responseObject.response);
					$("#td_filename_"+file.id).click(function(){
						previewFile({
							versionid:responseObject.response
						})
					})
					
				}else{//失败
					alertError("文件:["+file.name+"]上传失败,请联系管理员");
				}
			},Error:function(uploader,errObject){
				if(errObject.code=="-600"){
					alertInfo("文件大小超过200mb限制");
				}
				console.log(errObject);
			}
	    }
	});    

	//在实例对象上调用init()方法进行初始化
	_localfile_uploader.init();
}
function _localfile_edit_fileCommon(fileId,index){//逻辑删除
	$("#_localfile_tr_" + fileId).hide();
	$("#isUse"+index).val("N");
}
function _localfile_del_fileCommon(fileId){
	$("#_localfile_tr_" + fileId).remove();
	_localfile_uploader.removeFile(fileId);
}
/**
 * 给目标textbox增加回车事件
 * @param targert 选择器
 * @param searchReportBase 回车执行函数
 * @returns
 */
function bindEnterKey(targert,searchReportBase,type){
	if(!type){
		type="textbox";
	}
	$(targert)[type]("textbox").bind('keydown', function(e){
		if (e.keyCode == 13){	// 当按下回车键时接受输入的值。
			searchReportBase();
		}
	});
}