//自定义页面明细置灰
function disableForm(formId) {
    setCss($("#" + formId + " .textbox-f"), "textbox", false, true, false, true, false);
}

/** ***********************选择房屋维修申请信息************************ */
function selectMaMaintainApply() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "请选择房屋维修申请",
        contenturl: '/view/business/ma/MaMaintainApplySelect',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#MaMaintainApplySelect_datagrid').datagrid('getSelected');
            if (r) {
                $('#' + inputobj.inputId).textbox('setValue', r.maintainId);
                $('#' + inputobj.inputId).textbox('setText', r.maintainNo);
                return true;
            } else {
                alertInfo("请选择房屋维修申请");
                return false;
            }
        }
    })
}


/** ***********************选择中介机构信息************************ */
//type为1时单选
function selectMaIntermediariesLibrary(type) {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "请选择中介机构信息",
        contenturl: '/view/business/ma/MaIntermediariesLibrarySelectWin?type=' + type,
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#MaIntermediariesLibrarySelect_datagrid').datagrid('getSelected');
            if (r) {
                $('#' + inputobj.inputId).textbox('setValue', r.intermediariesId);
                $('#' + inputobj.inputId).textbox('setText', r.intermediariesName);
                return true;
            } else {
                alertInfo("请选择中介机构信息");
                return false;
            }
        }
    })
}

/** ***********************选择服务合同信息************************ */
function showGmConWinFun() {

    var inputobj = formatterInputobj(this);
    var serconType = null;
    var serviceNature = null;
    if (inputobj.inputId == "assessmentContractId" || inputobj.inputId == "assessContractId" || inputobj.inputId == "assessmentNo") {
        serconType = 423;
    } else if (inputobj.inputId == "guaranteeContractId") {
        serconType = 424;
    } else if (inputobj.inputId == "maintenanceContractId") {
        serviceNature = 5;
    } else if (inputobj.inputId == "assessmentConId") {
        serviceNature = 4;
    } else if (inputobj.inputId == "repairContractId") {
        serconType = 601;
        // serconType=425;
    } else if (inputobj.inputId == "leaseEvaluationlContractId") {
        serconType = 426;
    } else if (inputobj.inputId == "purchaseContractId") {
        serconType = 420;
    } else if (inputobj.inputId == "pmBidSerconXsId") {
        serconType = 700;
        serviceNature = 6;
    } else {
        serconType = 4;
    }
    openChooseDialog({
        title: "选择信息",
        contenturl: '/view/business/gm/GmconselectFun?serconType=' + serconType + '&serviceNature=' + serviceNature,
        width: 850,
        height: 500,
        okhandler: function () {
            var r = $('#GmConSelect_datagrid').datagrid('getSelected');
            if (r) {
                //$('#lender').val(r.bankId);
                //$('#lender_TEXT').textbox('setValue', r.bankName);
                $('#' + inputobj.inputId).textbox('setValue', r.serconId);
                $('#' + inputobj.inputId).textbox('setText', r.serconName);
                if ($('#GmAssetsMaintenance').length > 0) {

                    $('#maintenanceOrg').val(r.partyB);
                    $('#maintenanceOrg_TEXT_').textbox('setValue', r.partyBText);
                    $('#signDate').datebox('setValue', r.signData);
                } else if ($('#GmAssessmentApply').length > 0) {
                    $('#ratingAgencies').val(r.partyB);
                    $('#ratingAgencies_TEXT_').textbox('setValue', r.partyBText);
                    $('#contacts').textbox('setValue', r.contactName);
                }
                if (serconType == '700') {//销售合同

                    $('#cgOrgId').val(r.partyB);
                    $('#cgOrgId_TEXT_').textbox('setValue', r.partyBText);

                    delAllWGdata();
                    loadEditorGridXSCK(r.serconId);
                }


                return true;
            }
        }
    })
}

/** ***********************选择评估信息************************ */
function showAssessmentWinFun() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择评估信息",
        contenturl: '/view/business/gm/GmAssessmentWinFun',
        width: 850,
        height: 500,
        okhandler: function () {
            var r = $('#AssessmentSelect_datagrid').datagrid('getSelected');

            //var t = $('#MaHouseLibrary_datagrid').datagrid('getSelected');
            if (r) {
                //$('#lender').val(r.bankId);
                //$('#lender_TEXT').textbox('setValue', r.bankName);
                $('#' + inputobj.inputId).textbox('setValue', r.houseId);
                $('#' + inputobj.inputId).textbox('setText', r.houseName);
                return true;
            }
        }
    })
}

/** ***********************选择招标信息************************ */
function showBidWinFun() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择评估信息",
        contenturl: '/view/business/gm/GmBidApplyWinFun',
        width: 850,
        height: 500,
        okhandler: function () {
            var r = $('#BidApplySelect_datagrid').datagrid('getSelected');

            //var t = $('#MaHouseLibrary_datagrid').datagrid('getSelected');
            if (r) {
                //$('#lender').val(r.bankId);
                //$('#lender_TEXT').textbox('setValue', r.bankName);
                $('#' + inputobj.inputId).textbox('setValue', r.bidApplyId);
                $('#' + inputobj.inputId).textbox('setText', r.bidName);
                return true;
            }
        }
    })
}

//项目弹出选择框，只查询负责的项目
function showProjectOnlyme() {
    openChooseDialog({
        title: "选择项目",
        contenturl: '/view/business/pm/pmProjectSelectWin?isMe=Y',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#projectSelect_datagrid').datagrid('getSelected');
            // console.info(r);
            if (r) {
                //单一招标
                autoSetValue("projectName", r.projectName);
                autoSetValue("projectId", r.projectId);
                autoSetValue("bdstName", r.projectName);

                //采购申请
                if ($("#PmBidApplyInside").length > 0) {
                    $("#projectName").val(r.projectName);
                    $("#projectId").textbox('setValue', r.projectId);
                    $("#projectId").textbox('setText', r.projectName);
                }
                return true;
            } else {
                alertInfo("请选择项目");
                return false;
            }
        }
    });
}

/** ***********************选择房产信息************************ */
function showMaHouseSelect() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择房产信息",
        contenturl: '/view/business/ma/MaHouseSelect',
        width: 850,
        height: 500,
        okhandler: function () {
            var r = $('#MaHouseLibrary_datagrid').datagrid('getSelected');

            //var t = $('#MaHouseLibrary_datagrid').datagrid('getSelected');
            if (r) {
                //$('#lender').val(r.bankId);
                //$('#lender_TEXT').textbox('setValue', r.bankName);
                $('#' + inputobj.inputId).textbox('setValue', r.houseId);
                $('#' + inputobj.inputId).textbox('setText', r.houseName);
                return true;
            } else {
                alertInfo("请选择房产信息");
                return false;
            }
        }
    })
}

//租赁合同终止使用。合同执行状态是，执行中；审批状态是，已完成
/*************************租赁合同弹窗 ************************ */
function showRentPmconSelect() {

    var aim1 = $('#aim1').val();

    var formCode = '';
    if ($('#MaLeaseRebate').length > 0) {
        formCode = 'MaLeaseRebate';
    } else if ($('#MaLeaseRebate_FJYX').length > 0) {
        formCode = 'MaLeaseRebate_FJYX';
    } else if ($('#MaLeaseContract').length > 0) {//续租的选择 原租赁合同
        formCode = 'MaLeaseContract';
    }

    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择合同",
        contenturl: '/view/business/ma/MaLeaseContractSelect?aim1=' + aim1 + '&formCode=' + formCode,
        width: 850,
        height: 500,
        okhandler: function () {
            var r = $('#MaLeaseContract_datagrid_select').datagrid('getSelected');
            if (r) {
                $('#' + inputobj.inputId).textbox('setValue', r.contractId);
                $('#' + inputobj.inputId).textbox('setText', r.conNo);
                //选择时赋值。选一个带一片
                $("#lesseeText").textbox("setValue", r.lesseeText);
                $("#lessee").val(r.lessee);

                $("#oldUnit").val(r.oldUnit);
                $("#oldUnit_TEXT_").textbox("setValue", r.oldUnitText);

                $("#houseAddr").textbox("setValue", r.houseAddr);

                // 退租申请人
                $('#rebateAccount').textbox('setValue', r.lesseeText);

                // $('#shouldRefundMoney').numberbox('setValue',r.performanceBond);
                return true;
            } else {
                alertInfo("请选择合同");
                return false;
            }
        }
    })
}


/**
 * 门面弹窗
 * @param 资产类型的区分。 aim 1.aim = 1 房产；2.aim = 2 土地，房屋及建筑物，广告位
 * @returns {function(): void}
 */
function showMaHouseFacadeSelect(aim) {
    return function () {
        showMaHouseFacadeSelect2(aim, this);
    }
}

//多加一层。防止页面内容维护时，配参数。上来就执行
function showMaHouseFacadeSelect2(aim, that) {
    var inputobj = formatterInputobj(that);
    openChooseDialog({
        title: "选择资产",
        contenturl: '/view/business/ma/MaHouseFacadeSelect?aim1=' + aim,
        width: 850,
        height: 500,
        okhandler: function () {
            var r = $('#MaHouseFacade_datagrid').datagrid('getSelected');
            var l = $('#MaHouseLibrary_datagrid').datagrid('getSelected');

            //var t = $('#MaHouseLibrary_datagrid').datagrid('getSelected');
            if (r) {
                //$('#lender').val(r.bankId);
                //$('#lender_TEXT').textbox('setValue', r.bankName);
                $('#' + inputobj.inputId).textbox('setValue', r.facadeId);
                $('#' + inputobj.inputId).textbox('setText', r.facadeName);
                $('#leaseArea').textbox('setValue', r.leaseArea);
                return true;
            } else {
                alertInfo("请选择门面");
                return false;
            }
        }
    })
}

/**
 * 资产风险库弹出框
 * 之前门面巡查任务选择资产风险库，现在不用了
 */
function showMaSafeRiskWinFun() {
    var cel_index = getEndNumberForStr(this.id);
    cel_index = cel_index == null ? '' : cel_index;
    //任务选择。两个页面使用
    openChooseDialog({
        title: "选择资产风险库信息",
        contenturl: '/view/business/ma/MaSafeRiskSelectWin',
        width: 800,
        height: 450,
        okhandler: function () {
            var r = $('#MaSafeRiskSelectWin_datagrid').datagrid('getSelected');

            if (r) {
                $('#riskId' + cel_index).val(r.riskId);
                $('#taskName' + cel_index).textbox('setValue', r.riskName);
                $('#taskNo' + cel_index).textbox('setValue', r.riskNo);
                $('#taskCon' + cel_index).textbox('setValue', r.riskConnect);
                $('#memo' + cel_index).textbox('setValue', r.memo);
                $('#taskLvl' + cel_index).combobox('setValue', r.riskLvl);
                return true;
            } else {
                alertInfo("请选择结果");
                return false;
            }
        }
    })

}


/** ***********************租赁方案弹窗 ************************ */
function showMaLeasePlanSelect() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择方案",
        contenturl: '/view/business/ma/MaLeasePlanSelect',
        width: 850,
        height: 500,
        okhandler: function () {
            var r = $('#MaLeasePlan_datagrid').datagrid('getSelected');

            if (r) {
                //从租赁方案带过来
                //建表，又起错名字了。。。programId
                $('#programId').val(r.leasePlanId);
                $('#programIdText').textbox('setValue', r.proName);
                //$('#facadeId').val(r.facadeId);
                //$('#facadeIdText').textbox('setValue',r.facadeIdText);
                $('#assessMoney').numberbox('setValue', r.assessMoney);
                $('#tenantMoney').numberbox('setValue', r.leaseMoney);
                //租赁方案里租赁开始日期，结束日期。替换成租赁方案明细里拟租的
                $('#tenantStart').datebox('setValue', r.startDate);
                $('#tenantEnd').datebox('setValue', r.endDate);
                $('#purpose').combobox('setValue', r.tenantUse);
                $('#tenantArea').textbox('setValue', r.leaseArea);
                //履约保证金
                $('#bondMoney').numberbox('setValue', r.performanceBond);
                //拟租期限
                $('#tenantYears').numberbox('setValue', r.leaseTerm);
                return true;
            } else {
                alertInfo("请选择方案");
                return false;
            }
        }
    })
}


/*************************招租明细信息弹窗 ************************ */
function showMaRecruitDetailSelect() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择招租明细信息",
        //审批完成的，中标的
        contenturl: '/view/business/ma/MaRecruitDetailSelect?isBid=Y&flowDone=1',
        width: 785,
        height: 350,
        okhandler: function () {
            var r = $('#MaRecruitDetail_datagrid').datagrid('getSelected');
            if (r) {
                $('#recruitDetailId').val(r.recruitDetailId);
                //招租申请的主表编号。租赁合同不存，只是留着显示的
                $('#recruitNo').textbox('setValue', r.recruitNo);
                $('#conStart').datebox('setValue', r.tenantStart);
                $('#conEnd').datebox('setValue', r.tenantEnd);
                $('#leaseNums').textbox('setValue', r.tenantYears);
                // $('#leaseNums').val(r.tenantYears);
                $('#rent').numberbox('setValue', r.ensureMoney);
                $('#leaseArea').numberbox('setValue', r.tenantArea);

                $('#lessee').val(r.lesseeId);
                $('#lessee_TEXT_').textbox('setValue', r.lesseeIdText);
                //合同名称
                $('#conName').textbox('setValue', r.programIdText);

                //字典框
                $('#leasePurpose').combobox('setValue', r.purpose);

                //合同金额
                var ensureMoney = r.ensureMoney;
                var tenantYears = r.tenantYears;
                var conMoney = parseFloat(ensureMoney) * parseFloat(tenantYears);

                $('#conMoney').textbox('setValue', conMoney);

                $('#payeeAccount').textbox('setValue', r.payeeAccount);
                $('#payeeBank').textbox('setValue', r.payeeBank);
                $('#rentCycle').combobox('setValue', r.rentPaymentCycle);

                return true;
            } else {
                alertInfo("请选择招租明细信息");
                return false;
            }
        }
    })
}


/**
 * 银行信息选择框(选择我方银行)
 * 银行账号点击，弹出选择框，赋值账号，密码。
 *
 */
//租赁方案，租赁合同，
function showBasBankWinCommon(orgIdSel) {
    var inputobj = formatterInputobj(this);
    var url = '/view/base/BasBankSelectWin';
    //到账通知单获取当前收款人
    if ($("#FmCreditNote").length > 0) {
        orgIdSel = $('#payeeUnit').combobox('getValue');
    }
    if ($("#FmReceiveTotal").length > 0 || $("#FmNoConReceiveTotal").length > 0 || $("#FmReceive").length > 0) {
        orgIdSel = $('#orgId').combobox('getValue');
    }
    if (orgIdSel != null) {
        url = '/view/base/BasBankSelectWin?orgIdSel=' + orgIdSel + '&isEdit=true';
    }
    openChooseDialog({
        title: "选择银行",
        contenturl: url,
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#BasBankAccountWin_datagrid').datagrid('getSelected');

            if (r) {

                if ($("#FmBillIn").length > 0 || $("#FmFinancialReceivable").length > 0 || $("#FmMarginReceive").length > 0 || $("#FmMarginRefund").length > 0) {
                    $('#bankName').textbox('setValue', r.bankName);
                    $('#bankAccount').textbox('setValue', r.accountNo);

                } else if ($("#FmCreditNote").length > 0) {
                    $('#payeeBank').textbox('setValue', r.bankName);
                    $('#payeeAccount').textbox('setValue', r.accountNo);
                } else if ($("#FmReceiveTotal").length > 0 || $("#FmNoConReceiveTotal").length > 0) {
                    $('#bankName').textbox('setValue', r.bankName);
                    $('#bankAccount').textbox('setValue', r.accountNo);
                    $('#bankId').val(r.bankId);
                    $('#bankAccountId').val(r.bankAccountId);
                } else if ($("#FmAccessApply").length > 0) {
                    $('#bankName').textbox('setValue', r.bankName);
                    $('#bankAccount').textbox('setValue', r.accountNo);
                    $('#bankId').val(r.bankId);
                    $('#bankAccountId').val(r.bankAccountId);
                } else if ($("#GmAssetsReceiveOutWG_LS").length > 0) {
                    $('#payeeBank').textbox('setValue', r.bankName);
                    $('#payeeAccount').textbox('setValue', r.accountNo);
                    $('#payeeBankId').val(r.bankId);
                    $('#payeeAccountId').val(r.bankAccountId);
                } else if ($("#FmReceive").length > 0) {
                    $('#payeeBank').textbox('setValue', r.bankName);
                    $('#payeeAccount').textbox('setValue', r.accountNo);
                } else if ($("#MaCarOperationCostReceive").length > 0) {
                    $('#bankName').textbox('setValue', r.bankName);
                    $('#bankAccount').textbox('setValue', r.accountNo);
                    $('#bankId').val(r.bankId);
                    $('#bankAccountId').val(r.bankAccountId);
                } else {
                    //账号
                    $('#' + inputobj.inputId).textbox('setValue', r.accountNo);
                    //银行。有，则赋值；无，不报错。
                    //收款人的
                    autoSetValue('payeeBank', r.bankName);
                    //承租人的
                    // autoSetValue('lesseeBank',r.bankName);
                }

                return true;
            } else {
                alertInfo("请选择银行");
                return false;
            }
        }
    })
}


/**
 * 现在存银行名称了,不用了;
 * 银行信息选择框(通用)
 * 存储银行id,显示银行名称; 只需两个字段,银行id谁便,银行名称是 银行id+_TEXT_
 */
function showBasBankWinCommons() {
    var inputobj = formatterInputobj(this);

    openChooseDialog({
        title: "选择银行",
        contenturl: '/view/base/BasBankSelectWin',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#BasBankAccountWin_datagrid').datagrid('getSelected');
            if (r) {
                $('#' + inputobj.inputId).val(r.bankId);
                $('#' + inputobj.inputText).textbox('setValue', r.bankName);
                return true;
            } else {
                alertInfo("请选择银行");
                return false;
            }
        }
    })
}

/*******法院选择弹窗***************/
function showBasCourtWinFun() {
    openChooseDialog({
        title: "选择法院",
        contenturl: '/view/sys/basCourtSelectWin',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#basCourtSelect_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue('courtId', r.courtId);
                autoSetValue('courtName', r.courtName);
                if ($("#PmRiskIndicted").length > 0 || $("#PmRiskLawsuit").length > 0) {
                    $("#courtId").textbox("setText", r.courtName);
                }
                return true;
            } else {
                alertInfo("请选择法院");
                return false;
            }
        }
    })
}

/** **********************项目管理员窗口****** */
//对应前台页面内容维护配置的 人员选择框  showEmpWin(1)
function showEmpWin(type) {
    return function () {
        showEmpWinFun(type, this);
    }
}

// 人员选择弹出框(hr_emp表).
//对应前台页面内容维护配置的 人员档案选择框
function showHrEmpWinFun(type, that) {
    if (!that) {
        that = this;
    }
    var inputobj = formatterInputobj(that);
    var str="";
    if(type){
    	str = "?isWin=Y"
    }
    openChooseDialog({
        title: "选择人员",
        contenturl: "/view/sys/hrEmpSelectWin"+str,
        width: 800,
        height: 450,
        okhandler: function () {
            var r = $('#empSelect_datagrid').datagrid('getSelected');
            if (r) {
                //关联hr_emp的id。
                //之前的没关联上。20210120
                if ($("#empManage_form").length > 0) {
                    $('#empName').textbox('setValue', r.EMP_NAME);
                    $('#hrEmpId').val(r.EMP_ID);
                } else {

                    //这一部分原来的方式。不懂逻辑。放else里，保持原来逻辑
                	 $('#' + inputobj.inputId).val(r.EMP_ID);
                     $('#' + inputobj.inputText).textbox('setValue', r.EMP_NAME);
                     //这一部分原来的方式。不懂逻辑。放else里，保持原来逻辑
                   /*  $( "input" ).each( function() {
                         var inputId=$( this ).attr( "id" )+'';//获取id
                         if(inputId.indexOf("_easyui_")<0){
                             for(var data in r){
                                 if(inputId==data){
                                     autoSetValue(data,r[data]);
                                 }else if(inputId==ucfirst(data)){
                                     autoSetValue(inputId,r[data]);
                                 }else if(inputId==ucfirst(data)+'_TEXT_'){
                                     autoSetValue(inputId,r[data]);
                                 }else if(inputId==data+'_TEXT_'){
                                     autoSetValue(inputId,r[data]);
                                 }else if(r[data+'_TEXT_']!=null && inputId==data){
                                     autoSetValue(inputId,r[data+'_TEXT_']);
                                 }
                             }
                         }
                     } );*/
                }

                return true;
            } else {
                alertInfo("请选择人员");
                return false;
            }
        },
        onload: function () {
            $('#empSelect_datagrid').datagrid({
                onDblClickRow: function (index, r) {
                    var btns = $(this).closest('.window').find('.dialog-button .l-btn-small');
                    if (btns.length > 0) {
                        $(btns[0]).click();
                    }

                }

            })
        }
    })

}

function ucfirst(str) {
    str = str.toLowerCase();
    var kk = str.split('_');
    if (kk.length > 1) {
        var result = '';
        result = kk[0] + kk[1].substring(0, 1).toUpperCase() + kk[1].substring(1) + '';
        return result;
    } else {
        return str;
    }
}

// 人员选择弹出框
function showEmpWinFun(type, that) {
    var orgId = "";
    if (!that) {
        that = this;
    }
    var inputobj = formatterInputobj(that);
    if ($('#FmFinancialReceivable').length > 0) {
        orgId = $('#payee').combobox('getValue');
    }
    $.get(ctx + '/view/sys/empSelectWin?type=' + type + '&orgId=' + orgId, function (str) {
        var epmIndex = layer.open({
            type: 1,
            title: "<span class='icon iconfont icon-renshifenxi blue2'></span>人员选择",
            closeBtn: 1, //不显示关闭按钮
            btn: ['确定', '清空', '关闭'],
            //skin: 'layui-layer-qllan',
            area: ['800px', $("body").height() > 600 ? '560px' : $("body").height() + "px"],
            content: str, //iframe的url，no代表不显示滚动条
            btn2: function () {
                $('#' + inputobj.inputId).val('');
                $('#' + inputobj.inputText).textbox('setValue', '');
                if ($("#GmAssetsAdjustment").length > 0) {
                    if ('management' == inputobj.inputId) {
                        $('#manageOrg').combobox('clear');
                        $('#manageDept').val('');
                        $('#manageDept_TEXT_').textbox('clear');
                    } else if ('useAccount' == inputobj.inputId) {
                        $('#useDept').val('');
                        $('#useDept_TEXT_').textbox('clear');
                    }
                }
                if ('manageAccount' == inputobj.inputId) {
                    $('#manageOrg').combobox('clear');
                    $('#manageDept').val('');
                    $('#manageDept_TEXT_').textbox('clear');
                }
                if (haseasyui('#manageOrg') && haseasyui('#manageDept')) {
                    $('#manageOrg').combobox('clear');
                    $('#manageDept').val('');
                    $('#manageDept_TEXT_').textbox('clear');
                }
                if ('safekeepingAccount' == inputobj.inputId) {
                    $('#safekeepingDept').val('');
                    $('#safekeepingDept_TEXT_').textbox('clear');
                }
                if ($("#GmAssetsInventory").length > 0) {
                    autoSetValue('manageOrg', '');
                    autoSetValue('manageDept', '');
                } else if ($("#GmInventoryApply").length > 0) {
                    autoSetValue('supervisDept', '');
                } else if ($("#GmSealKZ").length > 0) {
                    autoSetValue('applyOrg', '');
                    autoSetValue('deptId', '');
                } else if ($("#feeDetailList").length > 0) {
                    var feeDIndex = inputobj.inputId.replace("writerByText", "");
                    $('#writerBy' + feeDIndex).val('');
                    $('#writerByText' + feeDIndex).textbox('clear');
                    $('#orgId' + feeDIndex).combobox('clear');
                    $('#deptId' + feeDIndex).combobox('clear');
                } else {
                    $('#applyDept').val('');
                    $('#applyOrg').val('');
                    autoSetValue("issueDept", '');
                    autoSetValue("issueDept_TEXT_", '');
                }
            },
            yes: function (index, layero) {
                var r = $('#empSelect_datagrid' + (empWinSelectIndex == 1 ? '1' : '')).datagrid('getSelected');
                if (r) {
                    var fcode = $('#assetsCatagory').val();


                    if ($("#HrEmpstateChangesDD").length > 0) {
                        $('#' + inputobj.inputId).val(r.ACCOUNT_ID);
                        $('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
                        $('#deptId').combobox('setValue', r.DEPT_ID);
                    }
                    // 人员异动
                    if ($("#HrEmpstateChangesLZ").length > 0) {
                        $('#' + inputobj.inputId).val(r.ACCOUNT_ID);
                        $('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
                        $('#deptId').combobox('setValue', r.DEPT_ID);
                        $('#presentJob').textbox('setValue', r.PRESENT_JOB_TEXT_);
                    }
                    if ($("#HrDesertApply").length > 0) {
                        $('#' + inputobj.inputId).val(r.ACCOUNT_ID);
                        $('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
                        $('#oldDeptId').combobox('setValue', r.DEPT_ID);
                        $('#oldStation').textbox('setValue', r.PRESENT_JOB_TEXT_);
                    }
                    if ($("#GmAssetsAdjustment").length > 0) {
                        if ('management' == inputobj.inputId) {
                            $('#' + inputobj.inputId).val(r.ACCOUNT_ID);
                            $('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
                            $('#manageOrg').combobox('setValue', r.ORG_ID);
                            $('#manageOrg').combobox('setText', r.OBS_NAME);
                            $('#manageDept').val(r.DEPT_ID);
                            $('#manageDept_TEXT_').textbox('setValue', r.DEPT_NAME);
                        } else if ('useAccount' == inputobj.inputId) {
                            $('#' + inputobj.inputId).val(r.ACCOUNT_ID);
                            $('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
                            $('#useDept').val(r.DEPT_ID);
                            $('#useDept_TEXT_').textbox('setValue', r.DEPT_NAME);
                        }
                        return true;
                    }
                    if ('manageAccount' == inputobj.inputId) {
                        $('#' + inputobj.inputId).val(r.ACCOUNT_ID);
                        $('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
                        $('#manageOrg').combobox('setValue', r.ORG_ID);
                        $('#manageOrg').combobox('setText', r.OBS_NAME);
                        $('#manageDept').val(r.DEPT_ID);
                        $('#manageDept_TEXT_').textbox('setValue', r.DEPT_NAME);
                    }
                    if (haseasyui('#manageOrg') && haseasyui('#manageDept')) {
                        $('#' + inputobj.inputId).val(r.ACCOUNT_ID);
                        $('#' + inputobj.inputText).textbox('setValue',
                            r.ACCOUNT_NAME);
                        $('#manageOrg').combobox('setValue', r.ORG_ID);
                        $('#manageOrg').combobox('setText', r.OBS_NAME);
                        $('#manageDept').val(r.DEPT_ID);
                        $('#manageDept_TEXT_').textbox('setValue', r.DEPT_NAME);
                        return true;
                    }
                    if ('safekeepingAccount' == inputobj.inputId) {
                        $('#' + inputobj.inputId).val(r.ACCOUNT_ID);
                        $('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
                        $('#safekeepingDept').val(r.DEPT_ID);
                        $('#safekeepingDept_TEXT_').textbox('setValue', r.DEPT_NAME);
                        return true;
                    }
                    if ($("#GmAssetsInventory").length > 0) {
                        $('#' + inputobj.inputId).val(r.ACCOUNT_ID);
                        $('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
                        autoSetValue('manageOrg', r.ORG_ID);
                        autoSetValue('manageDept', r.DEPT_ID);
                    } else if ($("#GmInventoryApply").length > 0) {
                        $('#' + inputobj.inputId).val(r.ACCOUNT_ID);
                        $('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
                        autoSetValue('supervisDept', r.DEPT_ID);
                    } else if ($("#GmSealKZ").length > 0) {
                        $('#' + inputobj.inputId).val(r.ACCOUNT_ID);
                        $('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
                        autoSetValue('applyOrg', r.ORG_ID);
                        autoSetValue('deptId', r.DEPT_ID);
                    } else if ($("#feeDetailList").length > 0) {

                        //获取当前下标

                        var feeDIndex = inputobj.inputId.replace("writerByText", "");
                        $('#writerBy' + feeDIndex).val(r.ACCOUNT_ID);
                        $('#writerByText' + feeDIndex).textbox('setValue', r.ACCOUNT_NAME);
                        $('#orgId' + feeDIndex).combobox('setValue', r.ORG_ID);
                        $('#deptId' + feeDIndex).combobox('setValue', r.DEPT_ID);
                    } else {
                        $('#' + inputobj.inputId).val(r.ACCOUNT_ID);
                        $('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
                        $('#applyDept').val(r.DEPT_ID);
                        $('#applyOrg').val(r.ORG_ID);
                        autoSetValue("issueDept", r.DEPT_ID);
                        autoSetValue("issueDept_TEXT_", r.DEPT_NAME);
                    }
                    layer.close(index);
                    return true;
                } else {
                    alertInfo("请选择人员");
                    return false;
                }
            },
            success: function (layero, index) {
            },
            end: function () {
                $(".todolist.intervalRefresh").closest(".layui-card").find(".refresh").trigger("click");
            }
        });
    });
//    openChooseDialog({
//        title: "选择人员",
//        contenturl: '/view/sys/empSelectWin?type=' + type+'&orgId='+orgId,
//
//        width: 800,
//        height: 450,
//        okhandler: function () {
//            var r = $('#empSelect_datagrid').datagrid('getSelected');
//            if (r) {
//            	var fcode = $('#assetsCatagory').val();
//            	if($("#GmAssetsAdjustment").length>0){
//            		if('management'==inputobj.inputId){
//            			$('#' + inputobj.inputId).val(r.ACCOUNT_ID);
//                		$('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
//                	    $('#manageOrg').combobox('setValue',r.ORG_ID);
//                		$('#manageOrg').combobox('setText',r.OBS_NAME);
//                		$('#manageDept').val(r.DEPT_ID);
//                		$('#manageDept_TEXT_').textbox('setValue',r.DEPT_NAME);
//            		}else if('useAccount'==inputobj.inputId){
//            			$('#' + inputobj.inputId).val(r.ACCOUNT_ID);
//                		$('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
//            			$('#useDept').val(r.DEPT_ID);
//            			$('#useDept_TEXT_').textbox('setValue',r.DEPT_NAME);
//            		}
//            		return true;
//            	}
//            	if('manageAccount'==inputobj.inputId){
//        			$('#' + inputobj.inputId).val(r.ACCOUNT_ID);
//            		$('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
//            	    $('#manageOrg').combobox('setValue',r.ORG_ID);
//            		$('#manageOrg').combobox('setText',r.OBS_NAME);
//            		$('#manageDept').val(r.DEPT_ID);
//            		$('#manageDept_TEXT_').textbox('setValue',r.DEPT_NAME);
//        		}
//				if (haseasyui('#manageOrg') && haseasyui('#manageDept')) {
//					$('#' + inputobj.inputId).val(r.ACCOUNT_ID);
//					$('#' + inputobj.inputText).textbox('setValue',
//							r.ACCOUNT_NAME);
//					$('#manageOrg').combobox('setValue', r.ORG_ID);
//					$('#manageOrg').combobox('setText', r.OBS_NAME);
//					$('#manageDept').val(r.DEPT_ID);
//					$('#manageDept_TEXT_').textbox('setValue', r.DEPT_NAME);
//					return true;
//				}
//				if ('safekeepingAccount' == inputobj.inputId) {
//					$('#' + inputobj.inputId).val(r.ACCOUNT_ID);
//					$('#' + inputobj.inputText).textbox('setValue',r.ACCOUNT_NAME);
//					$('#safekeepingDept').val(r.DEPT_ID);
//					$('#safekeepingDept_TEXT_').textbox('setValue', r.DEPT_NAME);
//					return true;
//				}
//            	if($("#GmAssetsInventory").length>0){
//            		 $('#' + inputobj.inputId).val(r.ACCOUNT_ID);
//                     $('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
//                     autoSetValue('manageOrg',r.ORG_ID);
//                     autoSetValue('manageDept',r.DEPT_ID);
//            	}else if($("#GmInventoryApply").length>0){
//           		 $('#' + inputobj.inputId).val(r.ACCOUNT_ID);
//                    $('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
//                    autoSetValue('supervisDept',r.DEPT_ID);
//           	    }else if($("#GmSealKZ").length>0){
//              		 $('#' + inputobj.inputId).val(r.ACCOUNT_ID);
//                     $('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
//                     autoSetValue('applyOrg',r.ORG_ID);
//                     autoSetValue('deptId',r.DEPT_ID);
//            	}else if($("#feeDetailList").length>0){
//
//            		//获取当前下标
//
//           		var feeDIndex = inputobj.inputId.replace("writerByText","");
//              		 $('#writerBy'+feeDIndex).val(r.ACCOUNT_ID);
//                     $('#writerByText'+feeDIndex).textbox('setValue', r.ACCOUNT_NAME);
//                     $('#orgId'+feeDIndex).combobox('setValue',r.ORG_ID);
//                     $('#deptId'+feeDIndex).combobox('setValue',r.DEPT_ID);
//            	}else{
//            		$('#' + inputobj.inputId).val(r.ACCOUNT_ID);
//            		$('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
//            		$('#applyDept').val(r.DEPT_ID);
//            		$('#applyOrg').val(r.ORG_ID);
//            		autoSetValue("issueDept",r.DEPT_ID);
//            		autoSetValue("issueDept_TEXT_",r.DEPT_NAME);
//            	}
//                return true;
//            } else {
//                alertInfo("请选择人员");
//                return false;
//            }
//        },
//        onload: function () {
//            $('#empSelect_datagrid').datagrid({
//                onDblClickRow: function (index, r) {
//                    var btns = $(this).closest('.window').find('.dialog-button .l-btn-small');
//                    if (btns.length > 0) {
//                        $(btns[0]).click();
//                    }
//                }
//
//            })
//        }
//    })

}

/** ***********************人员选择多选 用于可编辑列的弹窗************************ */
function showMultiEmpEditWin(type) {
    return function () {
        showMultiEmpWinEditFun(type, this);
    }
}

// 人员选择弹出框 多选
function showMultiEmpWinEditFun(type, that) {
    if (!that) {
        that = this;
    }
    var inputobj = formatterInputobj(that);
    var contenturl = '/view/sys/empMultiSelectWin?type=' + type;
    // 修改--获取人员id 和 name
    var index = getEndNumberForStr(that.id);
    var names = $('#' + inputobj.inputText).val();
    var ids = $('#' + inputobj.inputId + index).val();

    openChooseDialog({
        title: "选择人员",
        contenturl: contenturl,
        width: 1070,
        height: 450,
        okhandler: function () {
            var rows = $('#choosegrid').datagrid('getRows');
            if (rows) {
                var conids = [];
                var connames = [];
                for (var i = 0; i < rows.length; i++) {
                    conids.push(rows[i].ACCOUNT_ID);
                    connames.push(rows[i].ACCOUNT_NAME);
                }
                $('#' + inputobj.inputId + index).val(conids);
                $('#' + inputobj.inputText).textbox('setValue', connames);
                return true;
            } else {
                alertInfo("请选择人员");
                return false;
            }
        },
        onload: function () {
            if (names != null && names != "") {
                var namesArray = names.split(',');
                var idsArray = ids.split(',');
                for (var i = 0; i < namesArray.length; i++) {
                    $('#choosegrid').datagrid('appendRow', {
                        ACCOUNT_ID: idsArray[i],
                        EMP_CODE: idsArray[i],
                        ACCOUNT_NAME: namesArray[i]
                    })
                }
            }

        }
    })

}

/**
 * 人员弹出选择框
 * 无左边单位部门树。自己传登陆人单位id，部门id
 * isViceStation 是否关联副岗
 */
function showEmpWinFunNoTree() {
    var inputobj = formatterInputobj(this);

    var orgId = orgId_;
    var deptId = deptId_;
    var isViceStation = 'N';


    openChooseDialog({
        title: "选择人员",
        contenturl: '/view/sys/empSelectWinNoTree?isViceStation=' + isViceStation + '&orgId=' + orgId + '&deptId=' + deptId,
        width: 800,
        height: 450,
        okhandler: function () {
            var r = $('#empSelect_datagrid').datagrid('getSelected');
            if (r) {
                $('#' + inputobj.inputId).val(r.ACCOUNT_ID);
                $('#' + inputobj.inputText).textbox('setValue', r.ACCOUNT_NAME);
                return true;
            } else {
                alertInfo("请选择人员");
                return false;
            }
        },
        onload: function () {

        }
    })

}

//roleId过滤角色id
//isHaveOrgAndRole 是否需要过滤 登录人与角色
function showMultiEmpWin(type, roleId, isHaveOrgAndRole) {
    return function () {
        showMultiEmpWinFun(type, this, roleId, isHaveOrgAndRole);
    }
}

// 人员选择弹出框 多选
function showMultiEmpWinFun(type, that, roleId, isHaveOrgAndRole) {
    var resultObj = null;
    if (!that) {
        that = this;
    }
    var inputobj = formatterInputobj(that);

    if (inputobj.inputId.indexOf("sendOrRevPersion") > -1) { //列表使用
        inputobj = gridFormatterInputobj(that);
    }

    var contenturl = '/view/sys/empMultiSelectWin?type=' + type + "&roleId=" + roleId + "&isHaveOrgAndRole=" + isHaveOrgAndRole;
    if ($("#HrAttendanceTeam").length > 0) {
        contenturl += "&deptIds=" + $("#attendanceDept").val()
    }
    if ($("#GmInventoryApply").length > 0) {
        if ($("#inventoryOrg").combobox('getValue') != '' & $("#inventoryOrg").combobox('getValue') != null) {
            contenturl += "&inventoryOrg=" + $("#inventoryOrg").combobox('getValue');
        } else {
            alertInfo("请选择盘点单位");
            return false;
        }
    }
    // 修改--获取人员id 和 name
    var names = $('#' + inputobj.inputText).val();
    var ids = $('#' + inputobj.inputId).val();
    if ($('#HrAssessmentUser').length > 0) {
        var index = getEndNumberForStr(that.id);
        names = $('#assessdByText' + index).val();
        ids = $('#assessdBy' + index).val();
    }
    // if (ids){
    //换个值。换个范围
    openChooseDialog({
        title: "选择人员",
        contenturl: contenturl,
        width: 970,
        height: 560,
        okhandler: function () {
            var rows = $('#choosegrid').datagrid('getRows');
            if (rows) {
                var conids = [];
                var connames = [];
                for (var i = 0; i < rows.length; i++) {
                    conids.push(rows[i].ACCOUNT_ID);
                    connames.push(rows[i].ACCOUNT_NAME);
                }
                if ($('#BFcLandPartol_Form').length > 0) {
                    $('#inspectOneId').val(conids);
                    $('#inspectOneName').textbox('setValue', connames);
                } else if ($('#BFcHousePartolform').length > 0) {
                    $('#inspectOneId').val(conids);
                    $('#inspectOneName').textbox('setValue', connames);
                } else if (inputobj.inputId.indexOf("sendOrRevPersion") > -1) {
                    $("#" + inputobj.inputText).textbox("setValue", connames);
                    $("#" + inputobj.inputId).val(conids);
                } else if ($('#GmInventoryApply').length > 0) {
                    $("#inventoryAccount").val(conids);
                    $("#inventoryAccountText").textbox("setValue", connames);
                } else if ($('#HrAssessmentUser').length > 0) {
                    var index = getEndNumberForStr(that.id);
                    $('#assessdBy' + index).val(conids);
                    $('#assessdByText' + index).textbox('setText', connames);
                } else {
                    $('#' + inputobj.inputId).val(conids);
                    $('#' + inputobj.inputText).textbox('setValue', connames);
                }
                return true;
            } else {
                alertInfo("请选择人员");
                return false;
            }
        },
        onload: function () {
            if (names != null && names != "") {
                var namesArray = names.split(',');
                var idsArray = ids.split(',');
                //1.id一次查一个

                //2.传id的string，查所有
                //遍历结果。拼上choosegrid
                $.ajax({
                    url: ctx + "/HrEmp/findEmpByAccountIds",
                    data: {
                        accountIds: ids
                    },
                    dataType: 'json',
                    success: function (result) {
                        resultObj = result;
                        if (resultObj) {
                            for (var i = 0; i < resultObj.length; i++) {
                                if (idsArray.indexOf(resultObj[i].accountId.toString()) != -1) {
                                    //页面存储的ids，出来的idsArray顺序和查出来的顺序不一样

                                    $('#choosegrid').datagrid('appendRow', {
                                        ACCOUNT_ID: resultObj[i].accountId,
                                        EMP_CODE: resultObj[i].empCode,
                                        ACCOUNT_NAME: resultObj[i].accountName,
                                        OBS_NAME: resultObj[i].orgIdText,
                                        DEPT_NAME: resultObj[i].deptIdText
                                    })
                                }
                            }
                        }

                    }
                });
            }

        }


    })

    // }

}


/** **********************往来单位类别弹窗******************** */
function showContactOrgTypeWinFun() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择单位类别",
        contenturl: '/view/sys/contactOrgTypeSelectWin',
        width: 600,
        height: 450,
        okhandler: function () {
            var r = $('#contactOrgTypeSelect_datagrid').datagrid('getSelected');
            if (r) {
                $('#' + inputobj.inputId).val(r.CONTACT_ORG_TYPE_ID);
                $('#' + inputobj.inputText).textbox('setValue', r.CONTACT_ORG_TYPE_NAME);
                return true;
            } else {
                alertInfo("请选择单位类别");
                return false;
            }
        }
    })
}

/***onClickButton:showContactOrgWin(null,2) （自定义弹框）
 * type 2是个人；默认的是供应商(往来单位弹框)**/
/** ***********************往来单位弹出窗 ************************ */
function showContactOrgWin(code, type) {
    return function () {
        showContactOrgWinFun(this, code, type);
    }
}

function showContactOrgWinFun(that, code, type) {
//	type = type||'';
    var type = type == null ? 1 : type;
    code = code || '';
    var contenturl = '/view/pub/PubContactOrgFormSelectWin?code=' + code + "&type=" + type;
    var inputobj = formatterInputobj(that);
    var inputform = $(that).closest("form");
    var fcode = that.form.id;
    openChooseDialog({
        title: "单位选择",
        contenturl: contenturl,
        width: 1000,
        height: 450,
        okhandler: function () {
            var r = $('#PubContactOrgSelect_datagrid').datagrid('getSelected');
            if (r) {
                // $('#'+inputobj.inputId).val(r.contactOrgId);
                if (type == 2) {//个人时
                    $('#' + inputobj.inputId).textbox('setValue', r.contactOrgId);
                    $('#' + inputobj.inputId).textbox('setText', r.contactOrgName);
                } else {//供应商
                    if (inputobj.inputId == "ratingAgencies") {
                        $('#' + inputobj.inputId).val(r.contactOrgId);
                        $('#' + inputobj.inputText).textbox('setValue', r.contactOrgName);
                        $('#contacts').textbox('setValue', r.contactName);
                        $('#contactNumber').textbox('setValue', r.contactTel);
                    } else {

                        $('#' + fcode + ' #' + inputobj.inputId).val(r.contactOrgId);
                        $('#' + fcode + ' #' + inputobj.inputText).textbox('setValue', r.contactOrgName);
                    }
                    if ($('#PmBidSercon').length > 0) {
                        $.ajax({
                            url: ctx + "/PubContactOrgAccount/getBanksByContactOrgId",
                            data: {
                                contactOrgId: r.contactOrgId
                            },
                            dataType: 'json',
                            success: function (result) {
                                if (true == result.success) {
                                    $('#payeeBank').textbox('setValue', result.o.orgOpenBank);
                                    $('#payeeAccount').textbox('setValue', result.o.orgBankAccount);
                                } else {
                                    $('#payeeBank').textbox('setValue', '');
                                    $('#payeeAccount').textbox('setValue', '');
                                    alertInfo("该单位目前没有开户及行账号信息");
                                    return false;
                                }
                            }
                        });
                    }
                }
                if (r.workflowStatus == null) {
                    //临时新增的数据。还要再对应的保存方法里判断
                    alertInfo("该数据还没有审批，请别忘了审批");
                }

                return true;
            } else {
                alertInfo("请选择一个单位");
                return false;
            }
        },
        bottons: [{
            text: '清空',
            iconCls: 'icon-del blue iconfont',
            handler: function () {
                $('#' + inputobj.inputId).val("");
                $('#' + inputobj.inputText).textbox('setValue', "");
                var d = $(this).closest('.window').find('.window-body');
                d.dialog('destroy');
            }
        }]

    })
}

/****************************************采购合同供应商账户信息弹窗 start****************************************************/
function selectAccountDataByContractOrgId(contactOrgId) {
    if ($('#PmBidSercon').length > 0) {
        contactOrgId = $('#partyB').val();
        if (!contactOrgId) {
            alertInfo("请先选择乙方单位");
            return false;
        }
    } else if ($('#FmInvoiceOutApply').length > 0) {
        contactOrgId = $('#conContractOrg').val();
        if (!contactOrgId) {
            alertInfo("请先选择合同名称");
            return false;
        }
    }
    openChooseDialog({
        title: "选择往来单位开户行信息",
        contenturl: '/view/pub/PubOrgAccountSelect?contactOrgId=' + contactOrgId,
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#PubOrgAccountSelect_datagrid').datagrid('getSelected');
            if (r) {
                if ($('#FmInvoiceOutApply').length > 0) {
                    autoSetValue('openBank', r.orgOpenBank);
                    autoSetValue('bankAccount', r.orgBankAccount);
                } else {
                    autoSetValue('bankName', r.orgOpenBank);
                    autoSetValue('bankAccount', r.orgBankAccount);
                }

                return true;
            } else {
                alertInfo("请选择开户行信息");
                return false;
            }
        }
    })
}

/** ***********************往来单位窗口 多选******************** */
function showContactOrgMultiWin(code) {
    return function () {
        showContactOrgMultiWinFun(this);
    }
}

//往来单位弹出框
function showContactOrgMultiWinFun(that) {
    var inputobj = formatterInputobj(that);
    openChooseDialog({
        title: "选择供应商",
        contenturl: '/view/pub/PubContactOrgFormSelectWin?multi=1',
        width: 1000,
        height: 450,
        okhandler: function () {
            var rows = $('#PubContactOrgSelect_datagrid').datagrid('getSelections');
            if (rows && rows.length > 0) {
                var conids = [];
                var connames = [];
                for (var i = 0; i < rows.length; i++) {
                    conids.push(rows[i].contactOrgId);
                    connames.push(rows[i].contactOrgName);
                }
                $('#' + inputobj.inputId).val(conids.join(","));
                $('#' + inputobj.inputText).textbox('setValue', connames.join(","));
                return true;
            } else {
                alertInfo("请选择单位");
                return false;
            }
        },
        bottons: [{
            text: '清空',
            iconCls: 'icon-del blue iconfont',
            handler: function () {
                $('#' + inputobj.inputId).val("");
                $('#' + inputobj.inputText).textbox('setValue', "");
                var d = $(this).closest('.window').find('.window-body');
                d.dialog('destroy');
            }
        }]
    })
}

function showContactOrgFun1Win(that, code, type) {
    return function () {
        showContactOrgWinFun1(this, code, type);
    }
}

/**
 * 子表的往来单位选择框
 * 用法参考：MaHydropowerIncomeDetail
 * @param that 默认this
 * @param code
 * @param type 1:供应商,2:客户
 */
function showContactOrgWinFun1(that, code, type) {
    type = type || '';
    code = code || '';

    var contenturl = '/view/pub/PubContactOrgFormSelectWin?code=' + code + '&type=' + type;

    var inputobj = formatterInputobj(that);
    openChooseDialog({
        title: "单位选择",
        contenturl: contenturl,
        width: 1000,
        height: 450,
        okhandler: function () {
            var r = $('#PubContactOrgSelect_datagrid').datagrid('getSelected');
            if (r) {
                if ($('#PubContactAlt').length > 0) {
                    $('#' + inputobj.inputId).textbox('setValue', r.contactOrgName);
                    $('#versionNo').textbox('setValue', (r.versionNo + 1));
                    $('#contactOrgId').val(r.contactOrgId);
                } else {
                    $('#' + inputobj.inputId).textbox('setValue', r.contactOrgId);
                    $('#' + inputobj.inputId).textbox('setText', r.contactOrgName);
                }
                return true;
            } else {
                alertInfo("请选择一个单位");
                return false;
            }
        }
    })
}


/** **********************项目类别弹窗******************** */
function showProjectTypeWinFun() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择项目类别",
        contenturl: '/view/biz/pm/pmProjectWithTypeSelectWin?treeToProject=false',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#projectSelect_datagrid').datagrid('getSelected');
            if (r) {
                $('#' + inputobj.inputId).val(r.PROJECT_ID);
                $('#' + inputobj.inputText).textbox('setValue', r.PROJECT_NAME);
                return true;
            } else {
                alertInfo("请选择项目类别");
                return false;
            }
        }
    })
}


/** **********************已立项项目弹窗 start******************** */
function showProjectWinFun() {
    var inputobj = formatterInputobj(this);
    var chooseType = '';
    if ($('#PmContactOrgChoose').length > 0) {
        chooseType = $("#chooseType").combobox('getValue')
    }
    // var year=$("#planYear").yearbox('getValue');
    openChooseDialog({
        title: "选择项目",
        contenturl: '/view/business/pm/pmProjectSelectWin?formCode=' + _currentFormCode + '&chooseType=' + chooseType + '&workflowStatus=3',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#projectSelect_datagrid').datagrid('getSelected');
            if (r) {
                projectSelect(r, inputobj.inputText);
                return true;
            } else {
                alertInfo("请选择项目");
                return false;
            }
        }
    })
}

// 合同公共弹窗选择赋值和加载时间
function projectSelect(r, textId, notreload) {
    $('#projectId').val(r.projectId);
    autoSetValue("projectId", r.projectId);
    if (textId && $("#" + textId).hasClass("easyui-textbox")) {
        $("#" + textId).textbox("setText", r.projectName);
    }
    autoSetValue("projectId_TEXT_", r.projectName);
    autoSetValue("projectName", r.projectName);
    autoSetValue("projectCode", r.projectCode);
    autoSetValue("projectTypeId", r.projectTypeId);
    autoSetValue("projectSubclass", r.projectSubclass);
    autoSetValue("constructUnit", r.constructUnit);
    autoSetValue("constructUnit_TEXT_", r.constructUnitText);
    autoSetValue("projectAbbr", r.projectAbbr);
    autoSetValue("constructType", r.constructType);
    if ($("#PmDesignScheme").length === 0) {//总平方案页面不带入
        autoSetValue("investEstimate", r.investEstimate);
    }
    if ($("#PmProjectAuditMain").length > 0) {
        $('#projectId').textbox('setText', r.projectName);
    }
    autoSetValue("consultUnit", r.paymentUnit);
    autoSetValue("projectPlanId", "");
    autoSetValue("projectScale", r.projectScale);
    autoSetValue("projectInvest", r.investEstimate);
    autoSetValue("totalInvest", r.investEstimate);
    autoSetValue("investLyear", r.investEstimate);
    // 标段划分弹窗使用
    autoSetValue("bdstName", r.projectName);
    autoSetValue("investPlan", r.investEstimate);
    autoSetValue("regionId", r.regionId);
    autoSetValue("startDate", r.beginDate);
    autoSetValue("finishDate", r.endDate);
// autoSetValue("createAccount", r.createAccount);
    autoSetValue("projectMgr", r.projectMgr);
    autoSetValue("projectMgr_TEXT_", r.projectMgrText);
    if ($("#regionId").length > 0) {
        $("#regionId").val(r.regionId);
    }
    // 工程款支付申请
    if ($('#FmProjectPay').length > 0) {
        $("#" + textId).textbox("setValue", r.projectId);
        $("#" + textId).textbox("setText", r.projectName);
        $('#chargeBy_TEXT_').textbox('setValue', r.projectMgrText);
        $('#chargeBy').val(r.projectMgr);
        reloadMoneyByMonth();
    }
    autoSetValue("addr", r.addr);
    autoSetValue("positionInfo", r.positionInfo);
    // 刷新阶段附件面板-待实现
    if (_currentFormCode && stageId && !notreload) {
        $('.stageTypeFile').panel(
            'refresh',
            ctx + "/GenForm/reloadFileList?formcode="
            + _currentFormCode + "&isdetail=false&stageId="
            + stageId + "&projectId=" + r.projectId);
    }
    if ($('#PmProjectSetup').length > 0) {
        $('#PmProjectSetup').form("load", r);
        autoSetValue("processinstid", "");
        autoSetValue("workflowStatus", "");
    }
    // 商品房预售许可阵
    if ($('#PmPresalePermit').length > 0) {
        $.ajax({
            url: ctx + '/PmProject/getPermitNoByProjectId',
            type: "POST",
            data: {
                id: r.projectId
            },
            dataType: "json",
            success: function (result) {
                if (result.success) {
                    $('#landPermitNo').textbox('setValue', result.o.landPermitNo);
                    $('#landNo').textbox('setValue', result.o.licenceNos);
                    $('#buildingPermitNo').textbox('setValue', result.o.buildingPermitNo);
                    $('#builderPermitNo').textbox('setValue', result.o.builderPermitNo);
                } else {

                }

            }
        })
    }

    // 1 方案设计审查 2 施工图设计 刷新设计合同下拉框 combobox
    if ($('#PmDesignScheme').length > 0 || $('#PmDesignDrawing').length > 0 || $('#PmDesignInitial').length > 0) {
        changeCSS($('#pmconId'), "remove", "combobox");
        // $('#pmconId').combobox({required:true});
        if ($("#pmconId").hasClass("easyui-combobox")) {
            $('#pmconId').combobox('clear');
            $('#pmconId').combobox('reload', ctx + '/PmPmcon/getPmconByProjectId?projectId=' + r.projectId + '&pmconType=SJHT&isFixed=1');
        }
    }

    // 用地规划许可证
    if ($("#PmLandPermit").length > 0) {
        $.ajax({
            url: ctx + '/PmProjectSite/getPmProjectSiteByProjectId',
            type: "POST",
            data: {
                id: r.projectId
            },
            dataType: "json",
            success: function (result) {
                if (result.success) {
                    console.info(result);
                    if (result.o != null) {
                        $("#addr").textbox('setValue', result.o.addr);
                        $("#area").numberbox('setValue', result.o.area);
                        $("#scale").textbox('setValue', result.o.scale);
                    }
                } else {
                    alertError(result.msg)
                }
            }
        })
    }

    // 土地划拨书的信息从 选址意见书带出
    if ($("#PmLandAllotted").length > 0) {
        $.ajax({
            url: ctx + '/PmProjectSite/getPmProjectSiteByProjectId',
            type: "POST",
            data: {
                id: r.projectId
            },
            dataType: "json",
            success: function (result) {
                if (result.success) {
                    console.info(result);
                    if (result.o != null) {
                        $("#landArea").numberbox('setValue', result.o.area);
                        $("#addr").numberbox('setValue', result.o.addr);
                    }
                } else {
                    alertError(result.msg)
                }
            }
        })
    }

    // 土地证坐落位置、土地性质、使用权类型从土地划拨书带过来
    if ($("#PmLandCard").length > 0) {
        $.ajax({
            url: ctx + '/PmLandAllotted/getPmLandAllottedByProjectId',
            type: "POST",
            data: {
                id: r.projectId
            },
            dataType: "json",
            success: function (result) {
                if (result.success) {
                    console.info(result);
                    if (result.o != null) {
                        $("#positionInfo").var(result.o.positionInfo);
                        $("#addr").textbox('setValue', result.o.addr);
                        $("#landNature").combobox('setValue', result.o.positionInfo);
                        $("#usufructType").combobox('setValue', result.o.usufructType);
                    }
                } else {
                    alertError(result.msg)
                }
            }
        })
    }

    // 财政预算资金
    if ($('#PmPayPlan').length > 0) {
        $('#projectType').textbox('setValue', record.attributes.typename);
        $('#constructType').combobox('setValue', record.attributes.programtype);
        $('#projectInvest').numberbox('setValue', record.attributes.investestimate);
        $('#fundSource').combobox('setValue', record.attributes.fundsource);
    }
}

/** **********************项目弹窗******************** */
function showProjectWinFun() {
    var inputobj = formatterInputobj(this);
    var projectTypeId = "";
    if (haseasyui("#projectTypeId")) {
        projectTypeId = $("#projectTypeId").combotree('getValue');
    }
    openChooseDialog({
        title: "选择项目",
        contenturl: '/view/business/pm/pmProjectSelectWin?projectTypeId=' + projectTypeId,
        width: 1000,
        height: 450,
        okhandler: function () {
            var r = $('#projectSelect_datagrid').datagrid('getSelected');
            if (r) {
                $('#projectId').val(r.projectId);
                autoSetValue("projectId_TEXT_", r.projectName);
                autoSetValue("projectName", r.projectName);
                if (haseasyui("#projectPid")) {
                    $('#projectPid').val(r.projectId);
                }
                if (haseasyui("#projectPid_TEXT_")) {
                    $('#projectPid_TEXT_').textbox('setValue', r.projectName);
                }
                return true;
            } else {
                alertInfo("请选择项目");
                return false;
            }
        }
    })
}

/************************门面表弹窗******************** */
function showMaHouseFacadeWinFun() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择门面表",
        contenturl: '/view/business/ma/MaHouseFacadeSelectWin',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#MaHouseFacadeSelect_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue("facadeId", r.facadeId);
                autoSetValue("facadeIdText", r.facadeName);
                return true;
            } else {
                alertInfo("请选择门面表信息");
                return false;
            }
        }
    })
}


/**
 * 合同-项目分摊项目选择框
 */
function showProject() {
    var inputobj = formatterInputobj(this);
    var dateIndex = getEndNumberForStr(inputobj.inputId);
    // console.info(inputobj.inputId);
    openChooseDialog({
        title: "选择项目",
        contenturl: '/view/business/pm/pmProjectSelectWin',
        width: 1000,
        height: 450,
        okhandler: function () {
            var r = $('#projectSelect_datagrid').datagrid('getSelected');
            if (r) {
                $("#projectId" + dateIndex).val(r.projectId);
                $("#" + inputobj.inputId).textbox("setText", r.projectName);
                return true;
            } else {
                alertInfo("请选择项目");
                return false;
            }
        }
    })
}

function showpmpmcontype() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "合同类别",
        contenturl: '/view/sys/pmpmSelectWin',
        width: 450, height: 450,
        okhandler: function () {
            var r = $('#PmPmconItem_datagrid').datagrid('getSelected');
            if (r) {
                $('#' + inputobj.inputId).val(r.PMCON_ITEM_ID);
                $('#' + inputobj.inputText).textbox('setValue', r.ITEM_NAME);
                $('#pmconTypeId').val(r.PMCON_TYPE_ID);
                $('#pmconTypeId').textbox('setText', r.PMCON_TYPE_NAME);
                return true;
            } else {
                alertInfo("请选择一条合同属性");
                return false;
            }
        }

    })

}

/** **********************项目合同弹窗 start******************** */
function showPmConWinFun() {
    var inputobj = formatterInputobj(this);
    var projectId = $("#projectId").val();
    openChooseDialog({
        title: "选择合同",
        contenturl: '/view/business/pm/PmPmconStart',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#PmPmcon_datagrid').datagrid('getSelected');
            if (r) {
                // autoSetValue("pmconId_TEXT_",r.pmconName);
                // autoSetValue("pmconId",r.pmconId);
                $("#" + inputobj.inputId).textbox("setValue", r.pmconId);
                $("#" + inputobj.inputId).textbox("setText", r.pmconName);
                autoSetValue("contractUnit", r.partyB);
                autoSetValue("contractUnit_TEXT_", r.partyBName);
                autoSetValue("controlUnit", r.partyB);
                autoSetValue("controlUnit_TEXT_", r.partyBName);
                // $('#projectId').val(r.projectId);
                autoSetValue("projectId", r.projectId);
                autoSetValue("projectId_TEXT_", r.projectName);
                return true;
            } else {
                alertInfo("请选择合同");
                return false;
            }
        }
    })
}

/************************合同属性窗口*********************/
function ContractAttributeBomb() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择合同属性",
        contenturl: '/view/business/pm/PmContractAttributeSelectionBox',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#PmPmconItem_datagrid').datagrid('getSelected');
            if (r) {
                $('#' + inputobj.inputId).val(r.PMCON_ITEM_ID);
                $('#' + inputobj.inputText).textbox('setValue', r.ITEM_NAME);
                $('#pmconTypeId').combotree('setValue', r.PMCON_TYPE_ID);
                $('#pmconTypeId').combotree('setText', r.PMCON_TYPE_NAME);
                return true;
            } else {
                alertInfo("请选择一条合同属性");
                return false;
            }
        }

    })
}

/** ***********************行政区域选择框**************** */
//行政区域弹出框
function showRegionWinFun() {
    openChooseDialog({
        title: "选择行政区域",
        contenturl: '/view/sys/regionSelectWin',
        width: 600,
        height: 400,
        okhandler: function () {
            var r = $('#regionSelect_datagrid').datagrid('getSelected');
            if (r) {
                $('#regionId').val(r.regionId);
                $('#regionName').textbox('setValue', r.regionName);
                return true;
            } else {
                alertInfo("请选择行政区域");
                return false;
            }
        }
    })

}


/** **********************项目合同弹窗(施工组织设计 开工管理、停工管理、复工管理、工程延期
 *   按照项目负责人和 合同类型（施工合同）来过滤)******************** */
function showPmConWinFun1() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择合同",
        contenturl: '/view/business/pm/PmPmconStart?pmconTypeCode=SGHT&selectByMgr=Y',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#PmPmcon_datagrid').datagrid('getSelected');
            if (r) {
                $("#" + inputobj.inputId).val(r.pmconId);
                $("#" + inputobj.inputText).textbox("setText", r.pmconName);
                autoSetValue("contractUnit", r.partyB);
                autoSetValue("contractUnit_TEXT_", r.partyBName);
                autoSetValue("controlUnit", r.partyB);
                autoSetValue("controlUnit_TEXT_", r.partyBName);
                autoSetValue("projectId", r.projectId);
                autoSetValue("projectId_TEXT_", r.projectName);
                return true;
            } else {
                alertInfo("请选择合同");
                return false;
            }
        }
    })
}

//只选合同不选项目
function showPmConWinFunOnlyPmcon() {
    var inputobj = formatterInputobj(this);
    var projectId = $("#projectId").val();
    openChooseDialog({
        title: "选择合同",
        contenturl: '/view/business/pm/PmPmconStart',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#PmPmcon_datagrid').datagrid('getSelected');
            if (r) {
                // autoSetValue("pmconId_TEXT_",r.pmconName);
                // autoSetValue("pmconId",r.pmconId);
                $("#" + inputobj.inputId).textbox("setValue", r.pmconId);
                $("#" + inputobj.inputId).textbox("setText", r.pmconName);
                autoSetValue("contractUnit", r.partyB);
                autoSetValue("contractUnit_TEXT_", r.partyBName);
                autoSetValue("controlUnit", r.partyB);
                autoSetValue("controlUnit_TEXT_", r.partyBName);
                // $('#projectId').val(r.projectId);
                /* autoSetValue("projectId", r.projectId);
                autoSetValue("projectId_TEXT_", r.projectName);*/
                return true;
            } else {
                alertInfo("请选择合同");
                return false;
            }
        }
    })
}


/** **********************部门弹出窗********************* */
function showDeptWinFun() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择部门",
        contenturl: '/view/sys/deptSelectWin',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#deptSelect_datagrid').datagrid('getSelected');
            if (r) {
                $('#' + inputobj.inputId).val(r.DEPT_ID);
                $('#' + inputobj.inputText).textbox('setValue', r.DEPT_NAME);
                return true;
            } else {
                alertInfo("请选择部门");
                return false;
            }
        }
    })
}

/** **********************基金初审选在BP弹出框********************* */
function showFundFirstTrialWinFun() {
    openChooseDialog({
        title: "选择BP",
        contenturl: '/view/business/im/FundFirstTrialWin',
        width: 600,
        height: 450,
        okhandler: function () {
            var r = $('#FundFirstTrialWin_datagrid').datagrid('getSelected');
            if (r) {
                $('#bpName').textbox('setValue', r.bpName);
                $('#bpDirectionText').textbox('setValue', r.bpDirectionText);
                $('#fmSize').numberbox('setValue', r.fmSize);
                $('#contactOrgName').textbox('setValue', r.contactOrgName);
                $('#flowNumber').val(r.flowNumber);
                $('#bpName2').textbox('setValue', r.bpName);


                $('#fundManager').val(r.fmOrgcode);
                $('#fundManagerText').textbox('setValue', r.contactOrgName);
                $('#fundScale').numberbox('setValue', r.fmSize);
                $('#invDirection').combobox('setValue', r.bpDirection);

                return true;
            } else {
                alertInfo("请选择组织机构");
                return false;
            }
        }
    })
}

/** **********************基金决策选择框********************* */
function showFundDecisionApprovalWinFun() {
    openChooseDialog({
        title: "选择BP",
        contenturl: '/view/business/im/FundDecisionApprovalWin',
        width: 600,
        height: 450,
        okhandler: function () {
            var r = $('#FundDecisionApprovalWin_datagrid').datagrid('getSelected');
            if (r) {
                $('#bpName').textbox('setValue', r.bpName);
                $('#bpDirectionText').textbox('setValue', r.bpDirectionText);
                $('#fmSize').numberbox('setValue', r.fmSize);
                $('#contactOrgName').textbox('setValue', r.contactOrgName);
                $('#flowNumber').val(r.flowNumber);

                $('#dueNumber').textbox('setValue', r.dueNumber);

                return true;
            } else {
                alertInfo("请选择组织机构");
                return false;
            }
        }
    })
}

/** **********************部门弹出窗（可编辑列）********************* */
function showDeptWinFunEdit() {
    var inputobj = formatterInputobj(this);
    var index = getEndNumberForStr(this.id);
    openChooseDialog({
        title: "选择部门",
        contenturl: '/view/sys/deptSelectWin',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#deptSelect_datagrid').datagrid('getSelected');
            if (r) {
                $('#' + inputobj.inputId + index).val(r.DEPT_ID);
                $('#' + inputobj.inputText).textbox('setValue', r.DEPT_NAME);
                var node = $('#orgSelect_tree').tree('getSelected');
                if (node) {
                    $('#orgId' + index).val(node.id);
                    $('#orgId_TEXT_' + index).textbox('setValue', node.text);
                }

                return true;
            } else {
                alertInfo("请选择部门");
                return false;
            }
        }
    })
}

/** **********************组织机构弹出窗********************* */
function showOrgWinFun() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "组织机构",
        contenturl: '/view/sys/orgSelectWin',
        width: 450,
        height: 450,
        okhandler: function () {
            var r = $('#orgSelectWin_datagrid').datagrid('getSelected');
            if (r) {
                $('#' + inputobj.inputId).val(r.ORG_ID);
                $('#' + inputobj.inputText).textbox('setValue', r.ORG_NAME);
                return true;
            } else {
                alertInfo("请选择组织机构");
                return false;
            }
        }
    })
}

/** hou.chen* */
/** **********************表单ID弹出窗********************* */
function showFormWinFun() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "表单选择",
        contenturl: '/view/business/pm/FormSelectWin',
        width: 450,
        height: 450,
        okhandler: function () {
            var r = $('#FormId_datagrid').datagrid('getSelected');
            if (r) {
                $('#' + inputobj.inputId).val(r.ID);
                $('#' + inputobj.inputText).textbox('setValue', r.FORM_NAME);
                return true;
            } else {
                alertInfo("请选择表单ID");
                return false;
            }
        }
    })
}

/** ***********区域选择框*************** */
function showAreaChooseWinFun() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择区域",
        contenturl: '/view/base/chooseBasArea',
        width: 400,
        height: 400,
        okhandler: function () {
            var node = $('#chooseBasArea_tree').tree('getSelected');
            if (node && node.id !== "0") {
                $('#' + inputobj.inputId).val(node.id);
                $('#' + inputobj.inputText).textbox('setValue', node.attributes.area_full_name);
                return true;
            } else {
                alertInfo("请选择区域");
                return false;
            }
        },
        bottons: [{
            text: '安庆市',
            iconCls: 'icon-button',
            handler: function () {
                $('#' + inputobj.inputId).val("340100");
                $('#' + inputobj.inputText).textbox('setValue', "安徽省安庆市");
                var d = $(this).closest('.window').find('.window-body');
                d.dialog('destroy');
            }
        }
        ]
    })

}


/** **********************大建设计划弹窗******************** */
function showProjectPlanWithTypeWinFun() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择项目",
        contenturl: '/view/business/pm/pmProjectPlanSelectWin',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#projectPlanSelect_datagrid').datagrid('getSelected');
            if (r) {
                $('#projectPlanId').val(r.projectPlanId);
                autoSetValue("projectId", r.projectId);
                autoSetValue("projectId_TEXT_", r.projectId);
                autoSetValue("projectName", r.projectName);
                autoSetValue("projectCode", r.projectCode);
                autoSetValue("projectTypeId", r.projectTypeId);
                autoSetValue("constructType", r.constructType);
                autoSetValue("investEstimate", r.investEstimate);
                autoSetValue("addr", r.addr);
                $("#constructUnit").val(r.constructUnit);
                autoSetValue("constructUnit_TEXT_", r.contactOrgName);
                autoSetValue("investEstimate", r.investEstimate);
                autoSetValue("beginDate", r.startDate);
                autoSetValue("endDate", r.finishDate);
                autoSetValue("contactMan", r.contactName);
                return true;
            } else {
                alertInfo("请选择项目");
                return false;
            }
        }
    })
}


/** **********************所属项目弹窗******************** */
function showProjectPidWinFun() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择所属项目",
        contenturl: '/view/biz/pm/BPmProjectTree',
        width: 400,
        height: 500,
        okhandler: function () {
            var r = $('#BPmProject_tree').tree('getSelected');
            if (r) {
                $('#' + inputobj.inputId).val(r.id);
                $('#' + inputobj.inputText).textbox('setValue', r.text);
                return true;
            } else {
                alertInfo("请选择所属项目");
                return false;
            }
        }
    })
}


/************************根据项目ID选择合同列表*********************/
function showPmContractByProWinFun() {
    var inputobj = formatterInputobj(this);
    var projectId = '';
    if ($("#projectId")) {
        projectId = $("#projectId").val();
    }
    openChooseDialog({
        title: "选择合同",
        contenturl: '/view/business/pm/pmContractByProSelectWin?projectId=' + projectId,
        width: 1000,
        height: 450,
        okhandler: function () {
            var r = $('#PmPmcon_datagrid1').datagrid('getSelected');
            if (r) {
                $('#pmconId').val(r.pmconId);
                $('#projectId').val(r.projectId);
                $('#pmconName').textbox('setValue', r.pmconName);
                $('#projectId_TEXT_').textbox('setValue', r.projectName);
                $('#isAddContract').textbox('setValue', r.isAddContract);
                $('#mainPmconId_TEXT_').textbox('setValue', r.mainPmconIdText);
                $('#pmconMoney').numberbox('setValue', r.pmconMoney);
                $('#finalContractMoney').numberbox('setValue', r.finalContractMoney);
                $('#pmconResume').textbox('setValue', r.pmconResume);
                $('#pmconMoney').numberbox('fix');
                $('#finalContractMoney').numberbox('fix');
                if (haseasyui("#pmconId_TEXT_")) {
                    $('#pmconId_TEXT_').textbox('setValue', r.pmconName);
                }
                if (haseasyui("#contractMoney")) {
                    $('#contractMoney').numberbox('setValue', r.pmconMoney);
                }

                return true;
            } else {
                alertInfo("请选择一条项目合同");
                return false;
            }
        }
    })
}


/************************合同选择弹窗-带项目树*********************/
function showPmContractFilterByProjectWinFun() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择合同",
        contenturl: '/view/business/pm/PmContractSelectWin',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#PmPmcon_datagrid').datagrid('getSelected');
            if (r) {

                $('#pmconId').val(r.pmconId);
                $('#pmconId_TEXT_').textbox('setValue', r.pmconName);
                return true;
            } else {
                alertInfo("请选择一条项目合同");
                return false;
            }
        }
    })
}

function showCarInfoWinFunEdit() {
    var inputobj = formatterInputobj(this);
    var index = getEndNumberForStr(this.id);
    openChooseDialog({
        title: "选择车辆",
        contenturl: '/view/business/gm/GmCarInfoSelectWin',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#GmCarInfoSelect_datagrid').datagrid('getSelected');
            if (r) {
                $('#carNum' + index).textbox('setValue', r.carNum);
                $('#carInfoId' + index).val(r.carInfoId);

                return true;
            } else {
                alertInfo("请选择车辆");
                return false;
            }
        }
    })
}

/** ***************车辆详细信息弹窗************************* */
function showCarInfoWinFun() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择车辆",
        contenturl: '/view/business/gm/GmCarInfoSelectWin',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#GmCarInfoSelect_datagrid').datagrid('getSelected');
            if (r) {
                //$("#"+inputobj.inputId).textbox("setValue",r.carInfoId);
                $("#" + inputobj.inputId).textbox("setValue", r.carInfoId);
                $("#" + inputobj.inputId).textbox("setText", r.carNum);
                //$('#carInfoId').textbox('setText',r.carNum);
                $('#belongingOrg').combobox('setValue', r.belongingOrg);
                $('#belongingOrg').combobox('setText', r.belongingOrgText);
                //$('#belongingOrg').combobox('setValue',{id:r.belongingOrg,text:r.belongingOrgText});
                //$('#belongingOrg').combotree('setValue',{id:r.belongingOrg,text:r.belongingOrgText});

                return true;
            } else {
                alertInfo("请选择车辆");
                return false;
            }
        }
    })
}

/** ***************油卡登记车辆选择弹窗************************* */
function showCarInfoByOilCardWinFun() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择车辆",
        contenturl: '/view/business/gm/GmCarInfoSelectWin?type=oilCard',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#GmCarInfoSelect_datagrid').datagrid('getSelected');

            if (r) {
                //$("#"+inputobj.inputId).textbox("setValue",r.carInfoId);
                $("#" + inputobj.inputId).textbox("setValue", r.carInfoId);
                $("#" + inputobj.inputId).textbox("setText", r.carNum);
                //$('#carInfoId').textbox('setText',r.carNum);
                $('#belongingOrg').combobox('setValue', r.belongingOrg);
                $('#belongingOrg').combobox('setText', r.belongingOrgText);
                //$('#belongingOrg').combobox('setValue',{id:r.belongingOrg,text:r.belongingOrgText});
                //$('#belongingOrg').combotree('setValue',{id:r.belongingOrg,text:r.belongingOrgText});

                return true;
            } else {
                alertInfo("请选择车辆");
                return false;
            }
        }
    })
}

/** ***************车辆申请日历弹窗************************* */

/*function showCarInfoWinFunCalendar() {
	var id = $("#applyId").val();
	openChooseDialog({
		title:'选择车辆',
		contenturl:"/view/business/gm/carApplyWin?actionUrl=/GmCarApply/getApplyCarList&id="+id,
		width:700,
		height:400,
		okhandler:function(){
			calendar
			var row=$("#GmInfoType_datagrid").datalist('getSelected');
			if(row){
				$("#typeId").val(row.typeId);
				$("#typeIdName").textbox("setValue",row.typeName);
				$("#isApprove").val(row.isApproval);
				$("#flowCode").val(row.flowCode);
				return true;
			}else{
				alertInfo("请选择流程");
				return false;
			}
		}
	});
}
*/


/** *************日程类型弹窗********************* */
function showWorkplanTypeWinFun() {
    openChooseDialog({
        title: "选择日程类型",
        contenturl: '/view/business/gm/GmWorkplanTypeSelectWin',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#GmWorkplanTypeSelect_datagrid').datagrid('getSelected');
            if (r) {
                $('#workplanTypeId').val(r.workplanTypeId);
                $('#workplanType').textbox('setValue', r.workplanTypeName);
                $('#color').textbox('setValue', r.workplanTypeColor);
                return true;
            } else {
                alertInfo("请选择日程类型");
                return false;
            }
        }
    })
}


/** ***********************调用百度地图**************** */
function showAddressWin() {
    var id = this.id;
    layer.open({
        type: 2,
        title: "地图选择",
        area: ['700px', '470px'],
        btn: ['确定', '取消'],
        fixed: false, // 不固定
        maxmin: false,
        content: ctx + '/view/common/gdaddressSelectWin',
        success: function (layero, index) {
            if ($("#positionInfo").val()) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var position = $("#positionInfo").val().split(",");
                iframeWin.document.getElementById("txtlatitude").value = position[0];
                iframeWin.document.getElementById("txtLongitude").value = position[1];
                iframeWin.initPoint();
            }
        },
        yes: function (index, layero) {
            var iframeWin = window[layero.find('iframe')[0]['name']];
            var lat = iframeWin.document.getElementById("txtlatitude").value;// 纬度
            var lng = iframeWin.document.getElementById("txtLongitude").value;// 经度
            var address = iframeWin.document.getElementById("txtAddress").value;
            //当是资产清单里的房产新增时不要赋值
            if ($('#GmAssetsInfoFC').length > 0) {
                autoSetValue("longitude", lng);
                autoSetValue("latitude", lat);
                autoSetValue("positionInfo", lat + "," + lng);
            } else {
                autoSetValue("positionInfo", lat + "," + lng);
            }

            autoSetValue("px", lat);
            autoSetValue("py", lng);
            autoSetValue(id, address);
            layer.close(index);
        }
    });

}


/** ***********************批量存入区域坐标信息*************** */
function selectMarkersWin() {
    var id = this.id;
    var positions;
    layer.open({
        type: 2,
        title: "地图选择",
        area: ['700px', '470px'],
        btn: ['确定', '取消'],
        fixed: false, // 不固定
        maxmin: false,
        content: ctx + '/view/common/selectMarkersWin',
        success: function (layero, index) {
            if ($("#positionInfo").val()) {
                var iframeWin = window[layero.find('iframe')[0]['name']];
                var position = $("#positionInfo").val().split(",");
                iframeWin.document.getElementById("txtlatitude").value = position[0];
                iframeWin.document.getElementById("txtLongitude").value = position[1];
                iframeWin.initPoint();
            }
        },
        yes: function (index, layero) {
            var iframeWin = window[layero.find('iframe')[0]['name']];
            var lat = iframeWin.document.getElementById("txtlatitude").value;// 纬度
            var lng = iframeWin.document.getElementById("txtLongitude").value;// 经度
            var address = iframeWin.document.getElementById("txtAddress").value;
            positions = iframeWin.document.getElementById("txtPositions").value;
            var regex = "^,*|,*$";
            var geoAry = "[" + positions.replaceAll(regex, "") + "]";
            var arr = eval(geoAry);
            positions = "[" + positions.replaceAll(regex, "") + "," + "[" + "'" + arr[0][0] + "'" + "," + "'" + arr[0][1] + "'" + "]" + "]";
            addcooList(eval(positions));
            layer.close(index);
        }
    });

}

/** ***********************高德地图明细链接**************** */
function showAddressDetailWin(currentLat, currentLng, geoAry) {
    var id = this.id;
    layer.open({
        type: 2,
        title: "明细地址",
        area: ['700px', '470px'],
        btn: ['确定'],
        fixed: false, // 不固定
        maxmin: false,
        content: ctx + '/view/business/gm/GmAssetsAddressWin',
        success: function (layero, index) {
            var iframeWin = window[layero.find('iframe')[0]['name']];
            iframeWin.document.getElementById("txtlatitude").value = currentLat;
            iframeWin.document.getElementById("txtLongitude").value = currentLng;
            iframeWin.document.getElementById("txtgeoAry").value = geoAry;
            var color = '#80d8ff';
            iframeWin.document.getElementById("txtcolor").value = color;
            iframeWin.initPoint();
        }
    });

}


function chooseIco() {
    var that = this;
    openChooseDialog({
        title: '选择图标',
        contenturl: "/BasMenu/chooseIcons",
        width: 600,
        height: 400,
        okhandler: function () {
            if ($('#chooseico').val()) {
                $(that).textbox('setValue', $('#chooseico').val())
                autoSetValue("buttonIcon", $('#chooseico').val());
                autoSetValue("iconCls", $('#chooseico').val());
                return true;
            } else {
                alertInfo('请选择一个图标');
                return false;
            }
        }
    });


}


function selectTemplateName() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择模板",
        contenturl: '/view/business/edoc/EdocRedTemplateSelect',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#EdocRedTemplate_datagrid').datagrid('getSelected');
            if (r) {
                $("#" + inputobj.inputId).textbox("setValue", r.id);
                $("#" + inputobj.inputId).textbox("setText", r.templateName);
                return true;
            } else {
                alertInfo("请选择模板");
                return false;
            }
        }
    });
}


function selectEdocForm() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择表单",
        contenturl: '/view/business/edoc/EdocFormSelect',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#EdocForm_datagrid').datagrid('getSelected');
            if (r) {
                $("#" + inputobj.inputId).textbox("setValue", r.id);
                $("#" + inputobj.inputId).textbox("setText", r.formName);
                return true;
            } else {
                alertInfo("请选择表单");
                return false;
            }
        }
    });
}

function openBizArchiveFileDialog(_options) {
    var options = {
        title: '档案归档申请',
        width: 500,
        height: 300,
        maximized: true,
        submiturl: "/BArchive/saveBArchive"
    }
    $.extend(options, _options);
    var resToolBar = [];
    resToolBar.push({
        text: "发送申请",
        iconCls: 'icon-disk',
        handler: function () {
            var okbutton = $(this);
            var d = $(this).closest('.window').find('.window-body');
            var submitform = $("form", "#open_dialog");
            submitform.form('enableValidation');
            submitform.form('submit', {
                dataType: 'json',
                method: "POST",
                url: ctx + options.submiturl,
                onSubmit: function (param) {
                    if ($(this).form('validate')) {
                        layer.msg('发送中', {icon: 16, shade: 0.3, time: 0});
// var rows=$("#choosedownloadfilesgrid").datagrid("getChecked");
//
// if(rows.length>0){
// var formfileids=new Array();
// for(var i=0;i<rows.length;i++){
// formfileids.push(rows[i].FORM_FILE_ID);
// }
// // param.formfileids=formfileids.join(",");
// return true;
// }else{
// layer.closeAll();
// alertInfo("请选择要归档的文件");
// return false;
// }
                    } else {
                        return false;
                    }
                },
                success: function (result) {
                    result = jQuery.parseJSON(result);
                    if (result.success) {
                        layer.closeAll();
                        openFlowDialog({
                            processInstId: result.o.processinstid,
                            businessMainId: result.o.busiMainId,
                            formCode: 'BArchive_Form',
                            msgtitle: result.o.msgTitle,
                            callback: function () {
                                var callback = options.callback;
                                (callback && typeof (callback) === "function") && callback(result);
                                d.dialog('destroy');
                            }
                        });
                    } else {
                        layer.closeAll();
                        alertError(result.msg);
                        okbutton.linkbutton('enable');// 信息错误 则启用按钮
                    }
                }
            });
        }
    });
// 拼装返回按钮
    resToolBar.push({
        text: "返回",
        iconCls: 'icon-back iconfont red2',
        handler: function () {
            var d = $(this).closest('.window').find('.window-body');
            d.dialog('destroy');
        }
    });

// $.ajax({
// type : 'post',
// dataType : 'json',
// url : ctx + "/BArchive/checkhasBArchive",
// data:options,
// success : function(data) {
// if(data.success){
// if(data.o>0){//代归档文件大于0
    $('<div/>').dialog({
        id: "open_dialog",
        href: ctx + "/BArchive/applyBArchive?themeName=" + encodeURI(options.themeName) + "&formcode=" + options.formcode + "&pk=" + options.pk + "&formfileids=" + options.formfileids,
        style: {overflowX: 'hidden'},
        modal: true,
        title: "档案归档申请",
        width: options.width,
        height: options.height,
        maximized: options.maximized,
        draggable: false,
        toolbar: options.maximized ? resToolBar : '',
        buttons: options.maximized ? '' : resToolBar,
        onClose: function () {
            $(this).dialog('destroy');
        }
    });
// }else{
// alertInfo('没有待归档的文件');
// }
// }
// }
// });
}

//合同附件  档案信息中 归档申请按钮打开的页面
function openArchiveArchiveFileDialog(_options) {
    var options = {
        title: '档案归档申请',
        width: 500,
        height: 300,
        maximized: true,
        submiturl: "/ArchivesArchiveApplication/saveArchivesArchiveApplication"
    }
    $.extend(options, _options);
    var resToolBar = [];
    resToolBar.push({
        text: "发送申请",
        iconCls: 'icon-disk',
        handler: function () {
            var okbutton = $(this);
            var d = $(this).closest('.window').find('.window-body');
            var submitform = $("form", "#open_dialog");
            submitform.form('enableValidation');
            submitform.form('submit', {
                dataType: 'json',
                method: "POST",
                url: ctx + options.submiturl,
                onSubmit: function (param) {
                    if ($(this).form('validate')) {
                        layer.msg('发送中', {icon: 16, shade: 0.3, time: 0});
                    } else {
                        return false;
                    }
                },
                success: function (result) {
                    result = jQuery.parseJSON(result);
                    if (result.success) {
                        layer.closeAll();
                        openFlowDialog({
                            processInstId: result.o.processinstid,
                            businessMainId: result.o.busiMainId,
                            formCode: 'BArchive_Form',
                            msgtitle: result.o.msgTitle,
                            callback: function () {
                                var callback = options.callback;
                                (callback && typeof (callback) === "function") && callback(result);
                                d.dialog('destroy');
                            }
                        });
                    } else {
                        layer.closeAll();
                        alertError(result.msg);
                        okbutton.linkbutton('enable');// 信息错误 则启用按钮
                    }
                }
            });
        }
    });
// 拼装返回按钮
    resToolBar.push({
        text: "返回",
        iconCls: 'icon-back iconfont red2',
        handler: function () {
            var d = $(this).closest('.window').find('.window-body');
            d.dialog('destroy');
        }
    });

// $.ajax({
// type : 'post',
// dataType : 'json',
// url : ctx + "/BArchive/checkhasBArchive",
// data:options,
// success : function(data) {
// if(data.success){
// if(data.o>0){//代归档文件大于0
    $('<div/>').dialog({
        id: "open_dialog",
        href: ctx + "/ArchivesArchiveApplication/applyArchive?themeName=" + encodeURI(options.themeName) + "&formcode=" + options.formcode + "&pk=" + options.pk + "&formfileids=" + options.formfileids,
        style: {overflowX: 'hidden'},
        modal: true,
        title: "档案归档申请",
        width: options.width,
        height: options.height,
        maximized: options.maximized,
        draggable: false,
        toolbar: options.maximized ? resToolBar : '',
        buttons: options.maximized ? '' : resToolBar,
        onClose: function () {
            $(this).dialog('destroy');
        }
    });
// }else{
// alertInfo('没有待归档的文件');
// }
// }
// }
// });
}


function openArchiveFileDialog(_options) {
    var options = {
        title: '档案信息'
    }
    $.extend(options, _options);
    var openurl = "/view/business/archives/ArchivesArchiveFileForPmPmcon?themeName=" + encodeURI(options.themeName) + "&formcode=" + options.formcode + "&pk=" + options.pk;
    if (parent && parent.openInMainTab) {
        parent.openInMainTab(options.title, openurl);
    } else {
        window.open(ctx + openurl, '_blank');
    }
}

function openArchiveFileDialogForProDoc(_options) {
    var options = {
        title: '档案信息'
    }
    $.extend(options, _options);
    var openurl = "/BArchive/BArchivesBizForProDoc?formcode=BPmProjectDoc_form&pk=" + options.pk + "&themeName=" + encodeURI(options.themeName);
    if (parent && parent.openInMainTab) {
        parent.openInMainTab(options.title, openurl);
    } else {
        window.open(ctx + openurl, '_blank');
    }
}

function openArchiveHistoryDialog(_options) {
    openDetailDialog({
        title: "归档申请记录",
        maximized: true,
        contenturl: "/BArchive/bArchiveHistroy?formcode=" + _options.formcode + "&pk=" + (_options.pk == null ? '' : _options.pk)
    });
}

//招标申请弹窗
function showSelectPmBidApply(formCode) {
    return function () {
        selectPmBidApply(formCode);
    }
}

function selectPmBidApply(formCode) {
    openChooseDialog({
        title: "选择招标申请",
        contenturl: '/view/business/pm/PmBidApplySelect?formCode=' + formCode,
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#PmBidApply_datagrid').datagrid('getSelected');
            // console.info(r);
            if (r) {
                if ($('#MaMaintainApply').length > 0) {

                    //房屋维修的
                    $('#bidApplyId').textbox('setText', r.bidNo);
                }
                autoSetValue("bidApplyId", r.bidApplyId);

                autoSetValue("bidName", r.bidNo);
                //实体bean生成
                // autoSetValue("bidNo",r.bidNameText);

                autoSetValue("projectId", r.projectId);
                autoSetValue("projectId_TEXT_", r.projectName);
                autoSetValue("buildingNo", r.buildingNo);
                autoSetValue("buildingName", r.buildingName);

                autoSetValue("fundSource", r.fundSource);
                autoSetValue("budgetAmount", r.budgetAmount);
                autoSetValue("operator", r.operator);
                autoSetValue("operator_TEXT_", r.accountName);

                /* $.ajax({
                		 url:ctx+"/PmBidList/constructPmBidProjectList",
            			 type:"POST",
        	             data:{id:r.bidApplyId},
        	             success:function(data){
        	               console.info(data);
        	             },
        	             dataType:"json"
                	 });*/
                return true;
            } else {
                alertInfo("请选择招标申请");
                return false;
            }
        }
    })
}

//内部采购申请弹窗
function showPmBidApplyInsideSelect(formCode) {
    return function () {
        PmBidApplyInsideSelect(formCode);
    }
}

function PmBidApplyInsideSelect(formCode) {

    openChooseDialog({
        title: "内部采购申请选择",
        contenturl: '/view/business/pm/PmBidApplyInsideSelectWin?formCode=' + formCode,
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#PmBidApplySelectInside_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue("bidApplyId", r.bidApplyId);
                autoSetValue("bidName", r.bidName);
                autoSetValue("bidNo", r.bidNo);
                autoSetValue("budgetAmount", r.budgetAmount);
                autoSetValue("maxMoney", r.budgetAmount);
                autoSetValue("fundSource", r.fundSource);
                autoSetValue("operator", r.operator);
                autoSetValue("bidType", r.bidType);
                autoSetValue("content", r.content);
                return true;
            } else {
                alertInfo("请先选择内部采购申请");
                return false;
            }
        }
    })
//    openChooseDialog({
//        title: "内部采购申请选择",
//        contenturl: '/view/business/pm/PmBidFileInsideSelectWin?formCode='+formCode,
//        width: 750,
//        height: 450,
//        okhandler: function () {
//            var r = $('#PmBidApplySelectInside_datagrid').datagrid('getSelected');
//            if (r) {
//                autoSetValue("bidName", r.bidName);
//                autoSetValue("bidNo", r.bidNo);
//                autoSetValue("budgetAmount", r.budgetAmount);
//                autoSetValue("fundSource", r.fundSource);
//                autoSetValue("operator", r.operator);
//                autoSetValue("bidType", r.bidType);
//                autoSetValue("content", r.content);
//                return true;
//            } else {
//                alertInfo("请先选择内部采购申请");
//                return false;
//            }
//        }
//    })
}


/**
 * 内部采购文件弹窗
 * @param formCode 用到内部采购文件弹窗的 页面编码
 */
function showSelectPmBidFileInside(formCode) {
    return function () {
        selectPmBidFileInside(formCode);
    }
}

function selectPmBidFileInside(formCode) {
    openChooseDialog({
        title: "选择内部采购文件",
        contenturl: '/view/business/pm/PmBidFileSelectInside?formCode=' + formCode,
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#PmBidFileInsideSelect_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue("bidFileId", r.bidFileId);
                autoSetValue("bidNo", r.bidNo);
                autoSetValue("bidName", r.bidName);
                autoSetValue("buildingNo", r.buildingNo);
                autoSetValue("buildingName", r.buildingName);
                autoSetValue("bidMode", r.bidMode);

                autoSetValue("projectBudget", r.budgetAmount);
                autoSetValue("winUnit", r.winUnit);
                autoSetValue("winUnit_TEXT_", r.winUnitText);
                autoSetValue("winPrice", r.winPrice);
                autoSetValue("maxMoney", r.winPrice);
                autoSetValue("openingTime", r.openingTime);
                autoSetValue("openingPlace", r.openingPlace);

                //如果是中标通知书页面，则根据对应的招标文件实例化相应的标段combobox
                if ($('#PmBidNotice').length > 0) {
                    $('#bdstId').combobox('reload', ctx + '/PmBidProject/getAllBdstByBidApplyId?bidFileId=' + r.bidFileId);
                }
                return true;
            } else {
                alertInfo("请选择内部采购文件");
                return false;
            }
        }
    })
}


/**
 * 招标文件弹框 。招标答疑，招标结果使用
 * @param formCode
 * @returns {Function}
 */
function showSelectPmBidFile(formCode) {
    return function () {
        selectPmBidFile(formCode);
    }
}

function selectPmBidFile(formCode) {
    openChooseDialog({
        title: "选择招标文件",
        contenturl: '/view/business/pm/PmBidFileSelect?formCode=' + formCode,
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#PmBidFile_datagrid').datagrid('getSelected');

            if (r) {
                autoSetValue("bidFileId", r.bidFileId);
                autoSetValue("bidName", r.bidNo);

                if ($('#PmBidNotice').length > 0) {
                    $('#winPrice').numberbox('setValue', r.budgetAmount);
                }

                autoSetValue("buildingNo", r.buildingNo);
                autoSetValue("buildingName", r.buildingName);
                autoSetValue("bidMode", r.bidMode);

                autoSetValue("projectBudget", r.budgetAmount);
                autoSetValue("winUnit", r.winUnit);
                autoSetValue("winUnit_TEXT_", r.winUnitText);
                // autoSetValue("winPrice",r.winPrice);
                autoSetValue("openingTime", r.openingTime);
                autoSetValue("openingPlace", r.openingPlace);


                //如果是中标通知书页面，则根据对应的招标文件实例化相应的标段combobox
                //标段 暂时不用 20200701
                // if($('#PmBidNotice').length>0){
                // 	$('#bdstId').combobox('reload',ctx+'/PmBidProject/getAllBdstByBidApplyId?bidFileId='+r.bidFileId);
                // }


                return true;
            } else {
                alertInfo("请选择招标文件");
                return false;
            }
        }
    })
}


function selectPmPmconItemType() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "请选择合同类型",
        contenturl: '/view/business/pm/PmPmconTypeSelect',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#PmPmconType_datagrid_type').datagrid('getSelected');
            if (r) {
                autoSetValue('pmconTypeId', r.pmconTypeId);
                if ($("#pmconTypeId").hasClass("easyui-textbox")) {
                    $('#pmconTypeId').textbox('setText', r.pmconTypeName);
                }
                return true;
            } else {
                alertInfo("请选择合同类型");
                return false;
            }
        }
    })
}


function selectPmPmcon() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择合同属性",
        contenturl: '/view/business/pm/PmPmconItemSelect',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#PmPmconItem_datagrid_type').datagrid('getSelected');
            if (r) {
                autoSetValue("pmconTypeId", r.pmconTypeId);
                autoSetValue("pmconTypeId_TEXT_", r.pmconTypeIdText);
                autoSetValue("pmconItemId", r.pmconItemId);
                autoSetValue("pmconItemId_TEXT_", r.itemName);
                return true;
            } else {
                alertInfo("请选择合同属性");
                return false;
            }
        }
    })


}

function selectPmBidNotic() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择中标通知书",
        contenturl: '/view/business/pm/PmBidNoticeSelect',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#PmBidNotice_datagrid_select').datagrid('getSelected');
            if (r) {
                autoSetValue("bidNoticeId", r.bidNoticeId);
                autoSetValue("bidNoticeId_TEXT_", r.bidName);
                autoSetValue("partyB_TEXT_", r.contactOrgName);
                autoSetValue("partyB", r.winUnit);
                if (r.winPrice) {
                    autoSetValue("pmconMoney", r.winPrice * 10000);
                }
                // 选择中标通知后后，带出相关项目，放入分摊项目列表
                if ($("#pmpmconProjectList_datagrid").length > 0) {
                    appendPmpmconProjectData(r.bidNoticeId);
                }
                return true;
            } else {
                alertInfo("请选择中标通知书");
                return false;
            }
        }
    })
}

function appendPmpmconProjectData(bidNoticeId) {
    $.ajax({
        url: ctx + "/PmBidNotice/getPmpmconProjectData",
        type: "post",
        dataType: "json",
        data: {
            bidNoticeId: bidNoticeId
        },
        success: function (data) {
            if (data != null && data.length > 0) {
                for (var i = 0; i < data.length; i++) {
                    addOtherData(data[i]);
                }
            }
        }
    })
}

function selectPmSafeInspect() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择安全巡查",
        contenturl: '/view/business/pm/PmSafeInspectSelect',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#PmSafeInspect_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue("safeInspectId", r.safeInspectId);
                autoSetValue("safeInspectId_TEXT_", r.inspectNo);

                if ($('#PmSafeRectify').length > 0) {

                    autoSetValue("projectId", r.projectId);
                    autoSetValue("projectId_TEXT_", r.projectName);

                    autoSetValue("projectMgr", r.projectMgr);
                    autoSetValue("projectMgr_TEXT_", r.projectMgrText);

                    delAlldata();
                    addDetailByInspectdId(r.safeInspectId);
                }

                return true;
            } else {
                alertInfo("请选择安全检查");
                return false;
            }
        }
    })
}

//查询出库单号
function selectIssueById() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择出库单号",
        contenturl: '/view/business/gm/GmAssetsMaterialIssueSelect',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#GmAssetsMaterialIssueSelect_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue("issueId", r.issueId);
                autoSetValue("issueId_TEXT_", r.issueNo);
                return true;
            } else {
                alertInfo("请选择出库单号");
                return false;
            }
        }
    })
}


/**
 * @param object object为‘user’只可以选人，默认为空即可以选人员，组织和部门
 * @returns {Function}
 * flag:标识 是否需要根据 集团统建,企业自建 来过滤（单位 部门 用户）弹窗的数据
 * roleId : 角色id
 * isHaveOrgAndRole： Y 时，包含当前所属人机构和角色
 * showVisual:Y时展示外部用户
 */
function selectOrgOrDeptOrUserWin(object, flag, roleId, isHaveOrgAndRole, showVisual) {

    return function () {
        selectOrgOrDeptOrUser(object, flag, this, roleId, isHaveOrgAndRole, showVisual);
    }
}

function selectOrgOrDeptOrUser(object, flag, that, roleId, isHaveOrgAndRole, showVisual) {
    if (!that) {
        that = this;
    }

    var contenturl, infoType;
    if (flag == 1) {
        var infoTypeObj = $('#infoType');
        if (infoTypeObj.length > 0) {
            var objCls = infoTypeObj.attr("class");
            if (objCls && objCls.indexOf("easyui") != -1) {
                if (objCls.indexOf("numberbox") != -1) {
                    infoType = infoTypeObj.numberbox('getValue');
                } else if (objCls.indexOf("datebox") != -1) {
                    infoType = infoTypeObj.datebox('getValue');
                } else if (objCls.indexOf("combobox") != -1) {
                    infoType = infoTypeObj.combobox('getValue');
                } else if (objCls.indexOf("combotree") != -1) {
                    infoType = infoTypeObj.combotree('getValue');
                } else {
                    infoType = infoTypeObj.val();
                }
            } else {
                infoType = infoTypeObj.val();
            }
        }
        if (infoType == 1) {
            //集团统建
            contenturl = '/view/sys/selectOrgOrDeptOrUserWin?object=' + object + "&showVisual=" + showVisual;
        } else {
            //企业自建
            contenturl = '/view/sys/selectOrgOrDeptOrUserWin?object=' + object + '&infoType=' + infoType + "&showVisual=" + showVisual;
        }
    } else {
        contenturl = '/view/sys/selectOrgOrDeptOrUserWin?object=' + object + "&roleId=" + roleId + "&isHaveOrgAndRole=" + isHaveOrgAndRole + "&showVisual=" + showVisual;
    }
    var inputobj = formatterInputobj(that);
    // 修改--获取人员id 和 name
    var names = $('#' + inputobj.inputText).val();
    var ids = $('#' + inputobj.inputId).val();
    openChooseDialog({
        title: "选择组织",
        contenturl: contenturl,
        width: 800,
		height : 600,
        okhandler: function () {
            var rows = $('#choosegrid').datagrid('getRows');
            if (rows) {
                var conids = [];
                var connames = [];
                for (var i = 0; i < rows.length; i++) {
                    conids.push(rows[i].userId);
                    connames.push(rows[i].userName);
                }
                if ($('#BFcLandPartol_Form').length > 0) {
                    $('#inspectOneId').val(conids);
                    $('#inspectOneName').textbox('setValue', connames);
                } else if ($('#BFcHousePartolform').length > 0) {
                    $('#inspectOneId').val(conids);
                    $('#inspectOneName').textbox('setValue', connames);
                } else if ($('#HrWorkReportTemplate').length > 0) {
                    $('#PublishScope').val(conids);
                    $('#publishScope_TEXT_').textbox('setValue', connames);
                } else if ($('#BasSignature').length > 0) {
                    $("#" + inputobj.inputId).textbox("setValue", conids);
                    $("#" + inputobj.inputId).textbox("setText", connames);
                } else if (inputobj.inputId.indexOf("sendOrRevPersion") > -1) {
                    var reg = new RegExp("_TEXT_", "g");
                    $("#" + inputobj.inputText).textbox("setValue", connames);
                    $("#" + inputobj.inputText.replace(reg, "")).val(conids);
                } else {
                    $('#' + inputobj.inputId).val(conids);
                    $('#' + inputobj.inputText).textbox('setValue', connames);
                }
                return true;
            } else {
                alertInfo("请选择人员");
                return false;
            }
        },
        onload: function () {
            if (names != null && names != "") {
                var namesArray = names.split(',');
                var idsArray = ids.split(',');
                for (var i = 0; i < namesArray.length; i++) {
                    $('#choosegrid').datagrid('appendRow', {
                        userId: idsArray[i],
                        userName: namesArray[i]
                    });
                }
            }

        }
    });
}

/**
 * @Description: 携带组 的组织部门树
 * @Param
 * @author  houChen
 * @date  2020/3/26 10:25
 * @blog https://www.cnblogs.com/houchen/
 *
 *  为 ‘user’只可以选人，默认为空即可以选人员，组织和部门
 *  flag:标识 是否需要根据 集团统建,企业自建 来过滤（单位 部门 用户）弹窗的数据
 */

function selectOrgOrDeptOrUserOrGroupWin(object, flag) {
    return function () {
        selectOrgOrDeptOrUserOrGroup(object, flag, this);
    }
}

function selectOrgOrDeptOrUserOrGroup(object, flag, that) {
    if (!that) {
        that = this;
    }
    var contenturl, infoType;
    if (flag == 1) {
        var infoTypeObj = $('#infoType');
        if (infoTypeObj.length > 0) {
            var objCls = infoTypeObj.attr("class");
            if (objCls && objCls.indexOf("easyui") != -1) {
                if (objCls.indexOf("numberbox") != -1) {
                    infoType = infoTypeObj.numberbox('getValue');
                } else if (objCls.indexOf("datebox") != -1) {
                    infoType = infoTypeObj.datebox('getValue');
                } else if (objCls.indexOf("combobox") != -1) {
                    infoType = infoTypeObj.combobox('getValue');
                } else if (objCls.indexOf("combotree") != -1) {
                    infoType = infoTypeObj.combotree('getValue');
                } else {
                    infoType = infoTypeObj.val();
                }
            } else {
                infoType = infoTypeObj.val();
            }
        }
        if (infoType == 1) {
            //集团统建
            contenturl = '/view/sys/selectOrgOrDeptOrUserOrGroupWin?object=' + object;
        } else {
            //企业自建
            contenturl = '/view/sys/selectOrgOrDeptOrUserOrGroupWin?object=' + object + '&infoType=' + (infoType || '');
        }
    } else {
        contenturl = '/view/sys/selectOrgOrDeptOrUserOrGroupWin?object=' + object;
    }
    var inputobj = formatterInputobj(that);
    // 修改--获取人员id 和 name
    var names = $('#' + inputobj.inputText).val();
    var ids = $('#' + inputobj.inputId).val();
    openChooseDialog({
        title: "选择组织",
        contenturl: contenturl,
        width: 800,
        height: 500,
        okhandler: function () {
            var rows = $('#choosegrid').datagrid('getRows');
            if (rows) {
                var conids = [];
                var connames = [];
                for (var i = 0; i < rows.length; i++) {
                    // console.info(rows[i]);
                    conids.push(rows[i].userId);
                    connames.push(rows[i].userName);
                }
                // console.info(rows);
                $('#' + inputobj.inputId).val(conids);
                $('#' + inputobj.inputText).textbox('setValue', connames);
                return true;
            } else {
                alertInfo("请选择人员");
                return false;
            }
        },
        onload: function () {
            if (names != null && names != "") {
                var namesArray = names.split(',');
                var idsArray = ids.split(',');
                for (var i = 0; i < namesArray.length; i++) {
                    $('#choosegrid').datagrid('appendRow', {
                        userId: idsArray[i],
                        userName: namesArray[i]
                    });
                }
            }

        }
    });
}

function selectOrgPlus() {

    var inputobj = formatterInputobj(this);
    // 修改--获取人员id 和 name
    var names = $('#' + inputobj.inputText).val();
    var ids = $('#' + inputobj.inputId).val();
    openChooseDialog({
        title: "选择表单",
        contenturl: '/view/sys/selectOrgOrDeptOrUserWin',
        width: 800,
        height: 500,
        okhandler: function () {
            var rows = $('#choosegrid').datagrid('getRows');
            if (rows) {
                var conids = [];
                var connames = [];
                for (var i = 0; i < rows.length; i++) {
                    conids.push(rows[i].userId);
                    connames.push(rows[i].userName);
                }
                if ($('#BFcLandPartol_Form').length > 0) {
                    $('#inspectOneId').val(conids);
                    $('#inspectOneName').textbox('setValue', connames);
                } else if ($('#BFcHousePartolform').length > 0) {
                    $('#inspectOneId').val(conids);
                    $('#inspectOneName').textbox('setValue', connames);
                } else {
                    $('#' + inputobj.inputId).val(conids);
                    $('#' + inputobj.inputText).textbox('setValue', connames);
                }
                return true;
            } else {
                alertInfo("请选择人员");
                return false;
            }
        },
        onload: function () {
            if (names != null && names != "") {
                var namesArray = names.split(',');
                var idsArray = ids.split(',');
                for (var i = 0; i < namesArray.length; i++) {
                    $('#choosegrid').datagrid('appendRow', {
                        userId: idsArray[i],
                        userName: namesArray[i]
                    })
                }
            }

        }
    });

}


function archivesForm(_options) {
    if (!_options.formCode) {
        alertInfo("表单编码不能为空");
        return;
    }
    if (!_options.businessId) {
        alertInfo("业务主键不能为空");
        return;
    }
    var status = '1';
    var url = "/GenForm/form?formcode=ArchivesArchiveFile";
    $.ajax({
        url: ctx + "/ArchivesArchiveFile/findByFormCodeAndPrimaryKey",
        data: {
            formCode: _options.formCode,
            primaryKey: _options.businessId
        },
        dataType: 'json',
        async: false,
        success: function (result) {
            if (result.success) {
                if (result.o) {
                    url += "&id=" + result.o.archiveFileId;
                    status = result.o.workflowStatus;
                    if (result.o.workflowStatus == '3') {
                        url += "&isdetail=true";
                    }
                }
            } else {
                alertError(result.msg);
            }
        }
    });
    var options = {
        fileName: "",
        formName: '归档',
        maximized: false,
        width: 560,
        height: 460,
        contenturl: url,
        submiturl: "/ArchivesArchiveFile/saveArchivesArchiveFile?formcode=ArchivesArchiveFile",
        onload: function () {
            autoSetValue("formCode", _options.formCode);
            autoSetValue("primaryKey", _options.businessId);
            autoSetValue("archiveFileName", _options.fileName);
            autoSetValue("archiveObject", "form");
        }
    }
    $.extend(options, _options);
    if (status == '3') {
        openDetailDialog(options);
    } else {
        options.bottons = [{
            text: "发送",
            iconCls: 'icon-apply',
            handler: function () {
                if ($("#ArchivesArchiveFile").form("validate")) {
                    var savebtn = $(this).closest("div").find("a[id$='save']");
                    top.alertConfirmYes("确认发送归档？", function (yes) {
                        if (yes) {
                            $("#ArchivesArchiveFile #workflowStatus").val("3");
                            savebtn.click();
                        }
                    });
                } else {
                    alertInfo("请先完善表单信息");
                }
            }
        }];
        openSaveDialog(options);
    }
}

function showEmpVicePositionWin() {
    var inputobj = formatterInputobj(this);
    // 修改--获取人员id 和 name
    var names = $('#' + inputobj.inputText).val();
    var ids = $('#' + inputobj.inputId).val();
    openChooseDialog({
        title: "选择岗位",
        contenturl: '/view/business/hr/selectHrDeptPostWin',
        width: 800,
        height: 500,
        okhandler: function () {
            var rows = $('#choosegrid').datagrid('getRows');
            if (rows) {
                var conids = [];
                var connames = [];
                for (var i = 0; i < rows.length; i++) {
                    conids.push(rows[i].postId);
                    connames.push(rows[i].postName);
                }
                $('#' + inputobj.inputId).val(conids);
                $('#' + inputobj.inputText).textbox('setValue', connames);
                return true;
            } else {
                alertInfo("请选择岗位");
                return false;
            }
        },
        onload: function () {
            if (names != null && names != "") {
                var namesArray = names.split(',');
                var idsArray = ids.split(',');
                for (var i = 0; i < namesArray.length; i++) {
                    $('#choosegrid').datagrid('appendRow', {
                        postId: idsArray[i],
                        postName: namesArray[i]
                    });
                }
            }

        }
    });
}

function selectEdocApply() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择",
        contenturl: '/view/business/edoc/EdocApplySelect',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#EdocApplySelect_datagrid').datagrid('getSelected');
            if (r) {

                autoSetValue("issuer", r.issuer);
                autoSetValue("subject", r.subject);
                autoSetValue("docType", r.edocType);
                autoSetValue("docMark", r.docMark);
                autoSetValue("edocId", r.id);
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }
    });
}

function viewEdocDetailFw(index, field, value) {
    var START_TIME = $("#START_TIME").datebox("getValue");
    var END_TIME = $("#END_TIME").datebox("getValue");
    var ORG_REPLACE = $("#ORG_REPLACE").combobox("getValue");
    var ORG_ID = $("#ORG_ID").combobox("getValue");
    if (field == "HAS_BEAN_COMPLETE" || field == "HAS_NO_COMPLETE" || field == "TOTAL_NUMS") {
        openDetailDialog({
            title: "统计详情",
            maximized: true,
            contenturl: "/view/business/edoc/EdocApplyDetail?edocType=2&START_TIME=" + START_TIME + "&END_TIME=" + END_TIME + "&ORG_REPLACE=" + ORG_REPLACE + "&ORG_ID=" + ORG_ID + "&field=" + field
        })
    }

}

function viewEdocDetailSw(index, field, value) {
    var START_TIME = $("#START_TIME").datebox("getValue");
    var END_TIME = $("#END_TIME").datebox("getValue");
    var ORG_ID = $("#ORG_ID").combobox("getValue");
    if (field == "HAS_BEAN_COMPLETE" || field == "HAS_NO_COMPLETE" || field == "TOTAL_NUMS") {
        openDetailDialog({
            title: "统计详情",
            maximized: true,
            contenturl: "/view/business/edoc/EdocApplyDetail?edocType=1&START_TIME=" + START_TIME + "&END_TIME=" + END_TIME + "&ORG_ID=" + ORG_ID + "&field=" + field
        })
    }
}


//选择授权类型
function selectOrgOrDeptOrUserWinSingle(object) {
    return function () {
        selectOrgOrDeptOrUser(object, this);
    }
}

function selectOrgOrDeptOrUserSingle(object, that) {
    if (!that) {
        that = this;
    }
    var inputobj = formatterInputobj(that);
    // 修改--获取人员id 和 name
    var names = $('#' + inputobj.inputText).val();
    var ids = $('#' + inputobj.inputId).val();
    openChooseDialog({
        title: "选择组织",
        contenturl: '/view/sys/selectOrgOrDeptOrUserWinFileBorrows?object=' + object,
        width: 800,
        height: 500,
        okhandler: function () {
            var rows = $('#choosegrid').datagrid('getRows');
            if (rows) {

                var conids = [];
                var connames = [];
                var names = [];
                for (var i = 0; i < rows.length; i++) {
                    var str = rows[i].userId.substring(0, rows[i].userId.indexOf(":"))
                    conids.push(rows[i].userId.substring(rows[i].userId.lastIndexOf(":") + 1, rows[i].userId.length));
                    connames.push(rows[i].userId.substring(0, rows[i].userId.indexOf(":")));
                    names.push(rows[i].userName);
                }
                $('#userId').val(conids);
                $('#userType').textbox('setValue', connames);
                $('#userType').textbox('setText', names);
                /*if ($('#BFcLandPartol_Form').length > 0) {
					$('#inspectOneId').val(conids);
					$('#inspectOneName').textbox('setValue', connames);
				} else if ($('#BFcHousePartolform').length > 0) {
					$('#inspectOneId').val(conids);
					$('#inspectOneName').textbox('setValue', connames);
				} else {
					$('#' + inputobj.inputId).textbox('setValue',conids);
					$('#' + inputobj.inputText).textbox('setText', connames);
				}*/
                return true;
            } else {
                alertInfo("请选择人员");
                return false;
            }
        },
        onload: function () {
            if (names != null && names != "") {
                var namesArray = names.split(',');
                var idsArray = ids.split(',');
                for (var i = 0; i < namesArray.length; i++) {
                    $('#choosegrid').datagrid('appendRow', {
                        userId: idsArray[i],
                        userName: namesArray[i]
                    });
                }
            }

        }
    });
}


//归档文件选择
function selectArchiveFile() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择归档文件",
        contenturl: '/view/business/archives/ArchivesFileSelectWin',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#ArchivesArchiveFileSelect_datagrid').datagrid('getSelected');
            if (r) {
                $("#" + inputobj.inputId).textbox("setValue", r.archiveFileId);
                $("#" + inputobj.inputId).textbox("setText", r.archiveFileName);
                return true;
            } else {
                alertInfo("请选择归档文件");
                return false;
            }
        }
    });

}


//人员选择弹出框
function showEmpWinFunArchive(type, that) {
    if (!that) {
        that = this;
    }
    var inputobj = formatterInputobj(that);
    openChooseDialog({
        title: "选择人员",
        contenturl: '/view/sys/empSelectWin?type=' + type,
        width: 800,
        height: 450,
        okhandler: function () {
            var r = $('#empSelect_datagrid').datagrid('getSelected');
            if (r) {
                $('#' + inputobj.inputId).textbox('setValue', r.ACCOUNT_ID);
                $('#' + inputobj.inputId).textbox('setText', r.ACCOUNT_NAME);
                $('#applyDept').val(r.DEPT_ID);
                $('#applyOrg').val(r.ORG_ID);
                return true;
            } else {
                alertInfo("请选择人员");
                return false;
            }
        },
        onload: function () {
            $('#empSelect_datagrid').datagrid({
                onDblClickRow: function (index, r) {
                    var btns = $(this).closest('.window').find('.dialog-button .l-btn-small');
                    if (btns.length > 0) {
                        $(btns[0]).click();
                    }
                }

            })
        }
    })

}

//培训申报选择框
function selectHrLearnDeclare() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择培训申报",
        contenturl: '/view/business/hr/HrLearnDeclareSelect?useType=3',//useType为3时是内部培训的弹出框
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#HrLearnDeclareSelect_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue("trainName", r.trainName);
                autoSetValue("trainType", r.trainType);
                autoSetValue("declareId", r.declareId);
                autoSetValue("trainForm", r.trainForm);
                autoSetValue("planTime", r.planTime);
                autoSetValue("trainContent", r.trainContent);
                return true;
            } else {
                alertInfo("请选择培训申报");
                return false;
            }
        }
    });
}


//会议弹出选择框，只查询自己记录的会议
function selectMeetingOnlyme() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择会议",
//		contenturl : '/view/dialog/meetingSelect',
        contenturl: '/view/business/gm/selectArrangeWin?pageType=fromEdoc',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#datagrid').datagrid('getSelected');
            if (r) {
                $("#" + inputobj.inputId).textbox("setValue", r.meetingAgendaArrangeId);
                $("#" + inputobj.inputId).textbox("setText", r.meetingName);
                return true;
            } else {
                alertInfo("请选择会议");
                return false;
            }
        }
    });
}


//项目弹出选择框，只查询负责的项目
function selectProjectOnlyme() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择项目",
        contenturl: '/view/business/pm/pmProjectSelectWin?isMe=Y',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#projectSelect_datagrid').datagrid('getSelected');
            if (r) {
                $("#" + inputobj.inputId).textbox("setValue", r.projectId);
                $("#" + inputobj.inputId).textbox("setText", r.projectName);
                return true;
            } else {
                alertInfo("请选择项目");
                return false;
            }
        }
    });
}


function selectEdocApplySW() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择收文",
        contenturl: '/view/business/edoc/EdocApplySWSelect',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#EdocApply_datagrid_select').datagrid('getSelected');
            if (r) {
                $("#" + inputobj.inputId).textbox("setText", r.subject);
                $("#sendUnit").textbox("setValue", r.sendUnit);
                autoSetValue("edocId", r.id);
                return true;
            } else {
                alertInfo("请选择收文");
                return false;
            }
        },
        onload: function () {
            $("#startTimes").datebox("setValue", (new Date()).Format("yyyy-MM") + "-01");
            $("#endTimes").datebox("setValue", (new Date()).Format("yyyy-MM-dd"));
        }
    });
}

//发文弹窗
function selectEdocApplyFW() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择发文",
        contenturl: '/view/business/edoc/EdocApplyFWSelect',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#EdocApply_datagrid_select').datagrid('getSelected');
            // console.info(r);
            if (r) {
                $("#edocId").val(r.id);
                $("#meetingName").textbox("setValue", r.subject);
                return true;
            } else {
                alertInfo("请选择发文");
                return false;
            }
        }
    });
}

function addGmTaskRegister() {
    openSaveDialog({
        title: "添加收文任务",
        maximized: true,
        contenturl: "/GenForm/form?formcode=GmTaskRegister",
        submiturl: "/GmTaskRegister/saveGmTaskRegister?formcode=GmTaskRegister",
        onload: function () {
            autoSetValue("meetingName", $("#subject").textbox("getValue"));
            autoSetValue("edocId", $("#id").val());
            autoSetValue("sendUnit", $("#sendUnit").textbox("getValue"));
        }
    });
}


function selectGmTaskYear() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择收文",
        contenturl: '/view/business/gm/GmTaskYearSelect',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $("#GmTaskYear_datagrid").datagrid('getSelected');
            if (r) {
                $("#" + inputobj.inputId).textbox("setValue", r.taskYearId);
                $("#" + inputobj.inputId).textbox("setText", r.projectName);
                return true;
            } else {
                alertInfo("请选择收文");
                return false;
            }
        }
    });

}


function selectGmAssetsRequisition() {// 入库用的
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择资产申购单",
        contenturl: '/view/business/gm/GmAssetsRequisitionSelect',
        width: 750,
        height: 550,
        okhandler: function () {
            var r = $("#GmAssetsRequisition_datagrid").datagrid('getSelected');
            if (r) {
                $("#" + inputobj.inputId).textbox("setValue", r.requisitionId);
                $("#" + inputobj.inputId).textbox("setText", r.reqNo);
                autoSetValue("applyAccount", r.applyAccount);
                autoSetValue("applyAccount_TEXT_", r.applyAccountText);
                autoSetValue("applyDept", r.applyDept);
                autoSetValue("applyDept_TEXT_", r.applyDeptText);
                var rows = $("#childTable").datagrid("getSelections");
                if (rows.length > 0) {
                    $(".repList2").remove();
                    for (var i = 0; i < rows.length; i++) {
                        loadEditorGrid(rows[i].requisitionDetilId);
                    }
                }
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        },
        onload: function () {
            var month = new Date().getMonth();
            if (month == 0) {
                $("#startDate").datebox("setValue", parseInt((new Date()).Format("yyyy")) - 1 + "-12" + (new Date()).Format("dd"));
            } else {
                $("#startDate").datebox("setValue", (new Date()).Format("yyyy") + "-" + (month < 10 ? "0" + month : month) + "-" + (new Date()).Format("dd"));
            }
            $("#endDate").datebox("setValue", (new Date()).Format("yyyy-MM-dd"));
        }
    });

}

function selectGmAssetsRequisitionFW() {


    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择采购合同",
        contenturl: '/view/business/gm/GmAssetsRequisitionSelectFW?serviceNature=3',
        width: 750,
        height: 550,
        okhandler: function () {
            var r = $("#PmBidSerconSel_datagrid").datagrid('getSelected');

            if (r) {
                $("#" + inputobj.inputId).textbox("setValue", r.serconId);
                $("#" + inputobj.inputId).textbox("setText", r.serconCode);

                $("#contactOrgId").textbox("setValue", r.partyB);
                $("#contactOrgId").textbox("setText", r.partyBText);


                $('#applyNewServiceType').combobox('setValue', r.applyNewServiceType);
                $('#applyNewAssetsType').combobox('setValue', r.applyNewAssetsType);


                $.ajax({
                    url: ctx + "/PmServiceContent/findPmServiceContentBySerconId",
                    data: {
                        serconId: r.serconId
                    },
                    dataType: 'json',
                    success: function (result) {
                        if (result) {
                            delAllFWdata();
                            for (var i = 0; i < result.length; i++) {

                                //资产类别
                                // result.o[i].categoryId=result.o[i].categoryId==null?'':result.o[i].categoryId;

                                loadEditorGridAFD(result[i]);

                                //第二次选中采购申请时，先删除上一次的，总金额重新计算，删除一条计算一条。加载时又不计算结果显示0
                                //放这里赋值来避免上面的错误
                                //采购申请金额
                                // $('#serconMoney').numberbox('setValue',r.budgetMoney);
                            }
                        } else {
                        }
                    }
                });

                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }
    });

}

/**
 * 维修服务合同的验收,租金评估服务合同的验收
 * serviceNature ：1 维修；2 租金评估
 */
function selectGmAssetsRequisitionWX() {

    var serviceNature = '';
    if ($('#AssetsWxArrival').length > 0) {
        serviceNature = 1;
    }
    if ($('#MaLeaseEvConfirm').length > 0) {
        serviceNature = 2;
    }

    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择采购合同",
        contenturl: '/view/business/gm/GmAssetsRequisitionSelectWX?serviceNature=' + serviceNature,
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $("#PmBidSerconSel_datagrid").datagrid('getSelected');
            var rows = $("#childTable").datagrid("getSelections");

            if (r) {
                $("#" + inputobj.inputId).textbox("setValue", r.serconId);
                $("#" + inputobj.inputId).textbox("setText", r.serconCode);

                // autoSetValue("serconMoney",r.serconMoney);
                // $("#contactOrgId").textbox("setValue",r.partyB);
                // $("#contactOrgId").textbox("setText",r.partyBText);
                // autoSetValue("applyAccount_TEXT_",r.applyAccountText);
                // autoSetValue("applyDept",r.applyDept);
                // autoSetValue("applyDept_TEXT_",r.applyDeptText);


                if (rows.length > 0) {
                    // $(".repList2").remove();

                    if (serviceNature == '1') {//维修服务合同


                        autoSetValue("serconMoney", r.serconMoney);
                        //维修单位
                        $('#partyB').textbox('setValue', r.partyB);
                        $('#partyB').textbox('setText', r.partyBText);

                        delAllDataWX();
                        for (var i = 0; i < rows.length; i++) {

                            loadEditorGridWX(rows[i]);
                        }
                    }
                    if (serviceNature == '2') {//租金评估服务合同

                        //评估机构
                        $('#ratingAgencies').textbox('setValue', r.partyB);
                        $('#ratingAgencies').textbox('setText', r.partyBText);
                        delAllDataZJPG();
                        for (var i = 0; i < rows.length; i++) {
                            loadEditorGridZJPG(rows[i]);
                        }
                    }

                } else {
                    alertInfo("要选择采购合同明细,才能加载验收内容哦");
                }
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }
    });

}

//采购申请主表弹框 简单版。查询已完成的和采购方式为公开招标的
function showPmBidApplyNewSimple() {

    var serconSource = null;
    var formCode;
    if ($('#PmBidFile').length > 0) {//招标文件会签 时
        //采购方式为公开招标
        serconSource = 1;
        formCode = 'PmBidFile';
    }

    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择采购申请主表",
        // contenturl: '/view/business/gm/GmAssetsCatalogSelect?filterInfoId='+filterInfoId.join(','),
        contenturl: '/view/business/gm/PmBidApplyNewSelect?serconSource=' + serconSource + '&type=1&formCode=' + formCode,
        width: 850,
        height: 500,
        okhandler: function () {

            var r = $('#PmBidApplyNewSelect_datagrid').datagrid('getSelected');
            if (r) {
                $('#' + inputobj.inputId).textbox('setValue', r.applyNewId);
                $('#' + inputobj.inputId).textbox('setText', r.applyNewNo);

                if ($('#PmBidFile').length > 0) {//招标文件会签

                    $('#budgetAmount').numberbox('setValue', r.budgetMoney);

                    autoSetValue("bidApplyId", r.applyNewId);
                    autoSetValue("bidName", r.applyNewNo);
                }


                return true;
            } else {
                alertInfo("选择采购申请主表");
                return false;
            }
        }
    })

}

//采购申请主表弹框 采购合同使用。
function showPmBidApplyNew() {

    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择采购申请",
        contenturl: '/view/business/gm/PmBidApplyNewSelect?type=2',
        width: 850,
        height: 500,
        okhandler: function () {

            var r = $('#PmBidApplyNewSelect_datagrid').datagrid('getSelected');

            if (r) {

                $('#applyNewId').val(r.applyNewId);
                $('#applyNewIdText').textbox('setValue', r.applyNewNo);

                // $('#serconType').combotree('setValue',r.pmconTypeId);


                //采购方式
                //$('#serconSource').combobox('setValue',r.serconSource);
                // $('#serconMoney').numberbox('setValue',r.budgetMoney);


                //服务类型
                // $('#applyNewServiceType').combobox('setValue',r.applyNewServiceType);
                //资产类型
                // $('#applyNewAssetsType').combobox('setValue',r.applyNewAssetsType);

                //中标单位
                $('#partyB').val(r.winUnit);
                $('#partyB_TEXT_').textbox('setValue', r.winUnitText);


                if (r.aim == 1) {//货物类采购申请。采购合同的货物明细增加值
                    $.ajax({
                        url: ctx + "/PmBidApplyNewDetail/findPmBidApplyNewDetailListForPBS",
                        data: {
                            id: r.applyNewId
                        },
                        dataType: 'json',
                        success: function (result) {
                            if (result.success) {
                                delAllbiddata();
                                for (var i = 0; i < result.o.length; i++) {

                                    //资产类别
                                    // result.o[i].categoryId=result.o[i].categoryId==null?'':result.o[i].categoryId;

                                    loadEditorGridPBPD(result.o[i]);

                                    //第二次选中采购申请时，先删除上一次的，总金额重新计算，删除一条计算一条。加载时又不计算结果显示0
                                    //放这里赋值来避免上面的错误
                                    //采购申请金额
                                    $('#serconMoney').numberbox('setValue', r.budgetMoney);
                                }
                            } else {
                            }
                        }
                    });
                } else {//r.aim == 3 服务类采购申请。采购合同的服务明细增加值。工程类的先不考虑

                    $.ajax({
                        url: ctx + "/PmBidApplyNewGcDetail/findPmBidApplyNewGcDetailListForPBS",
                        data: {
                            id: r.applyNewId
                        },
                        dataType: 'json',
                        success: function (result) {
                            if (result.success) {
                                delAllServicedata();
                                for (var i = 0; i < result.o.length; i++) {
                                    //资产类别
                                    // result.o[i].categoryId=result.o[i].categoryId==null?'':result.o[i].categoryId;

                                    loadEditorSCGridPBPD(result.o[i]);

                                    //第二次选中采购申请时，先删除上一次的，总金额重新计算，删除一条计算一条。加载时又不计算结果显示0
                                    //放这里赋值来避免上面的错误
                                    //采购申请金额
                                    $('#serconMoney').numberbox('setValue', r.budgetMoney);
                                }
                            } else {

                            }
                        }
                    });
                }


                return true;
            } else {
                alertInfo("请选择资金收取计划");
                return false;
            }
        }
    })

}

//采购申请主表弹框 定点采购验收。
function showPmBidApplyNewDD() {

    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择采购申请",
        contenturl: '/view/business/gm/PmBidApplyNewSelect?type=3',
        width: 850,
        height: 500,
        okhandler: function () {

            var r = $('#PmBidApplyNewSelect_datagrid').datagrid('getSelected');
            if (r) {
                $('#' + inputobj.inputId).textbox('setValue', r.applyNewId);
                $('#' + inputobj.inputId).textbox('setText', r.applyNewNo);


                $.ajax({
                    url: ctx + "/PmBidApplyNewDetail/findPmBidApplyNewDetailListForDD",
                    data: {
                        id: r.applyNewId
                    },
                    dataType: 'json',
                    success: function (result) {


                        if (result.success) {
                            delAllData();

                            var isHC;
                            for (var i = 0; i < result.o.length; i++) {

                                if (result.o[i].categoryId) {//非耗材

                                    isHC = false;
                                } else {//耗材时
                                    isHC = true;
                                    // categoryId
                                    result.o[i].categoryId = result.o[i].categoryId == null ? '' : result.o[i].categoryId;
                                }
                                loadEditorGrid2(result.o[i], isHC);
                            }

                            //定点采购验收的就行。货物验收的不行
                            arrivalTotalMoney();

                        } else {
                            alertError(result.msg);
                        }
                    }
                });

                return true;
            } else {
                alertInfo("请选择采购申请");
                return false;
            }
        }
    })

}


/** 招标计划明细选择****************/
function showPmBidPlandWinFun() {
    openChooseDialog({
        title: "招标计划明细",
        contenturl: '/view/business/pm/PmBidPlandSelectWin',
        width: 750,
        height: 450,
        okhandler: function () {
            var row = $('#pmBidPlandSelect_datagrid').datagrid('getSelected');
            if (row) {
                autoSetValue('bidPlandId', row.bidPlandId);
                autoSetValue('bidName', row.bidName);
                autoSetValue('applyUnit', row.makeUnit);
                autoSetValue('budgetAmount', row.bidBudget);
                return true;
            } else {
                alertInfo("请选择一条招标计划明细");
                return false;
            }
        }
    })

}

/*************************融资合同选择框*****************/
function showFmConWithTypeWinFun() {
    var inputobj = formatterInputobj(this);
    var url = '/view/business/fm/FmContractWithTypeWinFun';
    if ($("#FmRepay").length > 0 || $("#FmRepayAdvance").length > 0) {
        var filterFmconid = [];
        var borrow = $('#orgId').combobox('getValue');
        var rows = $('#FmRepay_datagrid').datagrid("getRows");
        if (rows) {
            for (var i = 0; i < rows.length; i++) {
                filterFmconid.push(rows[i].fmconId);
            }
        }
        url = '/view/business/fm/FmContractWithTypeWinFun?isHuanB=true&filterFmconid=' + filterFmconid + '&borrow=' + borrow;//还本类合同弹窗过滤已经结束还款的合同  isHuanB=true
    }
    if ($("#FmExternalFundOut").length > 0) {
        url = '/view/business/fm/FmContractWithTypeWinFun?isZhuanC=true';
    }

    if ($("#FmExternalFundBack").length > 0) {
        url = '/view/business/fm/FmContractWithTypeWinFun?isZhuanH=true';
    }
    if ($("#FmExternalCon").length > 0) {
        url = '/view/business/fm/FmContractWithTypeWinFun?isZhuanD=true';
    }

    openChooseDialog({
        title: "选择融资合同",
        contenturl: url,
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#FmContractWin_datagrid').datagrid('getSelected');
            if (r) {
                $("#fmconId").val(r.fmconId);
                $("#" + inputobj.inputId).textbox("setText", r.fmconName);
                /*$("#fmproId_TEXT").textbox("setText",r.fmproIdText);
					$("#projectId_TEXT").val(r.projectIdText);
					$("#fmproId").val(r.fmproId);*/
                if ($("#FmRepay").length > 0 || $("#FmRepayAdvance").length > 0) {
                    $('#planRepayMoney').numberbox('clear');
                    $('#jsonData').val("");
                }
                if ($("#FmExternalFundOut").length > 0) {
                    $('#outDetailList').panel('refresh', ctx + '/FmFundOutDetail/editFmFundOutDetail?fmconId=' + r.fmconId);
                    $('#payeeUnit').val(r.externalUnit);
                    $('#payeeUnit_TEXT_').textbox('setValue', r.externalUnitText);
                    $('#outedMoney').numberbox('setValue', r.outedMoney);
                }
                if ($("#FmExternalFundBack").length > 0) {
                    $('#backDetailList').panel('refresh', ctx + '/FmFundBackDetail/editFmFundBackDetail?fmconId=' + r.fmconId);
                    $('#paymentUnit').val(r.externalUnit);
                    $('#paymentUnit_TEXT_').textbox('setValue', r.externalUnitText);
                    $('#backedMoney').numberbox('setValue', r.backedMoney);
                }

                if ($("#FmExternalCon").length > 0) {
                    $('#lend').combobox('setValue', r.borrower);
                    $('#borrower_TEXT_').textbox('setValue', r.externalUnitText);
                    $('#borrower').val(r.externalUnit);
                    $('#conMoney').numberbox('setValue', r.fmconMoney);
                }
                return true;
            } else {
                alertInfo("请选择融资合同");
                return false;
            }
        }
    })
}

//	if(haseasyui("#FmLoanDeclare #orgId")&&haseasyui("#FmLoanDeclare #applyMoney")){}
/*************************融资项目选择框*****************/
function showFmproWithTypeWinFun() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择融资项目",
        contenturl: '/view/business/fm/FmproWithTypeWinFun',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#FmProjectWin_datagrid').datagrid('getSelected');
            if (r) {
                $("#fmproId").val(r.fmproId);
                $("#fmproIdText").textbox("setText", r.fmproName);
                $("#fmproId_TEXT_").textbox("setText", r.fmproName);
                if (haseasyui("#creditProjectIdText")) {
                    $('#creditProjectIdText').textbox('clear');
                    $('#creditProjectId').val('');
                    $('#creditMoney_C').numberbox('clear');
                }
                var fmproId = $("#fmproId").val();
                var fmconId = $("#fmconId").val();
                if (haseasyui("#fmconProject")) {
                    var fmconTypeC = $('#fmconType').combobox('getValue');
                    $('#fmconProject').panel('refresh', ctx + '/FmConProject/toConProjectPage?fmproId=' + fmproId + '&id=' + fmconId + '&fmconTypeC=' + fmconTypeC);
                }
                return true;
            } else {
                alertInfo("请选择融资项目");
                return false;
            }
        }
    })
}


function showFmproWithTypeWinFunRz() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择融资项目",
        contenturl: '/view/business/fm/FmproWithTypeWinFun',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#FmProjectWin_datagrid').datagrid('getSelected');
            if (r) {
                $("#bidApplyId").val(r.applyId);
                $("#bidApplyIdText").textbox("setText", r.projectName);
                if (haseasyui("#creditProjectIdText")) {
                    $('#creditProjectIdText').textbox('clear');
                    $('#creditProjectId').val('');
                    // $('#creditMoney_C').numberbox('clear');
                }
                var fmproId = $("#fmproId").val();
                var conId = $("#conId").val();
                if (haseasyui("#fmconProject")) {
                    var fmconTypeC = $('#fmconType').combobox('getValue');
                    $('#fmconProject').panel('refresh', ctx + '/FmConProject/toConProjectPage?fmproId=' + fmproId + '&id=' + conId + '&fmconTypeC=' + fmconTypeC);
                }
                return true;
            } else {
                alertInfo("请选择融资项目");
                return false;
            }
        }
    })
}

//工程合同选择项目的弹框
function showFmproWithTypeWinFunGc() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择工程项目",
        contenturl: '/view/business/pm/PmProjectBuildWinFun',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#PmProject_datagrid').datagrid('getSelected');
            if (r) {
                $("#fmproId").val(r.projectId);
                $("#fmproIdText").textbox("setText", r.projectName);
                // if(haseasyui("#creditProjectIdText")){
                //     $('#creditProjectIdText').textbox('clear');
                //     $('#creditProjectId').val('');
                //     // $('#creditMoney_C').numberbox('clear');
                // }
                // var fmproId = $("#fmproId").val();
                // var conId = $("#conId").val();
                // if(haseasyui("#fmconProject")){
                //     var fmconTypeC = $('#fmconType').combobox('getValue');
                //     $('#fmconProject').panel('refresh',ctx+'/FmConProject/toConProjectPage?fmproId='+fmproId+'&id='+conId+'&fmconTypeC='+fmconTypeC);
                // }
                autoSetValue('pmConstructUnit', r.constructUnit);
                autoSetValue('pmConstructUnit_TEXT_', r.constructUnitText);
                autoSetValue('pmPreconstructUnit', r.pmPreconstructUnit);
                return true;
            } else {
                alertInfo("请选择工程项目");
                return false;
            }
        }
    })
}


function showConBidApply() {
    var inputobj = formatterInputobj(this);
    var bidApplyId = ($("#bidApplyId").val() == null || $("#bidApplyId").val() == "" || typeof ($("#bidApplyId").val()) == "undefined") ? "" : $("#bidApplyId").val();
    openChooseDialog({
        title: "选择招采项目",
        contenturl: '/view/business/cn/ConBidApplyWinFun?bidApplyId=' + bidApplyId,
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#ConBidApply_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue('bidApplyId', r.applyId);
                autoSetValue('bidApplyIdText', r.projectName);
                autoSetValue('ownerUnit', r.ownerUnit);
                autoSetValue('purchaseType', r.purchaseType);
                autoSetValue('budgetAmount', r.budgetAmount);
                return true;
            } else {
                alertInfo("请选择招采项目");
                return false;
            }
        }
    })
}

//增加入库子表
function showConApplyDetailsInfoNew() {
    var fCode = this.form.id;
    var formCode = "";
    if (fCode == "ConInfo_PM") {
        formCode = "ConTenderResult";
    }
    openChooseDialog({
        title: "申请单据",
        contenturl: '/view/business/cn/ConApplyDetailsSelectWin?formCode=' + formCode,
        width: 750,
        height: 450,
        okhandler: function () {
            var row = $("#GmAssetsMaterialReq_datagrid").datagrid('getSelected');
            if (row) {
                autoSetValue('pmBussinessIdText', row.reqDetails);
                autoSetValue('pmBussinessId', row.reqId);
                if ($("#pmConSource").length > 0) {
                    autoSetValue('pmConSource', row.formCode);
                }
                return true;
            } else {
                alertInfo("请选择单据信息");
                return false;
            }
        }
    })
}

//根据formCode和id查看表单明细
function openFormDetailNew(formcode, id) {
    openDetailDialog({
        title: "查看记录",
        maximized: true,
        contenturl: "/GenForm/form?formcode=" + formcode + "&isdetail=true&id=" + id
    });
}


//根据id查看合同表单明细
function openConFormDetailById(id) {
    var formcode = "";
    $.ajax
    ({
        url: ctx + "/ConInfo/findConInfo",
        dataType: "json",
        data: {
            id: id
        },
        success: function (res) {
            formcode = res.fCode;
            openDetailDialog({
                title: "查看记录",
                maximized: true,
                contenturl: "/GenForm/form?formcode=" + formcode + "&isdetail=true&id=" + id
            });
        },
        error: function () {
            alert('系统可能有些故障，请联系管理员!');
        },
    });
}

function showEngageResult() {
    var inputobj = formatterInputobj(this);
    var bidApplyId = ($("#conInstitutionId").val() == null || $("#conInstitutionId").val() == "" || typeof ($("#conInstitutionId").val()) == "undefined") ? "" : $("#conInstitutionId").val();
    openChooseDialog({
        title: "选择中介机构选择业务申请",
        contenturl: '/view/business/cn/ConInstitutionApplyWin?bidApplyId=' + bidApplyId,
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#ConInstitutionApplyWin_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue('conInstitutionId', r.applyId);
                autoSetValue('conInstitutionIdText', r.projectName);
                autoSetValue('ownerUnit', r.belongOrgId);
                return true;
            } else {
                alertInfo("请选择中介机构选择业务申请项目");
                return false;
            }
        }
    })
}

/**
 *资金支付明细页面资金改变事件
 *
 */
//申报金额改变事件
function applyMoneyChange(newValue, oldValue) {
//资金拨付进度款时获取预付款已付金额
//var phaseType = $('#phaseType').val();
//var pmconId = $('#pmconId').val();
//var paidMoney = 0.0;
    /*if(phaseType=="JDK"){
	$.ajax({
		url : ctx+"/FmPay/getpaidMoney",
		data : {
			pmconId :pmconId,
			phaseType:phaseType
		},
		dataType : 'json',
		success : function(result) {
			paidMoney = result;
		}
	});
}*/
    var phaseMoney = $('#FmPay #phaseMoney').numberbox('getValue');
    var pmconMoney = $('#FmPay #pmconMoney').numberbox('getValue');
    if (newValue > parseFloat(pmconMoney)) {
        alertWarn("申报金额不应大于合同金额，请重新输入");
        $('#FmPay #applyMoney').numberbox('clear');
        return;
    }
    if (newValue > parseFloat(phaseMoney)) {
        alertWarn('申报金额不能大于付款阶段金额，请重新输入');
        $('#FmPay #applyMoney').numberbox('clear');
        return;
    }
    $('#FmPay #preAuditMoney').numberbox('setValue', newValue);
}

//会审金额改变事件
function preAuditMoneyChange(newValue, oldValue) {
    var applyMoney = $('#FmPay #applyMoney').numberbox('getValue');
    if (newValue > parseFloat(applyMoney)) {
        alertWarn("会审金额不应大于申报金额");
        $('#FmPay #preAuditMoney').numberbox('clear');
        return;
    }
    $('#FmPay #auditMoney').numberbox('setValue', newValue);
}

//拟支付金额改变事件
function auditMoneyChange(newValue, oldValue) {
    var preAuditMoney = $('#FmPay #preAuditMoney').numberbox('getValue');
    if (newValue > parseFloat(preAuditMoney)) {
        alertWarn("拟支付金额不应大于会审金额");
        $('#FmPay #auditMoney').numberbox('clear');
        return;
    }

    $('#FmPay #payMoney').val(newValue);
}

//申报农民工工资改变事件
function farmerApplyMoneyChange(newValue, oldValue) {
    var applyMoney = $('#FmPay #applyMoney').numberbox('getValue');
    if (newValue > parseFloat(applyMoney)) {
        alertWarn("申报农民工工资不应大于申报金额");
        $('#FmPay #farmerApplyMoney').numberbox('clear');
        return;
    }
    $('#FmPay #farmerPreAuditMoney').numberbox('setValue', newValue);
}

//会审农民工工资改变事件
function farmerPreAuditMoneyChange(newValue, oldValue) {
    var farmerApplyMoney = $('#FmPay #farmerApplyMoney').numberbox('getValue');
    var preAuditMoney = $('#FmPay #preAuditMoney').numberbox('getValue');
    if (newValue > parseFloat(farmerApplyMoney)) {
        if (farmerApplyMoney == 0) {
            alertWarn("请填入申报农民工工资");
            $('#FmPay #farmerPreAuditMoney').numberbox('clear');
        }
        alertWarn("会审农民工工资不应大于申报农民工工资");
        $('#FmPay #farmerPreAuditMoney').numberbox('clear');
        return;
    }
    if (newValue > parseFloat(preAuditMoney)) {
        alertWarn("会审农民工工资不应大于会审金额");
        $('#FmPay #farmerPreAuditMoney').numberbox('clear');
        return;
    }
    $('#FmPay #farmerAuditMoney').numberbox('setValue', newValue);
}

//拟支付农民工工资改变事件
function farmerAuditMoneyChange(newValue, oldValue) {
    var farmerPreAuditMoney = $('#FmPay #farmerPreAuditMoney').numberbox('getValue');
    var auditMoney = $('#FmPay #auditMoney').numberbox('getValue');
    if (newValue > parseFloat(farmerPreAuditMoney)) {
        if (farmerPreAuditMoney == 0) {
            alertWarn("请填入会审农民工工资");
            $('#FmPay #farmerAuditMoney').numberbox('clear');
        }
        alertWarn("拟支付农民工工资不应大于会审农民工工资");
        $('#FmPay #farmerAuditMoney').numberbox('clear');
        return;
    }
    if (newValue > parseFloat(auditMoney)) {
        alertWarn("拟支付农民工工资不应大于拟支付金额");
        $('#FmPay #farmerAuditMoney').numberbox('clear');
        return;
    }
    $('#FmPay #farmerPayMoney').val(newValue);
}

//统计单元格样式
function formatterColor(formatterColorvalue, row, index) {
    return 'background-color:#6293BB;color:#000;margin-left:0px';
}

function chooseFlowType(type) {
    return function () {
        chooseFlow(type, this)
    }
}

function chooseFlow(type, that) {
    if (!that) {
        that = this;
    }
    if (typeof (type) == 'undefined') {
        type = '';
    }
    var inputobj = formatterInputobj(that);
    openChooseDialog({
        title: '选择流程',
        contenturl: '/GenForm/allflow?type=' + type + ($("#grantOrgs").length > 0 && $("#grantOrgs").combobox("getValue") ? "&orgId=" + $("#grantOrgs").combobox("getValue") : ""),
        width: 400,
        height: 500,
        okhandler: function () {
			var row=$("#allflow").datagrid('getSelected');
            if (row) {
                $("#" + inputobj.inputId).textbox("setValue", row.value);
                $("#" + inputobj.inputId).textbox("setText", row.text);
                return true;
            } else {
                alertInfo("请选择流程");
                return false;
            }
        }
    });

}

function openWordDialog() {
    // 自身浏览器打开
    var mhtmlHeight = window.screen.availHeight; // 获得窗口的垂直位置;
    var mhtmlWidth = window.screen.availWidth; // 获得窗口的水平位置;
    var iTop = 0; // 获得窗口的垂直位置;
    var iLeft = 0; // 获得窗口的水平位置;
    var recordId = $("#documentBody").val();//存储文档ID的字段
    if (recordId == "" || recordId == null) {
        recordId = generateUUID();
        autoSetValue("documentBody", recordId);
    }
    var documentFormat = $("#documentFormat").textbox("getValue");//文档类型word/excel
    var templateName = "";//文档标题
    if ($("#documentName").length > 0) {
        templateName = $("#documentName").textbox("getValue");
    }
    if (templateName == "") {
        templateName = "空文件";
    }
    var url = ctx + "/view/doc/iweboffice/addOrEditOffice?recordId=" + recordId + "&templateName=" + templateName + "&documentFormat=" + documentFormat;
    window.open(url, templateName, 'height=' + mhtmlHeight + ',width=' + mhtmlWidth + ',top=' + iTop + ',left=' + iLeft + ',toolbar=no,menubar=yes,scrollbars=no,resizable=yes, location=no,status=no');
}


/*************************财务科目树*****************/
function showBasAccountTree() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择财务科目",
        contenturl: '/FmAccount/FmAccountTree',
        width: 550,
        height: 500,
        okhandler: function () {
            var r = $('#BasAccount_tree').tree('getSelected');
            if (r) {
                if ($("#BFmVoucher_Form").length > 0) {//会计凭证
                    var rows = $BFmVoucherDtl_datagrid.datagrid('getRows');
                    var row = rows[BFmVoucherDtl_EditIndex];
                    var ed = $BFmVoucherDtl_datagrid.datagrid('getEditor', {index: BFmVoucherDtl_EditIndex, field: 'ACCOUNT_ID_TEXT_'});
                    $(ed.target).textbox('setValue', r.text);
                    row.ACCOUNT_ID = r.attributes.accountid;
                    //loadAssistanthgDatagrid(row.VOUCHER_DTL_ID,row.ACCOUNT_ID);
                } else if ($("#BFmInterestIncomeform").length > 0) {
                    $('#' + inputobj.inputId).val(r.attributes.accountid);
                    $('#' + inputobj.inputText).textbox('setValue', r.text);
                } else if ($("#BFmTemplate_Form").length > 0) {//会计模板
                    var rows = $BFmTemplateAccount_datagrid.datagrid('getRows');
                    var row = rows[templatedtl_edit_index];
                    var ed = $BFmTemplateAccount_datagrid.datagrid('getEditor', {index: templatedtl_edit_index, field: 'ACCOUNT_ID_TEXT_'});
                    $(ed.target).textbox('setValue', r.text);
//					var ed1 = $BFmTemplateAccount_datagrid.datagrid('getEditor', {index:templatedtl_edit_index,field:'PK_SUBJTYPE'});
//					$(ed1.target).combobox('setValue',r.attributes.pk_subjtype);
                    row.ACCOUNT_ID = r.attributes.accountid;
                    row.ACCOUNT_CODE = r.attributes.fnumber;
                } else if ($("#BasBankAccount_Form").length > 0) {//银行账号信息
                    var rows = $baccount_grid.datagrid('getRows');
                    var row = rows[bankaccount_edit_index];
                    var ed = $baccount_grid.datagrid('getEditor', {index: bankaccount_edit_index, field: 'ACCOUNT_ID_TEXT_'});
                    $(ed.target).textbox('setValue', r.text);
                    row.ACCOUNT_ID = r.attributes.accountid;
                } else {
                    $('#' + inputobj.inputId).val(r.attributes.accountid);
                    $('#' + inputobj.inputText).textbox('setValue', r.text);
                }
                return true;
            } else {
                alertInfo("请选择财务科目");
                return false;
            }
        }
    })
}

/*************************银行树*****************/
function showBasBankTree() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择银行",
        contenturl: '/view/sys/BasBankTree',
        width: 300,
        height: 400,
        okhandler: function () {
            var r = $('#BasBank_tree').tree('getSelected');
            if (r) {
                if ($("#FmRateAdjust").length > 0) {
                    $('#loanBankId').val(r.id);
                    $('#loanBank').textbox('setValue', r.attributes.bank_name);
                } else {
                    $('#' + inputobj.inputId).val(r.id);
                    $('#' + inputobj.inputText).textbox('setValue', r.text);
                }
                return true;
            } else {
                alertInfo("请选择银行信息");
                return false;
            }
        }
    })
}

/**
 *应诉管理的弹出框
 */
function showPmRiskLawsuitControlWin() {
    openChooseDialog({
        title: "请选择",
        contenturl: '/view/business/pm/PmRiskLawsuitControlSelect',
        width: 750,
        height: 450,
        okhandler: function () {
            var row = $('#PmRiskLawsuitControl_datagrid_Select').datagrid('getSelected');
            if (row) {
                $("#lawsuitNo").textbox('setValue', row.lawsuitNo);
                if ($("#PmRiskLawsuit").length > 0) {
                    autoSetValue("lawsuitTitle", row.lawsuitTitle);
                    autoSetValue("initiateDept", row.initiateDept);
                    autoSetValue("lawSubject", row.lawSubject);
                    $("#firstLawsuitId").textbox('setValue', row.riskLawsuitId);
                    $("#firstLawsuitId").textbox('setText', row.lawsuitTitle);
                }
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }
    })
}


//收文正文，选择已签收发文和审核的收文
function selectEdocApplyQS() {
    openChooseDialog({
        title: "选择已签收收文",
        contenturl: '/view/business/edoc/EdocApplySelectQSAndSH',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#EdocApplySelect_datagrid').datagrid('getSelected');
            if (r) {
                $('#subject').textbox('setValue', r.subject);
//				$('#send_department2').textbox('setValue',r.orgReplace);
                $('#send_department2').textbox('setValue', r.orgName);

                $('#doc_mark').textbox('setValue', r.docMark);
                if (r.docType == '2' || r.docType == '1') {
                    queryAndSetFileById(r.edocId);
                }

                return true;
            }
        }
    });
}

//收文点击跳转关联的已接收的收文
function viewFromEdoc(content, subject, id) {
    var mhtmlHeight = window.screen.availHeight; //获得窗口的垂直位置;
    var mhtmlWidth = window.screen.availWidth; //获得窗口的水平位置;
    var iTop = 0; //获得窗口的垂直位置;
    var iLeft = 0; //获得窗口的水平位置;
    var url = ctx + "/EdocApply/toAddOrEditPage?editType=0&recordId=" + content + "&templateName=" + subject + "&id=" + id;
    window.open(url);
}

//查看表单明细
function openFormDetail(id) {
    var url = ctx + "/EdocApply/openPrintPage?id=" + id;
    window.open(url);
}

function queryAndSetFileById(id) {
    if ($("#ortherDocId").length > 0) {
        $('#ortherDocId').textbox('setValue', id);
    }
    $.ajax({
        url: ctx + "/EdocApply/findEdocApply",
        data: {
            id: id
        },
        type: "post",
        dataType: "json",
        success: function (data) {
            //loadViewFileList(data.fileMap);

            if ($("#viewSpan").length > 0) {
                $('#viewSpan').remove();
            }

            var tr = '<tr id = "viewSpan">';
            if (data.edocType != '2') {
                tr += '<td style="WORD-WRAP: break-word" colspan="2" class="repList"><a  onclick=\'openFormDetail(' + data.id + ')\'><svg class="icon" aria-hidden="true"> <use xlink:href="#icon-file"></use> </svg><font color="blue"> ' + data.docMark + '</font></a></td>';
            }
            if (data.edocType == '2') {
                tr +=
                    //'<td style="WORD-WRAP: break-word"  class="repList"><a  onclick=\'openFormDetail('+data.id+')\'><svg class="icon" aria-hidden="true"> <use xlink:href="#icon-file"></use> </svg><font color="blue"> '+data.docMark+'</font></a></td>'
                    //'<td style="width:90px;"><a onclick=\'viewFromEdoc(\"'+data.content+'\",\"'+data.subject+'\",\"'+data.id+'\")\' ><svg class="icon" aria-hidden="true"> <use xlink:href="#icon-file"></use> </svg><font color="blue">'+data.docMark+'</font></a></td>';
                    '<td colspan="2" ><a onclick=\'previewFileByFileId("' + data.content + '")\' ><svg class="icon" aria-hidden="true"> <use xlink:href="#icon-file"></use> </svg><font color="blue">' + data.docMark + '</font></a></td>';
            }

            tr += '</tr>';

            $("#_local_filearray380").append(tr);
        }
    })
}

//根据维修类别改变整改框是否可编辑。1 整改；2 计划保养；3 应急
function maintainTypeChange() {
    var typeId = $("#maintainType").textbox("getValue");
    if (typeId == 1) {
        setCss($("#rectifyId"), "textbox", true, false, true, false, true);
    } else {
        setCss($("#rectifyId"), "textbox", false, true, false, true, true);
    }
}

//维修预算大于5万时 设置招标为：是，小于5万时不动 让其自己判断
function maintainBudgetChange(n, o) {
    if (n >= 5) {
        //setCss($id, datatype, editable, readonly, required, disableinput置灰, clear)
        setCss($("#isBid"), "combobox", false, true, false, true, true);
        $("#isBid").combobox("setValue", "Y");
    } else {
        setCss($("#isBid"), "combobox", false, false, true, false, true);
    }
}

//房屋维修的。根据是否招标改变招标申请框是否可编辑
function isBidChange() {
    var isBid = $("#isBid").textbox("getValue");
    if (isBid == 'Y') {
        //是招标
        setCss($("#bidApplyId"), "textbox", true, false, true, false, true);
    } else {
        setCss($("#bidApplyId"), "textbox", false, true, false, true, true);
    }
}

//作废流程
function destoryApply() {
    $.ajax({
        url: ctx + "/EdocApply/destoryApply",
        data: {
            id: $('#id').val()
        },
        type: "post",
        dataType: "json",
        success: function (data) {
            if (data.success) {
                alertInfo("作废成功");
                var endstr = ctx + "/"
                if (_preurl.substring(_preurl.length - endstr.length) == endstr && parent) {
                    if (typeof isLayer != "undefined") { //首页待办layer层打开
                        parent.layer.closeAll();
                    } else {
                        parent.closeByTabSelected();
                    }
                } else {
                    window.history.go(-1);
                }
            } else {
                alertError("作废失败，请联系管理员");
            }
        }
    })
}

/** ***********************往来单位弹出窗   用于可编辑列的弹窗************************ */
function showContactOrgWinEdit(code) {
    return function () {
        showContactOrgWinEditFun(code, this);
    }
}

function showContactOrgWinEditFun(code, that) {
    // var contenturl='/view/business/pm/ContactOrgFormSelectWin?code='+code;
    // if(code==null){
    //     contenturl='/view/business/pm/ContactOrgFormSelectWin';
    // }
    var contenturl = '/view/pub/PubContactOrgFormSelectWin';
    if (code) {
        var contenturl = '/view/pub/PubContactOrgFormSelectWin?code=' + code;
    }
    var inputobj = formatterInputobj(that);
    openChooseDialog({
        title: "单位选择",
        contenturl: contenturl,
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#PubContactOrgSelect_datagrid').datagrid('getSelected');
            if (r) {
                $("#" + inputobj.inputId).textbox("setValue", r.contactOrgId);
                $("#" + inputobj.inputId).textbox("setText", r.contactOrgName);
                if (inputobj.inputId.indexOf("corpId") != -1) {
                    //能获取PM_RISK_LAW_SUIT_CROP的字段
                    //则对可编辑界面进行赋值

                    var indexCorp = inputobj.inputId.replace("corpId", "");
                    $("#corpCode" + indexCorp).textbox('setValue', r.contactOrgCode);
                    $("#legalPerson" + indexCorp).textbox('setValue', r.legalPerson);

                }
                return true;
            } else {
                alertInfo("请选择一个单位");
                return false;
            }
        }
    })
}


/** **********************已立项项目弹窗 用于可编辑列******************** */
function showProjectWinFunEdit() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择项目",
        contenturl: '/view/business/pm/pmProjectSelectWin?type=2&isMe=N',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#projectSelect_datagrid').datagrid('getSelected');
            if (r) {
                $("#" + inputobj.inputId).textbox("setValue", r.projectId);
                $("#" + inputobj.inputId).textbox("setText", r.projectName);
                //autoSetValue("projectId", r.projectId);
                //autoSetValue("projectId_TEXT_", r.projectName);

                $("#bdstName").val(r.projectName);
                return true;
            } else {
                alertInfo("请选择项目");
                return false;
            }
        }
    })
}

//关联流程
function relatedProcess(isDetail) {
    if ($('#id').val()) {
        openDetailDialog({
            title: "关联流程",
            contenturl: '/view/business/edoc/EdocApplyRelatedProcess?isdetail=' + isDetail,
            width: 750,
            height: 450
        });
    } else {

        $('#contentForm').form('submit', {
            url: ctx + "/EdocApply/saveEdocApply",
            onSubmit: function (param) {
                var isValid = $(this).form('validate');
                if (!isValid) {
                    alertInfo("请完善表单信息");
                    return false;
                }
                param.formcode = $("#flowCode_tool").val();
                param.isExecute = null;
            },
            success: function (data) {
                data = JSON.parse(data);

                if (data.success) {
                    $('#id').val(data.o.id);
                    $('#processinstid').val(data.o.processinstid);
                    $('#workflowStatus').val(data.o.workflowStatus);
                    $('#createAccount').val(data.o.createAccount);

                    $.ajax({
                        url: ctx + "/EdocApply/findEdocApply",
                        type: "post",
                        data: {
                            id: data.o.id
                        },
                        dataType: "json",
                        success: function (data) {
                            loadFileList(data.fileMap);

                            openDetailDialog({
                                title: "关联流程",
                                contenturl: '/view/business/edoc/EdocApplyRelatedProcess?isdetail=' + isDetail,
                                width: 750,
                                height: 450
                            });
                        }
                    })
                }

            }
        });

    }
}

/*************************付款阶段选择框*****************/
function showConPhaseWinFun() {
    //判断是否已选择合同
    var pmconId = $('#pmconId').val();
    if (pmconId != null && pmconId != '') {
        openChooseDialog({
            title: "选择付款阶段",
            contenturl: '/view/business/pm/pmConPhaseSelectWin',
            width: 700,
            height: 500,
            okhandler: function () {
                var r = $('#phaseSelect_datagrid').datagrid('getSelected');
                if (r) {
                    $('#pmconPhaseId').val(r.pmconPhaseId);
                    $('#pmconPhaseId_TEXT_').textbox('setValue', r.phaseTypeName);
                    $('#phaseType').val(r.phaseType);
                    autoSetValue('phaseMoney', r.phaseMoney);
                    autoSetValue('phaseMoneyPaid', r.payMoney);
                    autoSetValue('payClause', r.remark);
                    payRatio = r.phaseRatio;
                    if ($('#phaseType').val() == 'YFK' || $('#phaseType').val() == 'QTKX') {
                        $("#isContractPay").val('N');
                        //更新最大可支付金额
//					setMaxPayMoney();
                    } else {
                        $("#isContractPay").val('Y');
                    }
                    return true;
                } else {
                    alertInfo("请选择付款阶段");
                    return false;
                }
            }
        })
    } else {
        alertInfo("请先选择合同");
        return false;
    }
}

//手动调用附件面板，点击添加附件按钮的公共okhandler函数（例子，使用见 ImInvconform.js）
function common_addPanelFile(filelist, jq, options, fileindex) {
    var index = fileindex;
    var filetypeid = options.fileTypeId;
    var formid = $(jq).closest('tr').parent().find("tr[filetypeid='" + filetypeid + "']").attr("formid");
    var catalogid = options.catalogid;
    var filterFunction = options.filterFunction;
    var showLocal = options.showlocal;
    var showVisual = options.showvisual;
    var showScan = options.showscan;
    for (var i = 0; i < filelist.length; i++) {
        var panelfilehtml =
            "<tr filetypeid=\"" + filetypeid + "\" class=\"repList2\">" +
            "          <td class=\"repList\" >" +
            "          <center><div class=\"icon-remove-file\"  onclick=\"${form.formcode!}_removePanelFile(this)\" style=\"width:20px;height:20px\"></div></center>" +
            "          <input class=\"docformfile_id\" type=\"hidden\" id=\"panelfilelist[" + index + "].formFileId\" name=\"panelfilelist[" + index + "].formFileId\" value=\"\">" +
            "          <input type=\"hidden\" id=\"panelfilelist[" + index + "].formId\" name=\"panelfilelist[" + index + "].formId\" value=\"" + formid + "\">" +
            "          <input type=\"hidden\" id=\"panelfilelist[" + index + "].fileTypeId\" name=\"panelfilelist[" + index + "].fileTypeId\" value=\"" + filetypeid + "\">" +
            "		   <input class=\"panelfile_isuse\" type=\"hidden\" id=\"panelfilelist[" + index + "].isUse\" name=\"panelfilelist[" + index + "].isUse\" value=\"Y\">" +
            "          </td>" +
            "          <td class=\"repList \">" +
            "            <input id=\"panelfilelist" + index + "_fileName\" name=\"panelfilelist[" + index + "].fileName\" value=\"" + filelist[i].filename + "\" class=\"easyui-textbox\"" +
            "          data-options=\"editable:true\"/>" +
            "          </td>" +
            "          <td class=\"repList\" >" +
            "          <input name=\"panelfilelist[" + index + "].fileVersionId\" id=\"panelfilelist[" + index + "].fileVersionId\" value=\"" + filelist[i].fileversionid + "\" class=\"easyui-choosefile\"" +
            "           data-options=\"setfilename:'#panelfilelist" + index + "_fileName',catalogid:" + catalogid + ",filename:'" + filelist[i].filename + "',filterFunction:'" + filterFunction + "',showlocal:" + showLocal + ",showvisual:" + showVisual + ",showscan:" + showScan + " \"  />" +
            "          </td>" +
            "          <td class=\"repList\" >" +
            "            <input id=\"panelfilelist[" + index + "].memo\" name=\"panelfilelist[" + index + "].memo\" class=\"easyui-textbox\"" +
            "          data-options=\"validType:'maxLength[100]'\"/>" +
            "          </td>" +
            "        </tr>";
        index++;
        $(jq).closest('tr').parent().find("tr[filetypeid='" + filetypeid + "']").last().after(panelfilehtml);
        $.parser.parse($(jq).closest('tr').parent().find("tr[filetypeid='" + filetypeid + "']").last());
    }
    return index;
}


//其它业务模块调用发送邮件的功能，id 主键id，formCode 页面code ，url跳转url
//有url根据url跳转，没有url；会通过formcode进行跳转
function sendEmail(id, formCode, url) {
//	var t = parent.$('#maintab');
//	var pageurl = ctx+"/GmWorkContact/toGmWorkContactForm?businessId="+id+"&businessFormCode="+formCode+"&businessUrl="+url;
//	var opts = {
//            title: "写邮件",
//            closable: true,
//            border: false,
//            content: '<iframe src=" '
//                + pageurl
//                + '" id=" frameborder="0"  style="display:block;border:0;width:100%;height:100%;"></iframe>'
//    };
//	t.tabs('add', opts);
    parent.openInMainTab('写邮件', "/GmWorkContact/toGmWorkContactForm?businessId=" + id + "&businessFormCode=" + formCode + "&businessUrl=" + url, '2');
}

//合同选择弹出框(包含所有类型合同)
function showReimbursePmconWinFun() {
    var url = "/view/business/pm/ContractSelectWin";
    if ($('#FmReceiveTotal').length > 0 || $('#FmReceiveEnsure').length > 0) {
        url = "/view/business/pm/ContractSelectWin?isKpiao=true";
    }
    openChooseDialog({
        title: "选择合同",
        contenturl: url,
        width: 800,
        height: 450,
        okhandler: function () {
            var r = $('#PmPmcon_datagrid').datagrid('getSelected');
            if (r) {
                $('#conId').val(r.conId);
                $('#pmconName').textbox('setValue', r.conName);
                if (haseasyui("#FmExpenseReimburse_HT #conMoney")) {
                    $('#conMoney').numberbox('setValue', r.contractMoney);
                    //通过合同id查找合同已付金额（仅合同支付一个出口）
                    getConPaidMoney(r.conId);
                } else if ($('#FmReceiveTotal').length > 0) {
                    $('#conNo').textbox('setValue', r.conCode);
                    $('#contractOrgName').textbox('setValue', r.partyAText);
                    $('#paymentUnit').val(r.partyA);
                    //清空历史明细数据
                    delDetailData();
                    //获取合同的收款信息
                    findConBankDataByconId(r.conId);
                } else if ($('#FmReceiveEnsure').length > 0) {
                    $('#conNo').textbox('setValue', r.conCode);
                    $('#contractOrgName').textbox('setValue', r.partyAText);
                }
                return true;
            } else {
                alertInfo("请选择合同");
                return false;
            }
        },
        onload: function () {
            $('#PmPmcon_datagrid').datagrid({
                onDblClickRow: function (index, r) {
                    var btns = $(this).closest('.window').find('.dialog-button .l-btn-small');
                    if (btns.length > 0) {
                        $(btns[0]).click();
                    }
                }

            })
        }
    })
}

//合同选择弹出框(包含所有类型合同)
function showReimbursePmconWinFunM() {
    var inputobj = formatterInputobj(this);

    var categoryId = $('#categoryId').combobox('getValue');
    if (!categoryId) {
        alertInfo("请先选择保证金类别");
        return false;
    }

    //isMargin categoryId(保证金类型)参数。
    //同一保证金类型里，选过的合同。选过了就不能再选了
    openChooseDialog({
        title: "选择合同",
        contenturl: '/view/business/pm/ContractSelectWin?isMargin=Y&categoryId=' + categoryId,
        width: 800,
        height: 450,
        okhandler: function () {
            var r = $('#PmPmcon_datagrid').datagrid('getSelected');
            if (r) {

                // $('#'+inputobj.inputId).textbox('setValue',r.conId);
                // $('#'+inputobj.inputId).textbox('setText',r.conName);
                $('#contractId').val(r.conId);
                $('#contractIdText').textbox('setValue', r.conName);
                return true;
            } else {
                alertInfo("请选择合同");
                return false;
            }
        },
        onload: function () {
            $('#PmPmcon_datagrid').datagrid({
                onDblClickRow: function (index, r) {
                    var btns = $(this).closest('.window').find('.dialog-button .l-btn-small');
                    if (btns.length > 0) {
                        $(btns[0]).click();
                    }
                }

            })
        }
    })
}


function showBankAccount(type) {
    return function () {
        showBankAccountByType(type, this);
    }
}

function showBankAccountByType(type, that) {
    var index = getEndNumberForStr(that.id);
    var bankId = "";
    var params = "";
    if (that.id.toString().indexOf("outBankName") == 0) {
        var outOrgId = $("#outOrgId" + index).combobox('getValue');
        if (!outOrgId) {
            alertInfo("请选择调出单位");
            return;
        }
        params = "&orgId=" + $("#outOrgId" + index).combobox('getValue');
    } else if (that.id.toString().indexOf("inBankName") == 0) {
        var inOrgId = $("#inOrgId" + index).combobox('getValue');
        if (!inOrgId) {
            alertInfo("请选择调入单位");
            return;
        }
        params = "&orgId=" + $("#inOrgId" + index).combobox('getValue');
    } else {
        params = "&orgId=" + $("#orgId").combobox('getValue');
    }
    openChooseDialog({
        title: "请选择",
        contenturl: '/view/pub/BasBankAccountSelect1?bankId=' + bankId + params,
        width: 750,
        height: 450,
        okhandler: function () {
            var row = $('#BasBankAccount1_datagrid').datagrid('getSelected');
            if (row) {
                if ("1" == type) {
                    if ($('#dispatchDetailList').length > 0) {
                        $('#inBankId' + index).val(row.bankId);
                        $('#inBankName' + index).textbox('setValue', row.bankName);
                        $('#inBankAccount' + index).textbox('setValue', row.accountNo);
                    } else if ($('#allocationdDetailList').length > 0) {
                        $('#payeeBank' + index).textbox('setValue', row.bankName);
                        $('#payeeAccount' + index).textbox('setValue', row.accountNo);
                        $('#bankAccountInId' + index).val(row.bankAccountId);
                    } else {
                        $('#payeeBank' + index).val(row.bankId);
                        $('#payeeBank_TEXT_' + index).textbox('setValue', row.bankName);
                        $('#payeeAccount' + index).textbox('setValue', row.accountNo);
                    }
                } else {
                    if ($('#dispatchDetailList').length > 0) {
                        $('#outBankId' + index).val(row.bankId);
                        $('#outBankName' + index).textbox('setValue', row.bankName);
                        $('#outBankAccount' + index).textbox('setValue', row.accountNo);

                    } else if ($('#allocationdDetailList').length > 0) {
                        $('#paymentBank' + index).textbox('setValue', row.bankName);
                        $('#paymentAccount' + index).textbox('setValue', row.accountNo);
                        $('#bankAccountOutId' + index).val(row.bankAccountId);
                    } else {
                        $('#paymentBank' + index).val(row.bankId);
                        $('#paymentBank_TEXT_' + index).textbox('setValue', row.bankName);
                        $('#paymentAccount' + index).textbox('setValue', row.accountNo);
                    }
                }
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }
    })
}

function showPayeeAccountWin(payeeType) {//type为1 供应商  2 客户  3职员
    return function () {
        showPayeeAccount(payeeType, this);
    }
}

function showPayeeAccount(payeeType, that) {
    var index = getEndNumberForStr(that.id);
    var inputobj = formatterInputobj(that);
    //定义收款人id/收款人名称
    var payee = '';
    var payeeName = '';
    openChooseDialog({
        title: "请选择",
        contenturl: '/view/business/fm/FmPayeeAccountWin?payeeType=' + payeeType,
        width: 760,
        height: 540,
        okhandler: function () {
            var row = $('#payee_datagrid').datagrid('getSelected');
            if (row) {
                if (accountType == "1" || accountType == "2") {
                    payee = row.contactOrgId;
                    payeeName = row.contactOrgName;
                } else {
                    payee = row.ACCOUNT_ID;
                    payeeName = row.ACCOUNT_NAME;
                }
                //租赁合同 承租方
                if (haseasyui("#MaLeaseContract #lesseeText") && inputobj.inputId == "lesseeText") {
                    // $('#projectPid').val(r.projectId);
                    $("#MaLeaseContract #lessee").val(payee);
                    $("#MaLeaseContract #lesseeText").textbox('setValue', payeeName);

                    //租赁合同 的客户类型。type==1是对公，type==2是个人
                    $("#MaLeaseContract #lesseeType").val(row.type);
                } else if (haseasyui("#MaLeaseContract_FJYX #lesseeText") && inputobj.inputId == "lesseeText") {
                    // $('#projectPid').val(r.projectId);
                    $("#MaLeaseContract_FJYX #lessee").val(payee);
                    $("#MaLeaseContract_FJYX #lesseeText").textbox('setValue', payeeName);

                    //租赁合同 的客户类型。type==1是对公，type==2是个人
                    $("#MaLeaseContract_FJYX #lesseeType").val(row.type);
                } else if (haseasyui("#GmAssetsArrival #contactOrgId") && inputobj.inputId == "contactOrgId") {
                    $("#GmAssetsArrival #contactOrgId").textbox('setValue', payee);
                    $("#GmAssetsArrival #contactOrgId").textbox('setText', payeeName);
                } else if (haseasyui("#FmCreditManage #creditUnit") && inputobj.inputId == "creditUnit") {
                    $("#FmCreditManage #creditUnit").textbox('setValue', payee);
                    $("#FmCreditManage #creditUnit").textbox('setText', payeeName);
                } else if (haseasyui("#AssetsWxArrival #partyB") && inputobj.inputId == "partyB") {

                    $("#AssetsWxArrival #partyB").textbox('setValue', payee);
                    $("#AssetsWxArrival #partyB").textbox('setText', payeeName);
                } else {

                    if (accountType == "1" || accountType == "2") {

                        autoSetValue('payeeUnit' + index, row.contactOrgId);
                        autoSetValue('payeeUnitText' + index, row.contactOrgName);
                    } else {

                        autoSetValue('payeeUnit' + index, row.ACCOUNT_ID);
                        autoSetValue('payeeUnitText' + index, row.ACCOUNT_NAME);
                        if ($('#cashierDetailList').length > 0 || $('#cashierXCList').length > 0 || $('#cashierSFList').length > 0 || $('#cashierHTList').length > 0 || $('#cashierCLList').length > 0 || $('#cashierList_GH').length > 0 || $('#cashierCLList_GH').length > 0) {
                            var type = $('#paymentType' + index).combobox('getValue');
                            if (type == '1') {
                                findAccountDataByAccountId(row.ACCOUNT_ID, index);
                            } else {
                                $('#payeeAccount' + index).textbox('setValue', '');
                                $('#payeeBank' + index).textbox('setValue', '');
                            }

                        }

                    }
                    autoSetValue('payeeType' + index, accountType);

                    $('#' + inputobj.inputId).textbox('setValue', payee);
                    $('#' + inputobj.inputId).textbox('setText', payeeName);
                }

                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }
    })
}

//开支项目弹出框
function showFmBudgetTotalDetailWin() {
    var inputobj = formatterInputobj(this);
    var searchDeptId = '';
    var searchDate = '';
    //获取当前的formcode
    var code = this.form.id;
    searchDate = haseasyui('#reimburseDate') ? $('#reimburseDate').datebox('getValue') : "";
    searchDeptId = haseasyui('#deptId') ? $('#deptId').combobox('getValue') : "";

    //经费申请
    if ($('#FmReimburseApply').length > 0) {
        searchDate = $("#applyDate").datebox('getValue');
        searchDeptId = $("#deptId").combobox('getValue');
    }
    //员工借款
    if ($('#FmFinancialLoan').length > 0 || $('#FmFinancialLoan_GH').length > 0) {
        searchDate = $("#loanDate").datebox('getValue');
        searchDeptId = $("#deptId").combobox('getValue');
    }
    //采购申请新
    if ($('#PmBidApplyNew').length > 0) {
        searchDate = $("#applyTime").datebox('getValue');
        searchDeptId = $("#applyDept").combobox('getValue');
    }
    //采购申请新 工程类
    if ($('#PmBidApplyNew_GC').length > 0) {
        searchDate = $("#applyTime").datebox('getValue');
        searchDeptId = $("#applyDept").combobox('getValue');
    }
    //采购申请新 服务类
    if ($('#PmBidApplyNew_FW').length > 0) {
        searchDate = $("#applyTime").datebox('getValue');
        searchDeptId = $("#applyDept").combobox('getValue');
    }
    //稿费登记
    if ($('#GmFeeRegister').length > 0) {
        searchDate = $("#endDate").datebox('getValue');
        searchDeptId = $("#deptId").val();
    }
    //招待申请
    if ($('#GmOfficeReceive').length > 0) {
        searchDate = $("#applyTime").datebox('getValue');
        searchDeptId = $("#deptId").val();
    }
    //车辆申请GmCarApply
    if ($('#GmCarApply').length > 0) {
        searchDate = $("#applyDate").datebox('getValue');
        searchDeptId = $("#applyDept").combobox('getValue');
    }
    //车辆用油申请GmCarOilApply
    if ($('#GmCarOilApply').length > 0) {
        searchDate = $("#createTime").datebox('getValue');
        searchDeptId = $("#applyDeptId").val();
    }
    //车辆年检GmCarInspection
    if ($('#GmCarInspection').length > 0) {
        searchDate = $("#createTime").datebox('getValue');
        searchDeptId = $("#deptId").val();
    }
    //洗车费登记表GmCarWashFee
    if ($('#GmCarWashFee').length > 0) {
        searchDate = $("#createTime").datebox('getValue');
        searchDeptId = $("#deptId").val();
    }
    //车辆里程补贴登记
    if ($('#GmCarMileageSubsidy').length > 0) {
        searchDate = $("#createTime").datebox('getValue');
        searchDeptId = $("#deptId").val();
    }
    //车辆维修申请
    if ($('#GmCarRepairApply').length > 0) {
        searchDate = $("#applyDate").datebox('getValue');
        searchDeptId = $("#applyDept").val();
    }
    //银行手续费处理
    if ($('#FmBankPoundageBill').length > 0) {
        searchDate = $("#payMonth").datebox('getValue');
        searchDeptId = $("#deptId").val();
    } else if ($('#FmNoConReceiveTotal').length > 0) {
        searchDate = $("#operatorDate").datebox('getValue');
        searchDeptId = $("#deptId").val();
    } else if ($('#FmNoConReceiveTotal').length > 0 || $('#FmMarginReceive').length > 0) {
        searchDate = $("#operatorDate").datebox('getValue');
        searchDeptId = $("#deptId").val();
    } else if ($('#GmCollectionEnsure').length > 0) {
        searchDate = $("#operatorDate").datebox('getValue');
        searchDeptId = $("#deptId").val();
    }
    //独生子女申请
    if ($('#HrOnlychildSubsidy').length > 0) {
        searchDate = $("#createByTime").datebox('getValue');
        searchDeptId = $("#deptId").val();
    }
    //资金拨付
    if ($('#FmPayApply_CJ').length > 0 || $('#FmPayApply_FP').length > 0 || $('#FmPayApply_GF').length > 0 || $('#FmPayApply_ES').length > 0) {
        searchDate = $("#applyMonth").datebox('getValue');
        searchDeptId = $("#applyUnit").val();
    }
    if ($('#GmAssetsEntryInnsure_form').length == 0) {
        if (!searchDeptId) {
            alertInfo("请先选择费用使用部门");
            return;
        }
    }
    openChooseDialog({
        title: "选择预算科目信息",
        contenturl: '/view/business/fm/showBudgetSelect?searchDeptId=' + searchDeptId + '&searchDate=' + searchDate + '&code=' + code,
        width: 1000,
        height: 500,
        okhandler: function () {
            var r = $('#FmBudgetSelectWin_datagrid').datagrid('getSelected');
            if (r) {
                var BudgetId = r.systemId != null ? r.systemId : '';
                $("#budgetId").val(BudgetId);
                //截取预算名称
                $("#budgetIdText").textbox("setValue", r.pathName);
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }
    });
}

/**
 * 调用下面的方法。只要合同id
 * @param conid
 */
function findVCommonConById(conid) {
    if (conid) {
        $.ajax({
            url: ctx + "/VCommonConCon/findVCommonCon",
            data: {
                id: conid
            },
            dataType: 'json',
            success: function (result) {
                if (result.success) {
                    openFormDetailCon(result.o.conId, result.o.formcode);
                } else {
                    alertInfo("没有查到相应的合同信息！");
                }

            }
        });
    }
}

/**
 * 查找合同明细
 * 或其他的在页面内容维护的表的明细
 * @param id 合同主键
 * @param formcode 合同页面配置编码
 */
function openFormDetailCon(id, formcode) {
    var str = '';
    if (formcode.indexOf('PmPmcon') != -1) {
        str = "childPmPmconHidden();";
    }

    if (formcode.indexOf('MaLeaseContract') != -1) {
        str += "initAddRates(true);" +
            "changeContractPanelHeightDetail();changeRentPlanPanelHeightDetail();";

    }
    openDetailDialog({
        title: "查看记录",
        maximized: true,
        loadScript: str,
        contenturl: "/GenForm/form?formcode=" + formcode + "&isdetail=true&id=" + id
    });
}

//采购申请明细
function findPmbidApplyNewById(applyNewId) {
    if (applyNewId) {
        $.ajax({
            url: ctx + "/PmBidApplyNew/findPmBidApplyNew",
            data: {
                id: applyNewId
            },
            dataType: 'json',
            success: function (result) {
                var resultFormcode = '';

                if (result) {
                    if (result.aim == '1') {//货物类采购申请
                        resultFormcode = 'PmBidApplyNew';
                    } else if (result.aim == '2') {//工程类采购申请
                        resultFormcode = 'PmBidApplyNew_GC';
                    } else {//result.aim == '3'  服务类采购申请
                        resultFormcode = 'PmBidApplyNew_FW';
                    }

                    openFormDetailCon(applyNewId, resultFormcode);
                } else {
                    alertInfo("没有查到相应的信息！");
                }

            }
        });
    }
}


//银行信息弹窗
function showBasBankWinCommonByOrgId(orgIdSel) {
    if (orgIdSel == null) {
        orgIdSel = 10000000//默认查询单位为同安的账号信息
    }
    if ($('#PmBidSerconXS').length > 0) {
        orgIdSel = $('#partyB').combobox('getValue');
    }
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择银行",
        contenturl: '/view/base/BasBankSelectWin?orgIdSel=' + orgIdSel + '&isEdit=true',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#BasBankAccountWin_datagrid').datagrid('getSelected');
            if (r) {
                if ($('#PmBidSerconXS').length > 0) {
                    $('#' + inputobj.inputId).textbox('setValue', r.bankName);
                    autoSetValue('payeeAccount', r.accountNo);
                } else if ("#BFmFundInvest".length > 0 || $("#FmFundEarnings").length > 0) {
                    $('#bankAccountId').val(r.bankAccountId);
                    $('#investBankAccount').textbox('setValue', r.accountNo);
                    $('#investBank').textbox('setValue', r.bankName);
                } else {
                    $('#' + inputobj.inputId).textbox('setValue', r.bankName);
                    autoSetValue('borrowerAccount', r.accountNo);
                }
                return true;
            } else {
                alertInfo("请选择银行");
                return false;
            }
        }
    })
}

//盘盈新增获取资产类别下拉框
function selectAssetsType(newV) {
    var fcode = newV;
    if (fcode) {
        $('#assetsTypeText').combobox({
            url: ctx + '/GmAssetsCategory/getassetsType?fcode=' + fcode,
            editable: false,
            onChange: function (newV, oldV) {
                $('#assetsType').val(newV);
            },
            required: true
        });
    }
}


//出差管理弹出选择框

function showTravelSelectWin() {

    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "出差信息",
        contenturl: '/view/business/hr/HrTravelRecordSelectWin',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#HrTravelRecordWin_datagrid').datagrid('getSelected');
            if (r) {
//                $('#' + inputobj.inputId).textbox('setValue',r.travelId);
//                $('#' + inputobj.inputId).textbox('setText', r.travelNo);

                $('#travelId').val(r.travelId);
                $('#travelIdText').textbox('setValue', r.travelNo);
                return true;
            } else {
                alertInfo("请选择出差信息");
                return false;
            }
        }
    })

}

/** ***************车辆年检申请信息弹窗************************* */
function showCarInspectInfoWinFun() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择车辆",
        contenturl: '/view/business/gm/GmCarInspectInfoSelectWin',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#GmCarInspectInfoSelect_datagrid').datagrid('getSelected');
            if (r) {
                $("#" + inputobj.inputId).textbox("setValue", r.carInfoId);
                $("#" + inputobj.inputId).textbox("setText", r.carNum);
                return true;
            } else {
                alertInfo("请选择车辆");
                return false;
            }
        }
    })
}

//收款方式改变事件  普通文本框
function changeLoanMethodEvent() {
    var loanMethod = $('#loanMethod').combobox('getValue');
    if (loanMethod == '1') {
        setCss($("#bankName"), "textbox", true, false, true, false, false);
        setCss($("#bankAccount"), "textbox", true, false, true, false, false);
    } else {

        setCss($("#bankName"), "textbox", false, true, false, true, true);
        setCss($("#bankAccount"), "textbox", false, true, false, true, true);
    }

}

//支付方式改变事件 弹出选择框
function changeLoanMethodForWinEvent() {
    var loanMethod = $('#loanMethod').combobox('getValue');
    if (loanMethod == '1') {
        setCss($("#bankName"), "textbox", true, false, true, false, false);
        setCss($("#bankAccount"), "textbox", true, false, true, false, false);
    } else {

        setCss($("#bankName"), "textbox", false, true, false, true, true);
        setCss($("#bankAccount"), "textbox", false, true, false, true, true);
    }

}

//转贷合同弹出选择框
function showFmExternalConWinFun() {
    var inputobj = formatterInputobj(this);
    var url = '/view/business/fm/FmExternalConSelectWin';
    if ($("#FmExternalFundOut").length > 0) {
        url = '/view/business/fm/FmExternalConSelectWin?isZhuanC=true';
    }
    if ($("#FmExternalFundBack").length > 0) {
        url = '/view/business/fm/FmExternalConSelectWin?isZhuanH=true';
    }
    openChooseDialog({
        title: "转贷合同",
        contenturl: url,
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#FmExternalConWin_datagrid').datagrid('getSelected');
            if (r) {
                $('#externalId').val(r.externalId);
                $("#" + inputobj.inputId).textbox("setText", r.billNo);

                if ($("#FmExternalFundOut").length > 0) {
                    $('#fmconId').val(r.fmconId);
                    $('#outDetailList').panel('refresh', ctx + '/FmFundOutDetail/editFmFundOutDetail?fmconId=' + r.fmconId);
                    $('#payeeUnit').val(r.orgId);
                    $('#payeeUnit_TEXT_').textbox('setValue', r.borrowerText);
                    $('#outedMoney').numberbox('setValue', r.outedMoney);

                }
                if ($("#FmExternalFundBack").length > 0) {
                    $('#fmconId').val(r.fmconId);
                    $('#backDetailList').panel('refresh', ctx + '/FmFundBackDetail/editFmFundBackDetail?fmconId=' + r.fmconId);
                    $('#paymentUnit').val(r.orgId);
                    $('#paymentUnit_TEXT_').textbox('setValue', r.borrowerText);
                    $('#backedMoney').numberbox('setValue', r.backedMoney);
                }

                return true;
            } else {
                alertInfo("请选择一条转贷合同");
                return false;
            }
        }
    })
}

/** ***********城市选择框*************** */
function showCityChooseWinFun() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择城市",
        contenturl: '/view/base/BaseAreaCitySelectWin',
        width: 500,
        height: 450,
        okhandler: function () {
            var r = $('#city_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue("city", r.areaName);
                return true;
            } else {
                alertInfo("请选择城市");
                return false;
            }
        }
    });

}

/***
 * 获取人员账户信息
 *
 * @param accountId 账户ID
 * @param index 行号
 */
function findAccountDataByAccountId(accountId, index) {
    $.ajax({
        url: ctx + "/FmReimbursementAccount/findAccountDataByAccountId",
        data: {
            accountId: accountId
        },
        dataType: 'json',
        success: function (result) {
            if (result.success) {
                if ($('#FmFinancialReceivable').length > 0) {
                    //为账号信息赋值
                    $('#bankAccount').textbox('setValue', result.o.accountNumber);
                    $('#bankName').textbox('setValue', result.o.bankName);
                }
                if ($('#cashierDetailList').length > 0 || $('#cashierXCList').length > 0 || $('#cashierSFList').length > 0 || $('#cashierHTList').length > 0 || $('#cashierCLList').length > 0 || $('#cashierList_GH').length > 0 || $('#cashierCLList_GH').length > 0 || $('#cashierJKList').length > 0) {
                    //为账号信息赋值
                    $('#payeeAccount' + index).textbox('setValue', result.o.accountNumber);
                    $('#payeeBank' + index).textbox('setValue', result.o.bankName);
                }
            }
        }
    });
}

/**
 * 物品领用中关联物品采购申请单号
 */

function showMaMaterialReq() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "请选择物品采购申请单",
        contenturl: '/view/business/ma/MaMaterialReqSelect',
        width: 700,
        height: 450,
        okhandler: function () {
            var r = $("#mainTable").datagrid('getSelected');
            if (r) {
                $("#" + inputobj.inputId).textbox("setValue", r.reqId);
                $("#" + inputobj.inputId).textbox("setText", r.reqNo);
                var childRow = $("#childTable").datagrid('getSelections');
                if (childRow.length == 0) {
                    childRow = $("#childTable").datagrid('getData').rows;
                }
                for (var i = 0; i < childRow.length; i++) {
                    adddataRow(childRow[i]);
                }
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }
    })
}

/**
 * 物品入库关联申购单 并按照当前登录人所在的项目过滤
 */

function showMaMaterialReqForArrival() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "请选择物品采购申请单",
        contenturl: '/view/business/ma/MaMaterialReqSelectForArrival',
        width: 700,
        height: 450,
        okhandler: function () {
            var r = $("#mainTable").datagrid('getSelected');
            if (r) {
                $("#" + inputobj.inputId).textbox("setValue", r.reqId);
                $("#" + inputobj.inputId).textbox("setText", r.reqNo);
                var childRow = $("#childTable").datagrid('getSelections');
                if (childRow.length == 0) {
                    childRow = $("#childTable").datagrid('getData').rows;
                }
                for (var i = 0; i < childRow.length; i++) {
                    adddataRow(childRow[i]);
                }
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }
    })
}

/*************************************************业务单引入议题 start***********************************************/
//会议事项改变事件
function itemTypeIdChangeEvent() {
    //判断事项类型是否有值
    var itemTypeId = $('#itemTypeId').combobox('getValue');
    if (itemTypeId) {

        $('#itemId').combobox({
            url: ctx + '/GmMeetingItem/queryMeetingItemByType?itemTypeId=' + itemTypeId,
            required: true,
            readonly: false,
        });

        $('#itemId').combobox('clear');
    } else {
        alertInfo("请选择事项类型");
    }
}

//判断是否有议题
function meetingAgendaJudge(options) {
    var checkUrl = "";
    var judge = false;
    // 通过流程节点及formcode 确定校验是否有议题的url
    $.ajax({
        url: ctx + "/PubMeetItemSet/findCheckUrlByFormCodeAndAct",
        async: false,
        data: {
            actId: options.wfActivityParams.actId,
            code: options.formCode
        },
        dataType: 'json',
        success: function (result) {
            if (result.success) {
                checkUrl = result.o.checkUrl;
                judge = agendaJudgeByCheckUrl(checkUrl);
            } else {
                alertError(result.msg);
            }
        }
    });

    return judge;
}

// 通过checkUrl查找是否有议题
function agendaJudgeByCheckUrl(checkUrl) {
    var judge = false;
    $.ajax({
        url: ctx + checkUrl,
        async: false,
        data: {},
        dataType: 'json',
        success: function (result) {
            if (result.success) {
                judge = true;
            } else {
            }
        }
    });
    return judge;
}

// 议题录入弹窗
function meetingAgendaAddData(options) {
    openSaveDialog({
        title: "添加记录",
        maximized: true,
        contenturl: "/GenForm/form?formcode=GmMeetingAgendaNew",
        submiturl: "/GmMeetingAgendaNew/saveGmMeetingAgendaNew?formcode=GmMeetingAgendaNew",
        onload: function () {
            // 赋关联默认值
            $('#bizCode').val(options.formCode);
            $('#pkId').val(options.businessMainId);
        },
        onsubmit: function () {
            openFlowDialog_action(options);
            return true;
        }
    });
}

/*************************************************业务单引入议题 end***********************************************/

/*************************************************续签申请 start***********************************************/

function selectByEmpIdAddContract() {
    var accountId = $('#empName').val();
    $.ajax({
        url: ctx + "/HrLaborContract/selectByEmpIdAddContract",
        data: {
            empId: accountId
        },
        dataType: 'json',
        success: function (result) {
            if (result.success) {
                /* $('#conProperty').combobox('setValue',result.o.conProperty);*/
                /*$('#employmentMode').combobox('setValue',result.o.employmentMode);*/
                /* $('#workhoureSys').combobox('setValue',result.o.workhoureSys);*/
                $('#oldHrconTerm').textbox('setValue', result.o.hrconTerm);
                $('#oldContractStartTime').textbox('setValue', result.o.hrconBegin);
                $('#oldContractEndTime').textbox('setValue', result.o.hrconEnd);
                $('#oldOrgId').combobox('setValue', result.o.oldOrgId);
                $('#oldDeptId').combobox('setValue', result.o.oldDeptId);
            }
        }
    });

}

/*************************************************续签申请 end***********************************************/

function showPubContactOrgAndAccountWin(payeeType) {//type为1 供应商  2 客户  3职员
    return function () {
        showPubContactOrgAndAccount(payeeType, this);
    }
}


function showPubContactOrgAndAccount(payeeType, that) {
    var index = getEndNumberForStr(that.id);
    var inputobj = formatterInputobj(that);
    var payee = '';
    var payeeName = '';
    var typeName = '';
    var typeId = '';
    var multi = true;
    var isBankEdit = false;
    var conids = [];
    var connames = [];
    if ($('#FmExpenseReimburse_GH').length > 0 || $('#FmTravelExpenseReimburse_GH').length > 0) {
        isBankEdit = true;
    }
    if (haseasyui("#MaLeaseContract #partCText") && inputobj.inputId == "partCText") {
        multi = false;
    }
    openChooseDialog({
        title: "请选择",
        contenturl: '/view/business/fm/FmContactOrgAndAccountWin?payeeType=' + payeeType + '&multi=' + multi,
        width: 750,
        height: 480,
        okhandler: function () {
            if (accountType == "1") {
                var row = $('#PubContactOrgGYS_datagrid').datagrid('getSelected');
            } else if (accountType == "2") {
                if ($('#MaLeaseContract').length > 0 || $('#MaLeaseContract_FJYX').length > 0) {
                    var row = $('#PubContactOrgKH_datagrid').datagrid('getSelections');
                    if (row && row.length > 0) {
                        for (var i = 0; i < row.length; i++) {
                            conids.push(row[i].contactOrgId);
                            connames.push(row[i].contactOrgName);
                        }
                    }
                } else if ($('#ConInfo_ZL').length > 0) {        // 租赁合同
                    var row = $('#PubContactOrgKH_datagrid').datagrid('getSelected');
                    $('#zlLesseeText').textbox('setValue', row.contactOrgName);
                    $('#zlLessee').val(row.contactOrgId);
                } else if ($('#ConInfo_ZC').length > 0) {        // 租车合同
                    var row = $('#PubContactOrgKH_datagrid').datagrid('getSelected');
                    $('#zcLesseeText').textbox('setValue', row.contactOrgName);
                    $('#zcLessee').val(row.contactOrgId);
                } else if ($('#MaCarOperationCost').length > 0) {        // 租车合同
                    var row = $('#PubContactOrgKH_datagrid').datagrid('getSelected');
                    $('#contactOrgId_TEXT_').textbox('setValue', row.contactOrgName);
                    $('#contactOrgId').val(row.contactOrgId);
                }
            } else {
                var row = $('#empSelectZY_datagrid').datagrid('getSelected');
            }
            if (row) {
                if (accountType == "1" || accountType == "2") {
                    payee = row.contactOrgId;
                    payeeName = row.contactOrgName;
                    typeName = row.typeName;
                    typeId = row.contactOrgTypeId;
                } else {
                    payee = row.ACCOUNT_ID;
                    payeeName = row.ACCOUNT_NAME;
                }
                autoSetValue('payeeUnit' + index, payee);
                autoSetValue('payeeUnitText' + index, payeeName);
                //合同相对方数据赋值
                if ($('#ConInfo_CG').length > 0) {
                    $('#contactOrgId' + index).val(payee);
                    $('#contactOrgIdText' + index).textbox('setValue', payeeName);
                    $('#oppositeTypeText' + index).textbox('setValue', typeName);
                    $('#oppositeType' + index).val(typeId);
                } else if ($('#ConInfo_ZL').length > 0) {
                    $('#contactOrgId' + index).val(payee);
                    $('#contactOrgIdText' + index).textbox('setValue', payeeName);
                    $('#oppositeTypeText' + index).textbox('setValue', typeName);
                    $('#oppositeType' + index).val(typeId);
                } else if ($('#ConInfo_PM').length > 0) {
                    $('#contactOrgId' + index).val(payee);
                    $('#contactOrgIdText' + index).textbox('setValue', payeeName);
                    $('#oppositeTypeText' + index).textbox('setValue', typeName);
                    $('#oppositeType' + index).val(typeId);
                } else if ($('#ConInfo_ZJFW').length > 0) {
                    $('#contactOrgId' + index).val(payee);
                    $('#contactOrgIdText' + index).textbox('setValue', payeeName);
                    $('#oppositeTypeText' + index).textbox('setValue', typeName);
                    $('#oppositeType' + index).val(typeId);
                } else if ($('#ConInfo_ZC').length > 0) {
                    $('#contactOrgId' + index).val(payee);
                    $('#contactOrgIdText' + index).textbox('setValue', payeeName);
                    $('#oppositeTypeText' + index).textbox('setValue', typeName);
                    $('#oppositeType' + index).val(typeId);
                } else if ($('#MaCarOperationCost').length > 0) {
                    $('#contactOrgId' + index).val(payee);
                    $('#contactOrgIdText' + index).textbox('setValue', payeeName);
                    $('#oppositeTypeText' + index).textbox('setValue', typeName);
                    $('#oppositeType' + index).val(typeId);
                }

                if ($('#cashierDetailList').length > 0
                    || $('#cashierXCList').length > 0
                    || $('#cashierSFList').length > 0
                    || $('#cashierHTList').length > 0
                    || $('#cashierCLList').length > 0
                    || $('#cashierList_GH').length > 0
                    || $('#cashierCLList_GH').length > 0
                    || ($('#cashierJKList').length > 0 && inputobj.inputId != "payeeText")) {
                    autoSetValue('payeeType' + index, accountType);
                    var type = $('#paymentType' + index).combobox('getValue');
                    if (accountType == "1" || accountType == "2") {
                        $('#payeeBank' + index).textbox({
                            buttonText: '选择',
                            editable: isBankEdit,
                            required: type == 1 ? true : false,
                            onClickButton: showAccountDataByContractOrgId,
                        });

                    } else {
                        $('#payeeBank' + index).textbox({
                            buttonText: '选择',
                            editable: isBankEdit,
                            required: type == 1 ? true : false,
                            onClickButton: showAccountDataByaccountId
                        });
                    }
                    if (type == '1' && accountType == 3) {
                        findAccountDataByAccountId(payee, index);
                    } else if (type == '1' && (accountType == "1" || accountType == "2")) {
                        findAccountDataByContractOrgId(payee, index);
                    } else {
                        $('#payeeAccount' + index).textbox('setValue', '');
                        $('#payeeBank' + index).textbox('setValue', '');
                    }

                }
                //代收缴纳人
                if ($('#incomeDetail_panel').length > 0) {
                    $('#payer' + index).val(payee);
                    $('#payerText' + index).textbox('setValue', payeeName);
                }
                //代付收款人
                if ($('#expendDetail_panel').length > 0) {
                    $('#payer' + index).val(payee);
                    $('#payerText' + index).textbox('setValue', payeeName);
                    findAccountDataByContractOrgId(payee, index);
                }
                //确认招租信息明细单
                if ($('#MaConfirmRecruitList').length > 0) {
                    $('#lesseeId' + index).val(payee);
                    $('#lesseeIdText' + index).textbox('setValue', payeeName);

                }
                //租赁合同 承租方
                if (haseasyui("#MaLeaseContract #lesseeText") && inputobj.inputId == "lesseeText") {
                    // $('#projectPid').val(r.projectId);
                    $("#MaLeaseContract #lessee").val(conids.join(","));
                    $("#MaLeaseContract #lesseeText").textbox('setValue', connames.join(","));

                    //租赁合同 的客户类型。type==1是对公，type==2是个人
                    $("#MaLeaseContract #lesseeType").val(row.type);
                } else if (haseasyui("#MaLeaseContract #zcLesseeText") && inputobj.inputId == "zcLesseeText") {
                    // $('#projectPid').val(r.projectId);
                    $("#MaLeaseContract #zcLessee").val(conids.join(","));
                    $("#MaLeaseContract #zcLesseeText").textbox('setValue', connames.join(","));

                    //租赁合同 的客户类型。type==1是对公，type==2是个人
                    $("#MaLeaseContract_FJYX #lesseeType").val(row.type);
                } else if (haseasyui("#MaLeaseContract #partCText") && inputobj.inputId == "partCText") {
                    // $('#projectPid').val(r.projectId);
                    $("#MaLeaseContract #partC").val(conids.join(","));
                    $("#MaLeaseContract #partCText").textbox('setValue', connames.join(","));

                    //租赁合同 的客户类型。type==1是对公，type==2是个人
                    $("#MaLeaseContract_FJYX #lesseeType").val(row.type);
                } else if (haseasyui("#MaLeaseContract_FJYX #lesseeText") && inputobj.inputId == "lesseeText") {
                    // $('#projectPid').val(r.projectId);
                    $("#MaLeaseContract_FJYX #lessee").val(conids.join(","));
                    $("#MaLeaseContract_FJYX #lesseeText").textbox('setValue', connames.join(","));

                    //租赁合同 的客户类型。type==1是对公，type==2是个人
                    $("#MaLeaseContract_FJYX #lesseeType").val(row.type);
                } else if (haseasyui("#GmAssetsArrival #contactOrgId") && inputobj.inputId == "contactOrgId") {
                    $("#GmAssetsArrival #contactOrgId").textbox('setValue', payee);
                    $("#GmAssetsArrival #contactOrgId").textbox('setText', payeeName);
                } else if (haseasyui("#AssetsWxArrival #partyB") && inputobj.inputId == "partyB") {

                    $("#AssetsWxArrival #partyB").textbox('setValue', payee);
                    $("#AssetsWxArrival #partyB").textbox('setText', payeeName);
                } else if (haseasyui("#PmBidSerconXS #partyA") && inputobj.inputId == "partyA") {

                    $("#PmBidSerconXS #partyA").textbox('setValue', payee);
                    $("#PmBidSerconXS #partyA").textbox('setText', payeeName);
                } else if (haseasyui("#PmBidSerconXSAlt #partyA_TEXT_") && inputobj.inputId == "partyA") {
                    $("#PmBidSerconXSAlt #partyA").val(payee);
                    $("#PmBidSerconXSAlt #partyA_TEXT_").textbox('setValue', payeeName);
                } else if (haseasyui("#GmAssetsReceiveOutWG_LS #cgOrgId_TEXT_")) {

                    $("#GmAssetsReceiveOutWG_LS #cgOrgId").val(payee);
                    $("#GmAssetsReceiveOutWG_LS #cgOrgId_TEXT_").textbox('setValue', payeeName);
                } else if (haseasyui("#GmAssetsReceiveOutWG_LY #cgOrgId_TEXT_")) {

                    $("#GmAssetsReceiveOutWG_LY #cgOrgId").val(payee);
                    $("#GmAssetsReceiveOutWG_LY #cgOrgId_TEXT_").textbox('setValue', payeeName);
                } else if ($('#FmMarginReceive').length > 0) {
                    // 暂时弃用
                    // $('#contractOrgId').val(payee);
                    // $('#contactOrgName').textbox('setValue', payeeName);
                    autoSetValue('payeeId' + index, payee);
                    autoSetValue('payee' + index, payeeName);
                    autoSetValue('contactOrgName' + index, payeeName);
                } else if ($('#FmMarginRefund').length > 0) {
                    autoSetValue('payeeId' + index, payee);
                    autoSetValue('payee' + index, payeeName);
                    // 暂时弃用
                    // $('#refundUnit').val(payee);
                    // $('#contactOrgName').textbox('setValue', payeeName);
                } else if ($('#FmFinancialLoan').length > 0 && inputobj.inputId == "payeeText") {
                    autoSetValue('payeeType', accountType);
                    $('#payee').val(payee);
                    $('#payeeText').textbox('setValue', payeeName);

                } else if ($('#FmNoConReceiveTotal').length > 0) {
                    autoSetValue('paymentType', accountType);
                    $('#paymentUnit').val(payee);
                    $('#paymentUnitText').textbox('setValue', payeeName);

                } else if ($('#MaCarOperationCost').length > 0) {
                    autoSetValue('contactOrgId', payee);
                    $('#contactOrgId_TEXT_').textbox('setValue', payeeName);
                } else if ($('#MaParkInfo').length > 0) {
                    autoSetValue('propertyUnit', payee);
                    $('#propertyUnit_TEXT_').textbox('setValue', payeeName);
                }

                //资产登记 股权投资
                if (haseasyui("#GmAssetsInventoryGQ #manageOrgText") && inputobj.inputId == "manageOrgText") {
                    $("#GmAssetsInventoryGQ #manageOrg").val(payee);
                    $("#GmAssetsInventoryGQ #manageOrgText").textbox('setValue', payeeName);
                }
                return true;
            } else {
                alertInfo("请选择数据");
                return false;
            }

        }
    })
}

/****************************************报账管理页面供应商账户信息弹窗 start****************************************************/
//客商账户弹框信息
function showAccountDataByContractOrgId(that) {
    var index = '';
    if (!that) {
        that = this;
    }
    if ($('#ConInfo_CG').length > 0) {
        index = that.id.replace('bankName', '');
    } else if ($('#expendDetail_panel').length > 0) {
        index = that.id.replace('bankName', '');
    } else if ($('#ConInfo_ZL').length > 0) {
        index = that.id.replace('bankName', '');
    } else if ($('#ConInfo_PM').length > 0) {
        index = that.id.replace('bankName', '');
    } else if ($('#FmMarginRefund').length > 0 || $('#FmMarginReceive').length > 0) {
        index = that.id.replace('bankName', '');
    } else if ($('#ConInfo_ZJFW').length > 0) {
        index = that.id.replace('bankName', '');
    } else {
        var inputobj = formatterInputobj(that);
        index = inputobj.inputId.replace('payeeBank', '');
    }
    var contactOrgId = $('#payeeUnit' + index).val();
    if ($('#expendDetail_panel').length > 0) {
        contactOrgId = $('#payer').val() == '' ? '' : $('#payer').val();
    } else if ($('#ConInfo_CG').length > 0) {
        contactOrgId = $('#contactOrgId' + index).val();
    } else if ($('#ConInfo_ZJFW').length > 0) {
        contactOrgId = $('#contactOrgId' + index).val();
    } else if ($('#ConInfo_ZL').length > 0) {
        contactOrgId = $('#contactOrgId' + index).val();
    } else if ($('#ConInfo_PM').length > 0) {
        contactOrgId = $('#contactOrgId' + index).val();
    } else if ($('#FmMarginRefund').length > 0 || $('#FmMarginReceive').length > 0) {
        contactOrgId = $('#payeeId' + index).val();
    }
    openChooseDialog({
        title: "选择账户开户行信息",
        contenturl: '/view/business/fm/FmPayApplyAccount?contactOrgId=' + contactOrgId,
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#PubContactOrgAccount_datagrid_select').datagrid('getSelected');
            if (r) {
                // 费用申请单或者税费缴纳申请或者差旅报销单
                if ($('#FmExpenseReimburse').length > 0 || $('#FmExpenseReimburse_SF').length > 0 || $('#FmExpenseReimburseAppropriation').length > 0 || $('#FmTravelExpenseReimburse').length > 0 || $('#FmFinancialLoan').length > 0 || $('#FmExpenseReimburse_HT_ZC').length > 0
                    || $('#FmExpenseReimburseProjectFunds').length > 0 || $('#FmExpenseReimburse_XC').length > 0) {
                    autoSetValue("payeeBank" + index, r.orgOpenBank);
                    autoSetValue("payeeAccount" + index, r.orgBankAccount);
                } else {
                    autoSetValue("bankName" + index, r.orgOpenBank);
                    autoSetValue("bankAccount" + index, r.orgBankAccount);
                }
                return true;
            } else {
                alertInfo("请选择开户行信息");
                return false;
            }
        }
    })
}

//职员账户弹框
function showAccountDataByaccountId(that) {
    if (!that) {
        that = this;
    }
    /*	if ($('#FmFinancialLoan').length > 0||$('#FmFinancialLoan_GH').length > 0) {
		var index;
	}else{*/
    var inputobj = formatterInputobj(that);
    var index = inputobj.inputId.replace('payeeBank', '');
    //}
    var accountId = $('#payeeUnit' + index).val();
    /*	if ($('#FmFinancialLoan').length > 0||$('#FmFinancialLoan_GH').length > 0) {
		accountId=$('#payee').val();
	}*/
    openChooseDialog({
        title: "选择账户开户行信息",
        contenturl: '/view/business/fm/FmReimburseAccountData?accountId=' + accountId,
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#ReimbursementAccount_datagrid_select').datagrid('getSelected');
            if (r) {
                /*if ($('#FmFinancialLoan').length > 0||$('#FmFinancialLoan_GH').length > 0) {
					autoSetValue("bankName", r.bankName);
					autoSetValue("bankAccount", r.accountNumber);
				} else {*/
                autoSetValue("payeeBank" + index, r.bankName);
                autoSetValue("payeeAccount" + index, r.accountNumber);
                //}
                return true;
            } else {
                alertInfo("请选择账户开户行信息");
                return false;
            }
        }
    })
}


//通过下标及 收款方ID获取账户信息数据
function findAccountDataByContractOrgId(payeeUnit, index) {
    $.ajax({
        url: ctx + "/FmPay/getBanksByContactOrgId",
        data: {
            contactOrgId: payeeUnit
        },
        dataType: 'json',
        success: function (result) {
            if (result.success) {
                if ($('#FmFinancialLoan').length > 0 || $('#FmFinancialLoan_GH').length > 0) {
                    $('#bankName').textbox('setValue', result.o.orgOpenBank);
                    $('#bankAccount').textbox('setValue', result.o.orgBankAccount);
                } else if ($('#expendDetail_panel').length > 0) {//代付
                    $('#payerBank' + index).textbox('setValue', result.o.orgOpenBank);
                    $('#payerAccount' + index).textbox('setValue', result.o.orgBankAccount);
                } else {
                    $('#payeeBank' + index).textbox('setValue', result.o.orgOpenBank);
                    $('#payeeAccount' + index).textbox('setValue', result.o.orgBankAccount);
                }
            } else if (result.success == false) {
                //一个单位对应多个开户行和账号(要把开户行框子变成弹出框，且选择开户行带出对应的银行账号)
                /*	if ($('#FmFinancialLoan').length > 0|| $('#FmFinancialLoan_GH').length > 0){
					$('#bankName').textbox('clear');
					$('#bankAccount').textbox('clear');
                }else{*/
                $('#payeeBank' + index).textbox('clear');
                $('#payeeAccount' + index).textbox('clear');
                //    }
            }
        }
    });
    //改变银行信息输入框为弹窗形式
    //changeBankToWin(index);
}

/****************************************报账管理页面供应商账户信息弹窗 end****************************************************/
/*************************************************合同续签查找申请页面信息 start***********************************************/
function showApplyContractLr() {

    openChooseDialog({
        title: "选择信息",
        contenturl: '/view/business/hr/HrLaborContractSA',
        width: 850,
        height: 500,
        okhandler: function () {
            var r = $('#HrLaborContractSA_datagrid').datagrid('getSelected');
            if (r) {
                $('#empId').val(r.empId);
                $('#empIdText').textbox('setValue', r.empName);
                $('#conProperty').combobox('setValue', r.conProperty);
                $('#oldDeptId').combobox('setValue', r.oldDeptId);
                $('#oldDeptId').combobox('setValue', r.oldDeptId);
                $('#employmentMode').combobox('setValue', r.employmentMode);
                $('#workhoureSys').combobox('setValue', r.workhoureSys);
                $('#oldContractStartTime').datebox('setValue', r.oldContractStartTime);
                $('#oldContractEndTime').datebox('setValue', r.oldContractEndTime);
                return true;
            } else {
                alertInfo('请选择招聘方案');
                return false;
            }
        }
    })
}

/*************************************************合同续签查找申请页面信息 end***********************************************/
/*************************************************独生子女补助申请 start***********************************************/

function selectByEmpIdAddContractForChild() {
    var accountId = $('#empId').val();
    $.ajax({
        url: ctx + "/HrLaborContract/selectByEmpIdAddContract",
        data: {
            empId: accountId
        },
        dataType: 'json',
        success: function (result) {
            if (result.success) {
                /* $('#conProperty').combobox('setValue',result.o.conProperty);*/
                /*$('#employmentMode').combobox('setValue',result.o.employmentMode);*/
                /* $('#workhoureSys').combobox('setValue',result.o.workhoureSys);*/
                $('#oldHrconTerm').textbox('setValue', result.o.hrconTerm);
                $('#oldContractStartTime').textbox('setValue', result.o.hrconBegin);
                $('#oldContractEndTime').textbox('setValue', result.o.hrconEnd);
                $('#empOrgId').combobox('setValue', result.o.oldOrgId);
                $('#empDeptId').combobox('setValue', result.o.oldDeptId);
            }
        }
    });

}

/*************************************************独生子女补助申请 end***********************************************/

/*************************************************员工离职申请 start***********************************************/

function selectByEmpIdAddContractForLeave() {
    var accountId = $('#empId').val();
    $.ajax({
        url: ctx + "/HrLaborContract/selectByEmpIdAddContract",
        data: {
            empId: accountId
        },
        dataType: 'json',
        success: function (result) {
            if (result.success) {
                $('#applyOrg').combobox('setValue', result.o.oldOrgId);
                $('#applyDept').combobox('setValue', result.o.oldDeptId);
                $('#oldPositionText').textbox('setValue', result.o.oldPositionText);
                $('#topEducation').combobox('setValue', result.o.topEducation);
                $('#signDate').datebox('setValue', result.o.signDate);
                $('#hrconBegin').datebox('setValue', result.o.hrconBegin);
                $('#hrconEnd').datebox('setValue', result.o.hrconEnd);
                $('#mobilephone').textbox('setValue', result.o.mobilephone);
                $('#topEducationText').textbox('setValue', result.o.topEducationText);
            }
        }
    });

}

/*************************************************员工离职申请 end***********************************************/

/** **********************表的字段弹出选择框********************* */
function showSelectColumns() {
    var inputobj = formatterInputobj(this);
    var modelPid = $('#bfm_form #modelPid').combotree('getValue');
    openChooseDialog({
        title: "选择编码",
        contenturl: '/view/sys/selectColumns?modelPid=' + modelPid,
        width: 400,
        height: 500,
        okhandler: function () {
            var r = $('#selectColumns_datagrid').datagrid('getSelected');
            if (r) {
                $('#' + inputobj.inputId).textbox('setValue', r.COLUMN_NAME);
                $('#' + inputobj.inputId).textbox('setText', r.COLUMN_NAME);
                $('#modelNameAdd').textbox('setValue', r.COMMENTS);
                $('#dataTypeAdd').combobox('setValue', r.DATA_TYPE);
                return true;
            } else {
                alertInfo("请选择部门");
                return false;
            }
        }
    })
}

function chooseTableModel() {
    var inputobj = formatterInputobj(this);
    var modelType = $('#BFmModel_form #modelType').combobox('getValue');
    var modelPid = $('#BFmModel_form #modelPid').combotree('getValue');
    if (modelType == 'mainTable' || modelType == 'sublistTable') {
        openChooseDialog({
            title: '选择数据库表',
            contenturl: '/gen/alltable',
            width: 400,
            height: 500,
            okhandler: function () {
                var row = $("#alltable").datagrid('getSelected');
                if (row) {
                    $('#' + inputobj.inputId).textbox('setValue', row.code);
                    $('#modelNameedit').textbox('setValue', row.name);
                    $('#' + inputobj.inputId).textbox('setText', row.code);
                    return true;
                } else {
                    alertInfo("请选择表名");
                    return false;
                }
            }
        });
    } else {
        openChooseDialog({
            title: "选择编码",
            contenturl: '/view/sys/selectColumns?modelPid=' + modelPid,
            width: 400,
            height: 500,
            okhandler: function () {
                var r = $('#selectColumns_datagrid').datagrid('getSelected');
                if (r) {
                    $('#' + inputobj.inputId).textbox('setValue', r.COLUMN_NAME);
                    $('#' + inputobj.inputId).textbox('setText', r.COLUMN_NAME);
                    return true;
                } else {
                    alertInfo("请选择部门");
                    return false;
                }
            }
        })
    }

}

/** **********************安保合同弹出选择框********************* */
function showPmSerconAB() {

    var serconType = 800;
    var formCode = '';
    /*if ($('#PmBidFile').length > 0){//招标文件会签 时
        //采购方式为公开招标
        serconSource = 1;
        formCode = 'PmBidFile';
    }*/

    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择安保合同主表",
        // contenturl: '/view/business/gm/GmAssetsCatalogSelect?filterInfoId='+filterInfoId.join(','),
        contenturl: '/view/business/gm/PmBidSerconabSelect?serconType=' + serconType + '&formCode=' + formCode,
        width: 850,
        height: 500,
        okhandler: function () {

            var r = $('#PmBidSerconabSelect_datagrid').datagrid('getSelected');
            if (r) {
                $('#' + inputobj.inputId).textbox('setValue', r.serconId);
                $('#' + inputobj.inputId).textbox('setText', r.serconName);

                $('#serconCode').textbox('setValue', r.serconCode);
                $('#serconMoney').numberbox('setValue', r.serconMoney);
                $('#serconId').val(r.serconId);


                $('#pmsecadjustdetailPanelId').panel('refresh', ctx + '/PmSecDeatail/editPmSecDeatailAdjust?isdetail=false&id=' + r.serconId);
                //autoSetValue("bidApplyId",r.applyNewId);
                //autoSetValue("bidName",r.applyNewNo);
                return true;
            } else {
                alertInfo("选择安保合同主表");
                return false;
            }
        }
    })

}

String.prototype.replaceAll = function (s1, s2) {
    return this.replace(new RegExp(s1, "gm"), s2);
}

/**
 * 根据资产ID和资产类别,查找资产明细
 *
 * @param id
 * @param assetsCatagory
 * @returns
 */
function openAssetsDetail(id, assetsCatagory) {
    openSaveDialog({
        title: "",
        maximized: true,
        submitType: 'single',
        fit: true,
        contenturl: "/GmAssetsInventory/searchAssetsReferData?assetsId=" + id + "&formCode=" + assetsCatagory + "&assetsId=" + id
        //onclose : reloadAssetsGrid
    });
}

//银行定期存款弹窗
function showBFmFundInvestWin(orgIdSel) {
    if (haseasyui('#orgId')) {
        orgIdSel = $("#orgId").combobox("getValue");//默认查询单位为同安的账号信息
    }
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择定期存款",
        contenturl: '/view/business/fm/FmFundInvestSelectWin?orgIdSel=' + orgIdSel + '&isEdit=true',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#FmFundInvestWin_datagrid').datagrid('getSelected');
            if (r) {
                if ($("#FmFundEarnings").length > 0) {
                    $("#fundInvestId").val(r.fundInvestId);
                    $("#investDetailId").val(r.investDetailId);
                    $("#investNo").textbox("setValue", r.investNo);
                    $('#interestBearDate').datebox('setValue', r.interestBearDate);
                    $("#estimateIncome").numberbox("setValue", r.estimateIncome);
                    $("#bankAccountId").val(r.bankAccountId);
                    $("#investBankAccount").textbox("setValue", r.investBankAccount);
                    $("#investBank").textbox("setValue", r.investBank);
                }
                return true;
            } else {
                alertInfo("请选择定期存款");
                return false;
            }
        }
    })
}


//通过业务表单编码与合同数据查找现金流量
function findFundSourceData(fmCode, conId, conNo) {
    var sourceData;
    $.ajax({
        url: ctx + "/FmBillSourceInfo/findFundSourceIdByCodes",
        async: false,
        data: {
            fmCode: fmCode,
            conId: conId,
            conCode: conNo
        },
        dataType: 'json',
        success: function (result) {
            if (result.success) {
                sourceData = result.o;
            } else {
                alertError(result.msg);
            }
        }
    });
    return sourceData;
}

function pmBidSerconDataSelectWin() {
    var involveType = "402";//采购类合同
    var inputobj = formatterInputobj(this);
    //若为（预）付款申请单
    if ($("#FmFinancialLoan_Payment").length > 0) {
        var involveType = $("input[name='involveType']:checked").val();
    }

    openChooseDialog({
        title: "选择采购合同",
        contenturl: '/view/business/fm/PmBidSerconDataSelect?involveType=' + involveType,
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $("#PmBidSerconSel_datagrid").datagrid('getSelected');
            if (r) {
                $('#pmconName').textbox('setValue', r.serconName);
                $('#conId').val(r.serconId);
                $('#conFormCode').val(r.formCode);
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }
    });

}

//党员选择弹窗
function showPartyMemberSelectWin() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择党员 ",
        contenturl: "/view/business/dj/PartyMemberSelectWin",
        width: 800,
        height: 500,
        okhandler: function () {
            var r = $('#PartyMemberInfo_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue(inputobj.inputId, r.infoId);
                autoSetValue(inputobj.inputText, r.accountIdText); //

                // 组织转接页面
                if ($("#PartyTransformation").length > 0) {
                    $("#partyOld").combotree('setValue', r.partyId)
                }
                if ($("#PartyTransformationOut").length > 0) {
                    $("#partyOld").combotree('setValue', r.partyId)
                }
                return true;
            } else {
                alertInfo("请选择项目");
                return false;
            }
        }
    });
}


//高级查询
function seniorSearch() {

    var doc = document;
//var seniorS=doc.getElementById("seniorS");
    var seniorS = $(".seniorLine");
//判断显示还是隐藏
    if (openSearch) {
        openSearch = false;
        seniorS.css("display", "display");
        document.getElementById('seniorSearchText').innerHTML = "关闭高级查询";
    } else {
        openSearch = true;
        seniorS.css("display", "none");
        document.getElementById('seniorSearchText').innerHTML = "打开高级查询";
    }
    //默认自动查询一次
    //searchEdocApply();
}


function selectGmAssetsRequisitionOut() {// 出库用的       ownerUnit
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择资产需用计划",
        contenturl: '/view/business/gm/GmAssetsRequisitionSelect_out',
        width: 750,
        height: 550,
        okhandler: function () {
            var r = $("#GmAssetsRequisition_datagrid").datagrid('getSelected');
            if (r) {
                $("#" + inputobj.inputId).textbox("setValue", r.requisitionId);
                $("#" + inputobj.inputId).textbox("setText", r.reqNo);
                autoSetValue("applyAccount", r.applyAccount);
                autoSetValue("applyAccount_TEXT_", r.applyAccountText);
                autoSetValue("applyDept", r.applyDept);
                autoSetValue("applyDept_TEXT_", r.applyDeptText);
                autoSetValue("applyTime", r.applyDate);
                var rows = $("#childTable").datagrid("getSelections");
                if (rows.length > 0) {
                    var ids = [];
                    for (var i = 0; i < rows.length; i++) {
                        ids.push(rows[i].infoId);
                    }
                    loadDataFun(ids.join(","));
                } else {
                    alertInfo("明细不能为空");
                }
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        },
        onload: function () {
            var month = new Date().getMonth();
            if (month == 0) {
                $("#startDate").datebox("setValue", parseInt((new Date()).Format("yyyy")) - 1 + "-12" + (new Date()).Format("dd"));
            } else {
                $("#startDate").datebox("setValue", (new Date()).Format("yyyy") + "-" + (month < 10 ? "0" + month : month) + "-" + (new Date()).Format("dd"));
            }
            $("#endDate").datebox("setValue", (new Date()).Format("yyyy-MM-dd"));
        }
    });

}

function selectGmAssetsRequisitionOutByNoCondition() { //出库无条件查找明细
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "项目信息",
        contenturl: '/view/business/gm/GmAssetsRequisitionSelectOutByNoCondition',
        width: 515,
        height: 465,
        okhandler: function () {
            var rows = $("#InvestProjectSelectWin_datagrid").datagrid("getSelections");
            if (rows.length > 0) {
                var ids = [];
                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].infoId);
                }
                loadDataFun(ids.join(","));
            }
            return true;
        }
    })
}

function selectGmAssetsInfoWin() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "资产信息",
        contenturl: '/view/business/gm/GmAssetsInfoWin',
        width: 515,
        height: 465,
        okhandler: function () {
            var rows = $("#InvestProjectSelectWin_datagrid").datagrid("getSelections")
            if (rows.length > 0) {
                for (var i = 0; i < rows.length; i++) {
                    adddataRow(rows[i]);
                }
            }
            return true;
        }
    })
}

function selectGmAssetsRequisition() {// 入库用的
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择资产需用计划",
        contenturl: '/view/business/gm/GmAssetsRequisitionSelect',
        width: 750,
        height: 550,
        okhandler: function () {
            var r = $("#GmAssetsRequisition_datagrid").datagrid('getSelected');
            if (r) {
                $("#" + inputobj.inputId).textbox("setValue", r.requisitionId);
                $("#" + inputobj.inputId).textbox("setText", r.reqNo);
                autoSetValue("applyAccount", r.applyAccount);
                autoSetValue("applyAccount_TEXT_", r.applyAccountText);
                autoSetValue("applyDept", r.applyDept);
                autoSetValue("applyDept_TEXT_", r.applyDeptText);
                var rows = $("#childTable").datagrid("getSelections");
                if (rows.length > 0) {
                    $(".repList2").remove();
                    for (var i = 0; i < rows.length; i++) {
                        loadEditorGrid(rows[i].requisitionDetilId);
                    }
                }
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        },
        onload: function () {
            var month = new Date().getMonth();
            if (month == 0) {
                $("#startDate").datebox("setValue", parseInt((new Date()).Format("yyyy")) - 1 + "-12" + (new Date()).Format("dd"));
            } else {
                $("#startDate").datebox("setValue", (new Date()).Format("yyyy") + "-" + (month < 10 ? "0" + month : month) + "-" + (new Date()).Format("dd"));
            }
            $("#endDate").datebox("setValue", (new Date()).Format("yyyy-MM-dd"));
        }
    });

}

function showEmpWinDet(type) {
    return function () {
        showEmpWinDet1(type, this);
    }
}

//人员选择弹出框
function showEmpWinDet1(type, that) {
    if (!that) {
        that = this;
    }
    var inputobj = formatterInputobj(that);
    openChooseDialog({
        title: "选择人员",
        contenturl: '/view/sys/empSelectWin?type=' + type,
        width: 800,
        height: 450,
        okhandler: function () {
            var r = $('#empSelect_datagrid').datagrid('getSelected');
            if (r) {
                var row = $("#issueList").datagrid("getSelected");
                // 获取请求行索引
                var rowIndex = $("#issueList").datagrid("getRowIndex", row);
                var proposedAccountName1 = $("#issueList").datagrid('getEditor', {
                    'index': rowIndex,
                    'field': 'proposedAccountName1'
                });
                // 赋值 proposedAccountName 汇报人员
                proposedAccountName1.target.textbox("setValue", r.ACCOUNT_NAME);
                row.reportMan = r.ACCOUNT_ID;
                return true;
            } else {
                alertInfo("请选择人员");
                return false;
            }
        },
        onload: function () {
            $('#empSelect_datagrid').datagrid({
                onDblClickRow: function (index, r) {
                    var btns = $(this).closest('.window').find('.dialog-button .l-btn-small');
                    if (btns.length > 0) {
                        $(btns[0]).click();
                    }
                }

            })
        }
    })

}

function selectRelationModelWin() {
    openChooseDialog({
        title: "请选择",
        contenturl: '/view/business/gm/relationModelSelect',
        width: 750,
        height: 450,
        okhandler: function () {
            var row = $('#edocApplyFW_datagrid').datagrid('getSelected');
            if (row) {
                autoSetValue('primaryKey', row.id);
                autoSetValue('formCode', "EdocApply");
                autoSetValue('businessTitle', row.subject);
                return true;
            }
            var row = $('#edocApplySW_datagrid').datagrid('getSelected');
            if (row) {
                autoSetValue('primaryKey', row.id);
                autoSetValue('formCode', "EdocApply");
                autoSetValue('businessTitle', row.subject);
                return true;
            }
        }
    })
}

//会议请假选择自身须参加的会议
function selectMeetingToMissingWin() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "会议信息",
        contenturl: '/view/business/gm/GmMeetingToMissingWin',
        width: 500,
        height: 465,
        okhandler: function () {
            var r = $("#MeetingToMissingWin_datagrid").datagrid('getSelected');
            if (r) {
                autoSetValue('meetingName', r.meetingTypeName);
                autoSetValue('meetingId', r.meetingNoticeId);
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }
    })
}

//耗材申购弹窗
function selectGmAssetsMaterialReqOut() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择申购单",
        contenturl: '/view/business/gm/GmAssetsMaterialReqSelectOut',// 领用出库只查办公用品
        width: 750,
        height: 550,
        okhandler: function () {
            var r = $("#mainTable").datagrid('getSelected');
            if (r) {
                $("#" + inputobj.inputId).textbox("setValue", r.reqId);
                $("#" + inputobj.inputId).textbox("setText", r.reqNo);
                var childRow = $("#childTable").datagrid('getSelections');
                if (childRow.length == 0) {
                    childRow = $("#childTable").datagrid('getData').rows;
                }
                for (var i = 0; i < childRow.length; i++) {
                    adddataRow(childRow[i]);
                }
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        },
        onload: function () {
            var month = new Date().getMonth();
            if (month == 0) {
                $("#startDate").datebox("setValue", parseInt((new Date()).Format("yyyy")) - 1 + "-12" + (new Date()).Format("dd"));
            } else {
                $("#startDate").datebox("setValue", (new Date()).Format("yyyy") + "-" + (month < 10 ? "0" + month : month) + "-" + (new Date()).Format("dd"));
            }
            $("#endDate").datebox("setValue", (new Date()).Format("yyyy-MM-dd"));
        }
    });
}

//获取时间区间节假日天数
function getHolidayCount(start, end, leaveType) {
    var cou = 0;
    $.ajax({
        url: ctx + '/HrHoliday/getHolidayCount',
        async: false,
        data: {
            start: start,
            end: end,
            leaveType: leaveType
        },
        dataType: 'JSON',
        success: function (result) {
            cou = result.o;
        }
    })
    return cou;
}

/** **********************项目弹出框********************* */
function showPmProjectBoard(tableName) {
    return function () {
        showPmProject(tableName);
    }
}

function showPmProject(tableName) {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "项目信息",
        contenturl: '/view/business/pm/PmProjectDecisionWin?tableName=' + tableName,
        width: 600,
        height: 450,
        okhandler: function () {
            $("#PmProjectDecisionList_datagrid")
            var r = $('#InvestProjectSelectWin_datagrid').datagrid('getSelected');
            // console.log(r);
            let allPaidIn = r.allPaidIn = '' || r.allPaidIn == null ? 0 : r.allPaidIn;
            if (r) {
                autoSetValue("projectCode", r.projectCode);
                autoSetValue("projectName", r.projectName);
                autoSetValue("projectId", r.projectId);

                autoSetValue("projectTypeId", r.projectTypeId);
                autoSetValue("constructBasis", r.constructBasis);
                autoSetValue("constructType", r.constructType);
                autoSetValue("projectMember", r.projectMember);
                autoSetValue("projectMember_TEXT_", r.projectMemberText);
                autoSetValue("planStartDate", r.planStartDate);
                autoSetValue("planEndDate", r.planEndDate);
                autoSetValue("paymentUnit", r.paymentUnit);
                autoSetValue("fundSource", r.fundSource);
                autoSetValue("investEstimate", r.investEstimate);
                autoSetValue("addr", r.addr);
                autoSetValue("totalInvest", r.investEstimate);

                autoSetValue("startDate", r.planStartDate);
                autoSetValue("finishDate", r.planEndDate);
                autoSetValue("projectScale", r.projectScale);
                autoSetValue("programType", r.constructBasis);

                autoSetValue("areaCovered", r.areaCovered);
                autoSetValue("builtArea", r.builtArea);
                autoSetValue("abovArea", r.abovArea);
                autoSetValue("constructUnit", r.constructUnit);
                autoSetValue("constructUnit_TEXT_", r.constructUnitText);


                autoSetValue("pmconId", '');
                autoSetValue("pmconName", '');
                if (!r.natureLand == '') {
                    $('#natureLand').combobox('setValues', r.natureLand);
                }
                return true;
            } else {
                alertInfo("请选择项目信息");
                return false;
            }
        }
    })
}

function selectPersonInfoBydeptOrOrgWin(id) {
    return function () {
        selectPersonInfoBydeptOrOrg(id, this);
    }
}

function selectPersonInfoBydeptOrOrg(id, that) {//通过组织或者部门查找所属人员信息
    var inputobj = formatterInputobj(that);
    var dateIndex = getEndNumberForStr(inputobj.inputId);
    openChooseDialog({
        title: "人员信息",
        contenturl: '/view/business/gm/SelectCommonPersonByDeptOrOrg?id=' + id,
        width: 515,
        height: 465,
        okhandler: function () {
            var r = $('#SelectCommonPerson_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue("undertakeAccountText" + dateIndex, r.ACCOUNT_NAME);
                autoSetValue("undertakeAccount" + dateIndex, r.ACCOUNT_ID);
            }
            return true;
        }
    })
}

/***
 * 隐藏除了第一个以外的所有tab页
 *
 */
function tabHiddenAll() {
    $(".tagCard>a").each(function (index, element) {
        if (index != 0) {
            hiddenTabClass($(element));
        }
    })
}

/***
 * 隐藏tab页
 *
 */
function tabShowAndHiddenOther(indexTab) {
    $(".tagCard>a").each(function (index, element) {
        if (index != 0 && indexTab != index) {
            hiddenTabClass($(element));
        } else {
            showTabClass($(element));
        }
    })
}

/***
 * 移除隐藏tab页的class
 *
 * @param hiddenTabText
 * @param node
 */
function hiddenTabClass(node) {
    node.removeClass("current");
    node.addClass("no_current");
    node.css("display", "none");
}

/***
 * 显示tab
 *
 * @param hiddenTabText
 * @param node
 */
function showTabClass(node) {
    node.removeClass("no_current");
    node.addClass("current");
    node.css("display", "-1");
}

function showCommonConInfoSelectWinForAppropriationP() {
    showCommonConInfoSelectWinForAppropriation('1', '0');
}

//公共合同弹框
//type为1收款    2付款    默认所有合同   isTree 1 有左侧树  conType 合同类型
function showCommonConInfoSelectWinForAppropriation(type, isTree) {
    if (isTree == '1') {
        return function () {
            //带左侧树
            showConWithTreeSelectWinFun(type, this, conType);
        }
    } else {
        showConNoTreeSelectWinFunForAppropriation(type, this);
    }

}

//公共合同弹框
//type为收支类型  1收款    2付款    默认所有合同   isTree 1 有左侧树  conType 合同类型
function showCommonConInfoSelectWin(type, isTree, conType) {
    if (isTree == '1') {
        return function () {
            //带左侧树
            showConWithTreeSelectWinFun(type, this, conType);
        }
    } else {
        return function () {
            //不带左侧树
            showConNoTreeSelectWinFun(type, this, conType);
        }
    }

}

//公共合同弹框（仅列表样式）
function showConNoTreeSelectWinFun(type, that, conType) {
    var inputobj = formatterInputobj(that);
    openChooseDialog({
        title: "请选择合同",
        contenturl: '/view/business/cn/ConInfoSelectNoTree?revExpTypes=' + type + '&conType=' + conType,
        width: 700,
        height: 450,
        okhandler: function () {
            var r = $("#ConNoTree_datagrid").datagrid('getSelected');
            // console.log(r);
            if (r) {
                $('#' + inputobj.inputId).val(r.conId);
                $('#' + inputobj.inputText).textbox('setValue', r.conName);

                // 合同终止，选择某个合同后，刷新该合同下的数据至页面显示
                if ($("#ConRentStop").length > 0) {
                    // 历史已收信息
                    $('#phaseList').panel('refresh', ctx + '/ConRentStopPhase/editConRentStopPhaseReceived?sId=' + r.conId);
                    // 历史未收信息
                    $('#phaseNotReceivedList').panel('refresh', ctx + '/ConRentStopPhase/editConRentStopPhaseNotReceived?sId=' + r.conId);
                    // 保证金信息
                    $('#marginList').panel('refresh', ctx + '/ConRentStopMargin/editConRentStopMargin?sId=' + r.conId);
                }
                // 非项目资金拨付，项目资金拨付单合同付款阶段设置
                if (($("#FmExpenseReimburseAppropriation").length > 0 || $("#FmExpenseReimburseProjectFunds").length > 0) && haseasyui('#phaseIdText')) {
                    if (r.pricingMethod == 2) {
                        // 设置合同付款阶段为不可用
                        setCss($("#phaseIdText"), "textbox", false, true, false, true, true);
                    } else {
                        // 设置合同付款阶段为可用
                        setCss($("#phaseIdText"), "textbox", false, false, true, false, false);
                    }
                }
                // 项目资金拨付单
                if ($("#FmExpenseReimburseProjectFunds").length > 0) {
                    autoSetValue('projectId', r.fmproId);
                    autoSetValue('projectName', r.projectName);
                    autoSetValue('conMoney', r.conMoney);
                    // 先清空，再赋值
                    autoSetValue('payOrgId', '');
                    autoSetValue('payOrgId', r.orgId);
                    // autoSetValue('payOrgIdText', r.orgIdText);
                }
                // 非项目资金拨付单
                if ($("#FmExpenseReimburseAppropriation").length > 0) {
                    autoSetValue('conMoney', r.conMoney);
                    // 支付信息新增一行，并且带出供应商信息
                    autoSetPayInfoAboutSupplierByContract(r.contactOrgName, r.contactOrgId);
                }
                // 募集说明书
                if ($("#FmProspectus").length > 0) {
                    autoSetValue('consignee', r.contactOrgId);
                    autoSetValue('consignee_TEXT_', r.contactOrgName);


                }
                // 工程结算报告
                if ($("#PmPmconAccountBackup").length > 0) {
                    autoSetValue('auditUnit', r.contactOrgId);
                    autoSetValue('auditUnit_TEXT_', r.contactOrgName);


                }
                return true;
            }
        },
    });
}

//公共合同弹框（仅列表样式）
function showConNoTreeSelectWinFunForAppropriation(type, that) {
    var inputobj = formatterInputobj(that);
    openChooseDialog({
        title: "请选择合同",
        contenturl: '/view/business/cn/ConInfoSelectNoTree',
        width: 700,
        height: 450,
        okhandler: function () {
            var r = $("#ConNoTree_datagrid").datagrid('getSelected');
            if (r) {
                autoSetValue("conId_TEXT_", r.conName);
                autoSetValue("conId", r.conId);
                autoSetValue("conMoney", r.conMoney);
                return true;
            }
        },
    });
}


//公共合同弹框(带左侧树)
//通过合同类型con_type_id，收付款类型REV_EXP_TYPES   1收款    2付款    0所有合同
function showConWithTreeSelectWinFun(type, that, conType) {
    var inputobj = formatterInputobj(that);
    openChooseDialog({
        title: "请选择合同",
        contenturl: "/view/business/cn/CnCommonSelectWin?revExpTypes=" + type + '&' + conType,
        width: 800,
        height: 450,
        okhandler: function () {
            var r = $('#ConData_datagrid').datagrid('getSelected');
            if (r) {
                $('#' + inputobj.inputId).val(r.conId);
                $('#' + inputobj.inputText).textbox('setValue', r.conName);
                return true;
            } else {
                alertInfo("请选择合同");
                return false;
            }
        },
        onload: function () {
            $('#PmPmcon_datagrid').datagrid({
                onDblClickRow: function (index, r) {
                    var btns = $(this).closest('.window').find('.dialog-button .l-btn-small');
                    if (btns.length > 0) {
                        $(btns[0]).click();
                    }
                }

            })
        }
    })
}

//参与者角色弹框
function selectGradePerson() {
    openChooseDialog({
        title: "参与者选择",
        contenturl: '/view/business/hr/HrGradePersonParticitant',
        width: 750,
        height: 450,
        okhandler: function () {
            return true;
        }
    })
}

/*************基金成立选择弹出框****************/
function showFundBuildChooseWin2(type, index) {
    return function () {
        showFundBuildChooseWin(type, index);
    }
}

function showFundBuildChooseWin(type, index) {
    openChooseDialog({
        title: "基金成立选择",
        contenturl: '/view/business/im/FundBuildWin',
        width: 790,
        height: 400,
        okhandler: function () {
            var node = $('#FundBuildWin_datagrid').datagrid('getSelected');
            if (node) {
                if (type == 2) {//年度投资计划->出资明细
                    autoSetValue('fundBuildId' + index, node.id);
                    autoSetValue('fundName' + index, node.fundName);
                } else if (type == 3) {//基金信息变更
                    autoSetValue('fundId', node.id);
                    autoSetValue('fundName', node.fundName);
                    autoSetValue('fundScale', node.fundScale / 10000);
                    autoSetValue("investBody", node.investBody);
                    autoSetValue("fundNumber", node.fundNumber);
                    autoSetValue("fundType", node.fundType);
                    autoSetValue("invDirection", node.invDirection);
                    autoSetValue("createDate", node.createDate);
                    autoSetValue("fundManager", node.fundManager);
                    autoSetValue("fundManagerName", node.contactOrgName);
                    // autoSetValue("officeAddress",node.officeAddress);
                    autoSetValue("registerAddress", node.registerAddress);
                    autoSetValue("otherInvDirection", node.otherInvDirection);
                    autoSetValue("versionNumber", node.versionNumber);
                    autoSetValue("fundCustodian", node.fundCustodian);
                    autoSetValue("fundStatus", node.fundStatus);
                    autoSetValue("durationExtenderPeriod", node.durationExtenderPeriod);

                    autoSetValue("durationInvPeriod", node.durationInvPeriod);
                    autoSetValue("withdrawalPeriod", node.withdrawalPeriod);
                    autoSetValue("durationExtenderPeriod", node.durationExtenderPeriod);
                    autoSetValue("durationWithdrawalPeriod", node.durationWithdrawalPeriod);
                    autoSetValue("durationExitDeadline", node.durationExitDeadline);
                    autoSetValue("durationInvDeadline", node.durationInvDeadline);

                    autoSetValue("cfarIsFiling", node.cfarIsFiling);
                    autoSetValue("cfarTime", node.cfarTime);

                    autoSetValue("isFiling", node.isFiling);
                    autoSetValue("filingTime", node.filingTime);


                } else if (type == 4) {//企业服务管理
                    autoSetValue('fundBuildId', node.id);
                    autoSetValue('fundName', node.fundName);
                } else {
                    // $('#fundSignAgreementId').val(node.id);
                    // $('#fundSignAgreementNumber').textbox('setValue',node.fundSignAgreementNumber);
                    // $('#fundName').textbox('setValue',node.fundName);
                    // $('#fundManager').val(node.fundManager);
                    autoSetValue('fundBuildId', node.id);
                    autoSetValue('fundName', node.fundName);
                    autoSetValue('contactOrgName', node.contactOrgName);
                    autoSetValue('fundScale', (node.fundScale / 10000).toFixed(6));
                    autoSetValue("contributBody", node.investBody);
                }
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }

    })
}

/*************企业服务管理弹出框****************/
function showImProjectEnterpriseServiceManageChooseWin2(type, index) {
    return function () {
        showImProjectEnterpriseServiceManageChooseWin(type, index);
    }
}

function showImProjectEnterpriseServiceManageChooseWin(type, index) {
    openChooseDialog({
        title: "企业服务管理选择",
        contenturl: '/view/business/im/ImProjectEnterpriseServiceManageWin',
        width: 680,
        height: 400,
        okhandler: function () {
            var node = $('#ImProjectEnterpriseServiceManageWin_datagrid').datagrid('getSelected');
            if (node) {
                if (type == 1) {

                } else if (type == 2) {

                } else {
                    autoSetValue('manageId', node.id);
                    autoSetValue('serviceManageNumber', node.serviceManageNumber);
                    autoSetValue('projectName', node.projectName);
                    autoSetValue('projectInfo', node.projectInfo);
                    autoSetValue('projectSource', node.projectSource);
                    autoSetValue('landDate', node.landDate);
                    autoSetValue('fundBuildId', node.fundBuildId);
                    autoSetValue('fundName', node.fundName);
                    autoSetValue('otherSource', node.otherSource);
                    autoSetValue('isPlanContribut', node.isPlanContribut);
                    autoSetValue('proposedLandBody', node.proposedLandBody);
                    autoSetValue('proposedLandPark', node.proposedLandPark);
                    autoSetValue('projectStatus', node.projectStatus);
                    autoSetValue('quitTime', node.quitTime);
                }
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }

    })
}

/*************年度投资计划->企业信息选择弹出框****************/
function showImProjectEnterpriseInformationChooseWin2(type, index) {
    return function () {
        showImProjectEnterpriseInformationChooseWin(type, index);
    }
}

function showImProjectEnterpriseInformationChooseWin(type, index) {
    openChooseDialog({
        title: "企业信息选择",
        contenturl: '/view/business/im/ImProjectEnterpriseInformationWin',
        width: 860,
        height: 400,
        okhandler: function () {
            var node = $('#ImProjectEnterpriseInformationWin_datagrid').datagrid('getSelected');
            if (node) {
                if (type == 1) {//年度投资计划->计划收益明细
                    autoSetValue('fundBuildIdTwo' + index, node.fundBuildId);
                    autoSetValue('fundNameTwo' + index, node.fundName);
                    autoSetValue('investmentPlanId' + index, node.id);
                    autoSetValue('shortName' + index, node.shortName);
                } else if (type == 2) {
                    autoSetValue('projectId', node.id);
                    autoSetValue('projectName', node.shortName);
                    autoSetValue('fundName', node.fundName);
                    autoSetValue('investDate', node.investDate);
                } else {

                }
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }
    })
}

/*************基金管理机构****************/
function showFundManagementOrganizationChooseWin(type) {
    return function () {
        showFundManagementOrganizationChooseWin2(type, this);
    }
}

function showFundManagementOrganizationChooseWin2(type, that) {
    var inputobj = formatterInputobj(that);
    openChooseDialogDt({
        title: "基金管理机构",
        contenturl: '/view/business/im/FundManagementOrganization',
        width: 700,
        height: 400,
        okhandler: function () {
            var node = $('#FundManagementOrganization_datagrid').datagrid('getSelected');
            if (node) {
                if (type == 1) {//bp管理
                    $('#fmOrgcode').val(node.id);
                    $('#fmOrgName').textbox('setValue', node.contactOrgName);
                    $('#cfaNumber').textbox('setValue', node.cfaNumber);
                    $('#contactOrgName').textbox('setValue', node.contactOrgName);
                    $('#creditCode').textbox('setValue', node.creditCode);
                    $('#registerAddr').textbox('setValue', node.registerAddr);
                    $('#capital').textbox('setValue', node.capital);
                } else if (type == 2) {//基金初审
                    $('#fundManager').val(node.id);
                    $('#fundManagerText').textbox('setValue', node.contactOrgName);
                } else {
                    autoSetValue('fundManager', node.id);
                    autoSetValue('fundManagerName', node.contactOrgName);
                }
                return true;
            } else {
                alertInfo("请选择基金机构");
                return false;
            }
        }

    })
}

/*************基金初审选择弹出框****************/
function showFundFirstTrialChooseWin() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "基金选择",
        contenturl: '/view/business/im/FundFirstTrialWinChooseWin',
        width: 790,
        height: 400,
        okhandler: function () {
            var node = $('#FundFirstTrialWin_datagrid').datagrid('getSelected');
            if (node) {
                $('#fundFirstTrialId').val(node.id);
                $('#fundFirstTrialNumber').textbox('setValue', node.fundFirstTrialNumber);
                $('#fundName').textbox('setValue', node.fundName);
                // $('#fundManagerText').textbox('setValue',node.fundManagerText);
                // $('#fundScale').numberbox('setValue',node.fundScale);

                $('#cfaNumber').textbox('setValue', node.cfaNumber);
                $('#contactOrgName').textbox('setValue', node.contactOrgName);
                $('#creditCode').textbox('setValue', node.creditCode);
                $('#registerAddr').textbox('setValue', node.registerAddr);
                $('#capital').textbox('setValue', node.capital);
                $('#officeAddr').textbox('setValue', node.officeAddr);
                $('#establishmentTime').textbox('setValue', node.establishmentTime);
                $('#registerationTime').textbox('setValue', node.registerationTime);
                $('#flowNumber').val(node.flowNumber);
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }

    })
}

/*************基金尽调选择弹出框****************/
function showFundDueDiligenceChooseWin() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "基金尽调选择",
        contenturl: '/view/business/im/FundDueDiligenceChooseWin',
        width: 790,
        height: 400,
        okhandler: function () {
            var node = $('#FundDueDiligenceWin_datagrid').datagrid('getSelected');
            if (node) {
                $('#fundDueDiligenceId').val(node.id);
                $('#dueNumber').textbox('setValue', node.dueNumber);
                $('#fundName').textbox('setValue', node.fundName);
                $('#contactOrgName').textbox('setValue', node.contactOrgName);
                $('#fundScale').numberbox('setValue', node.fundScale);

                // $('#cfaNumber').textbox('setValue',node.cfaNumber);
                // $('#contactOrgName').textbox('setValue',node.contactOrgName);
                // $('#creditCode').textbox('setValue',node.creditCode);
                // $('#registerAddr').textbox('setValue',node.registerAddr);
                // $('#capital').textbox('setValue',node.capital);
                // $('#officeAddr').textbox('setValue',node.officeAddr);
                // $('#establishmentTime').textbox('setValue',node.establishmentTime);
                // $('#registerationTime').textbox('setValue',node.registerationTime);
                // $('#flowNumber').val(node.flowNumber);
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }

    })
}

/*************基金决策审批选择弹出框****************/
function showFundDecisionApprovalChooseWin() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "基金决策选择",
        contenturl: '/view/business/im/FundDecisionApprovalChooseWin',
        width: 790,
        height: 400,
        okhandler: function () {
            var node = $('#FundDecisionApprovalWin_datagrid').datagrid('getSelected');
            if (node) {
                $('#fundDecisionApprovalId').val(node.id);
                $('#fundDecisionApprovalNumber').textbox('setValue', node.fundDecisionApprovalNumber);
                autoSetValue("fundName", node.fundName);
                $('#contactOrgName').textbox('setValue', node.contactOrgName);
                $('#fundScale').numberbox('setValue', node.fundScale / 10000);

                $('#raiseLimit').numberbox('setValue', node.raiseLimit);
                $('#duration').textbox('setValue', node.duration);
                $('#invPeriod').textbox('setValue', node.invPeriod);
                $('#manageQuitPeriod').textbox('setValue', node.withdrawalPeriod);
                $('#extenderPeriod').textbox('setValue', node.extenderPeriod);
                autoSetValue("durationInvPeriod", node.durationInvPeriod);
                autoSetValue("withdrawalPeriod", node.durationWithdrawalPeriod);
                autoSetValue("durationExtenderPeriod", node.durationWithdrawalExtenderPeriod);
                autoSetValue("durationWithdrawalPeriod", node.durationInvExtenderPeriod);
                autoSetValue("investBody", node.investBody);
                autoSetValue("renjiaoContribution", node.renjiaoContribution);
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }

    })
}

/** **********************展示决策条件输入框********************* */
function showParticipants() {
    if (this.value == '0') {
        $('#participants').closest("td").hide();
    } else {
        $('#participants').closest("td").show();
    }
}

/*************基金协议签订选择弹出框****************/
function showFundSignAgreementChooseWin() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "基金协议签订选择",
        contenturl: '/view/business/im/FundSignAgreementWin',
        width: 790,
        height: 400,
        okhandler: function () {
            var node = $('#FundSignAgreementWin_datagrid').datagrid('getSelected');
            if (node) {
                $('#fundSignAgreementId').val(node.id);
                $('#fundSignAgreementNumber').textbox('setValue', node.fundSignAgreementNumber);
                $('#fundName').textbox('setValue', node.fundName);
                $('#fundManager').val(node.fundManager);
                $('#contactOrgName').textbox('setValue', node.contactOrgName);
                $('#fundScale').numberbox('setValue', node.fundScale / 10000);
                $('#invDirection').combobox('setValues', node.invDirection);
                autoSetValue('investBody', node.investBody);
                autoSetValue('fundType', node.fundType);
                autoSetValue('durationInvPeriod', node.durationInvPeriod);
                autoSetValue('withdrawalPeriod', node.withdrawalPeriod);
                autoSetValue('durationWithdrawalPeriod', node.durationWithdrawalPeriod);
                autoSetValue('durationExtenderPeriod', node.durationExtenderPeriod);
                autoSetValue('projectManager', node.handleEmp);
                //$('#durationInvPeriod').textbox('setValue',node.durationInvPeriod);
                // $('#durationWithdrawalPeriod').textbox('setValue',node.durationWithdrawalPeriod);
                // $('#durationInvExtenderPeriod').textbox('setValue',node.durationInvExtenderPeriod);
                //$('#durationWithdrawalExtenderPeriod').textbox('setValue',node.durationWithdrawalExtenderPeriod);
                // $('#duration').textbox('setValue',node.durationInvPeriod+'+'+node.durationWithdrawalPeriod+'+'+node.durationInvExtenderPeriod+'+'+node.durationWithdrawalExtenderPeriod);

                //将合伙人信息带过来
                addRecordsByChangeFundSignAgreementId(node.id);

                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }

    })
}

/*************企业信息弹出选择框****************/
function showEnterpriseInfoChooseWin() {
    var inputobj = formatterInputobj(this);
    openChooseDialogDt({
        title: "企业信息选择",
        contenturl: '/view/business/em/EmEnterpriseinfoWin',
        // contenturl: '/view/business/em/EmEnterpriseinfo',
        width: 700,
        height: 400,
        okhandler: function () {
            var node = $('#EmEnterpriseinfo_datagrid').datagrid('getSelected');
            if (node) {
                $('#enterpriseId').val(node.enterpriseId);
                $('#enterpriseName').textbox('setValue', node.enterpriseName);
                initDataList(node);
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }

    })
}

/** **********************基金选择弹出窗********************* */
function showProjectFundName() {
    // var inputobj = formatterInputobj(obj);
    // console.log(inputobj);
    // console.log($('#' + inputobj.inputId).numberbox('getValue'));
    // console.log($('#' + inputobj.inputText).textbox('getValue'));
    openChooseDialog({
        title: "基金信息",
        contenturl: '/view/business/im/InvestProjectSelectFund',
        width: 1000,
        height: 600,
        okhandler: function () {
            var r = $('#InvestProjectSelectWin_datagrid').datagrid('getSelected');
            if (r) {
                // $('#' + inputobj.inputId).numberbox('setValue',r.projectId);
                // $('#' + inputobj.inputText).textbox('setValue', r.shortName);
                // console.log(r.projectId+"----"+r.shortName)
                // $('#projectName').textbox().textbox('setValue',r.shortName);
                // $('#projectId').numberbox().textbox('setValue',r.projectId);
                autoSetValue("fundBuildId", r.fundBuildId);
                $('#fundName').textbox().textbox('setValue', r.fundName);
                // $('#fundScale').textbox().textbox('setValue',r.fundScale);
                return true;
            } else {
                alertInfo("请选择基金信息");
                return false;
            }
        }
    })
}

/** **********************企业信息********************* */
function showEnterpriseInformation() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "企业信息",
        contenturl: '/view/business/im/EnterpriseInformationinitializationWin',
        width: 700,
        height: 450,
        okhandler: function () {
            var r = $('#InvestProjectSelectWin_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue("shortName", r.shortName);
                autoSetValue("fundName", r.fundName);
                autoSetValue("fundManager", r.fundManager);
                autoSetValue("companyId", r.companyId);
                autoSetValue("investAmount", (r.investAmount / 10000).toFixed(6));
                autoSetValue("fundBuildId", r.fundBuildId);
                autoSetValue("fundManagerName", r.fundManagerName);
                return true;
            } else {
                alertInfo("请选择企业信息");
                return false;
            }
        }
    })
}

/*************项目季度报告弹出窗****************/
function showQuarterlyReportWin() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "企业信息",
        contenturl: '/view/business/im/QuarterlyReportinitializationWin',
        width: 600,
        height: 450,
        okhandler: function () {
            var r = $('#InvestProjectSelectWin_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue("name", r.shortName);
                autoSetValue("fundName", r.fundName);
                autoSetValue("fundManager", r.fundManagerName);
                autoSetValue("prepareScale", r.investAmount / 10000);
                autoSetValue("projectId", r.projectId);
                autoSetValue("originalHoldRatio", r.originalHoldRatio);
                autoSetValue("postValuation", r.postInvestment / 10000);
                autoSetValue("beatClause", r.beatClause);
                autoSetValue("quitClause", r.quitClause);
                autoSetValue("elseClause", r.elseClause);
                return true;
            } else {
                alertInfo("请选择企业信息");
                return false;
            }
        }
    })
}

function changeCurrentValue() {
    var inputobj = formatterInputobj(this);
    var a = $('#currentDeliveryValue').numberbox('getValue');
    var b = $('#postValuation').numberbox('getValue');
    if (b == false) {
    } else {
        var c = (a - b) / b * 100;
        $('#growthDeliveryRatio').numberbox('setValue', c);

    }
}


/** **********************投资合同签订弹出窗********************* */
function showInvestProjecAggrementWinFun() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "项目信息",
        contenturl: '/view/business/im/InvestProjecAggrementinitializationWin',
        width: 600,
        height: 450,
        okhandler: function () {
            var r = $('#InvestProjectSelectWin_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue("projectId", r.projectId);
                autoSetValue("shortName", r.shortName);
                autoSetValue("prepareScale", r.prepareScale);
                autoSetValue("postInvestValue", r.postInvestValue);
                return true;
            } else {
                alertInfo("请选择项目信息");
                return false;
            }
        }
    })
}

/** **********************展示外派人员信息输入框********************* */
function showExpatriate() {
    if (this.value == 'N') {
        $('#expatriateInformation').closest("tr").hide();
    }
    if (this.value == 'Y') {
        $('#expatriateInformation').closest("tr").show();
    }
}

/** **********************企业信息库变更弹出窗********************* */
function showEnterpriseinfoChangeWinFun() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "企业信息",
        contenturl: '/view/business/im/EnterpriseinfoChangeWin',
        width: 650,
        height: 465,
        okhandler: function () {
            var r = $('#InvestProjectSelectWin_datagrid').datagrid('getSelected');
            if (r) {
                initEnterpriseChange(r);
                return true;
            } else {
                alertInfo("请选择项目信息");
                return false;
            }
        }
    })
}

/** 工程合同弹出选择框与项目联动 **/
function showPmPmconByprojectIdWin() {
    if ($('#projectId').val() == '') {
        alertInfo("请先选择项目");
        return;
    }
    openChooseDialog({
        title: "工程合同",
        contenturl: '/view/business/pm/showPmPmconByprojectIdWin?projectId=' + $('#projectId').val(),
        width: 600,
        height: 450,
        okhandler: function () {
            var r = $('#PmPmconWin_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue('pmconId', r.pmconId);
                autoSetValue('pmconName', r.pmconName);
                autoSetValue('partyBName', r.partyBName);
                autoSetValue('partyB', r.partyB);
                autoSetValue('partyB_TEXT_', r.partyBName);
                return true;
            } else {
                alertInfo("请选择工程合同");
                return false;
            }
        }
    })
}


/** 工程合同弹出选择框 **/
function showPmPmconWin(projectId) {
    openChooseDialog({
        title: "工程合同",
        contenturl: '/view/business/pm/PmPmconWin?projectId=' + projectId,
        width: 600,
        height: 450,
        okhandler: function () {
            var r = $('#PmPmconWin_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue('pmconId', r.pmconId);
                autoSetValue('pmconName', r.pmconName);
                autoSetValue('partyBName', r.partyBName);
                autoSetValue('designUnit', r.partyB);
                return true;
            } else {
                alertInfo("请选择工程合同");
                return false;
            }
        }
    })
}

/** 工程合同弹出选择框 新 **/
function showPmPmconWinByProjectIdNew(formCode) {
    return function () {
        showPmPmconWinByProjectIdNew2(formCode, this);
    }
}


function showPmPmconWinByProjectIdNew2(formCode, that) {
    if ($('#projectId').val() == '') {
        alertInfo("请先选择项目");
        return;
    }
    openChooseDialog({
        title: "工程合同",
        contenturl: '/view/business/pm/PmPmconWinNew?formCode=' + formCode + '&projectId=' + $('#projectId').val(),
        width: 600,
        height: 450,
        okhandler: function () {
            var r = $('#PmPmconWin_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue('pmconId', r.conId);
                autoSetValue('pmconName', r.conName);
                // autoSetValue('partyBName', r.partyBName);
                // autoSetValue('designUnit', r.partyB);
                return true;
            } else {
                alertInfo("请选择工程合同");
                return false;
            }
        }
    })
}

/** 工程合同弹出选择框 新 **/
function showPmPmconWinNew(formCode) {
    return function () {
        showPmPmconWinNew2(formCode, this);
    }
}


function showPmPmconWinNew2(formCode, that) {

    openChooseDialog({
        title: "工程合同",
        contenturl: '/view/business/pm/PmPmconWinNew?formCode=' + formCode,
        width: 600,
        height: 450,
        okhandler: function () {
            var r = $('#PmPmconWin_datagrid').datagrid('getSelected');
            console.log(r);
            if (r) {
                autoSetValue('pmconId', r.conId);
                autoSetValue('pmconName', r.conName);

                if ($("#PmPmconAccount").length > 0) {
                    autoSetValue("pmconMoney", r.conMoney);  // 带入合同金额
                    autoSetValue("projectId", r.fmproId);
                    autoSetValue("projectId_TEXT_", r.fmproIdText);

                    autoSetValue("partyAName", r.pmPaymentUnitText);
                    autoSetValue("partyBName", r.pmConstructUnitText);
                }
                // 工程竣交工收页面 PmPmconAccept
                if ($("#PmPmconAccept").length > 0) {

                    autoSetValue("projectId", r.fmproId);
                    autoSetValue("projectId_TEXT_", r.fmproIdText);

                    autoSetValue("addr", r.addr);
                    autoSetValue("constructUnit", r.constructUnit);
                    autoSetValue("constructUnit_TEXT_", r.constructUnitText);
                    autoSetValue("builderUnit", r.pmPreconstructUnitP);//代建单位
                    autoSetValue("projectMgr", r.projectMgr);
                    autoSetValue("projectMgr_TEXT_", r.projectMgrText);

                    autoSetValue("controlUnit", r.pmPreconstructUnitP);

                    autoSetValue("startDate", r.planStartDate);
                    autoSetValue("completeDate", r.planEndDate);


                }
                // 专项工程验收页面 PmSpecialAccept
                if ($("#PmSpecialAccept").length > 0) {

                    autoSetValue("projectId", r.fmproId);
                    autoSetValue("projectId_TEXT_", r.fmproIdText);
                    autoSetValue("buildingName", r.fmproIdText);

                    autoSetValue("addr", r.addr);
                    autoSetValue("constructUnit", r.constructUnit);
                    autoSetValue("constructUnit_TEXT_", r.constructUnitText);

                    autoSetValue("builderUnit", r.constructUnit);//施工单位
                    autoSetValue("builderUnit_TEXT_", r.constructUnitText);

                    autoSetValue("controlUnit", r.pmPreconstructUnitP);//监理单位


                }
                // 施工组织设计页面 PmDesignOrg
                if ($("#PmDesignOrg").length > 0) {
                    autoSetValue("constructUnit", r.constructUnit);
                    autoSetValue("constructUnit_TEXT_", r.constructUnitText);

                    autoSetValue("doUnit", r.contactOrgId);//乙方
                    autoSetValue("doUnit_TEXT_", r.contactOrgName);

                }
                // 设计变更 页面 PmPmconProve
                if ($("#PmPmconProve").length > 0) {
                    autoSetValue("projectId", r.fmproId);
                    autoSetValue("projectName", r.fmproIdText);
                    autoSetValue("pmconMoney", r.conMoney);

                    autoSetValue("constructUnit", r.constructUnit);
                    autoSetValue("constructUnit_TEXT_", r.constructUnitText);
                    autoSetValue("pmPreconstructUnit", r.pmPreconstructUnitP);

                }
                //开工管理 页面 PmProjectStart
                if ($("#PmProjectStart").length > 0) {
                    autoSetValue("projectId", r.fmproId);
                    autoSetValue("projectId_TEXT_", r.fmproIdText);

                    autoSetValue("constructUnit", r.constructUnit);
                    autoSetValue("constructUnit_TEXT_", r.constructUnitText);

                    autoSetValue("projectManager", r.projectMgr);
                    autoSetValue("projectManager_TEXT_", r.projectMgrText);
                }
                //停工管理 页面 PmProjectStop
                if ($("#PmProjectStop").length > 0) {
                    autoSetValue("projectId", r.fmproId);
                    autoSetValue("projectId_TEXT_", r.fmproIdText);

                    autoSetValue("constructUnit", r.constructUnit);
                    autoSetValue("constructUnit_TEXT_", r.constructUnitText);
                }
                //复工管理 页面 PmProjectRestart
                if ($("#PmProjectRestart").length > 0) {
                    autoSetValue("projectId", r.fmproId);
                    autoSetValue("projectId_TEXT_", r.fmproIdText);

                    autoSetValue("constructUnit", r.constructUnit);
                    autoSetValue("constructUnit_TEXT_", r.constructUnitText);
                }
                //工程变更 页面 PmEngineeringChange
                if ($("#PmEngineeringChange").length > 0) {

                    autoSetValue("contractUnit", r.constructUnit);
                    autoSetValue("contractUnit_TEXT_", r.constructUnitText);
                }

                return true;
            } else {
                alertInfo("请选择工程合同");
                return false;
            }
        }
    })
}


//工程变更页面合同选择,可按本人和本部门过滤
function showPmPmconSelectByAlter() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择合同",
        contenturl: '/view/business/pm/PmPmconSelectByAlter',
        width: 800,
        height: 460,
        okhandler: function () {
            var r = $('#PmPmcon_datagrid').datagrid('getSelected');
            if (r) {
                $("#" + inputobj.inputId).textbox("setValue", r.pmconId);
                $("#" + inputobj.inputId).textbox("setText", r.pmconName);
                autoSetValue("conMoney", r.pmconMoney);
                autoSetValue("pmconMoney", r.pmconMoney);
                autoSetValue("reserveMoney", r.reserveMoney);
                autoSetValue("projectId", r.projectId);
                autoSetValue("projectName", r.projectName);
                autoSetValue("contractUnit", r.partyB);
                autoSetValue("contractUnit_TEXT_", r.partyBName);
                autoSetValue("conAlterdMoney", r.totalMoneyCon = '' ? 0 : r.totalMoneyCon);
                autoSetValue("projectAlterdMoney", r.totalMoneyProject = '' ? 0 : r.totalMoneyProject);
                autoSetValue("conAlterMoney", r.totalMoneyCon = '' ? 0 : r.totalMoneyCon);
                autoSetValue("alterRatio", (r.totalMoneyCon = '' ? 0 : r.totalMoneyCon) * 100 / r.pmconMoney);
                autoSetValue("projectAlterMoney", r.totalMoneyProject = '' ? 0 : r.totalMoneyProject);
                $.ajax({
                    url: ctx + "/PmPmcon/findSupervisionUnit",
                    type: "POST",
                    data: {
                        id: r.projectId
                    },
                    success: function (result) {
                        console.info(result);
                        if (result.success) {
                            autoSetValue("controlUnit", result.o.partyB);
                            autoSetValue("controlUnit_TEXT_", result.o.partyBName);
                        } else {
                        }

                    },
                    dataType: "json"
                })
                return true;
            } else {
                alertInfo("请选择一条合同");
                return false;
            }
        }
    })
}

/**
 * 20211122 相关表逻辑改了。暂时不用
 * 项目建设合同公共弹出窗口 默认查询本人负责项目 可以切换部门合同 type 施工合同-SGHT 勘察设计-KCSJHT 监理合同-JLHT
 * 检测合同-JCHT YKGHT-已开工合同
 *
 */
function showPmConWinCommonWithType(type) {
    return function () {
        showPmConWinCommon(type, this);
    }
}

function showPmConWinCommon(type, that) {
    var inputobj = formatterInputobj(that);
    type = type || "";
    openChooseDialog({
        title: "选择合同",
        contenturl: '/view/business/pm/PmPmconSelectCommon?pmconTypeCode=' + type,
        width: 800,
        height: 460,
        okhandler: function () {
            var r = $('#PmPmcon_datagrid').datagrid('getSelected');
            if (r) {
                // 工程竣工决算
                autoSetValue("pmconMoney", r.pmconMoney);
                if ($("#PmPmconAccount").length > 0) {
                    if (r.isAudit == 'N') {
                        alertError("该合同不需要进行竣工结算");
                        return false;
                    }
                    // 80，84为总包和施工的类型ID，查询该合同是否竣工验收过，验收过大于
                    if ((r.pmcon_type_id == 80 || r.pmcon_type_id == 84) && r.nums == 0) {
                        alertError("合同是施工或总包时,做完竣工验收才能做竣工决算");
                        return false;
                    }

                    autoSetValue("paidMoney", r.totalPayment);// 已支付金额，通过合同ID和项目Id查自于v_fm_fiscal_pool视图
                    autoSetValue("reserveMoney", r.reserveMoney);
                    autoSetValue("pmconMoney", r.pmconMoney);
                    autoSetValue("builderUnit", r.partyB);
                    autoSetValue("builderUnit_TEXT_", r.partyBName);
                    // 刷新阶段附件面板-待实现
                    $('.stageTypeFile').panel(
                        'refresh',
                        ctx + "/GenForm/reloadFileList?formcode="
                        + _currentFormCode + "&isdetail=false&stageId="
                        + stageId + "&projectId=" + r.projectId);
                }
                if ($("#PmRiskLawsuit").length > 0 || $("#PmRiskIndictedControl").length > 0) {
                    $("#" + inputobj.inputId).val(r.pmconId);
                    $("#" + inputobj.inputText).textbox("setText", r.pmconName);
                } else {
                    $("#" + inputobj.inputId).textbox("setValue", r.pmconId);
                    $("#" + inputobj.inputId).textbox("setText", r.pmconName);
                }
                autoSetValue("projectId", r.projectId);
                autoSetValue("projectId_TEXT_", r.projectName);
                autoSetValue("buildingName", r.pmconName);
                autoSetValue("contractUnit", r.partyB);
                autoSetValue("contractUnit_TEXT_", r.partyBName);
                autoSetValue("builderUnit", r.partyB);
                autoSetValue("builderUnit_TEXT_", r.partyBName);
                autoSetValue("buildUnit", r.partyB);
                autoSetValue("buildUnit_TEXT_", r.partyBName);
                if ($("#PmProjectDelay").length <= 0) {
                    autoSetValue("controlUnit", r.partyB);
                    autoSetValue("controlUnit_TEXT_", r.partyBName);
                }
                if ($("#PmProjectDelay").length > 0) {
                    autoSetValue("startDate", r.planStartDate);
                    autoSetValue("planComplete", r.planEndDate);
                    $.ajax({
                        url: ctx + "/PmPmcon/findSupervisionUnit",
                        type: "POST",
                        data: {
                            id: r.projectId
                        },
                        success: function (result) {
                            console.info(result);
                            if (result.success) {
                                autoSetValue("controlUnit", result.o.partyB);
                                autoSetValue("controlUnit_TEXT_", result.o.partyBName);
                            } else {
                            }

                        },
                        dataType: "json"
                    })
                }
                autoSetValue("projectInvest", r.pmconMoney);
                // 分项工程验收
                if ($("#PmProjectQualityCheck").length > 0) {
                    autoSetValue("builderUnit", r.partyB);// 施工单位
                    autoSetValue("builderUnit_TEXT_", r.partyBName);
                }
                // 专项施工方案
                if ($('#PmWorkingScheme').length > 0) {
                    //changeCSS($('#wbsId'),"remove","combotree");
                    autoSetValue("builderUnit", r.partyB);
                    autoSetValue("builderUnit_TEXT_", r.partyBName);
                    autoSetValue("builderLeader", r.projectMgrName);
                    //$('#wbsId').combobox('clear');
                    //$('#wbsId').combobox('reload',ctx+'/PmBigengd/getPmBigengdByPmconIdAndProjectId?pmconId='+r.pmconId+"&projectId="+r.projectId);
                }
                // 施工许可证
                if ($("#PmBuilderPermit").length > 0) {
                    var id = that.id;
                    if ("designPmconId" == id) {
                        $("#designUnit").val(r.partyB);
                        $("#designUnit_TEXT_").textbox('setValue', r.partyBName);
                    }
                    if ("surveyPmconId" == id) {
                        $("#surveyUnit").val(r.partyB);
                        $("#surveyUnit_TEXT_").textbox('setValue', r.partyBName);
                    }
                    if ("supervisePmconId" == id) {
                        $("#superviseUnit").val(r.partyB);
                        $("#superviseUnit_TEXT_").textbox('setValue', r.partyBName);
                    }
                    if ("checkPmconId" == id) {
                        $("#checkUnit").val(r.partyB);
                        $("#checkUnit_TEXT_").textbox('setValue', r.partyBName);
                    }
                }

                // 施工组织设计
                if ($('#PmDesignOrg').length > 0) {
                    $('#constructUnit').val(r.partyB);
                    $('#constructUnit_TEXT_').textbox('setValue', r.partyBName);
                }
                // 项目开工 停工 复工
                if ($('#PmProjectStart').length > 0 || $('#PmProjectStop').length > 0 || $('#PmProjectRestart').length > 0) {
                    $('#constructUnit').val(r.partyB);
                    $('#constructUnit_TEXT_').textbox('setValue', r.partyBName);
                    $('#projectRestartId').val(r.projectRestartId);
                    $('#projectStopId').val(r.projectStopId);
                    $('#projectStartId').val(r.projectStartId);
                    $.ajax({
                        url: ctx + "/PmPmcon/findSupervisionUnit",
                        type: "POST",
                        data: {
                            id: r.projectId
                        },
                        success: function (result) {
                            console.info(result);
                            if (result.success) {
                                autoSetValue("supervisionUnit", result.o.partyB);
                                autoSetValue("supervisionUnit_TEXT_", result.o.partyBName);
                            } else {
                            }

                        },
                        dataType: "json"
                    })
                }
                // 检验批质量验收
                if ($('#PmInspectionAccept').length > 0) {
                    autoSetValue("constructUnit", r.partyA);
                    autoSetValue("constructUnit_TEXT_", r.partyAName);
                    autoSetValue("builderUnit", r.partyB);
                    autoSetValue("builderUnit_TEXT_", r.partyBName);
                }
                // 专项验收备案
                if ($('#PmSpecialAccept').length > 0) {
                    autoSetValue("constructUnit", r.partyA);
                    autoSetValue("constructUnit_TEXT_", r.partyAName);
                    autoSetValue("builderUnit", r.partyB);
                    autoSetValue("builderUnit_TEXT_", r.partyBName);
                }

                // 三方巡查管理 被巡察单位
                if ($('#PmSafeInspectSFXC').length > 0) {
                    autoSetValue("inspectedUnit", r.partyB);
                    autoSetValue("inspectedUnit_TEXT_", r.partyBName);
                    $.ajax({
                        url: ctx + "/PmProjectStart/findPmProjectStartBypmconIdAndProjectId",
                        type: "POST",
                        data: {
                            "pmconId": r.pmconId,
                            "projectId": r.projectId
                        },
                        success: function (result) {
                            console.info(result);
                            if (result.success) {
                                autoSetValue("controlUnit", result.o.superviseUnit);
                            } else {
                                alertError(result.msg);
                            }

                        },
                        dataType: "json"
                    })
                }

                // 工程移交
                if ($("#PmPmconTransfer").length > 0) {
                    autoSetValue("transferUnit", r.paymentUnit1);
                    autoSetValue("acceptUnit", r.constructUnit);
                    autoSetValue("acceptUnit_TEXT_", r.constructUnitText);

                    autoSetValue("PROJECT_MGR", r.projectMgr);
                    autoSetValue("projectMgrText", r.projectMgrName);
                }

                // 项目业主检查
                if ($("#PmSafeInspectXC").length > 0) {
                    $("#inspectedUnit").textbox('setValue', r.partyB);
                    $("#inspectedUnit").textbox('setText', r.partyBName);
                }

                // 开工管理
                if ($("#PmProjectStart").length > 0) {
                    autoSetValue("projectManager", r.projectMgr)
                    autoSetValue("projectManager_TEXT_", r.projectMgrName)
                    //$("#contactWay").textbox('setValue',r.contactTel);
                    //autoSetValue("startDate",r.planStartDate);
                    //autoSetValue("planEndDate",r.planEndDate);
                }
                if ($("#PmPmconProveQzqs").length > 0) {
                    autoSetValue("fundSource", r.fundSource);
                }
                return true;
            } else {
                alertInfo("请选择一条合同");
                return false;
            }
        }
    })
}


/**
 * @Description: 带队领导多选框 ----> 选择集团公司下的公司领导
 * @Param
 * @author houChen
 * @date 2020/3/19 14:32
 * @blog https://www.cnblogs.com/houchen/
 */
function showGroupLeaderWinFun() {
    var inputobj = formatterInputobj(this);
    var contenturl = '/view/sys/groupLeaderMulSelectWin';
    // 修改--获取人员id 和 name
    var names = $('#' + inputobj.inputText).val();
    var ids = $('#' + inputobj.inputId).val();

    openChooseDialog({
        title: "选择集团领导",
        contenturl: contenturl,
        width: 800,
        height: 450,

        okhandler: function () {
            var rows = $('#choosegrid').datagrid('getRows');
            if (rows) {
                var conids = [];
                var connames = [];
                for (var i = 0; i < rows.length; i++) {
                    conids.push(rows[i].ACCOUNT_ID);
                    connames.push(rows[i].ACCOUNT_NAME);
                }
                $('#' + inputobj.inputId).val(conids);
                $('#' + inputobj.inputText).textbox('setValue', connames);
                return true;
            } else {
                alertInfo("请选择领导");
                return false;
            }
        },
        onload: function () {
            if (names != null && names != "") {
                var namesArray = names.split(',');
                var idsArray = ids.split(',');
                for (var i = 0; i < namesArray.length; i++) {
                    $('#choosegrid').datagrid('appendRow', {
                        accountId: idsArray[i],
                        accountName: namesArray[i]
                    })
                }
            }
        }
    })
}


/** ********************** 往来单位弹窗 多选（左右移动）***************** */
function showContactOrgWinFun_Mul(projectId) {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "选择往来单位",
        contenturl: '/view/sys/contactOrgMulSelectWin?projectId=' + projectId,
        width: 800,
        height: 450,
        okhandler: function () {
            var rows = $('#rightGrid').datagrid('getRows');
            if (rows && rows.length > 0) {
                var conids = [];
                var connames = [];
                for (var i = 0; i < rows.length; i++) {
                    conids.push(rows[i].contactOrgId);
                    connames.push(rows[i].contactOrgName);
                }
                autoSetValue('' + inputobj.inputId, conids.join(","));
                autoSetValue('' + inputobj.inputText, connames.join(","));
                return true;
            } else {
                alertInfo("请选择单位");
                return false;
            }
        }
    })
}

/** 项目进度计划 **/
function showPmMilepostPlanWin() {
    openChooseDialog({
        title: "项目进度计划选择",
        contenturl: '/view/business/pm/PmMilepostPlanWin',
        width: 600,
        height: 450,
        okhandler: function () {
            var r = $('#PmMilepostPlanWin_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue('planId', r.milepostPlanId);
                autoSetValue('planName', r.projectIdText);
                autoSetValue('projectId', r.projectId);
                autoSetValue('projectName', r.projectIdText);
                autoSetValue('pmconId', r.pmconId);
                autoSetValue('makeUnit', r.makeUnit);
                autoSetValue('makePerson', r.makePerson);
                autoSetValue('makePersonText', r.makePersonText);
                autoSetValue('makeDate', r.makeDate);
                autoSetValue('remark', r.remark);


                return true;
            } else {
                alertInfo("请选择项目进度计划");
                return false;
            }
        }
    })
}


// 单体审计申请页面的合同选择框
function showPmConWinFunInPmconAccount() {
    openChooseDialog({
        title: "选择合同",
        contenturl: '/view/business/pm/PmPmconSelectWinInPmconAccount',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#PmPmcon_datagrid').datagrid('getSelected');
            console.info(r);
            if (r) {
                $("#pmconId").textbox("setValue", r.pmconId);
                $("#pmconId").textbox("setText", r.pmconName);
                autoSetValue("pmconMoney", r.pmconMoney);  // 带入合同金额
                autoSetValue("builderUnit", r.partyB);
                autoSetValue("builderUnit_TEXT_", r.partyBName);
                autoSetValue("projectId", r.projectId);
                autoSetValue("projectId_TEXT_", r.projectName);
                autoSetValue("pmconTypeName", r.pmconTypeName);
                autoSetValue("partyAName", r.partyAName);
                autoSetValue("partyBName", r.partyBName);

                // 选择合同时 将该合同的合同项目分摊加入单体审计的字表
                // 切换合同时删除所有字表
                /*  delAllData();
                  $.ajax({
                      url: ctx+"/PmPmconProject/getPmPmconProjectByPmconId",
                      data:{
                          pmconId:r.pmconId
                      },
                      dataType:"json",
                      success:function(result){
                          if(result.success){
                              if(result.o.length>0){
                                  for(var i=0;i<result.o.length;i++){
                                      addFun(result.o[i]);
                                  }
                              }
                          }else{
                              alertInfo(result.o);
                          }
                      }
                  })*/
                return true;
            } else {
                alertInfo("请选择合同");
                return false;
            }
        }
    })
}


/**
 * 工程结算申请选择弹窗
 */
function showPmPmconAccount() {
    var inputobj = formatterInputobj(this);
    openChooseDialog({
        title: "工程结算申请信息",
        contenturl: '/view/business/pm/PmPmconAccountWin',
        width: 600,
        height: 450,
        okhandler: function () {
            // $("#pmPmconAccountBackupList_datagrid")
            var r = $('#pmPmconAccountSelectWin_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue("pmconAccountId", r.pmconAccountId);
                autoSetValue("applyNo", r.accountNo);
                autoSetValue("pmconIdText", r.pmconIdText);
                autoSetValue("pmconId", r.pmconId);
                autoSetValue("buildingName", r.projectName);
                autoSetValue("reportMoney", r.reportMoney);
                autoSetValue("pmconMoney", r.pmconMoney);
                return true;
            } else {
                alertInfo("请选择工程结算申请信息");
                return false;
            }
        }
    })
}

function firstLawsuitIdselect1() {
    openChooseDialog({
        title: "请选择",
        contenturl: '/view/business/pm/PmRiskLawsuitFirstRecord?ltype=2',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#PmRiskLawsuitRecord_datagrid').datagrid('getSelected');
            if (r) {

                $("#firstLawsuitId").textbox('setValue', r.riskLawsuitId);
                $("#firstLawsuitId").textbox('setText', r.lawsuitTitle);
                autoSetValue('lawsuitTitle', r.lawsuitTitle);
//	            autoSetValue('lawsuitNo',r.lawsuitNo);
//	            autoSetValue('lawsuitNum',r.lawsuitNum);
                $("#initiateDept").combobox('setValue', r.initiateDept);
                $("#initiateDept").combobox('setText', r.initiateDeptName);
                //autoSetValue('initiateDept',r.initiateDept);
                //autoSetValue('initiateDeptName',r.initiateDeptName);
                autoSetValue('operators', r.operators);
                autoSetValue('operators_TEXT_', r.operatorsName);
                autoSetValue('applyDate', r.applyDate);
                autoSetValue('lawSubject', r.lawSubject);
                autoSetValue('caseMoney', r.caseMoney);
                autoSetValue('courtJudge', r.courtJudge);
                autoSetValue('dispute', r.dispute);
                autoSetValue('caseDeal', r.caseDeal);
                autoSetValue('remark', r.remark);
                $.ajax({
                    url: ctx + "/PmRiskLawsuit/getLawSuitCorp",
                    data: {
                        id: r.riskLawsuitId
                    },
                    dataType: 'json',
                    success: function (result) {
                        console.log(result)
                        if (result) {
                            for (var i = 0; i < result.length; i++) {
                                adddataRowCropSelectCorp(result[i]);
                            }
                        }
                    }
                });

                $.ajax({
                    url: ctx + "/PmRiskLawsuit/getLawSuitProject",
                    data: {
                        id: r.riskLawsuitId
                    },
                    dataType: 'json',
                    success: function (result) {
                        console.log(result)
                        if (result) {
                            for (var i = 0; i < result.length; i++) {
                                adddataRowProjec2(result[i]);
                            }
                        }
                    }
                });
                //appendData(r.riskLawsuitId);
                //$("#courtId").textbox("setValue",r.courtId);
                //$("#courtId").textbox("setText",r.courtName);
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }
    })
}

function firstLawsuitIdselect2() {
    openChooseDialog({
        title: "请选择",
        contenturl: '/view/business/pm/PmRiskLawsuitFirstRecord?ltype=1',
        width: 750,
        height: 450,
        okhandler: function () {
            var r = $('#PmRiskLawsuitRecord_datagrid').datagrid('getSelected');
            if (r) {
                $("#firstLawsuitId").textbox('setValue', r.riskLawsuitId);
                $("#firstLawsuitId").textbox('setText', r.lawsuitTitle);
                autoSetValue('lawsuitTitle', r.lawsuitTitle);
//                autoSetValue('lawsuitNo',r.lawsuitNo);
//                autoSetValue('lawsuitNum',r.lawsuitNum);
                autoSetValue('initiateDept', r.initiateDept);
                autoSetValue('initiateDeptName', r.initiateDeptName);
                autoSetValue('operators', r.operators);
                autoSetValue('operators_TEXT_', r.operatorsName);
                autoSetValue('applyDate', r.applyDate);
                autoSetValue('lawSubject', r.lawSubject);
                autoSetValue('caseMoney', r.caseMoney);
                autoSetValue('courtJudge', r.courtJudge);
                autoSetValue('dispute', r.dispute);
                autoSetValue('caseDeal', r.caseDeal);
                autoSetValue('remark', r.remark);

//                appendData(r.riskLawsuitId);
//                alert(2)
                $.ajax({
                    url: ctx + "/PmRiskLawsuit/getLawSuitCorp",
                    data: {
                        id: r.riskLawsuitId
                    },
                    dataType: 'json',
                    success: function (result) {
                        console.log(result)
                        if (result) {
                            for (var i = 0; i < result.length; i++) {
                                adddataRowCropSelectCorp(result[i]);
                            }
                        }
                    }
                });

                $.ajax({
                    url: ctx + "/PmRiskLawsuit/getLawSuitProject",
                    data: {
                        id: r.riskLawsuitId
                    },
                    dataType: 'json',
                    success: function (result) {
                        console.log(result)
                        if (result) {
                            for (var i = 0; i < result.length; i++) {
                                adddataRowProjec2(result[i]);
                            }
                        }
                    }
                });

//                $("#firstLawsuitId").textbox('setValue', r.riskLawsuitId);
//              $("#firstLawsuitId").textbox('setText', r.lawsuitTitle);
//              autoSetValue('lawsuitTitle',r.lawsuitTitle);
//              autoSetValue('lawsuitNo',r.lawsuitNo);
//              autoSetValue('lawsuitNum',r.lawsuitNum);
//              autoSetValue('initiateDept',r.initiateDept);
//              autoSetValue('operators',r.operators);
//              autoSetValue('applyDate',r.applyDate);
//              autoSetValue('lawSubject',r.lawSubject);
//              autoSetValue('caseMoney',r.caseMoney);
//              autoSetValue('courtJudge',r.courtJudge);
//              autoSetValue('dispute',r.dispute);
//              autoSetValue('caseDeal',r.caseDeal);
//              autoSetValue('remark',r.remark);
//              $("#courtId").textbox("setValue",r.courtId);
//	    		$("#courtId").textbox("setText",r.courtName);
                return true;
            } else {
                alertInfo("请选择一条数据");
                return false;
            }
        }
    })
}


/** **********************项目立项弹出框********************* */
function showPmProjectBuild(tableName) {
    return function () {
        showPmProjectBuild2(tableName);
    }
}

function showPmProjectBuild2(tableName) {
    openChooseDialog({
        title: "项目立项信息",
        contenturl: '/view/business/pm/PmProjectBuildWin?tableName=' + tableName,
        width: 600,
        height: 450,
        okhandler: function () {
            var r = $('#PmProjectBuildWin_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue("projectBuildId", r.projectBuildId);
                autoSetValue("projectBuildName", r.projectName);
                return true;
            } else {
                alertInfo("请选择项目立项信息");
                return false;
            }
        }
    })
}

function showGenFormWin() {
    openChooseDialog({
        title: "表单信息",
        contenturl: '/view/gen/GenFormWin',
        width: 600,
        height: 450,
        okhandler: function () {
            var r = $('#GenFormWin_datagrid').datagrid('getSelected');
            if (r) {
                autoSetValue("fCode_TEXT_", r.FORM_NAME);
                autoSetValue("fCode", r.FORM_CODE);
                return true;
            } else {
                alertInfo("请选择表单信息");
                return false;
            }
        }
    })
}

function showGenFormWins() {
    openChooseDialog({
        title: "表单信息",
        contenturl: '/view/gen/GenFormWins',
        width: 600,
        height: 450,
        okhandler: function () {
            var r = $('#GenFormWin_datagrid').datagrid('getSelections');
            if (r.length > 0) {
                var rLength = r.length;
                var fCodeNames = [];
                var fCodes = [];
                // debugger
                for (let i = 0; i < rLength; i++) {
                    fCodeNames.push(r[i].FORM_NAME);
                    fCodes.push(r[i].FORM_CODE);

                }
                autoSetValue("documentsCode_TEXT_", fCodeNames.join(','));
                autoSetValue("documentsCode", fCodes.join(','));
                return true;
            } else {
                alertInfo("请选择表单信息");
                return false;
            }
        }
    })
}

/**
 * 滨投的
 * 项目建设合同公共弹出窗口 只查询本人负责的项目 对应的合同 type 施工合同-SGHT 勘察设计-KCSJHT 监理合同-JLHT 检测合同-JCHT
 * isAudit: Y 过滤出需要审计的合同 N 过滤出不需要审计的合同 null 不对是否审计进行过滤
 *
 */
function showPmConWinCommonWithTypeAndme(type, isAudit) {
    return function () {
        showPmConWinCommonForme(type, isAudit, this);
    }
}

function showPmConWinCommonForme(type, isAudit, that) {
    var inputobj = formatterInputobj(that);
    isAudit = isAudit || "";
    type = type || "";
    openChooseDialog({
        title: "选择合同",
        contenturl: '/view/business/pm/PmPmconSelectCommonForme?pmconTypeCode=' + type + "&isAudit=" + isAudit,
        width: 800,
        height: 460,
        okhandler: function () {
            var r = $('#PmPmcon_datagrid').datagrid('getSelected');
            if (r) {
                $("#" + inputobj.inputId).textbox("setValue", r.pmconId);
                $("#" + inputobj.inputId).textbox("setText", r.pmconName);
                autoSetValue("projectId", r.projectId);
                autoSetValue("projectId_TEXT_", r.projectName);
                autoSetValue("buildingName", r.pmconName);
                autoSetValue("contractUnit", r.partyB);
                autoSetValue("contractUnit_TEXT_", r.partyBName);
                autoSetValue("constructUnit", r.partyA);
                autoSetValue("constructUnit_TEXT_", r.partyAName);
                autoSetValue("builderUnit", r.partyB);
                autoSetValue("builderUnit_TEXT_", r.partyBName);
                autoSetValue("buildUnit", r.partyB);
                autoSetValue("buildUnit_TEXT_", r.partyBName);
                autoSetValue("startDate", r.startDate);
                // autoSetValue("controlUnit",r.partyB);
                // autoSetValue("controlUnit_TEXT_",r.partyBName);


                // 工程竣工验收页面 PmPmconAccept
                if ($("#PmPmconAccept").length > 0) {
                    // 工程地点
                    autoSetValue("addr", r.addr);
                    // 建设单位
                    autoSetValue("contractUnit", r.contractUnit);
                    autoSetValue("contractUnit_TEXT_", r.contractUnitText);
                    // 项目开工 规划许可证号 施工许可证号
                    $.ajax({
                        url: ctx + "/PmProjectStart/findPmProjectStartBypmconIdAndProjectId",
                        type: "POST",
                        data: {
                            "pmconId": r.pmconId,
                            "projectId": r.projectId
                        },
                        success: function (result) {
                            console.info(result);
                            if (result.success) {
                                // 建设工程规划许可证
                                autoSetValue("buildingPermitNo", result.o.gongchengNo);
                                // 施工许可证 监理单位 设计单位
                                autoSetValue("builderPermitNo", result.o.shigongNo);
                                autoSetValue("controlUnit", result.o.partyControl);
                                autoSetValue("surveyUnit", result.o.partySurvey);
                                autoSetValue("controlUnitName", result.o.partyControlName);
                                autoSetValue("surveyUnitName", result.o.partySurveyName);
                                autoSetValue("designUnit", result.o.designUnit);

                            } else {
                                alertError(result.msg);
                            }

                        },
                        dataType: "json"
                    })
                    autoSetValue("buildUnit", r.partyB);

                }

                return true;
            } else {
                alertInfo("请选择一条合同");
                return false;
            }
        }
    })
}

// 自动带出供应商信息
function autoSetPayInfoAboutSupplierByContract(contactOrgName, contactOrgId) {
    // 非项目资金拨付单
    if ($("#FmExpenseReimburseAppropriation").length > 0) {
        addCashierRowAutoInsert(contactOrgName, contactOrgId);
    }
}

/***
 * 自动增加支付信息
 *
 * 1、传入值：供应商名称、供应商id
 * 2、影响值：增加新的一行
 */
function addCashierRowAutoInsert(contactOrgName, contactOrgId) {
    var workflowStatus = '<%=request.getParameter("workflowStatus")%>';
    var sql = "";
    var unitType = "";
    if ("GmAssetsReceiveOutWG_LS" == code) {
        unitType = "4";
    }
    // 状态判断
    if (workflowStatus == 77) {
        sql = '<tr id="trcashier' + cashier_index + '" class="repList2">'
            + '<td class="repList"  align="center"><a class="easyui-linkbutton" data-options="iconCls:\'icon-del iconfont red2\',plain:true" onclick="delcashier(' + cashier_index + ')"></a></td>'
            + '<td class="repList disableinput" style="text-align:center;width:110px;"><input readonly="true" class="easyui-combobox" style="width:90%;" data-options="panelHeight:\'auto\',url:getLoanMethodUrl(' + cashier_index + ')" name="cashierList[' + cashier_index + '].paymentType"  id="paymentType' + cashier_index + '"></td>';
        if ("GmAssetsReceiveOutWG_LS" != code) {
            sql += '<td class="repList" style="text-align:center;width:110px;"><input class="easyui-textbox" style="width:90%;" data-options="required:true,validType:\'maxLength[128]\',editable:false,buttonText:\'选择\',onClickButton:findPayeeWin() " name="cashierList[' + cashier_index + '].payeeUnitText"  id="payeeUnitText' + cashier_index + '" value="' + contactOrgName + '"></td>';
        }
        sql += '<td class="repList disableinput" style="text-align:center;width:110px;"><input readonly="true" class="easyui-textbox" style="width:90%;" data-options="editable:false,validType:\'maxLength[128]\',buttonText:\'选择\',onClickButton:findAccountDataById" name="cashierList[' + cashier_index + '].payeeBank"  id="payeeBank' + cashier_index + '"></td>'
            + '<td class="repList disableinput" style="text-align:center;width:110px;"><input readonly="true" class="easyui-textbox" style="width:90%;" data-options="editable:false,validType:\'maxLength[64]\'" name="cashierList[' + cashier_index + '].payeeAccount"  id="payeeAccount' + cashier_index + '"></td>'
            + '<td class="repList disableinput" style="text-align:center;width:110px;"><input readonly="true" class="easyui-numberbox" style="width:90%;" data-options="required:true,groupSeparator:\',\',precision:2,validType:\'maxLength[18]\',onChange:payeeMoneyChangeEvent" name="cashierList[' + cashier_index + '].payeeMoney"  id="payeeMoney' + cashier_index + '"></td>'
            + '<td class="repList" style="text-align:center;width:110px;"><input class="easyui-textbox" style="width:90%;" data-options="validType:\'maxLength[1024]\'" name="cashierList[' + cashier_index + '].memo"  id="memo' + cashier_index + '"></td>'
            + '<input type="hidden" name="cashierList[' + cashier_index + '].detailDetailid" id="detailDetailid' + cashier_index + '" />'
            + '<input type="hidden" name="cashierList[' + cashier_index + '].payeeType" id="payeeType' + cashier_index + '"  value="' + unitType + '"/>'
            + '<input type="hidden" name="cashierList[' + cashier_index + '].bizMainId" id="bizMainId' + cashier_index + '" />'
            + '<input type="hidden" name="cashierList[' + cashier_index + '].payeeUnit" id="payeeUnit' + cashier_index + '" value="' + contactOrgId + '"/>'
            + '<input type="hidden" name="cashierList[' + cashier_index + '].formCode" id="formCode' + cashier_index + '" />'
            + '<input type="hidden" name="cashierList[' + cashier_index + '].isUse" id="isUse' + cashier_index + '" />'
            + '<input type="hidden" name="cashierList[' + cashier_index + '].payTotalId" id="payTotalId' + cashier_index + '" />'
            + '</tr>';
    } else {
        sql = '<tr id="trcashier' + cashier_index + '" class="repList2">'
            + '<td class="repList"  align="center"><a class="easyui-linkbutton" data-options="iconCls:\'icon-del iconfont red2\',plain:true" onclick="delcashier(' + cashier_index + ')"></a></td>'
            + '<td class="repList" style="text-align:center;width:110px;"><input class="easyui-combobox" style="width:90%;" data-options="required:true,panelHeight:\'auto\',url:getLoanMethodUrl(' + cashier_index + '),onChange:paymentTypeChange" name="cashierList[' + cashier_index + '].paymentType"  id="paymentType' + cashier_index + '"></td>';
        if ("GmAssetsReceiveOutWG_LS" != code) {
            sql += '<td class="repList" style="text-align:center;width:110px;"><input class="easyui-textbox" style="width:90%;" data-options="required:true,validType:\'maxLength[128]\',editable:false,buttonText:\'选择\',onClickButton:findPayeeWin() " name="cashierList[' + cashier_index + '].payeeUnitText"  id="payeeUnitText' + cashier_index + '" value="' + contactOrgName + '"></td>';
        }
        sql += '<td class="repList" style="text-align:center;width:110px;"><input  class="easyui-textbox" style="width:90%;" data-options="editable:false,validType:\'maxLength[128]\',buttonText:\'选择\',onClickButton:findAccountDataById" name="cashierList[' + cashier_index + '].payeeBank"  id="payeeBank' + cashier_index + '"></td>'
            + '<td class="repList" style="text-align:center;width:110px;"><input  class="easyui-textbox" style="width:90%;" data-options="editable:false,validType:\'maxLength[64]\'" name="cashierList[' + cashier_index + '].payeeAccount"  id="payeeAccount' + cashier_index + '"></td>'
            + '<td class="repList" style="text-align:center;width:110px;"><input class="easyui-numberbox" style="width:90%;" data-options="required:true,groupSeparator:\',\',precision:2,validType:\'maxLength[18]\',onChange:payeeMoneyChangeEvent" name="cashierList[' + cashier_index + '].payeeMoney"  id="payeeMoney' + cashier_index + '"></td>'
            + '<td class="repList" style="text-align:center;width:110px;"><input class="easyui-textbox" style="width:90%;" data-options="validType:\'maxLength[1024]\'" name="cashierList[' + cashier_index + '].memo"  id="memo' + cashier_index + '"></td>'
            + '<input type="hidden" name="cashierList[' + cashier_index + '].detailDetailid" id="detailDetailid' + cashier_index + '" />'
            + '<input type="hidden" name="cashierList[' + cashier_index + '].payeeType" id="payeeType' + cashier_index + '" value="' + unitType + '"/>'
            + '<input type="hidden" name="cashierList[' + cashier_index + '].bizMainId" id="bizMainId' + cashier_index + '" />'
            + '<input type="hidden" name="cashierList[' + cashier_index + '].payeeUnit" id="payeeUnit' + cashier_index + '" value="' + contactOrgId + '"/>'
            + '<input type="hidden" name="cashierList[' + cashier_index + '].formCode" id="formCode' + cashier_index + '" />'
            + '<input type="hidden" name="cashierList[' + cashier_index + '].isUse" id="isUse' + cashier_index + '" />'
            + '<input type="hidden" name="cashierList[' + cashier_index + '].payTotalId" id="payTotalId' + cashier_index + '" />'
            + '</tr>';
        $("#cashierList_datagrid").append(sql);
    }
    $.parser.parse($("#trcashier" + cashier_index));
    // 设置弹窗等
    setPayeeBankWinMethod(cashier_index);
    // 赋值银行账号信息
    findAccountDataByContractOrgId(contactOrgId, cashier_index);
    cashier_index++;
}

// 计算两个日期之间的月数，不足一月按一月算
function MonthsBetweenSE(sDate, eDate) {
    var months = 0;
    var day = parseInt(eDate.split("-")[2].replace(/^0+/, "")) - parseInt(sDate.split("-")[2].replace(/^0+/, ""));
    if (day >= 0) {
        months += 1;
    }

    var month = parseInt(eDate.split("-")[1].replace(/^0+/, "")) - parseInt(sDate.split("-")[1].replace(/^0+/, ""));
    months += month;

    var year = (parseInt(eDate.split("-")[0].replace(/^0+/, "")) - parseInt(sDate.split("-")[0].replace(/^0+/, ""))) * 12;
    months += year;
    return months;
}

/***
 * 设置银行弹窗方法
 *
 */
function setPayeeBankWinMethod(index) {
    if ($('#cashierDetailList').length > 0
        || $('#cashierXCList').length > 0
        || $('#cashierSFList').length > 0
        || $('#cashierHTList').length > 0
        || $('#cashierCLList').length > 0
        || $('#cashierList_GH').length > 0
        || $('#cashierCLList_GH').length > 0) {
        // 设置payeeType 为 1
        autoSetValue('payeeType' + index, '1');
        // 设置payeeBank弹出框方法
        $('#payeeBank' + index).textbox({
            buttonText: '选择',
            editable: true,
            required: false,
            onClickButton: showAccountDataByContractOrgId,
        });
        // 清空银行信息
        $('#payeeAccount' + index).textbox('setValue', '');
        $('#payeeBank' + index).textbox('setValue', '');
    }
}