var workgrid=$('#dw');
$(function(){
	workGrid();
});

function workGrid(){
	workgrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		queryParams: {
			empId:empId
		},
		toolbar:"#HrWorkLive_datagrid_tb",
	    url:ctx+'/HrWorkLive/pageHrWorkLive',
	    columns:[[
	    {field:'WORK_LIVE_ID',title:'工作履历ID',width:100,align:'center',halign:'center',hidden:true},
	    {field:'EMP_ID',title:'员工ID',width:100,align:'center',halign:'center',hidden:true},
	    {field:'START_TIME',title:'开始时间',width:125,align:'center',halign:'center',editor : {
			 type:'monthbox',
			 options:{required:true}
		},formatter:dateformatter},
	    {field:'END_TIME',title:'结束时间',width:125,align:'center',halign:'center',editor : {
	    	type:'monthbox'
		},formatter:function(value,row,index){
			if(!value){
				return '至今';
			}
			return dateformatter(value,row)
		}},
	    {field:'WORK_UNIT',title:'工作单位',width:125,align:'center',halign:'center',editor:{type:'textbox',options:{
	    	validType:'maxLength[100]'}}},
	    {field:'DEPT_NAME',title:'部门及职务',width:125,align:'center',halign:'center',editor:{type:'textbox',options:{
	    	validType:'maxLength[32]'}}},
	    {field:'MODIFY_ACCOUNT',title:'最后修改人',width:125,align:'center',halign:'center',hidden:true},
	    {field:'MODIFY_TIME',title:'最后修改时间',width:125,align:'center',halign:'center',hidden:true},
	    {field:'IS_USE',title:'是否使用',width:100,align:'center',halign:'center',hidden:true},
	    {field:'CERTIFIER',title:'证明人',width:125,align:'center',halign:'center',editor:{type:'textbox',options:{
	    	validType:'maxLength[32]'}}},
	    {field:'TELEPHONE',title:'电话',width:125,align:'center',halign:'center',editor:{type:'textbox',options:{
	    	validType:'maxLength[32]'}}},
	    {field:'REMARK',title:'备注',width:125,align:'center',halign:'center',editor:{type:'textbox',options:{
	    	validType:'maxLength[100]'}}}
	    ]],
	    onClickRow : onClickRowwork
	});

}
//重新加载表格
function reloadGridwork(){
	workgrid.datagrid('reload');
}
var editIndexwork = undefined;
function endEditingwork (){
    if (editIndexwork == undefined){return true}
    if (workgrid.datagrid('validateRow', editIndexwork)){
    	workgrid.datagrid('endEdit', editIndexwork);
        editIndexwork = undefined;
        return true;
    } else {
        return false;
    } }

function onClickRowwork(index){
	if (editIndexwork != index){
		if (endEditingwork ()){
			workgrid.datagrid('selectRow', index)
					.datagrid('beginEdit', index);
			editIndexwork = index;
		} else {
			  setTimeout(function(){
				  workgrid.datagrid('selectRow', editIndex);
       },0);

		}
		}
	}
function appendwork(){
	if (endEditingwork ()){
		workgrid.datagrid('appendRow',{is_use:'Y'});
		editIndexwork = workgrid.datagrid('getRows').length-1;
		workgrid.datagrid('selectRow', editIndexwork)
				.datagrid('beginEdit', editIndexwork);
	}
}

function judgework(){
	var row = workgrid.datagrid('getSelected');
	if (row.WORK_LIVE_ID!=null) {
		removework();
		}
	else{
		removeitwork();
	}
}

function removeitwork(){
	if (editIndexwork == undefined){return}
	workgrid.datagrid('cancelEdit', editIndexwork)
			.datagrid('deleteRow', editIndexwork);
	editIndexwork = undefined;
}

function removework() {
	var row = workgrid.datagrid('getSelected');
	if (row) {
		var id = row.WORK_LIVE_ID;
		if (row.WORK_LIVE_ID == null) {
			return;
		}
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
							url : ctx + "/HrWorkLive/delHrWorkLive",
							data : {
								id : id
							},
							dataType : 'json',
							success : function(result) {
								if (result.success) {
									workgrid.datagrid('reload');
									alertInfo(result.msg);
								} else {
									alertError(result.msg);
								}
							}
						});
			}
		});
	}
}
