var basegrid=$('#HrSettings_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#HrSettings_datagrid_tb",
	    url:ctx+'/HrSettings/pageHrSettings',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+row.id+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'id',title:'id',width:100,align:'center',halign:'center'},
	    {field:'crossOrg',hidden:true},
	    {field:'crossOrgText',title:'跨组织查询',width:100,align:'center',halign:'center'},
	    {field:'mgrProtect',hidden:true},
	    {field:'mgrProtectText',title:'高管保护',width:100,align:'center',halign:'center'},
	    {field:'idProtect',hidden:true},
	    {field:'idProtectText',title:'身份证保护',width:100,align:'center',halign:'center'},
	    {field:'privacyProtect',hidden:true},
	    {field:'privacyProtectText',title:'隐私保护',width:100,align:'center',halign:'center'},
	    {field:'orgId',title:'单位ID',width:100,align:'center',halign:'center'},
	    {field:'createAccount',title:'创建人',width:100,align:'center',halign:'center'},
	    {field:'createTime',title:'创建日期',width:100,align:'center',halign:'center'},
	    {field:'modifyAccount',title:'最后修改人',width:100,align:'center',halign:'center'},
	    {field:'modifyTime',title:'最后修改时间',width:100,align:'center',halign:'center'},
	    {field:'isUse',title:'是否使用',width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.id);
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('HrSettings_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=HrSettings&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchHrSettings(){
	basegrid.datagrid('load',{
		search:$("#searchHrSettings").val()
	});
}

//增加记录
function addHrSettings() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=HrSettings",
		submiturl:"/HrSettings/saveHrSettings?formcode=HrSettings",
//		contenturl:"/view/business/hr/HrSettings",
//		submiturl:"/HrSettings/saveHrSettings",
		callback:reloadGrid
	});
	
}

//修改记录
function editHrSettings() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.id;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=HrSettings&id=" + id,
			submiturl:"/HrSettings/saveHrSettings?formcode=HrSettings",
//			contenturl : "/view/business/hr/HrSettings",
//			submiturl : "/HrSettings/saveHrSettings",
//			onload : "/HrSettings/findHrSettings?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delHrSettings() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.id;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/HrSettings/delHrSettings",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
