var basegrid=$('#HrProtectScopt_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#HrProtectScopt_datagrid_tb",
	    url:ctx+'/HrProtectScopt/pageHrProtectScopt',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+row.protectId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'protectId',title:'主键ID',width:100,align:'center',halign:'center'},
	    {field:'empId',title:'员工ID',width:100,align:'center',halign:'center'},
	    {field:'userType',title:'隐藏保护类型',width:100,align:'center',halign:'center'},
	    {field:'userId',title:'隐藏人员ID',width:100,align:'center',halign:'center'},
	    {field:'orderBy',title:'排序',width:100,align:'center',halign:'center'},
	    {field:'createAccount',title:'创建人',width:100,align:'center',halign:'center'},
	    {field:'createTime',title:'创建时间',width:100,align:'center',halign:'center'},
	    {field:'modifyAccount',title:'修改人',width:100,align:'center',halign:'center'},
	    {field:'modifyTime',title:'修改时间',width:100,align:'center',halign:'center'},
	    {field:'isUse',title:'是否使用',width:100,align:'center',halign:'center'}
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.protectId);
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('HrProtectScopt_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=HrProtectScopt&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchHrProtectScopt(){
	basegrid.datagrid('load',{
		search:$("#searchHrProtectScopt").val()
	});
}

//增加记录
function addHrProtectScopt() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=HrProtectScopt",
		submiturl:"/HrProtectScopt/saveHrProtectScopt?formcode=HrProtectScopt",
//		contenturl:"/view/business/hr/HrProtectScopt",
//		submiturl:"/HrProtectScopt/saveHrProtectScopt",
		callback:reloadGrid
	});
	
}

//修改记录
function editHrProtectScopt() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.protectId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=HrProtectScopt&id=" + id,
			submiturl:"/HrProtectScopt/saveHrProtectScopt?formcode=HrProtectScopt",
//			contenturl : "/view/business/hr/HrProtectScopt",
//			submiturl : "/HrProtectScopt/saveHrProtectScopt",
//			onload : "/HrProtectScopt/findHrProtectScopt?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delHrProtectScopt() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.protectId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/HrProtectScopt/delHrProtectScopt",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}
