var HrPostDataGrid=$('#HrPost_datagrid');
$(function(){
	initHrPostGrid();
	loadOrgTree();
});

// 加载组织结构树
function loadOrgTree() {
	$('#orgManage_tree').tree({
		url : ctx + '/basorg/queryOrgAndDeptTree',
		onSelect : function(node) {
			searchHrPost();
		},
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('collapseAll');
				$(this).tree('expand',root.target);
				$(this).tree('select', root.target);
			}
		}
	});
}

function initHrPostGrid(){
	HrPostDataGrid.datagrid({
		height:$("body").height()-200,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		// queryParams:{
		// 	startDate:$('#sDate').datebox('getValue'),
		// 	endDate:$('#eDate').datebox('getValue')
		// },
		cls:'md',
		toolbar:"#HrPost_datagrid_tb",
	    url:ctx+'/HrPost/pageHrPost',
	    columns:[[
	    // {
		// 	field:'opt',title:'明细',width:40,align:'center',
		// 	formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
		// 		return '<div onclick="HrPostFormDetail('+row.postId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		// }},
	    // {field:'ageLimit',title:'年龄上限',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'createAccount',title:'创建人',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'createTime',title:'创建日期',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'deptId',title:'部门ID',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'postId',title:'岗位编号',width:100,align:'center',halign:'center',sortable:true},
		{field:'postCode',title:'岗位编码',width:100,align:'center',halign:'center',sortable:true},
		{field:'postName',title:'岗位名称',width:100,align:'center',halign:'center',sortable:true},
		{field:'deptname',title:'所属部门',width:100,align:'center',halign:'center',sortable:true},
		// {field:'deptId',title:'部门ID',width:100,align:'center',halign:'center',sortable:true},
		{field:'postType',title:'岗位类别',width:100,align:'center',halign:'center',sortable:true,

			formatter: function(value,row,index){
				if (value =='1'){
					return '管理类';
				}else if (value=='2'){
					return '技术类';
				}else if (value=='3'){
					return '营销类';
				}else if (value=='4'){
					return '职能类';
				}
			}},
		// {field:'displayNo',title:'DISPLAY_NO',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'isUse',title:'IS_USE',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'modifyAccount',title:'最后修改人',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'modifyTime',title:'最后修改时间',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'oaId',title:'OA系统ID',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'orgId',title:'组织机构ID',width:100,align:'center',halign:'center',sortable:true},
	    {field:'postLimit', title:'编制人数',width:100,align:'center',halign:'center',sortable:true},
		{field:'count',title:'在编人数',width:100,align:'center',halign:'center',sortable:true},
		{field:'postStatus',title:'状态',width:100,align:'center',halign:'center',sortable:true},
		// {field:'postDuty',title:'岗位职责',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'postCompetence',title:'任职资格',width:100,align:'center',halign:'center',sortable:true},
	    // {field:'remark',title:'备注',width:100,align:'center',halign:'center',sortable:true}
		]],
	    onDblClickRow:function(index, row){
    		//查看明细
			HrPostFormDetail(row.postId);
	    },
	    onLoadSuccess:function(data){
            var postLimit = 0;
            var totalCount = 0;
            for(var i=0;i<data.rows.length;i++)
            { 
            	postLimit +=  data.rows[i].postLimit;
            	totalCount +=  data.rows[i].count;
            }
            //赋值操作
            document.getElementById('postLimit').innerHTML = postLimit+" 人";
            document.getElementById('totalCount').innerHTML = totalCount+" 人";
        },
		onLoad:function () {
			// document.getElementById('seniorSearchText').innerHTML = "关闭高级查询";
		}
	});
    HrPostDataGrid.datagrid('doCellTip');
    var pager = HrPostDataGrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('HrPost_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function HrPostFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=HrPost&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadHrPost(){
	HrPostDataGrid.datagrid('reload');
}
//查询表格
function searchHrPost(node){
	var node = $('#orgManage_tree').tree('getSelected');
    var orgId=node.attributes.org_id;
    var deptId=node.attributes.dept_id;
	// console.log(node);
	// console.log(orgId+"--"+deptId);
	if (deptId!=null){
        orgId="";
    }
    // console.log(orgId+"--"+deptId);
	HrPostDataGrid.datagrid('load',{
		search:$("#searchHrPost").val(),
		orgId:orgId,
		deptId:deptId,
	});
}

//增加记录
function addHrPost() {
    var node = $('#orgManage_tree').tree('getSelected');
    if (node.attributes.dept_id!=null){
        openSaveDialog({
            title:"添加记录",
            // maximized : true,
            width: 800,
            height: 550,
            contenturl:"/GenForm/form?formcode=HrPost",
            submiturl:"/HrPost/saveHrPost?formcode=HrPost",
           // loadScript:str,
            onload:onloadData,
            callback:reloadHrPost
        });
    } else {
		alertWarn('请选择相关部门进行添加操作');
    }

}

//修改记录
function editHrPost() {
	var row = HrPostDataGrid.datagrid('getSelected');
	if (row) {
		var id = row.postId;
		openSaveDialog({
			title : "修改记录",
			// maximized : true,
			width: 750,
			height: 450,
			contenturl:"/GenForm/form?formcode=HrPost&id=" + id,
			submiturl:"/HrPost/saveHrPost?formcode=HrPost",
//			contenturl : "/view/business/hr/HrPost",
//			submiturl : "/HrPost/saveHrPost",
//			onload : "/HrPost/findHrPost?id=" + id,
			onload:function () {
				var node = $('#orgManage_tree').tree('getSelected');
				$("#deptCode").textbox("setValue", node.attributes.dept_code);
			},
			callback : reloadHrPost
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delHrPost() {
	var row = HrPostDataGrid.datagrid('getSelected');
	if (row) {
		if(row.count>0){
			alertInfo('该岗位已被分配，不可删除！');
		}else {
			var id = row.postId;
			alertConfirmYes('您是否要删除当前选中的数据？', function (r) {
				if (r) {
					$.ajax({
						url: ctx + "/HrPost/delHrPost",
						data: {
							id: id
						},
						dataType: 'json',
						success: function (result) {
							if (result.success) {
								HrPostDataGrid.datagrid('reload');
								alertInfo(result.msg);
							} else {
								alertError(result.msg);
							}
						}
					});
				}
			});
		}
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}

