var basegrid=$('#BasEmp_datagrid');
var empId=null;
var openSearch = false;
$(function(){
	initGrid();
	initOrgtree();
	seniorSearch();
});

function initGrid(){
	basegrid.datagrid({
		singleSelect:false,
		border:false,
		rownumbers:true,
		fitColumns:true,
		cls:'md',
		pagination:true,
		height:$("body").height()-170,
	    url:ctx+'/HrEmp/pageAllEmp',
	    queryParams:{
	    	status : '1'
	    },
	    columns : [[
	    {
		field:'opt',title:'明细',width:40,align:'center',
		formatter:function(value,rowData,index){	//value表示字段的值,rowData行记录数据,index行索引
			return '<div onclick="showDetailA(\''+rowData.EMP_ID+'\')" class="icon-detail iconfont blue">&nbsp;</div>';
					}},
        {field:'EMP_ID',title:'工号',hidden : true},
	    {field:'DEPT_ID',title:'部门ID ',width:100,align:'center',halign:'center',hidden : true},
	    {field:'EMP_NAME',title:'姓名',width:100,align:'left',halign:'left',sortable:true},
	    {field:'ORG_NAME',title:'公司 ',width:180,align:'left',halign:'left',sortable:true},
	    {field:'DEPT_NAME',title:'部门 ',width:120,align:'left',halign:'left',sortable:true},
//	    {field:'EMP_NO',title:'工号',width:80,align:'center',halign:'center',sortable:true},
	    {field:'DIC_TEXT',title:'性别',width:60,align:'center',halign:'center',sortable:true},
//        {field:'NATIVE_PLACE',title:'籍贯',width:80,align:'left',halign:'center',sortable:true},
//        {field:'POLITICAL_STAT_TEXT_',title:'政治面貌',width:80,align:'left',halign:'center',sortable:true},
//	    {field:'NATION_TEXT_',title:'民族',width:80,align:'center',halign:'center',sortable:true},
//        {field:'BIRTHDAY_F',title:'出生日期',width:80,align:'center',halign:'center',sortable:true},
//	    {field:'WORK_TIME_F',title:'参加工作时间',width:100,align:'center',halign:'center',sortable:true},
//	    {field:'BORNDAY',title:'年龄',width:40,align:'right',halign:'center',sortable:true},
//        {field:'JOIN_ORG_TIME',title:'加入组织时间',width:80,align:'center',halign:'center',sortable:true},
//	    {field:'RANK',title:'职称',width:80,align:'center',halign:'left',sortable:true},
//	    {field:'PRESENT_JOB_TEXT_',title:'岗位',width:140,align:'left',halign:'center',sortable:true},
//	    {field:'STATION_TEXT_',title:'级别',width:70,align:'center',halign:'center',sortable:true},
//	    {field:'STATION_LEVEL_TEXT_',title:'职级',width:50,align:'center',halign:'center',sortable:true},
//	    {field:'TECHNICAL_TEXT_',title:'等级',width:70,align:'center',halign:'center',hidden : true},
	    {field:'ENTRY_TIME_F',title:'入司时间',width:80,align:'center',halign:'center',sortable:true},
//	    {field:'TOP_EDUCATION_TEXT_',title:'学历',width:70,align:'left',halign:'center',sortable:true},
//	    {field:'GRADUATE_COLL',title:'毕业院校',width:150,align:'left',halign:'center',sortable:true},
//	    {field:'PROFESSION',title:'专业',width:150,align:'left',halign:'center',sortable:true},
//	    {field:'MOBILEPHONE',title:'手机号',width:150,align:'center',halign:'center',sortable:true},
//	    {field:'ID_CARD',title:'身份证号',width:150,align:'center',halign:'center',sortable:true},
//	    {field:'EMP_TYPE_TEXT_',title:'员工类别',width:100,align:'center',halign:'center',hidden:true},
	    {field:'STATUS_TEXT_',title:'员工状态',width:100,align:'center',halign:'center',sortable:true}
	    ]],
	    onDblClickRow : function(index, row){
  	    	showDetailA(row.EMP_ID);
  	    }
	});
	basegrid.datagrid('doCellTip');
	var pager = basegrid.datagrid('getPager');    // 得到datagrid的pager对象  
	pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('BasEmp_datagrid',"员工档案信息");   
	        }    
	    }]   
	}); 
}

//打印
function printerBasEmp() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		id = row.EMP_ID;
		window.open(ctx+"/ReportServer?reportlet=BasEmp.cpt&id="+id);
	} else {
		alertInfo('请选择一条记录进行打印');
	}
}


//重新加载表格
function reloadGrid(orgid,deptid,politicalStatus,borndaya,borndayb,status,professionalTitle){
	basegrid.datagrid('reload',{
		orgid:orgid,
		deptid:deptid,
		politicalStatus:politicalStatus,
		borndaya:borndaya,
		borndayb:borndayb,
		status:status,
		professionalTitle:professionalTitle,
		search:$("#searchBasEmp").val()
	});
}

//初始化组织机构tree
function initOrgtree(){
	$('#basemp_orgdepttree').tree({
	    url:  ctx + '/basorg/longUserOrgAndDeptTree',
	    onLoadSuccess : function(node, data) {
	    	// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('collapseAll');
				$(this).tree('expand',root.target);
				$(this).tree('select', root.target);
			}
		},
		onSelect : function(node) {
//			reloadGrid(node.attributes.org_id,node.attributes.dept_id);
			isChange();
		}
	});
}
//查询表格
function searchBasEmp(){
	var node = $('#basemp_orgdepttree').tree("getSelected");
	basegrid.datagrid('load', {
		orgid : node == null ? null : node.attributes.org_id,
		deptid : node == null ? null : node.attributes.dept_id,
		name:$('#name').textbox('getValue'),
		status:$('#status').combobox('getValue'),
		workTimeStart:$('#workTimeStart').datebox('getValue'),
		workTimeEnd:$('#workTimeEnd').datebox('getValue'),
		politicalStatus:$('#politicalStatus').textbox('getValue'),
		borndaya:$('#borndaya').datebox('getValue'),
		borndayb:$('#borndayb').datebox('getValue'),
		empPropStatus:$('#empPropStatus').combobox('getValue'),
		topEducation:$('#topEducation').textbox('getValue'),
		professionalTitle:$('#professionalTitle').combobox('getValue'),

		/*politicalStatus : $("#politics").combobox('getValue'),
		empPropStatus : $("#empPropCombo").combobox('getValue'),
		nationStatus : $("#nationCombo").combobox('getValue'),
		workTimeStart : $("#workTimeStart").combobox('getValue'),
		workTimeEnd : $("#workTimeEnd").combobox('getValue'),
		borndaya : $("#years").numberbox('getValue'),
		borndayb : $("#yeare").numberbox('getValue'),
		status : $("#status").combobox('getValue'),
		topEducation : $("#topEducation").combobox('getValue'),
		professionalTitle : $("#professionalTitle").combobox('getValue'),*/
		search : $("#searchBasEmp").val()
	});
}

//增加记录
function addBasEmp() {
	var node=$('#basemp_orgdepttree').tree('getSelected');
	if(!node){
		alertInfo("请先选择一个单位节点");
		return;
	}
	openSaveDialog({
		title:"添加记录",
	    width:1040,
	    maximized : true,
		contenturl:"/view/business/hr/HrEmpform",
		submiturl:"/HrEmp/savestaff?formcode=HrEmp_form",
		onsubmit:function(param){
			endEditingfamily();
			endEditingedu();
			endEditingtrain();
			endEditingwork();
			param.edugrid= JSON.stringify($('#de').datagrid('getChanges'));
			param.traingrid= JSON.stringify($('#dt').datagrid('getChanges'));
			param.workgrid= JSON.stringify($('#dw').datagrid('getRows'));
			param.familygrid= JSON.stringify($('#df').datagrid('getChanges'));
			return true;
		},
		callback:refreshGride,
		onload:addLoad
	});
}

//刷新grid
function refreshGride(){
//	var node=$('#basemp_orgdepttree').tree("getSelected");
//	reloadGrid(node.attributes.org_id,node.attributes.dept_id);
	isChange();
}

//点击新增加载数据方法
function addLoad(){
	$("#photo").attr("src",ctx+"/static/style/images/nobody.png");

//	$("#documentid").val(generateUUID())
//	$('#orgselect_tree').combotree({
//		url : ctx + '/basorg/queryOrgmenu.action',
//		onLoadSuccess : function() {
//			
//		},
//		onChange : function(newvalue,oldvalue) {
//			queryByOrg(newvalue);
//		}
//	});
	var node=$('#basemp_orgdepttree').tree('getSelected');
	$('#deptManage_tree').combotree('setValue',node.attributes.dept_id);
	$('#orgselect_tree').combotree('setValue',node.attributes.org_id);
}
function queryByOrg(orgid,ov) {
	var deptId=$('#deptManage_tree').combotree("getValue");
	var pid = 0;
	var orgId = orgid;
	if(ov){
		$("#deptManage_tree").combotree("clear");
		$("#station").combobox("clear");
		$("#stationLevel").combobox("clear");
		$("#presentJob").combobox("clear");
	}
	$('#deptManage_tree').combotree('reload',ctx + "/basdept/queryDeptmenu?pid=" + pid
				+ "&orgId=" + orgId+"&isTree=true");
	// $('#presentJob').combobox('reload',ctx + "/HrPost/combo?orgId=" + orgId);
	$('#presentJob').combobox('reload',ctx + "/HrPost/combo?orgId=" + orgId + "&deptId=" + deptId);
}

function querByDept(deptid,ov){
	var deptId = deptid;
	var orgId=$('#orgselect_tree').combotree("getValue");
	if(ov){
		$("#presentJob").combobox("clear");
	}
	$('#presentJob').combobox('reload',ctx + "/HrPost/combo?orgId=" + orgId + "&deptId=" + deptId);
}

//修改记录
function editBasEmp() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.EMP_ID;
	    empId = row.EMP_ID;
		openSaveDialog({
			title : "修改记录",
			width:800,
			maximized : true,
			contenturl : "/view/business/hr/HrEmpform?empId=" + id,
			submiturl:"/HrEmp/savestaff?formcode=HrEmp_form",
			onload:function(){
				$.ajax({
					type : 'post',
					dataType : 'json',
					url : ctx + "/HrEmp/queryEmpById?empId=" + id,
					success : function(data) {
						var submitform = $("#basempform_div");
						submitform.form('load', data);
						var versionId=data.photoVersionId;
						if(versionId){
							$("#photo").attr("src",ctx+"/file/viewfile/preview.JPG?versionid="+versionId);
						}else{
							$("#photo").attr("src",ctx+"/static/style/images/nobody.png");
						}
					}
				});
			},
			onsubmit:function(param){
				endEditingfamily();
				endEditingedu();
				endEditingtrain();
				endEditingwork();
				param.edugrid= JSON.stringify($('#de').datagrid('getChanges'));
				param.traingrid= JSON.stringify($('#dt').datagrid('getChanges'));
				param.workgrid= JSON.stringify($('#dw').datagrid('getRows'));
				param.familygrid= JSON.stringify($('#df').datagrid('getChanges'));
				return true;
			},
			callback : refreshGride
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delBasEmp() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.EMP_ID;
	alertConfirmYes('您是否要注销当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					type : 'post',
					url : ctx+"/HrEmp/delemp?empId="+id,
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			
			} 
		});
}else {
	alertInfo('请先选择要删除的数据信息');
}
	}

//注销人员    如果有待办选择代理人  没有待办直接选择注销
function delEmp() {
	var row = basegrid.datagrid('getSelected');
	if (row ) {
	if(row.IS_USE=='Y'){
	var id =row.EMP_ID;
	$.ajax({
		type : 'post',
		url : ctx+"/BasMessage/isHaveTodo?accountId="+id,
		dataType : 'json',
		success : function(result) {
			if(result>0){
				alertConfirmYes('当前人员存在未处理的待办,请先选择代理人', function(r) {
					if (r) {
						openSaveDialog({
							title:"流程委托",
						    width:300,
						    maximized : false,
						    height:120,
							contenturl:"/view/business/hr/delHrEmpform?empId=" + id,
							submiturl:"/WfAgent/saveWfAgent1?formcode=delHrEmpform_Form&accountId="+id,
							callback:del
						});
					}
				});
			}else{
				alertConfirmYes('您是否要注销当前人员？', function(r) {
				if (r) {
					$.ajax({
						type : 'post',
						url : ctx+"/HrEmp/delHrEmp?id="+id,
						dataType : 'json',
						success : function(result) {
							if (result.success) {
								basegrid.datagrid('reload');
								alertInfo(result.msg);
							}else{
								alertError(result.msg);
							}
						}
					});
				
				}
			});
			}
		}
	});
		/*alertConfirmYes('您是否要删除当前人员？', function(r) {
			if (r) {
				$.ajax({
					type : 'post',
					url : ctx+"/HrEmp/delHrEmp?id="+id,
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			
			}
		});*/
	}else{
	alertInfo('该人员已是注销状态');
	}} else {
	alertInfo('请先选择要删除的数据信息');
}
	}

function del(){
	var row = basegrid.datagrid('getSelected');
	var id =row.EMP_ID;
	if (row ) {
	$.ajax({
		type : 'post',
		url : ctx+"/HrEmp/delHrEmp?id="+id,
		dataType : 'json',
		success : function(result) {
			if (result.success) {
				basegrid.datagrid('reload');
				alertInfo(result.msg);
			}else{
				alertError(result.msg);
			}
		}
	});
	}	
}
/*筛选*/
function isChange() {
	var node = $('#basemp_orgdepttree').tree("getSelected");
	var params ={
			orgid : node == null ? null : node.attributes.org_id,
			deptid : node == null ? null : node.attributes.dept_id,
			status : $("#status").combobox('getValue'),
			search : $("#searchBasEmp").val()
	}
	if(!openSearch){
		$.extend(params,{
			empPropStatus : $("#empPropStatus").combobox('getValue'),
			workTimeStart:$('#workTimeStart').datebox('getValue'),
			workTimeEnd:$('#workTimeEnd').datebox('getValue'),
			politicalStatus:$('#politicalStatus').textbox('getValue'),
			borndaya:$('#borndaya').datebox('getValue'),
			borndayb:$('#borndayb').datebox('getValue'),
			topEducation:$('#topEducation').textbox('getValue'),
			professionalTitle:$('#professionalTitle').combobox('getValue')
		})
	}
	basegrid.datagrid('load', params);
}

function openChooseFileDialog() {
	var jq=$("#photoVersionId");
	$('<div/>').dialog({
		href :ctx + "/file/filechoose",
		queryParams : {
			versionid :  jq.val() ? jq.val() : '',
			catalogid : '641',
			projectid : "",
			standerfileid : '',
			showlocal:true,//是否显示本地文件上传tab页
			showvisual:false,//是否显示从文件库选择上传传tab页
			showscan:false//是否显示扫描上传tab页
		},
		style : {
			overflowX : 'hidden'
		},
		width : 740,
		height : 500,
		modal : true,
		title : "文件选择",
		inline : false,
		buttons : [{
			text : '确定',
			iconCls : 'icon-disk',
			handler : function() {
				var okbutton = $(this);
				var d = $(this).closest('.window').find('.window-body');
				var versionid = $("#_loaclfileversionid").val();
				if(!versionid){
					alertInfo("请先点击上传按钮上传文件");
					return ;
				}
				jq.val(versionid);
				$("#photo").attr("src",ctx+"/file/viewfile/preview.JPG?versionid="+versionid);
				d.dialog('destroy');
			}
		}, {
			text : '取消',
			iconCls : 'icon-dialog-cancel',
			handler : function() {
				var d = $(this).closest('.window').find('.window-body');
				d.dialog('destroy');
			}
		}],
		onClose : function() {
			$(this).dialog('destroy');
		},
		onLoad : function() {
			(onload && typeof(onload) === "function") && onload();
		}
	});
}
//清除空值
function clearComboboxValue(newValue,oldValue){
	if(newValue.length==1&&!newValue[0]){
		$('#'+this.id).combobox('clear');
	}
}

function showDetailA(empid){
		var id = empid;
	    empId = empid;
		openDetailDialog({
			title : "详细信息",
			maximized : true,
			contenturl : "/view/business/hr/HrEmpDetail?empId="+id,
			onload:function(){
				$.ajax({
					type : 'post',
					dataType : 'json',
					url : ctx + "/HrEmp/queryEmpById?empId="+id,
					success : function(data) {
						$("#basempform_div").form('load', data);
						var versionId=data.photoVersionId;
						if(versionId){
							$("#photo").attr("src",ctx+"/file/viewfile/preview.JPG?versionid="+versionId);
						}else{
							$("#photo").attr("src",ctx+"/static/style/images/nobody.png");
						}
					}
				});
			}
		});
}
function pushBasEmp(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
		alertConfirmYes('您是否要推送当前人员到财务系统？', function(r) {
			if (r) {
				$.ajax({
					type : 'post',
					url : ctx+"/HrEmp/genEmpXml",
					data:{
						empId : row.EMP_ID
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			
			} 
		});
	}else {
		alertInfo('请先选择要推送的数据信息');
	}
}
//员工信息打印
function printEmp(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
		window.open(ctx+"/HrEmp/printEmpInfo?empId="+row.EMP_ID);
	}else {
		alertInfo('请先选择要打印的员工信息');
	}
}

// 批量打印
function printEmpMulti(){
    var rows= basegrid.datagrid('getSelections');
    console.info(rows);
    if (rows&&rows.length!=0) {
        var ids = [];
        for(var i=0;i<rows.length;i++){
            ids.push(rows[i].EMP_ID);
        }
        var url = ctx + "/HrEmp/EmpInfoMulti?empIds=" +ids;
        window.open(url);
    } else {
        alertInfo('请先选择要打印的数据信息');
    }
}

// 批量导出
function exportEmpMulti(){
    var rows= basegrid.datagrid('getSelections');
    console.info(rows);
    if (rows&&rows.length!=0) {
        var ids = [];
        for(var i=0;i<rows.length;i++){
            ids.push(rows[i].EMP_ID);
        }
        window.open(ctx + "/HrEmp/exportEmpExcel?empIds="+ids);
    }else {
        alertInfo('请先选择要导出的数据信息');
    }
}

//全部导出
function exportAllEmp(){
        window.open(ctx + "/HrEmp/exportEmpExcel");
}

function editBasEmpContent(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
	    var mhtmlHeight = window.screen.availHeight; // 获得窗口的垂直位置;
	    var mhtmlWidth = window.screen.availWidth; // 获得窗口的水平位置;
	    var iTop = 0; // 获得窗口的垂直位置;
	    var iLeft = 0; // 获得窗口的水平位置;
	    var url=ctx+"/HrEmp/toExcelPage?recordId="+row.RECORD_ID+"&empId="+row.EMP_ID;
	    window.open(url,row.EMP_NAME,'height=' + mhtmlHeight + ',width=' + mhtmlWidth + 
		',top=' + iTop + ',left=' + iLeft + ',toolbar=no,menubar=yes,scrollbars=no,resizable=yes, location=no,status=no');
	}else {
		alertInfo('请先选择要编辑的人事档案');
	}
}

function pushHrEmp(){
	var row = basegrid.datagrid('getSelected');
	if (row) {
		alertConfirmYes('您是否要推送当前人员信息到财务系统？', function(r) {
			if (r) {
				$.ajax({
					type : 'post',
					url : ctx+"/HrEmp/pushHrEmp",
					data:{
						empId : row.EMP_ID
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});

			}
		});
	}else {
		alertInfo('请先选择要编辑的人事档案');
	}
}

//高级查询
function seniorSearch(){
	// alert("执行高级查询");
	var doc=document;
//var seniorS=doc.getElementById("seniorS");
	var seniorS=$(".seniorLine");
//判断显示还是隐藏

	if (openSearch) {
		openSearch=false;
		seniorS.css("display","display");
		document.getElementById('seniorSearchText').innerHTML = "关闭高级查询";
		basegrid.datagrid('resize',{
			height:$("body").height()-324,
		});
	} else {
		openSearch=true;
		seniorS.css("display","none");
		document.getElementById('seniorSearchText').innerHTML = "打开高级查询";
		basegrid.datagrid('resize',{
			height:$("body").height()-180,
		});
	}
	//默认自动查询一次
	//searchEdocApply();
}
