var basegrid=$('#GmSpaceComponentDefinition_datagrid');
$(function(){
	initGrid();
});

function initGrid(){
	basegrid.datagrid({
		fit:true,
		border:false,
		singleSelect:true,
		rownumbers:true,
		fitColumns:true,
		pagination:true,
		toolbar:"#GmSpaceComponentDefinition_datagrid_tb",
	    url:ctx+'/GmSpaceComponentDefinition/pageGmSpaceComponentDefinition',
	    columns:[[
	    {
			field:'opt',title:'明细',width:40,align:'center',
			formatter:function(value,row,index){	//value表示字段的值,rowData行记录数据,index行索引
				return '<div onclick="openFormDetail('+row.componentId+')" class="icon-detail iconfont blue">&nbsp;</div>';
		}},
	    {field:'componentName',title:'组建名称',width:100,align:'left',halign:'left',sortable:true},
	    {field:'componentSourceText',title:'组件来源',width:50,align:'center',halign:'center',sortable:true},
	    {field:'componentCategoryText',title:'归属类别',width:50,align:'center',halign:'center',sortable:true},
	    {field:'creationTypeText',title:'组件归属',width:50,align:'center',halign:'center',sortable:true},
	    {field:'orgId',hidden:true},
	    {field:'orgName',title:'归属单位',width:100,align:'center',halign:'center',sortable:true},
	    {field:'linkAddress',title:'链接地址',width:100,align:'center',halign:'center',sortable:true},
	    {field:'view',title:'',width:50,formatter: function(value,row,index){
	    		return '<a id="preview'+index+'" class="easyui-linkbutton"'
						+'href="javascript:void(0)" data-options="iconCls:\'icon-page-printer\',plain:true"'
						+'onclick="previewGmSpaceComponent(this)">预览</a>'
	    	}
	    }
	    
	    ]],
	    onDblClickRow:function(index, row){
    		//查看明细
			openFormDetail(row.componentId);
	    }
	});
    basegrid.datagrid('doCellTip');
    var pager = basegrid.datagrid('getPager');
    pager.pagination({    
	    buttons:[{    
	        iconCls:'icon-page_excel',    
	        handler:function(){    
	           exportExcel('GmSpaceComponentDefinition_datagrid',"title");   
	        }    
	    }]   
	});
}
//查看表单明细
function openFormDetail(id){
	openDetailDialog({
		title : "查看记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=GmSpaceComponentDefinition&isdetail=true&id="+id
	});
}
//重新加载表格
function reloadGrid(){
	basegrid.datagrid('reload');
}
//查询表格
function searchGmSpaceComponentDefinition(){
	basegrid.datagrid('load',{
		search:$("#searchGmSpaceComponentDefinition").val()
	});
}

//增加记录
function addGmSpaceComponentDefinition() {
	openSaveDialog({
		title:"添加记录",
		maximized : true,
		contenturl:"/GenForm/form?formcode=GmSpaceComponentDefinition",
		submiturl:"/GmSpaceComponentDefinition/saveGmSpaceComponentDefinition?formcode=GmSpaceComponentDefinition",
//		contenturl:"/view/business/gm/GmSpaceComponentDefinition",
//		submiturl:"/GmSpaceComponentDefinition/saveGmSpaceComponentDefinition",
		callback:reloadGrid
	});
	
}

//修改记录
function editGmSpaceComponentDefinition() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
		var id = row.componentId;
		openSaveDialog({
			title : "修改记录",
			maximized : true,
			contenturl:"/GenForm/form?formcode=GmSpaceComponentDefinition&id=" + id,
			submiturl:"/GmSpaceComponentDefinition/saveGmSpaceComponentDefinition?formcode=GmSpaceComponentDefinition",
//			contenturl : "/view/business/gm/GmSpaceComponentDefinition",
//			submiturl : "/GmSpaceComponentDefinition/saveGmSpaceComponentDefinition",
//			onload : "/GmSpaceComponentDefinition/findGmSpaceComponentDefinition?id=" + id,
			callback : reloadGrid
		});
		
	} else {
		alertInfo('请选择一条记录进行修改');
	}
}

//删除记录
function delGmSpaceComponentDefinition() {
	var row = basegrid.datagrid('getSelected');
	if (row) {
	var id =row.componentId;
		alertConfirmYes('您是否要删除当前选中的数据？', function(r) {
			if (r) {
				$.ajax({
					url : ctx+"/GmSpaceComponentDefinition/delGmSpaceComponentDefinition",
					data : {
						id : id
					},
					dataType : 'json',
					success : function(result) {
						if (result.success) {
							basegrid.datagrid('reload');
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		alertInfo('请先选择要删除的数据信息');
	}
}

//预览组件
function previewGmSpaceComponent(prame){
	var prviewId=prame.id;
	var index=prviewId.substr(7,prviewId.length-7);
	basegrid.datagrid('selectRow',index);
	var row=basegrid.datagrid('getSelected');
	var url = ctx+"/GmSpaceComponentDefinition/previewGmSpaceComponent?id=" +row.componentId;
	window.open(url);
}
