// 新增修改标记,0意味着新增,1意味着修改
var saveFlag = 1;
var basetree=$('#orgManage_tree');

$(function() {
	  loadOrgTree();
});

function expandNode(){
	basetree.tree('expandAll');
}

// 加载组织结构树
function loadOrgTree() {
	$('#orgManage_tree').tree({
		url : ctx + '/basorg/queryOrgTreeReal',
		onSelect : function(node) {
			openOrg(node);
		},
		onLoadSuccess : function(node, data) {
			// 默认显示根节点信息
			var root = $(this).tree('getRoot');
			if(node){
				$(this).tree('select', node.target);
			}else{
				$(this).tree('collapseAll');
				$(this).tree('expand',root.target);
				$(this).tree('select', root.target);
			}
		}
	});
}

// 单击打开节点事件
function openOrg(node) {
	saveFlag = 1;
	$.ajax({
		type : 'post',
		dataType : 'json',
		url: ctx + '/basorg/queryOrgInfo?orgId='+node.id,
		success : function(data){
			$('#orgManage_form').form('load',data);
			var parent = $('#orgManage_tree').tree('getParent',node.target);
			if(parent!=null){
				$("#belongDept").combotree('reload',ctx+"/basdept/queryDeptmenu?pid=0&isTree=true&orgId="+parent.id);
			}else{
				$("#belongDept").combotree('loadData',[]);
			}
		}
	});
}

// 新增组织机构信息
function newOrg() {
	saveFlag = 0;
	// 获取选中的节点
	var node = $('#orgManage_tree').tree('getSelected');
	if(node){
		// 清除当前界面信息
		$('#orgManage_form').form('clear');
		// 构建树结构
		$('#porgId').val(node.id);
		//$("#belongDept").combotree('reload',ctx+"/basdept/queryDeptmenu?pid=0&isTree=true&orgId="+node.id);
		$('#isUse').val('Y');
	}else{
		alertInfo("请选择组织节点");
	}

}

// 删除组织机构信息
function removeOrg() {
	// 获取选中的节点
	var node = $('#orgManage_tree').tree('getSelected');
	var child = $('#orgManage_tree').tree('isLeaf', node.target);
	if (child) {
		// 不存在子节点
		alertConfirm('确定删除该组织结构?', function(r) {
			if (r) {
				$.ajax({
					type : 'post',
					dataType : 'json',
					url : ctx + "/basorg/deleOrg?orgId=" + node.id,
					success : function(result) {
						if (result.success) {
							var pnode = $('#orgManage_tree').tree('getParent',node.target);
							if(pnode){
								$('#orgManage_tree').tree('select', pnode.target);
							}
							// 移除节点
							$('#orgManage_tree').tree('remove', node.target);
							alertInfo(result.msg);
						}else {
							alertError(result.msg);
						}
					}
				});
			}
		});
	} else {
		// 存在子节点
		alertConfirm('将删除该组织机构及其子机构,确定进行本次操作?', function(r) {
			if (r) {
				$.ajax({
					type : 'post',
					dataType : 'json',
					url : ctx + "/basorg/deleOrgs?orgId=" + node.id,
					success : function(result) {
						if (result.success) {
							var pnode = $('#orgManage_tree').tree('getParent',node.target);
							if(pnode){
								$('#orgManage_tree').tree('select', pnode.target);
							}
							// 移除节点
							$('#orgManage_tree').tree('remove', node.target);
							alertInfo(result.msg);
						}else {
							alertError(result.msg);
						}
					}
				});
			}
		});
	}
}

//取消按钮,取消当前编辑
function cancelOrg() {
	if(saveFlag == 1){
		var node = $('#orgManage_tree').tree('getSelected');
		openOrg(node);
	}else{
		newOrg();
	}
}

// 保存组织机构信息
function saveOrg() {
	$('#orgManage_form').form('enableValidation');
	$('#orgManage_form').form('submit', { 
		url : ctx + "/basorg/saveOrg",
		dataType : 'json',
		onSubmit : function() {
			if($(this).form('validate')){
        		// 防止重复发送
        		$('#saveBtn').linkbutton('disable');
             	return true;
        	 }else{
        		 return false;
        	 }
		},
		success : function(result) {
			result=jQuery.parseJSON(result);
			if (result.success) {
				// 获取选中的节点
				var node = $('#orgManage_tree').tree('getSelected');
				if (saveFlag == 1) {
					$('#orgManage_tree').tree('update',{
						 target: node.target,
						 text : result.o.abbr,
						 attributes:{
					 		orgcode:result.o.orgCode,
							code:result.o.code
						}
					 });
					alertInfo(result.msg);
				} else if (saveFlag == 0) {
					// 新增
				   $('#orgManage_tree').tree('append', {
						parent : node.target,
						data:[{
							id:result.o.orgId,
							text: result.o.abbr,
							attributes:{
						 		orgcode:result.o.orgCode,
								code:result.o.code
							}
						}]
					});
				    alertInfo(result.msg);
				}
			} else {
				alertError(result.msg);
			}
			// 启用按钮
			$('#saveBtn').linkbutton('enable');
		}
	});
}


function pushBasOrg(){
	var node = $('#orgManage_tree').tree('getSelected');
	if (node) {
		alertConfirmYes('您是否要推送当前组织信息到财务系统？', function(r) {
			if (r) {
				var loadIndex = layer.msg('数据同步中...', {
					icon: 16,
					shade: 0.3, time: 0
				});
				$.ajax({
					type : 'post',
					url : ctx+"/basorg/pushBasOrg",
					data:{
						orgId : node.id
					},
					dataType : 'json',
					success : function(result) {
						layer.close(loadIndex);
						if (result.success) {
							alertInfo(result.msg);
						}else{
							alertError(result.msg);
						}
					},
					error: function () {
						layer.close(loadIndex);
						alertError("数据同步出错");
					}
				});

			}
		});
	}else {
		alertInfo('请先选择要推送的数据信息');
	}
}
