// 初始化用户帐套grid
function initAccounGrid(empId){
		$('#empAccount_datagrid').datagrid({
			fit : true,
			singleSelect:true,
			rownumbers:true,
			fitColumns:true,
			url:ctx+'/basEmpAccount/findEmpAccountByEmpId.action',
			queryParams:{
				empId: empId
			},
			toolbar:[
			   {text:'新增',iconCls:'icon-add iconfont blue',handler:addEmpAccount},'-',
			    {text:'修改',iconCls:'icon-edit iconfont green',handler:editEmpAccount},'-',
			    {text:'删除',iconCls:'icon-del iconfont red2',handler:delEmpAccount},'-',
			    {text:'集成用户',iconCls:'blue iconfont   icon-user',handler:editEmpAccountInt}
			],
			columns:[[
			          {field:'ACCOUNT_ID',title:'accountId',width:100,hidden:true},
			          {field:'ACCOUNT_NAME',title:'帐套名称',width:100},
			          {field:'ORG_NAME',title:'组织机构',width:100},
			           {field:'DEPT_NAME',title:'部门名称',width:100},
			          {field:'EMP_NAME',title:'人员名称',width:100},
			          //{field:'IS_USE',title:'是否使用',width:100,formatter:formatter(result["IS_USE"])},
			          {field:'DISPLAY_NO',title:'排序',width:100,hidden:true}
			]],
			onLoadSuccess:function(data){
				if(data.rows){
					$(this).datagrid("selectRow",0)
				}
			}
		});
}

//刷新账户grid
function refreshAccountGride(){
	$('#empAccount_datagrid').datagrid('reload');
}

//点击新增账户按钮加载form
function addAccountLoad(){
	var row = $('#basemp_datagrid').datagrid('getSelected');
	$('#empId').val(row["EMP_ID"] );
}

//点击修改账户按钮加载form
function editAccountLoad(){
	var row = $('#empAccount_datagrid').datagrid('getSelected');
	$.ajax({
		type:'post',
		dataType:'json',
		url:ctx+"/basEmpAccount/queryEmpAccountById?accountId="+row["ACCOUNT_ID"],
		success:function(data){
			$('#empAccount_form').form('load',data);
		},
		error:function(){
			alertError("数据请求失败");
		}
	});
}
//增加用户帐套
function addEmpAccount(){
	openSaveDialog({
		title:"添加用户帐套",
		width:550,
		height:400,
		contenturl:"/view/base/basempAccountform",
		submiturl:"/basEmpAccount/saveEmpAccount",
		callback:refreshAccountGride,
		onload:addAccountLoad
	});
}
//修改用户帐套
function editEmpAccount(){
	var row = $('#empAccount_datagrid').datagrid('getSelected');
	if (row) {
		openSaveDialog({
		title:"修改用户帐套",
		width:550,
		height:400,
		contenturl:"/view/base/basempAccountform",
		submiturl:"/basEmpAccount/saveEmpAccount",
		callback:refreshAccountGride,
		onload:editAccountLoad
	});
//		openSaveDialog('修改用户权限组', '/sysbase/empAccountAddOrEdit.action',
//				'/basEmpAccount/saveEmpAccount.action', 400, 300, 'empAccount_form',refreshAccountGride,editAccountLoad);
	} else {
		alertInfo('请先选择一条记录再进行修改');
	}
}
//修改用户对应集成系统用户
function editEmpAccountInt(){
	var row = $('#empAccount_datagrid').datagrid('getSelected');
	if (row) {
		openSaveDialog({
		title:"修改集成用户",
		width:400,
		height:300,
		contenturl:"/view/base/basempAccountIntform",
		submiturl:"/basEmpAccount/saveEmpAccountInt",
		callback:refreshAccountGride,
		onload:editAccountLoad
	});
//		openSaveDialog('修改用户权限组', '/sysbase/empAccountAddOrEdit.action',
//				'/basEmpAccount/saveEmpAccount.action', 400, 300, 'empAccount_form',refreshAccountGride,editAccountLoad);
	} else {
		alertInfo('请先选择一条记录再进行修改');
	}
}
//删除用户帐套
function delEmpAccount(){
	var row = $('#empAccount_datagrid').datagrid('getSelected');
    if (row){
    	var rows = $('#empAccount_datagrid').datagrid('getRows');
    	if(rows.length==1){
    		alertInfo('您选中的数据为该用户的最后一个权限组，不能删除');
    	}else{
    		alertConfirm('确定删除该权限组?',function(r){
        		if(r){
        			$.ajax({
    					type:'post',
    					dataType:'json',
    					url:ctx+"/basEmpAccount/delEmpAccount?empAccountId="+row["ACCOUNT_ID"],
    					success:function(data){
    						alertInfo("删除成功");
    						$('#empAccount_datagrid').datagrid('reload');
    					},
    					error:function(){
    						alertError("删除失败");
    					}
    				});
        		}
       		});
    	}
    }else{
    	alertInfo('请先选择一条记录再进行删除');
    }
}
